/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.vertica;

import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.database.Dbms;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.util.SearchPath;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.TreePatternNode;
import com.intellij.database.util.TreePatternUtils;
import com.intellij.database.util.Version;
import com.intellij.openapi.util.Couple;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.SqlDialectImplUtil;
import com.intellij.sql.dialects.SqlImportUtil;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.SqlTypeSystem;
import com.intellij.sql.dialects.base.SqlLexer;
import com.intellij.sql.dialects.base.TokenClasses;
import com.intellij.sql.dialects.functions.SqlFunctionDefinition;
import com.intellij.sql.dialects.functions.SqlFunctionsUtil;
import com.intellij.sql.dialects.vertica.VertTokens;
import com.intellij.sql.dialects.vertica.VertTypeSystem;
import com.intellij.sql.dialects.vertica.refactoring.VertExtractFunctionHelper;
import com.intellij.sql.editor.SqlCloseBlockProcessor;
import com.intellij.sql.editor.SqlCloseBlockProcessorImpl;
import com.intellij.sql.editor.SqlEnterHandlerImpl;
import com.intellij.sql.editor.SubstitutionDescriptorImpl;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlKeywordTokenType;
import com.intellij.sql.psi.SqlMergeStatement;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.SqlUpdateStatement;
import com.intellij.sql.refactoring.extractFunction.SqlExtractFunctionHelper;
import com.intellij.sql.util.SqlTokenRegistry;
import com.intellij.util.NullableFunction;
import com.intellij.util.ObjectUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VertDialect
extends SqlLanguageDialectEx {
    public static final VertDialect INSTANCE = new VertDialect();

    public VertDialect() {
        super("Vertica");
    }

    @NotNull
    public SqlTypeSystem getTypeSystem() {
        VertTypeSystem vertTypeSystem = VertTypeSystem.INSTANCE;
        if (vertTypeSystem == null) {
            VertDialect.$$$reportNull$$$0(0);
        }
        return vertTypeSystem;
    }

    protected void addTypes(Map<String, SqlFunctionDefinition.Type> myTypes) {
        super.addTypes(myTypes);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"geom", (String)"geometry", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"uuid", (String)"uuid", (SqlLanguageDialectEx)this);
    }

    @NotNull
    public Dbms getDbms() {
        Dbms dbms = Dbms.VERTICA;
        if (dbms == null) {
            VertDialect.$$$reportNull$$$0(1);
        }
        return dbms;
    }

    public boolean isReservedKeyword(IElementType tokenType) {
        return tokenType instanceof SqlKeywordTokenType && LazyData.ourReservedTokens.fun((Object)tokenType.toString()) != null;
    }

    @NotNull
    public SqlLanguageDialectEx.BuiltinFunctions getSupportedFunctions() {
        SqlLanguageDialectEx.BuiltinFunctions builtinFunctions = LazyData.ourFunctionMap;
        if (builtinFunctions == null) {
            VertDialect.$$$reportNull$$$0(2);
        }
        return builtinFunctions;
    }

    public boolean isOperatorSupported(@Nullable IElementType tokenType) {
        return tokenType != null && LazyData.ourSupportedOperators.contains(tokenType);
    }

    @NotNull
    public Set<String> getKeywords() {
        Set<String> set = LazyData.ourKeywords;
        if (set == null) {
            VertDialect.$$$reportNull$$$0(3);
        }
        return set;
    }

    @NotNull
    public Set<String> getReservedKeywords() {
        Set<String> set = LazyData.ourReservedKeywords;
        if (set == null) {
            VertDialect.$$$reportNull$$$0(4);
        }
        return set;
    }

    @NotNull
    public Set<String> getSystemVariables() {
        Set<String> set = Collections.emptySet();
        if (set == null) {
            VertDialect.$$$reportNull$$$0(5);
        }
        return set;
    }

    @NotNull
    public TreePattern forcedContextPattern(@Nullable DbDataSource dataSource, @Nullable SearchPath searchPath) {
        Couple<ObjectName> scAndDb = VertDialect.getScAndDb(dataSource);
        TreePatternNode.Group[] schemas2 = SqlImportUtil.optAr((TreePatternNode.Group)TreePatternUtils.create((ObjectName)((ObjectName)scAndDb.first), (ObjectKind)SqlDbElementType.SCHEMA, (TreePatternNode.Group[])new TreePatternNode.Group[0]));
        TreePattern treePattern = this.applyImplicitImports(SqlImportUtil.getRealDsNames((DbDataSource)dataSource), SqlDialectImplUtil.forcedContextExpandedToSchemas((DbDataSource)dataSource, (Dbms)this.getDbms(), (SearchPath)searchPath, (TreePatternNode.Group[])schemas2, (TreePatternNode.Group[])SqlImportUtil.optAr((TreePatternNode.Group)TreePatternUtils.create((ObjectName)((ObjectName)scAndDb.second), (ObjectKind)SqlDbElementType.DATABASE, (TreePatternNode.Group[])schemas2))));
        if (treePattern == null) {
            VertDialect.$$$reportNull$$$0(6);
        }
        return treePattern;
    }

    public boolean isValidRawToken(@NotNull IElementType type, @NotNull CharSequence text) {
        if (type == null) {
            VertDialect.$$$reportNull$$$0(7);
        }
        if (text == null) {
            VertDialect.$$$reportNull$$$0(8);
        }
        return SqlLexer.isValidRawCopyToken(text);
    }

    public boolean supportsJoinUsing() {
        return true;
    }

    public boolean supportsNaturalJoin() {
        return true;
    }

    public boolean isTableAliasAllowedAt(@NotNull PsiElement element) {
        if (element == null) {
            VertDialect.$$$reportNull$$$0(9);
        }
        return super.isTableAliasAllowedAt(element) || PsiTreeUtil.getContextOfType((PsiElement)element, (Class[])new Class[]{SqlUpdateStatement.class, SqlMergeStatement.class}) != null;
    }

    @NotNull
    public TreePattern getBaseImports(@Nullable DbDataSource dataSource, ObjectName @Nullable [] dsNames) {
        ObjectName dbName = VertDialect.getDbName(dataSource);
        DasNamespace namespace = VertDialect.getDefaultNamespace((DbDataSource)dataSource, (ObjectName)dbName);
        if (namespace != null) {
            TreePattern treePattern = SqlDialectImplUtil.createObjectPattern((ObjectName[])dsNames, (DasObject)namespace, (TreePatternNode.Group[])new TreePatternNode.Group[]{namespace.getKind() == SqlDbElementType.SCHEMA ? null : TreePatternUtils.create((ObjectName)LazyData.PUBLIC_NAME, (ObjectKind)SqlDbElementType.SCHEMA, (TreePatternNode.Group[])new TreePatternNode.Group[0])});
            if (treePattern == null) {
                VertDialect.$$$reportNull$$$0(10);
            }
            return treePattern;
        }
        return new TreePattern(SqlImportUtil.createDataSources((ObjectName[])dsNames, (TreePatternNode.Group[])SqlImportUtil.optAr((TreePatternNode.Group)SqlImportUtil.createPositiveDatabase((dataSource == null ? 1 : 0) != 0, (ObjectName)dbName, (TreePatternNode.Group[])new TreePatternNode.Group[]{TreePatternUtils.create((ObjectName)LazyData.PUBLIC_NAME, (ObjectKind)SqlDbElementType.SCHEMA, (TreePatternNode.Group[])new TreePatternNode.Group[0])}))));
    }

    @NotNull
    public TreePattern applyImplicitImports(ObjectName @Nullable [] dsNames, @NotNull TreePattern pattern) {
        if (pattern == null) {
            VertDialect.$$$reportNull$$$0(11);
        }
        TreePattern treePattern = SqlImportUtil.addObjectsByPath((TreePattern)pattern, (ObjectName[])dsNames, Arrays.asList(ObjectName.quoted((String)"v_internal"), ObjectName.quoted((String)"v_catalog"), ObjectName.quoted((String)"v_monitor")), (boolean)false, (ObjectKind[])new ObjectKind[]{SqlImportUtil.DATA_SOURCE, SqlDbElementType.DATABASE, SqlDbElementType.SCHEMA});
        if (treePattern == null) {
            VertDialect.$$$reportNull$$$0(12);
        }
        return treePattern;
    }

    @Nullable
    public EnterHandlerDelegate getEnterHandler() {
        return LazyData.ENTER_HANDLER;
    }

    @NotNull
    public Collection<ObjectKind> getMajorChildKinds() {
        Collection<ObjectKind> collection = LazyData.MAJOR_CHILD_KINDS;
        if (collection == null) {
            VertDialect.$$$reportNull$$$0(13);
        }
        return collection;
    }

    @Nullable
    public SqlExtractFunctionHelper getExtractFunctionHelper() {
        return VertExtractFunctionHelper.INSTANCE;
    }

    public int getMaxIdentifierLength(@NotNull SqlIdentifier identifier, Version version) {
        if (identifier == null) {
            VertDialect.$$$reportNull$$$0(14);
        }
        return 128;
    }

    public <T extends Collection<ObjectKind>> T getParentDbTypes(T result2, ObjectKind type) {
        if (type == SqlDbElementType.PROJECTION) {
            result2.add((ObjectKind)SqlDbElementType.SCHEMA);
        }
        return (T)super.getParentDbTypes(result2, type);
    }

    @Nullable
    private static ObjectName getDbName(@Nullable DbDataSource dataSource) {
        RawConnectionConfig config = SqlImportUtil.getConnectionConfig((DbDataSource)dataSource);
        return ObjectName.plain((String)((String)ObjectUtils.chooseNotNull((Object)SqlDialectImplUtil.getDatabaseName((RawConnectionConfig)config), (Object)SqlDialectImplUtil.getUserName((RawConnectionConfig)config))));
    }

    private static Couple<ObjectName> getScAndDb(@Nullable DbDataSource dataSource) {
        ObjectName dbName = VertDialect.getDbName(dataSource);
        ObjectName scName = null;
        DasNamespace namespace = VertDialect.getDefaultNamespace((DbDataSource)dataSource, (ObjectName)dbName);
        if (namespace != null) {
            DasObject parent2;
            if (namespace.getKind() == SqlDbElementType.SCHEMA) {
                scName = ObjectName.quoted((String)namespace.getName());
            }
            if ((parent2 = namespace.getDasParent()) != null && parent2.getKind() == SqlDbElementType.DATABASE) {
                dbName = ObjectName.quoted((String)parent2.getName());
            }
        }
        if (scName == null) {
            scName = LazyData.PUBLIC_NAME;
        }
        return Couple.of((Object)scName, (Object)dbName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 14: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 14: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/vertica/VertDialect";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeSystem";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedFunctions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeywords";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getReservedKeywords";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemVariables";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "forcedContextPattern";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/vertica/VertDialect";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseImports";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "applyImplicitImports";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getMajorChildKinds";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isValidRawToken";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isTableAliasAllowedAt";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "applyImplicitImports";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getMaxIdentifierLength";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 14: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class LazyData {
        static final TokenClasses ourClasses = new TokenClasses(VertTokens.class);
        static final SqlLanguageDialectEx.BuiltinFunctions ourFunctionMap = SqlFunctionsUtil.loadFunctionDefinition((SqlLanguageDialectEx)INSTANCE);
        static final ObjectName PUBLIC_NAME = ObjectName.quoted((String)"public");
        static final NullableFunction<String, IElementType> ourReservedTokens;
        static Set<String> ourKeywords;
        static Set<String> ourReservedKeywords;
        static final Set<IElementType> ourSupportedOperators;
        private static final EnterHandlerDelegate ENTER_HANDLER;
        private static final Collection<ObjectKind> MAJOR_CHILD_KINDS;

        LazyData() {
        }

        static {
            SqlLexer.initTokens(ourFunctionMap, ourClasses);
            ourReservedTokens = SqlTokenRegistry.getTokenProvider((Class)LazyData.ourClasses.reserved);
            ourKeywords = SqlTokenRegistry.getTokens((Class)LazyData.ourClasses.all);
            ourReservedKeywords = SqlTokenRegistry.getTokens((Class)LazyData.ourClasses.reserved);
            ourSupportedOperators = Set.of(SqlTokens.SQL_QUESTION_MARK, SqlTokens.PG_OP_ABS, SqlTokens.SQL_OP_NOT2, SqlTokens.PG_OP_BITWISE_XOR, SqlTokens.SQL_OP_INVERT, SqlTokens.SQL_OP_CONCAT, SqlTokens.SQL_OP_NULLSAFE_EQ, SqlTokens.SQL_OP_LEFT_SHIFT, SqlTokens.SQL_OP_RIGHT_SHIFT, SqlTokens.SQL_OP_BITWISE_AND, SqlTokens.SQL_OP_BITWISE_OR, SqlTokens.SQL_OP_PLUS, SqlTokens.SQL_OP_MINUS, SqlTokens.SQL_OP_MUL, SqlTokens.SQL_OP_DIV, SqlTokens.SQL_OP_LT, SqlTokens.SQL_OP_GT, SqlTokens.SQL_OP_LE, SqlTokens.SQL_OP_GE, SqlTokens.SQL_OP_EQEQ, SqlTokens.SQL_OP_EQ, SqlTokens.SQL_OP_MODULO, SqlTokens.SQL_OP_BITWISE_XOR, SqlTokens.SQL_OP_NEQ, SqlTokens.SQL_OP_NEQ2);
            ENTER_HANDLER = new SqlEnterHandlerImpl(new SqlCloseBlockProcessor[]{new SqlCloseBlockProcessorImpl(new SqlCloseBlockProcessorImpl.SubstitutionDescriptor[]{new SubstitutionDescriptorImpl(new IElementType[]{SqlCommonKeywords.SQL_BEGIN, SqlCompositeElementTypes.SQL_BLOCK_STATEMENT}, "", "end;", 1, new SubstitutionDescriptorImpl.TailCheck[]{SubstitutionDescriptorImpl.TailCheck.tail((IElementType[])new IElementType[]{SqlCommonKeywords.SQL_END, SqlTokens.SQL_SEMICOLON}).mask(new boolean[]{true, false})})})});
            MAJOR_CHILD_KINDS = Arrays.asList(SqlDbElementType.KEY, SqlDbElementType.INDEX, SqlDbElementType.PROJECTION);
        }
    }
}

