/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.sybase;

import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.SqlTypeSystem;
import com.intellij.sql.dialects.sybase.AseDialect;
import com.intellij.sql.psi.SqlType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AseTypeSystem
extends SqlTypeSystem {
    public static final AseTypeSystem INSTANCE = new AseTypeSystem();

    private AseTypeSystem() {
        super((SqlLanguageDialectEx)AseDialect.INSTANCE);
    }

    @NotNull
    public String getNormalizedTypeName(@NotNull String name2) {
        if (name2 == null) {
            AseTypeSystem.$$$reportNull$$$0(0);
        }
        if ("integer".equals(name2 = super.getNormalizedTypeName(name2))) {
            return "int";
        }
        if ("unsigned integer".equals(name2)) {
            return "unsigned int";
        }
        if ("dec".equals(name2)) {
            return "decimal";
        }
        if ("double precision".equals(name2)) {
            return "float";
        }
        if ("character".equals(name2)) {
            return "char";
        }
        if ("character varying".equals(name2)) {
            return "varchar";
        }
        if ("char varying".equals(name2)) {
            return "varchar";
        }
        if ("nchar varying".equals(name2)) {
            return "nvarchar";
        }
        if ("national char".equals(name2)) {
            return "nchar";
        }
        if ("national character".equals(name2)) {
            return "nchar";
        }
        if ("national char varying".equals(name2)) {
            return "nvarchar";
        }
        if ("national character varying".equals(name2)) {
            return "nvarchar";
        }
        String string = name2;
        if (string == null) {
            AseTypeSystem.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    public String getDefaultTypeName(@NotNull SqlType.Category cat) {
        if (cat == null) {
            AseTypeSystem.$$$reportNull$$$0(2);
        }
        switch (cat) {
            case INTEGER: {
                return "int";
            }
            case REAL: {
                return "numeric";
            }
            case STRING: {
                return "varchar";
            }
            case BOOLEAN: {
                return "boolean";
            }
            case DATE_TIME: {
                return "datetime";
            }
            case DATE: {
                return "date";
            }
            case TIME: {
                return "time";
            }
            case TIMESTAMP: {
                return "timestamp";
            }
            case BYTES: {
                return "blob";
            }
        }
        return null;
    }

    @NotNull
    public SqlType.Category getTypeCategoryByName(@NotNull String typeName) {
        if (typeName == null) {
            AseTypeSystem.$$$reportNull$$$0(3);
        }
        if ("smallmoney".equals(typeName)) {
            SqlType.Category category = SqlType.Category.REAL;
            if (category == null) {
                AseTypeSystem.$$$reportNull$$$0(4);
            }
            return category;
        }
        if ("money".equals(typeName)) {
            SqlType.Category category = SqlType.Category.REAL;
            if (category == null) {
                AseTypeSystem.$$$reportNull$$$0(5);
            }
            return category;
        }
        if ("bit".equals(typeName)) {
            SqlType.Category category = SqlType.Category.INTEGER;
            if (category == null) {
                AseTypeSystem.$$$reportNull$$$0(6);
            }
            return category;
        }
        if ("sysname".equals(typeName)) {
            SqlType.Category category = SqlType.Category.STRING;
            if (category == null) {
                AseTypeSystem.$$$reportNull$$$0(7);
            }
            return category;
        }
        if ("longsysname".equals(typeName)) {
            SqlType.Category category = SqlType.Category.STRING;
            if (category == null) {
                AseTypeSystem.$$$reportNull$$$0(8);
            }
            return category;
        }
        SqlType.Category category = super.getTypeCategoryByName(typeName);
        if (category == null) {
            AseTypeSystem.$$$reportNull$$$0(9);
        }
        return category;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/sybase/AseTypeSystem";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cat";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/sybase/AseTypeSystem";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getNormalizedTypeName";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeCategoryByName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getNormalizedTypeName";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultTypeName";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getTypeCategoryByName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

