/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.postgres.psi;

import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTrigger;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbCustomUsageSearcher;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbRoutine;
import com.intellij.database.psi.DbTable;
import com.intellij.database.psi.DbTrigger;
import com.intellij.database.symbols.DasSymbol;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbUtil;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.dialects.ReservedEntity;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.postgres.PgDialectBase;
import com.intellij.sql.dialects.postgres.psi.PgCreateTriggerStatementImpl;
import com.intellij.sql.dialects.postgres.psi.PgOuterCodeBlockElementType;
import com.intellij.sql.dialects.postgres.psi.PgPsiUtil;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlReturnsClause;
import com.intellij.sql.psi.SqlRoutineDefinition;
import com.intellij.sql.psi.SqlScopeProcessor;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.impl.SqlCreateFunctionStatementImpl;
import com.intellij.sql.psi.impl.SqlCreateTriggerStatementWithFakeTables;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.sql.psi.impl.SqlScopeProcessorBase;
import com.intellij.sql.psi.impl.SqlTableTypeBase;
import com.intellij.sql.psi.impl.SqlTypeFactory;
import com.intellij.sql.psi.stubs.SqlNamedElementStub;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PgCreateFunctionStatementImpl
extends SqlCreateFunctionStatementImpl {
    public PgCreateFunctionStatementImpl(@NotNull ASTNode node) {
        if (node == null) {
            PgCreateFunctionStatementImpl.$$$reportNull$$$0(0);
        }
        super(node);
    }

    public PgCreateFunctionStatementImpl(SqlNamedElementStub<?> stub) {
        super(stub);
    }

    @NotNull
    public JBIterable<SqlStatement> getBody() {
        JBIterable jBIterable = JBIterable.of((Object)PgPsiUtil.getPgBody((SqlRoutineDefinition)this));
        if (jBIterable == null) {
            PgCreateFunctionStatementImpl.$$$reportNull$$$0(1);
        }
        return jBIterable;
    }

    public boolean processImplicitContextDeclarations(SqlScopeProcessor processor, ResolveState state2, PsiElement lastParent, PsiElement place) {
        SqlReferenceExpression ref;
        if (!SqlImplUtil.isProcessingOneOf((SqlScopeProcessor)processor, (ObjectKind[])new ObjectKind[]{ObjectKind.TABLE, ObjectKind.COLUMN})) {
            return true;
        }
        boolean inBody = lastParent.getParent() == this && PsiUtilCore.getElementType((PsiElement)lastParent) instanceof PgOuterCodeBlockElementType;
        SqlReturnsClause returnArgument2 = this.getReturnArgument();
        if (inBody && returnArgument2 != null && SqlImplUtil.getSqlDialectSafe((PsiElement)this).getTypeSystem().isTriggerFunctionType(returnArgument2.getDataType()) && !this.processTriggerDeclarations(processor, state2, place)) {
            return false;
        }
        if (inBody && (ref = (SqlReferenceExpression)ObjectUtils.tryCast((Object)this.getNameElement(), SqlReferenceExpression.class)) != null && !SqlImplUtil.processQualifier((SqlReferenceExpression)ref, (SqlScopeProcessor)processor, (ResolveState)state2, (PsiElement)place)) {
            return false;
        }
        return super.processImplicitContextDeclarations(processor, state2, lastParent, place);
    }

    private boolean processTriggerDeclarations(SqlScopeProcessor processor, ResolveState state2, PsiElement place) {
        SqlCreateTriggerStatementWithFakeTables.FakeTablesHandler handler = this.getFakeHandler();
        if (handler != null && (handler.getProvider() instanceof PgCreateTriggerStatementImpl ? !((PgCreateTriggerStatementImpl)handler.getProvider()).processDeclarations(processor, state2, handler.getProvider().getLastChild(), place) : !handler.processSimple(processor, state2))) {
            return false;
        }
        SqlScopeProcessorBase sqlProcessor = (SqlScopeProcessorBase)ObjectUtils.tryCast((Object)processor, SqlScopeProcessorBase.class);
        if (sqlProcessor != null) {
            PgDialectBase dialect = (PgDialectBase)sqlProcessor.getDialect();
            if (handler == null) {
                if (!sqlProcessor.executeTarget((DasSymbol)dialect.getNewTableAlias(), (SqlType)SqlTableTypeBase.EMPTY_TABLE, null, state2)) {
                    return false;
                }
                if (!sqlProcessor.executeTarget((DasSymbol)dialect.getOldTableAlias(), (SqlType)SqlTableTypeBase.EMPTY_TABLE, null, state2)) {
                    return false;
                }
            }
            SqlType stringType = SqlTypeFactory.defaultType((SqlType.Category)SqlType.Category.STRING, (SqlLanguageDialectEx)SqlImplUtil.getSqlDialectSafe((PsiElement)this));
            for (ReservedEntity entity : dialect.getTriggerStringImplicits().values()) {
                if (sqlProcessor.executeTarget((DasSymbol)entity, stringType, null, state2)) continue;
                return false;
            }
            if (!sqlProcessor.executeTarget((DasSymbol)dialect.getTriggerNArgsColumn(), SqlTypeFactory.defaultType((SqlType.Category)SqlType.Category.INTEGER, (SqlLanguageDialectEx)SqlImplUtil.getSqlDialectSafe((PsiElement)this)), null, state2) || !sqlProcessor.executeTarget((DasSymbol)dialect.getTriggerArgVColumn(), SqlTypeFactory.defaultType((SqlType.Category)SqlType.Category.ARRAY, (SqlLanguageDialectEx)SqlImplUtil.getSqlDialectSafe((PsiElement)this)), null, state2)) {
                return false;
            }
        }
        return true;
    }

    @Nullable
    private SqlCreateTriggerStatementWithFakeTables.FakeTablesHandler getFakeHandler() {
        return (SqlCreateTriggerStatementWithFakeTables.FakeTablesHandler)CachedValuesManager.getCachedValue((PsiElement)this, () -> CachedValueProvider.Result.create((Object)this.findOrCreateHandler(), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
    }

    @Nullable
    private SqlCreateTriggerStatementWithFakeTables.FakeTablesHandler findOrCreateHandler() {
        DbTable table;
        PgCreateTriggerStatementImpl sqlTrigger = this.findSqlTrigger();
        if (sqlTrigger != null) {
            return sqlTrigger.getHandler();
        }
        DbTrigger trigger = this.findDbTrigger();
        DbTable dbTable = table = trigger == null ? null : (DbTable)ObjectUtils.tryCast((Object)trigger.getTable(), DbTable.class);
        if (table == null) {
            return null;
        }
        return PgCreateTriggerStatementImpl.createHandler((PsiElement)this, (PsiElement)table);
    }

    @Nullable
    private DbTrigger findDbTrigger() {
        SqlReferenceExpression ref = (SqlReferenceExpression)ObjectUtils.tryCast((Object)this.getNameElement(), SqlReferenceExpression.class);
        if (ref == null) {
            return null;
        }
        SqlReferenceExpression unboundedRef = SqlPsiElementFactory.createReferenceFromText((String)ref.getText(), (SqlLanguageDialect)SqlImplUtil.getSqlDialectSafe((PsiElement)ref), (SqlReferenceElementType)ref.getReferenceElementType(), (PsiElement)this);
        if (unboundedRef == null) {
            return null;
        }
        for (ResolveResult result2 : unboundedRef.multiResolve(false)) {
            DbDataSource dataSource;
            DasTrigger trigger;
            DasObject routine2;
            PsiElement resolved = result2.getElement();
            if (!(resolved instanceof DbRoutine) || (routine2 = DbUtil.getDasObject((Object)resolved)) == null || (trigger = (DasTrigger)(dataSource = ((DbRoutine)resolved).getDataSource()).getDelegate().getModel().traverser().filter(DasTrigger.class).filter(o2 -> DbCustomUsageSearcher.referencesTarget((DasObject)o2, (DasObject)routine2, (ObjectKind)ObjectKind.ROUTINE)).first()) == null) continue;
            return (DbTrigger)DbImplUtil.findElement((DbDataSource)dataSource, (DasObject)trigger);
        }
        return null;
    }

    @Nullable
    private PgCreateTriggerStatementImpl findSqlTrigger() {
        PgCreateTriggerStatementImpl statement = null;
        SqlFile file = (SqlFile)ObjectUtils.tryCast((Object)this.getContainingFile(), SqlFile.class);
        if (file != null) {
            SqlCreateFunctionStatementImpl target2 = (SqlCreateFunctionStatementImpl)CompletionUtil.getOriginalOrSelf((PsiElement)this);
            statement = (PgCreateTriggerStatementImpl)PsiTreeUtil.getParentOfType((PsiElement)target2, PgCreateTriggerStatementImpl.class);
            if (statement != null) {
                return statement;
            }
            for (SqlElement element : file.getDdl()) {
                SqlFunctionCallExpression call2;
                SqlReferenceExpression ref;
                PgCreateTriggerStatementImpl trigger = (PgCreateTriggerStatementImpl)((Object)ObjectUtils.tryCast((Object)element, PgCreateTriggerStatementImpl.class));
                if (trigger == null || (ref = (call2 = (SqlFunctionCallExpression)ObjectUtils.tryCast((Object)trigger.getTriggerProcedure(), SqlFunctionCallExpression.class)) == null ? null : call2.getNameElement()) == null || !ref.getReference().isReferenceTo((PsiElement)target2)) continue;
                statement = trigger;
                break;
            }
        }
        return statement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/postgres/psi/PgCreateFunctionStatementImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/postgres/psi/PgCreateFunctionStatementImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getBody";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

