/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.postgres;

import com.intellij.database.Dbms;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.symbols.DasSymbol;
import com.intellij.database.util.SearchPath;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.TreePatternNode;
import com.intellij.database.util.TreePatternUtils;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.Couple;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveState;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.ReservedEntity;
import com.intellij.sql.dialects.SqlDialectImplUtil;
import com.intellij.sql.dialects.SqlImportUtil;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.base.SqlLexer;
import com.intellij.sql.dialects.dateTime.SqlDateTimeLanguageHelper;
import com.intellij.sql.dialects.functions.SqlFunctionDefinition;
import com.intellij.sql.dialects.functions.SqlFunctionsUtil;
import com.intellij.sql.dialects.postgres.PgDateTimeLanguageHelper;
import com.intellij.sql.dialects.postgres.PgDialect;
import com.intellij.sql.dialects.postgres.refactoring.PgExtractVariableHelper;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlExpressionList;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlReference;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlScopeProcessor;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.impl.SqlFunctionCallExpressionImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlReferenceImpl;
import com.intellij.sql.psi.impl.SqlScopeProcessorBase;
import com.intellij.sql.psi.stubs.SqlFileElementType;
import com.intellij.sql.refactoring.SqlExtractVariableHelper;
import com.intellij.sql.symbols.DasSymbolUtil;
import com.intellij.util.ObjectUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PgDialectBase
extends SqlLanguageDialectEx {
    private final AtomicNotNullLazyValue<LazyInstanceData> myInstanceData;

    public static boolean inPl(PsiElement element) {
        return SqlFileElementType.isInPl((PsiElement)element);
    }

    public final ReservedEntity getNewTableAlias() {
        return ((LazyInstanceData)this.myInstanceData.getValue()).myNewTableAlias;
    }

    public final ReservedEntity getOldTableAlias() {
        return ((LazyInstanceData)this.myInstanceData.getValue()).myOldTableAlias;
    }

    public final Map<String, ReservedEntity> getTriggerStringImplicits() {
        return ((LazyInstanceData)this.myInstanceData.getValue()).myTriggerStringImplicits;
    }

    public final ReservedEntity getTriggerNArgsColumn() {
        return ((LazyInstanceData)this.myInstanceData.getValue()).myTriggerNArgsColumn;
    }

    public final ReservedEntity getTriggerArgVColumn() {
        return ((LazyInstanceData)this.myInstanceData.getValue()).myTriggerArgVColumn;
    }

    protected void addTypes(Map<String, SqlFunctionDefinition.Type> myTypes) {
        super.addTypes(myTypes);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"dpn", (String)"double precision", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"bigint", (String)"bigint", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"numeric", (String)"numeric", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"dp", (String)"double precision", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"bytea", (String)"bytea", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"name", (String)"name", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"oid", (String)"oid", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"gobject", (String)"geometric object", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"circle", (String)"circle", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"path", (String)"path", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"box", (String)"box", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"polygon", (String)"polygon", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"lseg", (String)"lseg", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"point", (String)"point", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"line", (String)"line", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"cidr", (String)"cidr", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"inet", (String)"inet", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"macaddr", (String)"macaddr", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"tsvector", (String)"tsvector", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"tsquery", (String)"tsquery", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"trigger", (String)"trigger", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"range", (String)"range", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"txid_snapshot", (String)"txid_snapshot", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"void", (String)"void", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"record", (String)"record", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"enum", (String)"enum", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"xml", (String)"xml", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"float4", (String)"float4", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"int2vector", (String)"int2vector", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"json", (String)"json", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"jsonb", (String)"jsonb", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"regclass", (String)"regclass", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"regdictionary", (String)"regdictionary", (SqlLanguageDialectEx)this);
    }

    public PgDialectBase(@NotNull String id) {
        if (id == null) {
            PgDialectBase.$$$reportNull$$$0(0);
        }
        super(id);
        this.myInstanceData = AtomicNotNullLazyValue.createValue(() -> new LazyInstanceData());
    }

    public boolean processReservedEntitiesWithType(@Nullable String name2, @NotNull PsiElement place, boolean resolve2, @NotNull SqlScopeProcessor processor) {
        SqlFunctionDefinition definition;
        SqlReferenceExpression ref;
        if (place == null) {
            PgDialectBase.$$$reportNull$$$0(1);
        }
        if (processor == null) {
            PgDialectBase.$$$reportNull$$$0(2);
        }
        SqlExpression qualifier = (ref = (SqlReferenceExpression)ObjectUtils.tryCast((Object)place, SqlReferenceExpression.class)) == null ? null : ref.getQualifierExpression();
        boolean isFunctionCall = place.getParent() instanceof SqlFunctionCallExpression;
        SqlFunctionDefinition sqlFunctionDefinition = definition = name2 == null || qualifier == null || isFunctionCall ? null : this.getSupportedFunctions().get(name2);
        if (definition != null) {
            for (SqlFunctionDefinition.Prototype prototype : definition.getPrototypes()) {
                SqlType type;
                if (prototype.getParams().length != 1 || processor.executeTarget((DasSymbol)definition, type = SqlFunctionCallExpressionImpl.createBuiltinFunctionReturnType((SqlFunctionDefinition.Prototype)prototype, (SqlReferenceExpression)ref, (PsiElement)qualifier, (PsiElement)ref), null, ResolveState.initial())) continue;
                return false;
            }
        }
        return true;
    }

    public boolean processUnqualifiedResolve(@NotNull SqlScopeProcessor processor, @NotNull ResolveState state2, @NotNull PsiReference ref) {
        if (processor == null) {
            PgDialectBase.$$$reportNull$$$0(3);
        }
        if (state2 == null) {
            PgDialectBase.$$$reportNull$$$0(4);
        }
        if (ref == null) {
            PgDialectBase.$$$reportNull$$$0(5);
        }
        PsiElement place = ref.getElement();
        if (processor.isExpected(ObjectKind.ROUTINE)) {
            List exprs;
            SqlFunctionCallExpression callExpression = (SqlFunctionCallExpression)ObjectUtils.tryCast((Object)place.getParent(), SqlFunctionCallExpression.class);
            SqlExpressionList params = callExpression == null ? null : callExpression.getParameterList();
            List list = exprs = params == null ? Collections.emptyList() : params.getExpressionList();
            if (exprs.size() == 1) {
                SqlTableType type = (SqlTableType)ObjectUtils.tryCast((Object)((SqlExpression)exprs.get(0)).getSqlType(), SqlTableType.class);
                if (type == null) {
                    return true;
                }
                Set expected = processor.getInitialExpectedTypes();
                processor.setExpectedKinds(Collections.singleton(ObjectKind.COLUMN));
                boolean res2 = SqlImplUtil.processDeclarationsInType((SqlTableType)type, (SqlScopeProcessor)processor, (ResolveState)state2, (PsiElement)place);
                processor.setExpectedKinds(expected);
                if (!res2) {
                    return false;
                }
            }
        }
        return super.processUnqualifiedResolve(processor, state2, ref);
    }

    public boolean processQualifiedResolve(@NotNull SqlScopeProcessor processor, @NotNull ResolveState state2, @NotNull SqlReference ref, @NotNull SqlExpression qualifier) {
        DasSymbol qualifierSymbol;
        if (processor == null) {
            PgDialectBase.$$$reportNull$$$0(6);
        }
        if (state2 == null) {
            PgDialectBase.$$$reportNull$$$0(7);
        }
        if (ref == null) {
            PgDialectBase.$$$reportNull$$$0(8);
        }
        if (qualifier == null) {
            PgDialectBase.$$$reportNull$$$0(9);
        }
        if (SqlImplUtil.isProcessingOneOf((SqlScopeProcessor)processor, (ObjectKind[])new ObjectKind[]{ObjectKind.COLUMN, ObjectKind.VARIABLE}) && qualifier instanceof SqlReferenceExpression && ((qualifierSymbol = ((SqlReferenceExpression)qualifier).resolveSymbol()) == ((LazyInstanceData)this.myInstanceData.getValue()).myOldTableAlias || qualifierSymbol == ((LazyInstanceData)this.myInstanceData.getValue()).myNewTableAlias)) {
            return processor.executeTarget(DasSymbolUtil.getInlineSymbol((SqlReference)ref), null, Boolean.valueOf(false), state2);
        }
        if (!processor.isExpected(ObjectKind.COLUMN)) {
            return true;
        }
        if (processor.getReferenceName() == null && qualifier.getSqlType() == SqlType.UNKNOWN) {
            return true;
        }
        if (qualifier.getSqlType().getCategory() == SqlType.Category.RECORD) {
            return processor.executeTarget(DasSymbolUtil.getInlineSymbol((SqlReference)ref), (SqlType)SqlType.UNKNOWN, Boolean.valueOf(false), state2);
        }
        SqlScopeProcessorBase filteringProcessor = PgDialectBase.filterSingleArgumentRoutines(processor);
        SqlReferenceImpl refImpl = (SqlReferenceImpl)ObjectUtils.tryCast((Object)ref, SqlReferenceImpl.class);
        if (refImpl != null && !refImpl.processUnqualifiedResolveVariants((SqlScopeProcessor)filteringProcessor, ResolveState.initial())) {
            return false;
        }
        return super.processQualifiedResolve(processor, state2, ref, qualifier);
    }

    public <T extends Collection<ObjectKind>> T getParentDbTypes(T result2, ObjectKind type) {
        if (type == ObjectKind.COLUMN) {
            result2.add((ObjectKind)ObjectKind.COLUMN);
        }
        return (T)super.getParentDbTypes(result2, type);
    }

    public boolean isResolveTargetAccepted(@Nullable DasSymbol symbol, ObjectKind type, @NotNull Set<ObjectKind> expectedTypes, @Nullable PsiElement place, boolean strict, boolean isCompletion) {
        if (expectedTypes == null) {
            PgDialectBase.$$$reportNull$$$0(10);
        }
        if (strict) {
            return false;
        }
        if (type == ObjectKind.COLUMN && expectedTypes.contains(ObjectKind.VARIABLE)) {
            return true;
        }
        if (type == ObjectKind.AGGREGATE && expectedTypes.contains(ObjectKind.ROUTINE)) {
            return true;
        }
        if (ModelConsts.TABLE_OR_VIEW_KINDS.contains(type) && expectedTypes.contains(ObjectKind.OBJECT_TYPE)) {
            return true;
        }
        if (expectedTypes.contains(ObjectKind.COLUMN) && type == ObjectKind.ROUTINE) {
            if (place instanceof SqlReferenceExpression) {
                return ((SqlReferenceExpression)place).getQualifierExpression() != null;
            }
            return true;
        }
        return super.isResolveTargetAccepted(symbol, type, expectedTypes, place, strict, isCompletion);
    }

    @NotNull
    private static SqlScopeProcessorBase filterSingleArgumentRoutines(final SqlScopeProcessor sqlProcessor) {
        SqlScopeProcessorBase processor = new SqlScopeProcessorBase(sqlProcessor.getReferenceName(), (SqlLanguageDialectEx)sqlProcessor.getDialect(), sqlProcessor.getDataSources(), sqlProcessor.getPlace()){

            public boolean isResultEmpty() {
                return sqlProcessor.isResultEmpty();
            }

            public boolean executeTarget(@NotNull DasSymbol symbol, @Nullable SqlType sqlType, @Nullable Boolean forcedCaseSens, @NotNull ResolveState state2) {
                if (symbol == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (state2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                return !SqlFunctionsUtil.isSingleArgumentRoutine((DasObject)symbol.getDasObject()) || sqlProcessor.executeTarget(symbol, sqlType, forcedCaseSens, state2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "symbol";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "state";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/sql/dialects/postgres/PgDialectBase$1";
                objectArray[2] = "executeTarget";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        processor.setExpectedKinds(Collections.singleton(ObjectKind.ROUTINE));
        SqlScopeProcessorBase sqlScopeProcessorBase = processor;
        if (sqlScopeProcessorBase == null) {
            PgDialectBase.$$$reportNull$$$0(11);
        }
        return sqlScopeProcessorBase;
    }

    @NotNull
    public TreePattern forcedContextPattern(@Nullable DbDataSource dataSource, @Nullable SearchPath searchPath) {
        Couple<ObjectName> scAndDb = PgDialectBase.getScAndDb(dataSource);
        TreePatternNode.Group[] schemas2 = SqlImportUtil.optAr((TreePatternNode.Group)TreePatternUtils.create((ObjectName)((ObjectName)scAndDb.first), (ObjectKind)ObjectKind.SCHEMA, (TreePatternNode.Group[])new TreePatternNode.Group[0]));
        TreePattern treePattern = this.applyImplicitImports(SqlImportUtil.getRealDsNames((DbDataSource)dataSource), SqlDialectImplUtil.forcedContextExpandedToSchemas((DbDataSource)dataSource, (Dbms)this.getDbms(), (SearchPath)searchPath, (TreePatternNode.Group[])schemas2, (TreePatternNode.Group[])SqlImportUtil.optAr((TreePatternNode.Group)TreePatternUtils.create((ObjectName)((ObjectName)scAndDb.second), (ObjectKind)ObjectKind.DATABASE, (TreePatternNode.Group[])schemas2))));
        if (treePattern == null) {
            PgDialectBase.$$$reportNull$$$0(12);
        }
        return treePattern;
    }

    public boolean isValidRawToken(@NotNull IElementType type, @NotNull CharSequence text) {
        if (type == null) {
            PgDialectBase.$$$reportNull$$$0(13);
        }
        if (text == null) {
            PgDialectBase.$$$reportNull$$$0(14);
        }
        return SqlLexer.isValidRawCopyToken(text);
    }

    public boolean supportsJoinUsing() {
        return true;
    }

    public boolean supportsNaturalJoin() {
        return true;
    }

    @NotNull
    public SqlDateTimeLanguageHelper getDateTimeHelper() {
        PgDateTimeLanguageHelper pgDateTimeLanguageHelper = PgDateTimeLanguageHelper.INSTANCE;
        if (pgDateTimeLanguageHelper == null) {
            PgDialectBase.$$$reportNull$$$0(15);
        }
        return pgDateTimeLanguageHelper;
    }

    @Nullable
    public SqlExtractVariableHelper getExtractVariableHelper() {
        return new PgExtractVariableHelper(this);
    }

    private static Couple<ObjectName> getScAndDb(@Nullable DbDataSource dataSource) {
        ObjectName dbName = PgDialectBase.getDbName(dataSource);
        ObjectName scName = null;
        DasNamespace namespace = PgDialectBase.getDefaultNamespace((DbDataSource)dataSource, (ObjectName)dbName);
        if (namespace != null) {
            DasObject parent2;
            if (namespace.getKind() == ObjectKind.SCHEMA) {
                scName = ObjectName.quoted((String)namespace.getName());
            }
            if ((parent2 = namespace.getDasParent()) != null && parent2.getKind() == ObjectKind.DATABASE) {
                dbName = ObjectName.quoted((String)parent2.getName());
            }
        }
        if (scName == null) {
            scName = PgDialect.LazyData.PUBLIC_NAME;
        }
        return Couple.of((Object)scName, (Object)dbName);
    }

    @Nullable
    protected static ObjectName getDbName(@Nullable DbDataSource dataSource) {
        RawConnectionConfig config = SqlImportUtil.getConnectionConfig((DbDataSource)dataSource);
        return ObjectName.plain((String)((String)ObjectUtils.chooseNotNull((Object)SqlDialectImplUtil.getDatabaseName((RawConnectionConfig)config), (Object)SqlDialectImplUtil.getUserName((RawConnectionConfig)config))));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 12: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 12: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedTypes";
                break;
            }
            case 11: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/postgres/PgDialectBase";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/postgres/PgDialectBase";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "filterSingleArgumentRoutines";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "forcedContextPattern";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getDateTimeHelper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "processReservedEntitiesWithType";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processUnqualifiedResolve";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "processQualifiedResolve";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isResolveTargetAccepted";
                break;
            }
            case 11: 
            case 12: 
            case 15: {
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isValidRawToken";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 12: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class LazyInstanceData {
        private final ReservedEntity myNewTableAlias;
        private final ReservedEntity myOldTableAlias;
        private final Map<String, ReservedEntity> myTriggerStringImplicits;
        private final ReservedEntity myTriggerNArgsColumn;
        private final ReservedEntity myTriggerArgVColumn;

        private LazyInstanceData() {
            this.myNewTableAlias = new ReservedEntity(PgDialectBase.this.getDbms(), "new", ObjectKind.TABLE);
            this.myOldTableAlias = new ReservedEntity(PgDialectBase.this.getDbms(), "old", ObjectKind.TABLE);
            this.myTriggerStringImplicits = SqlDialectImplUtil.buildEntities((Dbms)PgDialectBase.this.getDbms(), (ObjectKind)ObjectKind.COLUMN, (String[])new String[]{"tg_name", "tg_when", "tg_level", "tg_op", "tg_relid", "tg_relname", "tg_table_name", "tg_table_schema", "tg_tag", "tg_event"});
            this.myTriggerNArgsColumn = new ReservedEntity(PgDialectBase.this.getDbms(), "tg_nargs", ObjectKind.COLUMN);
            this.myTriggerArgVColumn = new ReservedEntity(PgDialectBase.this.getDbms(), "tg_argv", ObjectKind.COLUMN);
        }
    }
}

