/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.oraplus;

import com.intellij.lexer.Lexer;
import com.intellij.lexer.LexerPosition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.oracle.OraLexer;
import com.intellij.sql.dialects.oraplus.OraPlusDialect;
import com.intellij.sql.dialects.oraplus.OraPlusTokens;
import com.intellij.sql.dialects.oraplus.OraPlusTypes;
import com.intellij.sql.dialects.oraplus._OraPlusLexer;
import com.intellij.sql.psi.SqlTokens;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class OraPlusLexer
extends OraLexer {
    private static final Pattern SUBS_ID = Pattern.compile("[a-z0-9_]+", 2);
    private static final Pattern VERSION_PATTERN = Pattern.compile("\\d+(\\.\\d+){1,2}");
    private static final Pattern VERSION_PATTERN_TAIL = Pattern.compile("(\\.\\d+){1,2}");
    private ExpectationState myExpectingFormat = null;
    private boolean myExpectingSubsVar;
    private boolean myExpectingVersion;
    private DefineState myDefineState = null;

    public OraPlusLexer() {
        super(OraPlusDialect.LazyData.ourClasses, new _OraPlusLexer());
    }

    @Override
    protected void lookAhead(@NotNull Lexer baseLexer) {
        if (baseLexer == null) {
            OraPlusLexer.$$$reportNull$$$0(0);
        }
        if (!(this.remapDelimiterAfterContinuation(baseLexer) || this.remapRemark(baseLexer) || this.remapSlashSeparator(baseLexer) || this.remapParams(baseLexer) || this.remapBackslash(baseLexer) || this.remapDotSymbol(baseLexer) || this.remapVersion(baseLexer) || this.remapSubsVar(baseLexer) || this.remapFormat(baseLexer))) {
            super.lookAhead(baseLexer);
        }
        this.updateStates();
    }

    private boolean remapDelimiterAfterContinuation(Lexer lexer) {
        IElementType type = lexer.getTokenType();
        if (type == SqlTokens.SQL_OP_MINUS) {
            this.advanceLexer(lexer);
            if (lexer.getTokenType() == SqlTokens.ORAP_DELIMITER_TOKEN) {
                this.advanceAs(lexer, SqlTokens.WHITE_SPACE);
            }
            return true;
        }
        return false;
    }

    private boolean remapFormat(Lexer lexer) {
        if (this.myExpectingFormat == null) {
            return false;
        }
        IElementType type = lexer.getTokenType();
        if (type == SqlTokens.BAD_CHARACTER) {
            this.advanceAs(lexer, (IElementType)SqlTokens.SQL_IDENT);
            return true;
        }
        return false;
    }

    private boolean remapRemark(Lexer lexer) {
        if (lexer.getTokenType() != SqlTokens.SQL_IDENT) {
            return false;
        }
        String text = lexer.getTokenText();
        if ("REM".equalsIgnoreCase(text) || "REMARK".equalsIgnoreCase(text)) {
            CharSequence buf = lexer.getBufferSequence();
            if (!OraPlusLexer.isStartOfLine(lexer)) {
                return false;
            }
            int idx = StringUtil.indexOfAny((CharSequence)buf, (String)"\n\r", (int)lexer.getTokenEnd(), (int)lexer.getBufferEnd());
            if (idx == -1) {
                idx = lexer.getBufferEnd();
            }
            this.addToken(idx, (IElementType)SqlTokens.ORAP_LINE_COMMENT);
            lexer.start(buf, idx, lexer.getBufferEnd(), lexer.getState());
            return true;
        }
        return false;
    }

    private boolean remapSlashSeparator(Lexer lexer) {
        IElementType type = lexer.getTokenType();
        if (type != SqlTokens.ORAP_DELIMITER_TOKEN && type != SqlTokens.ORAP_BIG_DELIMITER_TOKEN) {
            return false;
        }
        LexerPosition position = lexer.getCurrentPosition();
        lexer.advance();
        if (lexer.getTokenType() != SqlTokens.SQL_OP_DIV) {
            lexer.restore(position);
            return false;
        }
        this.addToken(lexer.getTokenStart(), SqlTokens.SQL_WHITE_SPACE);
        this.advanceAs(lexer, (IElementType)SqlTokens.ORAP_SLASH_DELIMITER_TOKEN);
        type = lexer.getTokenType();
        if (type == SqlTokens.ORAP_DELIMITER_TOKEN || type == SqlTokens.ORAP_BIG_DELIMITER_TOKEN) {
            this.advanceAs(lexer, SqlTokens.WHITE_SPACE);
        }
        return true;
    }

    private boolean remapSubsVar(Lexer lexer) {
        if (this.myExpectingSubsVar) {
            IElementType firstType;
            int advances = 0;
            IElementType type = firstType = lexer.getTokenType();
            LexerPosition position = lexer.getCurrentPosition();
            while (!OraPlusTokens.WHITE_SPACE_TOKENS.contains(type) && SUBS_ID.matcher(lexer.getTokenText()).matches()) {
                type = lexer.getTokenType();
                lexer.advance();
                ++advances;
            }
            if (advances == 0) {
                return false;
            }
            if (advances == 1 && firstType != SqlTokens.BAD_CHARACTER) {
                lexer.restore(position);
                return false;
            }
            this.addToken(lexer.getTokenStart(), (IElementType)SqlTokens.SQL_IDENT);
            return true;
        }
        return false;
    }

    private void updateStates() {
        IElementType current = this.getTokenType();
        if (!OraPlusTokens.WHITE_SPACE_TOKENS.contains(current)) {
            this.myExpectingFormat = this.myExpectingFormat == null ? (current == OraPlusTypes.ORAP_FORMAT || current == OraPlusTypes.ORAP_FOR || current == OraPlusTypes.ORAP_NUMFORMAT || current == OraPlusTypes.ORAP_NUMF ? ExpectationState.EXPECTING : null) : (current != SqlTokens.ORAP_DELIMITER_TOKEN && current != SqlTokens.ORAP_BIG_DELIMITER_TOKEN && current != SqlTokens.ORAP_SLASH_DELIMITER_TOKEN && current != SqlTokens.SQL_WHITE_SPACE && current != SqlTokens.SQL_OP_BITWISE_AND && current != SqlTokens.SQL_STRING_TOKEN && current != SqlTokens.SQL_IDENT_DELIMITED ? ExpectationState.PROCESSING : null);
            boolean bl = this.myExpectingVersion = current == OraPlusTypes.ORAP_SQLPLUSCOMPATIBILITY || current == OraPlusTypes.ORAP_SQLPLUSCOMPAT;
            if ((current == OraPlusTypes.ORAP_DEFINE || current == OraPlusTypes.ORAP_DEF) && this.myDefineState == null) {
                this.myDefineState = DefineState.DEF_VAR;
                this.myExpectingSubsVar = true;
            } else if (this.myDefineState == DefineState.DEF_VAR) {
                this.myDefineState = DefineState.DEF_EQ;
                this.myExpectingSubsVar = false;
            } else if (current == SqlTokens.SQL_OP_EQ && this.myDefineState == DefineState.DEF_EQ) {
                this.myDefineState = DefineState.DEF_VAL;
                this.myExpectingSubsVar = true;
            } else {
                this.myDefineState = null;
                this.myExpectingSubsVar = current == SqlTokens.SQL_OP_BITWISE_AND;
            }
        } else if (this.myExpectingFormat == ExpectationState.PROCESSING) {
            this.myExpectingFormat = null;
        }
    }

    private boolean remapBackslash(Lexer lexer) {
        if (lexer.getTokenType() == SqlTokens.BAD_CHARACTER && StringUtil.equals((CharSequence)lexer.getTokenText(), (CharSequence)"\\")) {
            this.advanceAs(lexer, (IElementType)SqlTokens.SQL_IDENT);
            return true;
        }
        return false;
    }

    private boolean remapDotSymbol(Lexer lexer) {
        if (lexer.getTokenType() == SqlTokens.BAD_CHARACTER && lexer.getTokenText().equals(".")) {
            this.advanceAs(lexer, (IElementType)SqlTokens.SQL_INTEGER_TOKEN);
            return true;
        }
        return false;
    }

    private boolean remapVersion(Lexer lexer) {
        if (!this.myExpectingVersion) {
            return false;
        }
        boolean added = false;
        IElementType type = lexer.getTokenType();
        while (type == SqlTokens.SQL_PERIOD || added && type == SqlTokens.SQL_INTEGER_TOKEN || (type == SqlTokens.BAD_CHARACTER || type == SqlTokens.SQL_FLOAT_TOKEN) && (added ? VERSION_PATTERN_TAIL : VERSION_PATTERN).matcher(lexer.getTokenText()).matches()) {
            lexer.advance();
            type = lexer.getTokenType();
            added = true;
        }
        if (added) {
            this.addToken(lexer.getTokenStart(), (IElementType)OraPlusTokens.ORAP_VERSION_TOKEN);
        }
        return added;
    }

    private boolean remapParams(Lexer lexer) {
        IElementType type = lexer.getTokenType();
        if (type == SqlTokens.SQL_OP_BITWISE_AND || type == SqlTokens.SQL_OP_LOGICAL_AND) {
            LexerPosition position = lexer.getCurrentPosition();
            lexer.advance();
            if (lexer.getTokenType() == SqlTokens.SQL_INTEGER_TOKEN) {
                this.addToken(lexer.getTokenStart(), type);
                this.advanceAs(lexer, (IElementType)SqlTokens.SQL_IDENT);
                return true;
            }
            if (lexer.getTokenType() == SqlTokens.SQL_FLOAT_TOKEN) {
                int dot = lexer.getTokenText().indexOf(46);
                if (dot != -1) {
                    int start2 = lexer.getTokenStart();
                    this.addToken(start2, type);
                    this.addToken(start2 + dot, (IElementType)SqlTokens.SQL_IDENT);
                    this.addToken(start2 + dot + 1, (IElementType)SqlTokens.SQL_PERIOD);
                    lexer.start(lexer.getBufferSequence(), start2 + dot + 1, lexer.getBufferEnd(), 0);
                    return true;
                }
            } else if (lexer.getTokenType() == SqlTokens.SQL_IDENT) {
                this.addToken(lexer.getTokenStart(), type);
                this.advanceAs(lexer, (IElementType)SqlTokens.SQL_IDENT);
                if (lexer.getTokenType() == SqlTokens.SQL_OP_RANGE) {
                    this.addToken(lexer.getTokenEnd() - 1, (IElementType)SqlTokens.SQL_PERIOD);
                    this.advanceAs(lexer, (IElementType)SqlTokens.SQL_PERIOD);
                }
                return true;
            }
            lexer.restore(position);
        }
        return false;
    }

    private static boolean isStartOfLine(Lexer lexer) {
        int start2 = lexer.getTokenStart();
        CharSequence buf = lexer.getBufferSequence();
        int prev = start2 > 0 ? (int)buf.charAt(start2 - 1) : 10;
        return prev == 10 || prev == 13;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseLexer", "com/intellij/sql/dialects/oraplus/OraPlusLexer", "lookAhead"));
    }

    private static enum ExpectationState {
        EXPECTING,
        PROCESSING;

    }

    private static enum DefineState {
        DEF_VAR,
        DEF_EQ,
        DEF_VAL;

    }
}

