/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.oracle.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.database.Dbms;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.refactoring.suggested.UtilsKt;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.actions.NavigationHelper;
import com.intellij.sql.actions.members.SqlMembersHelper;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.oracle.inspections.OraUnmatchedForwardDeclarationInspection;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.psi.SqlBlockStatement;
import com.intellij.sql.psi.SqlCreateStatement;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlRoutineDefinition;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.util.containers.JBIterable;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0014\u00a8\u0006\u000f"}, d2={"Lcom/intellij/sql/dialects/oracle/inspections/OraUnmatchedForwardDeclarationInspection;", "Lcom/intellij/sql/inspections/SqlInspectionBase;", "()V", "createAnnotationVisitor", "Lcom/intellij/sql/inspections/SqlInspectionBase$SqlAnnotationVisitor;", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialectEx;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "result", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "onTheFly", "", "AddDefinitionFix", "intellij.database.dialects.oracle"})
public final class OraUnmatchedForwardDeclarationInspection
extends SqlInspectionBase {
    @Nullable
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(@NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result2, boolean onTheFly) {
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        Dbms dbms = dialect.getDbms();
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"dialect.dbms");
        if (!dbms.isOracle()) {
            return null;
        }
        NavigationHelper helper = (NavigationHelper)NavigationHelper.EP.forDbms(dialect.getDbms());
        return new SqlInspectionBase.SqlAnnotationVisitor(helper, onTheFly, manager, dialect, result2, manager, (SqlLanguageDialect)dialect, result2){
            final /* synthetic */ NavigationHelper $helper;
            final /* synthetic */ boolean $onTheFly;
            final /* synthetic */ InspectionManager $manager;
            final /* synthetic */ SqlLanguageDialectEx $dialect;
            final /* synthetic */ List $result;

            public void visitSqlBlockStatement(@NotNull SqlBlockStatement o2) {
                Intrinsics.checkNotNullParameter((Object)o2, (String)"o");
                super.visitSqlBlockStatement(o2);
                this.checkBlock((SqlElement)o2);
            }

            public void visitSqlCreateStatement(@NotNull SqlCreateStatement o2) {
                Intrinsics.checkNotNullParameter((Object)o2, (String)"o");
                super.visitSqlCreateStatement(o2);
                if (Intrinsics.areEqual((Object)o2.getKind(), (Object)ObjectKind.BODY)) {
                    this.checkBlock((SqlElement)o2);
                }
            }

            private final void checkBlock(SqlElement block) {
                for (PsiElement child : SqlImplUtil.sqlChildren((PsiElement)((PsiElement)block))) {
                    if (!(child instanceof SqlRoutineDefinition)) continue;
                    JBIterable jBIterable = ((SqlRoutineDefinition)child).getBody();
                    Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"child.body");
                    if (jBIterable.isNotEmpty()) continue;
                    Pair definitions = this.$helper.findDefinitions((DasObject)child, false);
                    if (definitions != null) {
                        Object object = definitions.second;
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"definitions.second");
                        if (!((JBIterable)object).isEmpty()) continue;
                    }
                    this.reportUnmatchedForward((SqlRoutineDefinition)child);
                }
            }

            private final void reportUnmatchedForward(SqlRoutineDefinition routine2) {
                this.addDescriptor(this.myManager.createProblemDescriptor((PsiElement)routine2, (PsiElement)routine2, SqlBundle.message((String)"inspection.message.unmatched.forward", (Object[])new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.$onTheFly, new LocalQuickFix[]{AddDefinitionFix.INSTANCE}));
            }
            {
                this.$helper = $captured_local_variable$0;
                this.$onTheFly = $captured_local_variable$1;
                this.$manager = $captured_local_variable$2;
                this.$dialect = $captured_local_variable$3;
                this.$result = $captured_local_variable$4;
                super($super_call_param$5, $super_call_param$6, $super_call_param$7);
            }
        };
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\t\u001a\f0\n\u00a2\u0006\u0002\b\u000b\u00a2\u0006\u0002\b\fH\u0016J\u0014\u0010\r\u001a\u00020\u000e*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\nH\u0002\u00a8\u0006\u0011"}, d2={"Lcom/intellij/sql/dialects/oracle/inspections/OraUnmatchedForwardDeclarationInspection$AddDefinitionFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "()V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "isLeaf", "", "Lcom/intellij/psi/PsiElement;", "text", "intellij.database.dialects.oracle"})
    public static final class AddDefinitionFix
    implements LocalQuickFix {
        public static final AddDefinitionFix INSTANCE;

        @NotNull
        public String getFamilyName() {
            String string = SqlBundle.message((String)"quickfix.name.add.definition", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"SqlBundle.message(\"quickfix.name.add.definition\")");
            return string;
        }

        private final boolean isLeaf(PsiElement $this$isLeaf, String text) {
            return $this$isLeaf instanceof LeafPsiElement && Intrinsics.areEqual((Object)((LeafPsiElement)$this$isLeaf).getText(), (Object)text);
        }

        /*
         * Unable to fully structure code
         */
        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            v0 = (SqlRoutineDefinition)descriptor.getStartElement();
            if (v0 == null) {
                return;
            }
            header = v0;
            v1 = header.getBody();
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"header.body");
            if (v1.isNotEmpty()) {
                return;
            }
            v2 = SqlImplUtil.sqlParent((PsiElement)((PsiElement)header));
            if (v2 == null) {
                return;
            }
            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"SqlImplUtil.sqlParent(header) ?: return");
            parent = v2;
            v3 = SqlImplUtil.getSqlDialectSafe((PsiElement)((PsiElement)header));
            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"SqlImplUtil.getSqlDialectSafe(header)");
            dialect = v3;
            v4 = (SqlMembersHelper)SqlMembersHelper.EP.forDbms(dialect.getDbms());
            if (v4 == null) {
                return;
            }
            helper = v4;
            v5 = header.getContainingFile();
            if (v5 == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.sql.psi.SqlFile");
            }
            delimiter = dialect.getDelimiterAt((SqlFile)v5, UtilsKt.getStartOffset((PsiElement)((PsiElement)header)));
            v6 = SqlImplUtil.siblings((PsiElement)((PsiElement)header)).skip(1).filter((Condition)applyFix.siblings.1.INSTANCE);
            Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"SqlImplUtil.siblings(hea\u2026ce && it !is PsiComment }");
            siblings = v6;
            v7 = (PsiElement)siblings.first();
            if (v7 == null) ** GOTO lbl-1000
            v8 = delimiter;
            Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"delimiter");
            if (!this.isLeaf(v7, v8)) lbl-1000:
            // 2 sources

            {
                v9 = parent.addAfter(SqlPsiElementFactory.createLeafFromText((Project)project, (SqlLanguageDialect)((SqlLanguageDialect)dialect), (String)delimiter), (PsiElement)header);
            } else {
                v10 = siblings.takeWhile((Condition)new Condition<PsiElement>(delimiter){
                    final /* synthetic */ String $delimiter;

                    public final boolean value(PsiElement it) {
                        PsiElement psiElement = it;
                        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"it");
                        String string = this.$delimiter;
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"delimiter");
                        return AddDefinitionFix.access$isLeaf(AddDefinitionFix.INSTANCE, psiElement, string);
                    }
                    {
                        this.$delimiter = string;
                    }
                }).last();
                Intrinsics.checkNotNull((Object)v10);
                v9 = (PsiElement)v10;
            }
            anchor = v9;
            v11 = helper.generateImplementation(header);
            Intrinsics.checkNotNullExpressionValue((Object)v11, (String)"helper.generateImplementation(header)");
            definition = v11;
            definitionInPlace = anchor != null ? parent.addAfter((PsiElement)definition, anchor) : parent.add((PsiElement)definition);
            v12 = SqlPsiElementFactory.newLine((Project)project);
            Intrinsics.checkNotNullExpressionValue((Object)v12, (String)"SqlPsiElementFactory.newLine(project)");
            newLine = v12;
            parent.addAfter(newLine, anchor);
            parent.addAfter(newLine, anchor);
            var13_13 = PsiDocumentManager.getInstance((Project)project);
            var14_14 = false;
            var15_15 = false;
            $this$with = var13_13;
            $i$a$-with-OraUnmatchedForwardDeclarationInspection$AddDefinitionFix$applyFix$1 = false;
            v13 = $this$with.getDocument(header.getContainingFile());
            if (v13 == null) {
            } else {
                $this$with.doPostponedOperationsAndUnblockDocument(v13);
            }
            CodeStyleManager.getInstance((Project)project).reformat(definitionInPlace);
        }

        private AddDefinitionFix() {
        }

        static {
            AddDefinitionFix addDefinitionFix;
            INSTANCE = addDefinitionFix = new AddDefinitionFix();
        }

        public static final /* synthetic */ boolean access$isLeaf(AddDefinitionFix $this, PsiElement $this$access_u24isLeaf, String text) {
            return $this.isLeaf($this$access_u24isLeaf, text);
        }
    }
}

