/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.oracle.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.database.Dbms;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasUserDefinedType;
import com.intellij.database.model.ObjectKind;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.actions.NavigationHelper;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.oracle.OraTypeSystem;
import com.intellij.sql.dialects.oracle.OraTypes;
import com.intellij.sql.dialects.oracle.psi.OraCreatePackageStatementImpl;
import com.intellij.sql.dialects.oracle.psi.OraMemberFunctionDefinitionImpl;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.psi.SqlCreateStatement;
import com.intellij.sql.psi.SqlCreateTypeStatement;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0014\u00a8\u0006\u000e"}, d2={"Lcom/intellij/sql/dialects/oracle/inspections/OraMissingBodyInspection;", "Lcom/intellij/sql/inspections/SqlInspectionBase;", "()V", "createAnnotationVisitor", "Lcom/intellij/sql/inspections/SqlInspectionBase$SqlAnnotationVisitor;", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialectEx;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "result", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "onTheFly", "", "intellij.database.dialects.oracle"})
public final class OraMissingBodyInspection
extends SqlInspectionBase {
    @Nullable
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(@NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result2, boolean onTheFly) {
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        Dbms dbms = dialect.getDbms();
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"dialect.dbms");
        if (!dbms.isOracle()) {
            return null;
        }
        NavigationHelper helper = (NavigationHelper)NavigationHelper.EP.forDbms(dialect.getDbms());
        return new SqlInspectionBase.SqlAnnotationVisitor(helper, onTheFly, manager, dialect, result2, manager, (SqlLanguageDialect)dialect, result2){
            final /* synthetic */ NavigationHelper $helper;
            final /* synthetic */ boolean $onTheFly;
            final /* synthetic */ InspectionManager $manager;
            final /* synthetic */ SqlLanguageDialectEx $dialect;
            final /* synthetic */ List $result;

            public void visitSqlCreateStatement(@NotNull SqlCreateStatement o2) {
                Intrinsics.checkNotNullParameter((Object)o2, (String)"o");
                super.visitSqlCreateStatement(o2);
                if (o2 instanceof OraCreatePackageStatementImpl || o2 instanceof SqlCreateTypeStatement && OraTypeSystem.isObjectType((DasUserDefinedType)o2)) {
                    this.checkDeclaration((SqlDefinition)o2);
                }
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private final boolean hasCallSpec(SqlDefinition $this$hasCallSpec) {
                PsiElement it;
                if (!($this$hasCallSpec instanceof OraMemberFunctionDefinitionImpl)) return false;
                JBIterable jBIterable = SqlImplUtil.sqlChildren((PsiElement)((PsiElement)((OraMemberFunctionDefinitionImpl)$this$hasCallSpec).getReturnArgument()));
                Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"SqlImplUtil.sqlChildren(returnArgument)");
                Iterable $this$any$iv = (Iterable)jBIterable;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    return false;
                }
                Iterator<T> iterator = $this$any$iv.iterator();
                do {
                    if (!iterator.hasNext()) return false;
                    T element$iv = iterator.next();
                    it = (PsiElement)element$iv;
                    boolean bl = false;
                } while (!Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)it), (Object)OraTypes.ORA_LANGUAGE));
                return true;
            }

            private final void checkDeclaration(SqlDefinition declaration) {
                boolean bl;
                block6: {
                    boolean isObjectType = Intrinsics.areEqual((Object)declaration.getKind(), (Object)ObjectKind.OBJECT_TYPE);
                    JBIterable jBIterable = SqlImplUtil.sqlChildren((PsiElement)((PsiElement)declaration)).filter(SqlDefinition.class);
                    Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"SqlImplUtil\n            \u2026qlDefinition::class.java)");
                    Iterable $this$any$iv = (Iterable)jBIterable;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            SqlDefinition it = (SqlDefinition)element$iv;
                            boolean bl2 = false;
                            SqlDefinition sqlDefinition = it;
                            Intrinsics.checkNotNullExpressionValue((Object)sqlDefinition, (String)"it");
                            if (!(Intrinsics.areEqual((Object)sqlDefinition.getKind(), (Object)ObjectKind.ROUTINE) && (!isObjectType || !this.hasCallSpec(it)) || Intrinsics.areEqual((Object)it.getKind(), (Object)SqlDbElementType.CURSOR))) continue;
                            bl = true;
                            break block6;
                        }
                        bl = false;
                    }
                }
                if (!bl) {
                    return;
                }
                Pair pair = this.$helper.findDefinitions((DasObject)declaration, false);
                if (pair == null || (pair = (JBIterable)pair.second) == null) {
                    JBIterable jBIterable = JBIterable.empty();
                    pair = jBIterable;
                    Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"JBIterable.empty()");
                }
                Pair bodies = pair;
                if (bodies.isEmpty()) {
                    this.reportMissingBody(declaration);
                }
            }

            private final void reportMissingBody(SqlDefinition declaration) {
                PsiElement psiElement;
                PsiElement psiElement2;
                SqlNameElement nameElement;
                boolean isObjectType = Intrinsics.areEqual((Object)declaration.getKind(), (Object)ObjectKind.OBJECT_TYPE);
                SqlNameElement sqlNameElement = nameElement = declaration.getNameElement();
                PsiElement startAnchor = sqlNameElement != null ? (PsiElement)sqlNameElement : declaration.getFirstChild();
                SqlNameElement sqlNameElement2 = nameElement;
                if (sqlNameElement2 != null) {
                    psiElement2 = (PsiElement)sqlNameElement2;
                } else {
                    T element$iv2;
                    block4: {
                        JBIterable jBIterable = SqlImplUtil.siblings((PsiElement)startAnchor);
                        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"SqlImplUtil.siblings(startAnchor)");
                        Iterable $this$first$iv = (Iterable)jBIterable;
                        boolean $i$f$first = false;
                        for (T element$iv2 : $this$first$iv) {
                            PsiElement e2 = (PsiElement)element$iv2;
                            boolean bl = false;
                            IElementType iElementType = PsiTreeUtilKt.getElementType((PsiElement)e2);
                            boolean bl2 = false;
                            boolean bl3 = false;
                            IElementType it = iElementType;
                            boolean bl4 = false;
                            boolean bl5 = Intrinsics.areEqual((Object)it, (Object)OraTypes.ORA_PACKAGE) || Intrinsics.areEqual((Object)it, (Object)OraTypes.ORA_TYPE);
                            if (!bl5) continue;
                            break block4;
                        }
                        throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
                    }
                    psiElement2 = psiElement = (PsiElement)element$iv2;
                }
                if (psiElement2 == null) {
                    psiElement = startAnchor;
                }
                PsiElement endAnchor = psiElement;
                String messageKey = isObjectType ? "inspection.message.missing.type.body" : "inspection.message.missing.package.body";
                this.addDescriptor(this.myManager.createProblemDescriptor(startAnchor, endAnchor, SqlBundle.message((String)messageKey, (Object[])new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.$onTheFly, new LocalQuickFix[0]));
            }
            {
                this.$helper = $captured_local_variable$0;
                this.$onTheFly = $captured_local_variable$1;
                this.$manager = $captured_local_variable$2;
                this.$dialect = $captured_local_variable$3;
                this.$result = $captured_local_variable$4;
                super($super_call_param$5, $super_call_param$6, $super_call_param$7);
            }
        };
    }
}

