/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.mysql;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.SqlTypeSystem;
import com.intellij.sql.dialects.mysql.MysqlDialectBase;
import com.intellij.sql.psi.SqlType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MysqlBaseTypeSystem
extends SqlTypeSystem {
    protected MysqlBaseTypeSystem(MysqlDialectBase dialect) {
        super((SqlLanguageDialectEx)dialect);
    }

    @NotNull
    public String getNormalizedTypeName(@NotNull String name2) {
        if (name2 == null) {
            MysqlBaseTypeSystem.$$$reportNull$$$0(0);
        }
        name2 = super.getNormalizedTypeName(name2);
        name2 = StringUtil.trimStart((String)name2, (String)"national ");
        name2 = StringUtil.trimEnd((String)name2, (String)" zerofill");
        name2 = StringUtil.trimEnd((String)name2, (String)" signed");
        if ((name2 = StringUtil.trimEnd((String)name2, (String)" unsigned")).equals("nchar varying")) {
            return "varchar";
        }
        if (name2.equals("nvarchar")) {
            return "varchar";
        }
        if (name2.equals("nchar")) {
            return "char";
        }
        if (name2.equals("character varying")) {
            return "varchar";
        }
        if (name2.equals("char varying")) {
            return "varchar";
        }
        if (name2.equals("character")) {
            return "char";
        }
        if (name2.equals("long")) {
            return "mediumtext";
        }
        if (name2.equals("integer")) {
            return "int";
        }
        if (name2.equals("boolean")) {
            return "tinyint";
        }
        if (name2.equals("bool")) {
            return "tinyint";
        }
        if (name2.equals("dec")) {
            return "decimal";
        }
        if (name2.equals("numeric")) {
            return "decimal";
        }
        if (name2.equals("fixed")) {
            return "decimal";
        }
        if (name2.equals("double precision")) {
            return "double";
        }
        if (name2.equals("real")) {
            return "double";
        }
        String string = name2;
        if (string == null) {
            MysqlBaseTypeSystem.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    public String getDefaultTypeName(@NotNull SqlType.Category cat) {
        if (cat == null) {
            MysqlBaseTypeSystem.$$$reportNull$$$0(2);
        }
        switch (cat) {
            case INTEGER: {
                return "int";
            }
            case REAL: {
                return "decimal";
            }
            case STRING: {
                return "varchar";
            }
            case BOOLEAN: {
                return "tinyint";
            }
            case DATE_TIME: {
                return "datetime";
            }
            case DATE: {
                return "date";
            }
            case TIME: {
                return "time";
            }
            case TIMESTAMP: {
                return "timestamp";
            }
            case INTERVAL: {
                return "interval";
            }
            case BYTES: {
                return "binary";
            }
            case ARRAY: {
                return "binary";
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/mysql/MysqlBaseTypeSystem";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cat";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/mysql/MysqlBaseTypeSystem";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getNormalizedTypeName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getNormalizedTypeName";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultTypeName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

