/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.mssql.inspections;

import com.intellij.analysis.AnalysisBundle;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.database.Dbms;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.mssql.MsTypes;
import com.intellij.sql.dialects.mssql.inspections.MsOrderByInspection;
import com.intellij.sql.inspections.DropPsiFix;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.psi.SqlOrderByClause;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlTableDefinition;
import com.intellij.sql.psi.impl.SqlNamedQueryDefinitionImpl;
import com.intellij.sql.refactoring.SqlSubqueryUtils;
import com.intellij.util.containers.JBIterable;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0014\u00a8\u0006\u000e"}, d2={"Lcom/intellij/sql/dialects/mssql/inspections/MsOrderByInspection;", "Lcom/intellij/sql/inspections/SqlInspectionBase;", "()V", "createAnnotationVisitor", "Lcom/intellij/sql/inspections/SqlInspectionBase$SqlAnnotationVisitor;", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialectEx;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "result", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "onTheFly", "", "intellij.database.dialects.mssql"})
public final class MsOrderByInspection
extends SqlInspectionBase {
    @Nullable
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(@NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result2, boolean onTheFly) {
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        Dbms dbms = dialect.getDbms();
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"dialect.dbms");
        if (!dbms.isMicrosoft()) {
            return null;
        }
        return new SqlInspectionBase.SqlAnnotationVisitor(onTheFly, manager, dialect, result2, manager, (SqlLanguageDialect)dialect, result2){
            final /* synthetic */ boolean $onTheFly;
            final /* synthetic */ InspectionManager $manager;
            final /* synthetic */ SqlLanguageDialectEx $dialect;
            final /* synthetic */ List $result;

            public void visitSqlOrderByClause(@NotNull SqlOrderByClause o2) {
                Intrinsics.checkNotNullParameter((Object)o2, (String)"o");
                super.visitSqlOrderByClause(o2);
                PsiElement psiElement = o2.getParent();
                if (!(psiElement instanceof SqlQueryExpression)) {
                    psiElement = null;
                }
                SqlQueryExpression sqlQueryExpression = (SqlQueryExpression)psiElement;
                if (sqlQueryExpression == null) {
                    return;
                }
                SqlQueryExpression query = sqlQueryExpression;
                if (this.forbidsOrderBy(query) && !this.hasExemptionClause(query)) {
                    this.reportProblem((PsiElement)o2);
                }
            }

            private final boolean hasExemptionClause(SqlQueryExpression $this$hasExemptionClause) {
                boolean bl;
                block5: {
                    block7: {
                        block6: {
                            JBIterable jBIterable = $this$hasExemptionClause.getLimitClauses();
                            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"limitClauses");
                            if (jBIterable.isNotEmpty()) break block6;
                            JBIterable jBIterable2 = $this$hasExemptionClause.getOffsetClauses();
                            Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"offsetClauses");
                            if (!jBIterable2.isNotEmpty()) break block7;
                        }
                        return true;
                    }
                    PsiElement psiElement = PsiTreeUtil.findSiblingForward((PsiElement)$this$hasExemptionClause.getFirstChild(), (IElementType)MsTypes.MSSQL_QUERY_FLATTEN_CLAUSE, (boolean)false, null);
                    if (psiElement == null) {
                        return false;
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"PsiTreeUtil.findSiblingF\u2026se, null) ?: return false");
                    PsiElement flattenClause = psiElement;
                    Sequence $this$any$iv = SequencesKt.generateSequence((Object)flattenClause.getFirstChild(), (Function1)createAnnotationVisitor.hasExemptionClause.1.INSTANCE);
                    boolean $i$f$any = false;
                    for (E element$iv : $this$any$iv) {
                        PsiElement it = (PsiElement)element$iv;
                        boolean bl2 = false;
                        if (!(Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)it), (Object)MsTypes.MSSQL_XML) || Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)it), (Object)MsTypes.MSSQL_JSON))) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
                return bl;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private final boolean forbidsOrderBy(SqlQueryExpression $this$forbidsOrderBy) {
                if ($this$forbidsOrderBy.getParent() instanceof SqlNamedQueryDefinitionImpl) return true;
                if (SqlSubqueryUtils.findEnclosingQueryWithContext((PsiElement)((PsiElement)$this$forbidsOrderBy)) != null) return true;
                SqlTableDefinition sqlTableDefinition = (SqlTableDefinition)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)$this$forbidsOrderBy), SqlTableDefinition.class);
                if (!Intrinsics.areEqual((Object)(sqlTableDefinition != null ? sqlTableDefinition.getQueryExpression() : null), (Object)$this$forbidsOrderBy)) return false;
                return true;
            }

            private final void reportProblem(PsiElement anchor2) {
                this.addDescriptor(this.myManager.createProblemDescriptor(anchor2, AnalysisBundle.message((String)"MsOrderByInspection.inspection.message.order.by.clause.invalid", (Object[])new Object[0]), (LocalQuickFix)DropPsiFix.INSTANCE, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.$onTheFly));
            }
            {
                this.$onTheFly = $captured_local_variable$0;
                this.$manager = $captured_local_variable$1;
                this.$dialect = $captured_local_variable$2;
                this.$result = $captured_local_variable$3;
                super($super_call_param$4, $super_call_param$5, $super_call_param$6);
            }
        };
    }
}

