/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.mssql.inspections;

import com.intellij.analysis.AnalysisBundle;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.database.Dbms;
import com.intellij.database.model.DataType;
import com.intellij.psi.PsiElement;
import com.intellij.sql.dialects.BuiltinFunction;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlType;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0014\u00a8\u0006\u000e"}, d2={"Lcom/intellij/sql/dialects/mssql/inspections/MsBuiltinInspection;", "Lcom/intellij/sql/inspections/SqlInspectionBase;", "()V", "createAnnotationVisitor", "Lcom/intellij/sql/inspections/SqlInspectionBase$SqlAnnotationVisitor;", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialectEx;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "result", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "onTheFly", "", "intellij.database.dialects.mssql"})
public final class MsBuiltinInspection
extends SqlInspectionBase {
    @Nullable
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(@NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result2, boolean onTheFly) {
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        Dbms dbms = dialect.getDbms();
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"dialect.dbms");
        if (!dbms.isMicrosoft()) {
            return null;
        }
        return new SqlInspectionBase.SqlAnnotationVisitor(onTheFly, manager, dialect, result2, manager, (SqlLanguageDialect)dialect, result2){
            final /* synthetic */ boolean $onTheFly;
            final /* synthetic */ InspectionManager $manager;
            final /* synthetic */ SqlLanguageDialectEx $dialect;
            final /* synthetic */ List $result;

            public void visitSqlFunctionCallExpression(@NotNull SqlFunctionCallExpression o2) {
                Intrinsics.checkNotNullParameter((Object)o2, (String)"o");
                BuiltinFunction builtinFunction = o2.getFunctionDefinition();
                if (builtinFunction == null) {
                    return;
                }
                Intrinsics.checkNotNullExpressionValue((Object)builtinFunction, (String)"o.functionDefinition ?: return");
                BuiltinFunction builtinFunction2 = builtinFunction;
                if (!StringsKt.equals((String)builtinFunction2.getName(), (String)"isnull", (boolean)true)) {
                    return;
                }
                Object object = o2.getParameterList();
                if (object == null || (object = object.getExpressionList()) == null) {
                    return;
                }
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"o.parameterList?.expressionList ?: return");
                Object expressions = object;
                if (expressions.size() != 2) {
                    return;
                }
                E e2 = expressions.get(0);
                Intrinsics.checkNotNullExpressionValue(e2, (String)"expressions[0]");
                SqlType sqlType = ((SqlExpression)e2).getSqlType();
                Intrinsics.checkNotNullExpressionValue((Object)sqlType, (String)"expressions[0].sqlType");
                SqlType type1 = sqlType;
                E e3 = expressions.get(1);
                Intrinsics.checkNotNullExpressionValue(e3, (String)"expressions[1]");
                SqlType sqlType2 = ((SqlExpression)e3).getSqlType();
                Intrinsics.checkNotNullExpressionValue((Object)sqlType2, (String)"expressions[1].sqlType");
                SqlType type2 = sqlType2;
                if (type1.getCategory() != SqlType.Category.STRING && type2.getCategory() != SqlType.Category.STRING) {
                    return;
                }
                DataType dataType = type1.getDataType();
                Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"type1.dataType");
                int n = dataType.getLength();
                DataType dataType2 = type2.getDataType();
                Intrinsics.checkNotNullExpressionValue((Object)dataType2, (String)"type2.dataType");
                if (n < dataType2.getLength()) {
                    PsiElement psiElement = (PsiElement)o2;
                    String string = AnalysisBundle.message((String)"MsBuiltinInspection.inspection.message.second.argument.isnull.implicitly.truncated", (Object[])new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"AnalysisBundle.message(\"\u2026ll.implicitly.truncated\")");
                    this.reportProblem(psiElement, string);
                }
            }

            private final void reportProblem(PsiElement anchor2, @InspectionMessage String message2) {
                this.addDescriptor(this.myManager.createProblemDescriptor(anchor2, message2, (LocalQuickFix)null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.$onTheFly));
            }
            {
                this.$onTheFly = $captured_local_variable$0;
                this.$manager = $captured_local_variable$1;
                this.$dialect = $captured_local_variable$2;
                this.$result = $captured_local_variable$3;
                super($super_call_param$4, $super_call_param$5, $super_call_param$6);
            }
        };
    }
}

