/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.mongo.js.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.JdbcConsoleProvider;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.sql.dialects.mongo.js.inspections.MongoJSInspectionBase;
import com.intellij.sql.inspections.SqlSideEffectsInspection;
import com.intellij.sql.psi.ExecutionFlowAnalyzer;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.util.ThreeState;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0014\u00a8\u0006\u000e"}, d2={"Lcom/intellij/sql/dialects/mongo/js/inspections/MongoJSSideEffectsInspection;", "Lcom/intellij/sql/dialects/mongo/js/inspections/MongoJSInspectionBase;", "()V", "createFileVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "file", "Lcom/intellij/psi/PsiFile;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "isOnTheFly", "", "results", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "intellij.database.dialects.mongo"})
public class MongoJSSideEffectsInspection
extends MongoJSInspectionBase {
    @Override
    @Nullable
    protected PsiElementVisitor createFileVisitor(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly, @NotNull List<ProblemDescriptor> results) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter(results, (String)"results");
        return (PsiElementVisitor)new PsiRecursiveElementVisitor(results, manager, isOnTheFly){
            final /* synthetic */ List $results;
            final /* synthetic */ InspectionManager $manager;
            final /* synthetic */ boolean $isOnTheFly;

            public void visitElement(@NotNull PsiElement element) {
                LocalDataSource dataSource;
                JdbcConsole console;
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                super.visitElement(element);
                ExecutionFlowAnalyzer executionFlowAnalyzer = SqlPsiFacade.getInstance((Project)element.getProject()).getExecutionFlowAnalyzer(element.getLanguage());
                if (executionFlowAnalyzer == null) {
                    return;
                }
                Intrinsics.checkNotNullExpressionValue((Object)executionFlowAnalyzer, (String)"SqlPsiFacade.getInstance\u2026ement.language) ?: return");
                ExecutionFlowAnalyzer analyzer = executionFlowAnalyzer;
                PsiFile psiFile = element.getContainingFile();
                Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"element.containingFile");
                VirtualFile virtualFile = psiFile.getVirtualFile();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"element.containingFile.virtualFile");
                VirtualFile virtualFile2 = virtualFile;
                JdbcConsole jdbcConsole = console = JdbcConsoleProvider.getValidConsole((Project)element.getProject(), (VirtualFile)virtualFile2);
                Object object = dataSource = jdbcConsole != null ? jdbcConsole.getDataSource() : null;
                if (dataSource == null || !dataSource.isReadOnly() || !analyzer.isAcceptable(element)) {
                    return;
                }
                ExecutionFlowAnalyzer.Flow flow = analyzer.analyze(element);
                Intrinsics.checkNotNullExpressionValue((Object)flow, (String)"analyzer.analyze(element)");
                ExecutionFlowAnalyzer.Flow flow2 = flow;
                if (flow2.isPure() == ThreeState.YES) {
                    return;
                }
                String string = (String)flow2.transform(SqlSideEffectsInspection.TRANSFORMER);
                if (string == null) {
                    return;
                }
                String reason = string;
                SqlSideEffectsInspection.MakeDataSourceWritable fix = new SqlSideEffectsInspection.MakeDataSourceWritable(dataSource);
                Collection collection = this.$results;
                ProblemDescriptor problemDescriptor = this.$manager.createProblemDescriptor(element, reason, true, ProblemHighlightType.WEAK_WARNING, this.$isOnTheFly, new LocalQuickFix[]{(LocalQuickFix)fix});
                boolean bl = false;
                collection.add(problemDescriptor);
            }
            {
                this.$results = $captured_local_variable$0;
                this.$manager = $captured_local_variable$1;
                this.$isOnTheFly = $captured_local_variable$2;
            }
        };
    }
}

