/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.mongo.js.completion;

import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbPresentation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.mongo.js.inspections.MongoJSDeprecationInspection;
import com.intellij.sql.dialects.mongo.js.psi.resolve.MongoJSResolveHelper;
import com.intellij.sql.dialects.mongo.js.psi.resolve.ResolveUtilKt;
import com.intellij.sql.dialects.mongo.js.psi.resolve.symbols.MongoJSCollection;
import com.intellij.sql.dialects.mongo.js.psi.resolve.symbols.MongoJSDatabase;
import com.intellij.sql.dialects.mongo.js.psi.resolve.symbols.MongoJSMethod;
import com.intellij.sql.dialects.mongo.js.psi.resolve.symbols.MongoJSSymbol;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000@\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a,\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u0001\u001a$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t2\b\b\u0002\u0010\n\u001a\u00020\u0001\u001aZ\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00072\b\u0010\u0010\u001a\u0004\u0018\u00010\u000e26\u0010\u0011\u001a2\u0012\u0013\u0012\u00110\u0013\u00a2\u0006\f\b\u0014\u0012\b\b\u0015\u0012\u0004\b\b(\u0004\u0012\u0013\u0012\u00110\u0001\u00a2\u0006\f\b\u0014\u0012\b\b\u0015\u0012\u0004\b\b(\n\u0012\u0004\u0012\u00020\f0\u0012\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"DEFAULT_MONGO_PRIORITY", "", "createLookupElement", "Lcom/intellij/codeInsight/lookup/LookupElement;", "symbol", "Lcom/intellij/sql/dialects/mongo/js/psi/resolve/symbols/MongoJSSymbol;", "lookupString", "", "kind", "Lcom/intellij/database/model/ObjectKind;", "priority", "suggestCollectionsByQualifier", "", "qualifier", "Lcom/intellij/psi/PsiElement;", "referenceName", "originalExpression", "body", "Lkotlin/Function2;", "Lcom/intellij/sql/dialects/mongo/js/psi/resolve/symbols/MongoJSCollection;", "Lkotlin/ParameterName;", "name", "intellij.database.dialects.mongo"})
public final class MongoJsCompletionUtilKt {
    public static final double DEFAULT_MONGO_PRIORITY = 1000.0;

    @NotNull
    public static final LookupElement createLookupElement(@NotNull MongoJSSymbol symbol, @NotNull String lookupString, @NotNull ObjectKind kind, double priority) {
        LookupElement lookupElement;
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        Intrinsics.checkNotNullParameter((Object)lookupString, (String)"lookupString");
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        double finalPriority = priority + 1000.0;
        LookupElementBuilder lookupElementBuilder = LookupElementBuilder.create((Object)symbol, (String)lookupString).withIcon(DbPresentation.getIcon((ObjectKind)kind));
        Intrinsics.checkNotNullExpressionValue((Object)lookupElementBuilder, (String)"LookupElementBuilder.cre\u2026esentation.getIcon(kind))");
        LookupElementBuilder builder = lookupElementBuilder;
        boolean deprecated = false;
        if (symbol instanceof MongoJSMethod) {
            LookupElementBuilder lookupElementBuilder2 = builder.withPresentableText(symbol.getName() + "()");
            Intrinsics.checkNotNullExpressionValue((Object)lookupElementBuilder2, (String)"builder.withPresentableText(\"${symbol.name}()\")");
            builder = lookupElementBuilder2;
            Map<String, MongoJSDeprecationInspection.Companion.QuickFix> map2 = MongoJSDeprecationInspection.Companion.getDeprecatedMethods();
            String string = symbol.getName();
            boolean bl = false;
            Map<String, MongoJSDeprecationInspection.Companion.QuickFix> map3 = map2;
            boolean bl2 = false;
            deprecated = map3.containsKey(string);
        }
        if (deprecated) {
            LookupElement lookupElement2 = PrioritizedLookupElement.withPriority((LookupElement)((LookupElement)builder.strikeout()), (double)900.0);
            lookupElement = lookupElement2;
            Intrinsics.checkNotNullExpressionValue((Object)lookupElement2, (String)"PrioritizedLookupElement\u2026ULT_MONGO_PRIORITY - 100)");
        } else if (finalPriority > 0.0) {
            LookupElement lookupElement3 = PrioritizedLookupElement.withPriority((LookupElement)((LookupElement)builder), (double)finalPriority);
            lookupElement = lookupElement3;
            Intrinsics.checkNotNullExpressionValue((Object)lookupElement3, (String)"PrioritizedLookupElement\u2026y(builder, finalPriority)");
        } else {
            lookupElement = (LookupElement)builder;
        }
        return lookupElement;
    }

    public static /* synthetic */ LookupElement createLookupElement$default(MongoJSSymbol mongoJSSymbol, String string, ObjectKind objectKind, double d, int n, Object object) {
        if ((n & 2) != 0) {
            string = mongoJSSymbol.getName();
        }
        if ((n & 4) != 0) {
            objectKind = mongoJSSymbol.getKind();
        }
        if ((n & 8) != 0) {
            d = 0.0;
        }
        return MongoJsCompletionUtilKt.createLookupElement(mongoJSSymbol, string, objectKind, d);
    }

    @NotNull
    public static final LookupElement createLookupElement(@NotNull String lookupString, @Nullable ObjectKind kind, double priority) {
        LookupElement lookupElement;
        Intrinsics.checkNotNullParameter((Object)lookupString, (String)"lookupString");
        double finalPriority = priority + 1000.0;
        LookupElementBuilder lookupElementBuilder = LookupElementBuilder.create((String)lookupString);
        Intrinsics.checkNotNullExpressionValue((Object)lookupElementBuilder, (String)"LookupElementBuilder.create(lookupString)");
        LookupElementBuilder builder = lookupElementBuilder;
        if (kind != null) {
            LookupElementBuilder lookupElementBuilder2 = builder.withIcon(DbPresentation.getIcon((ObjectKind)kind));
            Intrinsics.checkNotNullExpressionValue((Object)lookupElementBuilder2, (String)"builder.withIcon(DbPresentation.getIcon(kind))");
            builder = lookupElementBuilder2;
        }
        if (finalPriority > 0.0) {
            LookupElement lookupElement2 = PrioritizedLookupElement.withPriority((LookupElement)((LookupElement)builder), (double)finalPriority);
            lookupElement = lookupElement2;
            Intrinsics.checkNotNullExpressionValue((Object)lookupElement2, (String)"PrioritizedLookupElement\u2026y(builder, finalPriority)");
        } else {
            lookupElement = (LookupElement)builder;
        }
        return lookupElement;
    }

    public static /* synthetic */ LookupElement createLookupElement$default(String string, ObjectKind objectKind, double d, int n, Object object) {
        if ((n & 2) != 0) {
            objectKind = null;
        }
        if ((n & 4) != 0) {
            d = 0.0;
        }
        return MongoJsCompletionUtilKt.createLookupElement(string, objectKind, d);
    }

    public static final void suggestCollectionsByQualifier(@NotNull PsiElement qualifier, @Nullable String referenceName, @Nullable PsiElement originalExpression, @NotNull Function2<? super MongoJSCollection, ? super Double, Unit> body2) {
        ResolveResult[] resolveResultArray;
        Intrinsics.checkNotNullParameter((Object)qualifier, (String)"qualifier");
        Intrinsics.checkNotNullParameter(body2, (String)"body");
        MongoJSResolveHelper mongoJSResolveHelper = ResolveUtilKt.getMongoHelper(qualifier);
        if (mongoJSResolveHelper == null) {
            return;
        }
        MongoJSResolveHelper helper = mongoJSResolveHelper;
        Class<? extends PsiElement> refExpressionClass = helper.getReferenceExpressionClass();
        if (!refExpressionClass.isInstance(qualifier)) {
            return;
        }
        PsiReference psiReference = qualifier.getReference();
        if (!(psiReference instanceof PsiPolyVariantReference)) {
            psiReference = null;
        }
        if ((resolveResultArray = (ResolveResult[])psiReference) == null || (resolveResultArray = resolveResultArray.multiResolve(true)) == null) {
            resolveResultArray = ResolveResult.EMPTY_ARRAY;
        }
        ResolveResult[] resolveResultArray2 = resolveResultArray;
        int n = resolveResultArray2.length;
        for (int j = 0; j < n; ++j) {
            MongoJSDatabase db;
            ResolveResult target2;
            ResolveResult resolveResult = target2 = resolveResultArray2[j];
            Intrinsics.checkNotNullExpressionValue((Object)resolveResult, (String)"target");
            MongoJSSymbol mongoJSSymbol = helper.getSymbol(resolveResult);
            if (!(mongoJSSymbol instanceof MongoJSDatabase)) {
                mongoJSSymbol = null;
            }
            if ((MongoJSDatabase)mongoJSSymbol == null) {
                continue;
            }
            for (MongoJSCollection collection : db.getCollections()) {
                body2.invoke((Object)collection, (Object)10.0);
            }
            for (MongoJSCollection collection : ResolveUtilKt.getMongoScope(qualifier).getExtraCollections(db)) {
                PsiElement source;
                if (collection.getSource() == null) {
                    continue;
                }
                if (originalExpression != null && Intrinsics.areEqual((Object)collection.getName(), (Object)referenceName) && PsiTreeUtil.isAncestor((PsiElement)originalExpression, (PsiElement)source, (boolean)false)) continue;
                body2.invoke((Object)collection, (Object)5.0);
            }
        }
    }
}

