/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.mongo.js.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.database.model.ObjectKind;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiQualifiedReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.mongo.js.completion.MongoJsCompletionUtilKt;
import com.intellij.sql.dialects.mongo.js.psi.resolve.MongoJSResolveHelper;
import com.intellij.sql.dialects.mongo.js.psi.resolve.ResolveUtilKt;
import com.intellij.sql.dialects.mongo.js.psi.resolve.symbols.MongoJSCollection;
import com.intellij.sql.dialects.mongo.js.psi.resolve.symbols.MongoJSDatabase;
import com.intellij.sql.dialects.mongo.js.psi.resolve.symbols.MongoJSMethod;
import com.intellij.sql.dialects.mongo.js.psi.resolve.symbols.MongoJSSymbol;
import com.intellij.sql.dialects.mongo.js.psi.resolve.types.MongoJSType;
import com.intellij.util.ProcessingContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J&\u0010\u000b\u001a\u00020\u00052\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u0011"}, d2={"Lcom/intellij/sql/dialects/mongo/js/completion/MongoJSReferenceCompletionProvider;", "Lcom/intellij/codeInsight/completion/CompletionProvider;", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "()V", "addCompletions", "", "parameters", "context", "Lcom/intellij/util/ProcessingContext;", "result", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "suggestSymbols", "symbols", "", "Lcom/intellij/sql/dialects/mongo/js/psi/resolve/symbols/MongoJSSymbol;", "isCall", "", "intellij.database.dialects.mongo"})
public final class MongoJSReferenceCompletionProvider
extends CompletionProvider<CompletionParameters> {
    public static final MongoJSReferenceCompletionProvider INSTANCE;

    private final void suggestSymbols(Collection<? extends MongoJSSymbol> symbols, boolean isCall, CompletionResultSet result2) {
        for (MongoJSSymbol mongoJSSymbol : symbols) {
            String lookupString = isCall || !(mongoJSSymbol instanceof MongoJSMethod) ? mongoJSSymbol.getName() : mongoJSSymbol.getName() + "()";
            result2.addElement(MongoJsCompletionUtilKt.createLookupElement$default(mongoJSSymbol, lookupString, null, 0.0, 12, null));
        }
    }

    protected void addCompletions(@NotNull CompletionParameters parameters2, @NotNull ProcessingContext context, @NotNull CompletionResultSet result2) {
        PsiElement qualifier;
        Intrinsics.checkNotNullParameter((Object)parameters2, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        PsiElement psiElement = parameters2.getPosition();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"parameters.position");
        PsiElement position = psiElement;
        if (position.getParent() instanceof PsiErrorElement) {
            return;
        }
        MongoJSResolveHelper mongoJSResolveHelper = ResolveUtilKt.getMongoHelper(position);
        if (mongoJSResolveHelper == null) {
            return;
        }
        MongoJSResolveHelper helper = mongoJSResolveHelper;
        Class<? extends PsiElement> refExpressionClass = helper.getReferenceExpressionClass();
        PsiElement psiElement2 = PsiTreeUtil.getParentOfType((PsiElement)position, refExpressionClass);
        if (psiElement2 == null) {
            return;
        }
        PsiElement expression = psiElement2;
        PsiElement originalPosition = parameters2.getOriginalPosition();
        PsiElement originalExpression = PsiTreeUtil.getParentOfType((PsiElement)originalPosition, refExpressionClass);
        boolean isCall = originalExpression != null && helper.isCalleeReference(originalExpression);
        PsiReference psiReference = expression.getReference();
        if (!(psiReference instanceof PsiQualifiedReference)) {
            psiReference = null;
        }
        PsiQualifiedReference psiQualifiedReference = (PsiQualifiedReference)psiReference;
        Object object = qualifier = psiQualifiedReference != null ? psiQualifiedReference.getQualifier() : null;
        if (qualifier == null) {
            boolean isUseTarget = helper.isUseTargetReference(expression);
            if (!isCall) {
                if (isUseTarget) {
                    Iterable $this$distinctBy$iv = ResolveUtilKt.getMongoScope(expression).getDatabases();
                    boolean $i$f$distinctBy = false;
                    HashSet<String> set$iv = new HashSet<String>();
                    ArrayList list$iv = new ArrayList();
                    for (Object e$iv : $this$distinctBy$iv) {
                        MongoJSDatabase it = (MongoJSDatabase)e$iv;
                        boolean bl = false;
                        String key$iv = it.getName();
                        if (!set$iv.add(key$iv)) continue;
                        list$iv.add(e$iv);
                    }
                    for (MongoJSDatabase db : (List)list$iv) {
                        result2.addElement(MongoJsCompletionUtilKt.createLookupElement$default(db, null, null, 0.0, 14, null));
                    }
                } else {
                    result2.addElement(MongoJsCompletionUtilKt.createLookupElement$default("db", ObjectKind.DATABASE, 0.0, 4, null));
                }
            }
            if (!isUseTarget) {
                this.suggestSymbols(MongoJSSymbol.Companion.getTopLevelSymbols(), isCall, result2);
            }
            return;
        }
        if (!isCall) {
            PsiElement psiElement3 = originalExpression;
            Object object2 = psiElement3 != null ? psiElement3.getReference() : null;
            if (!(object2 instanceof PsiQualifiedReference)) {
                object2 = null;
            }
            PsiQualifiedReference psiQualifiedReference2 = (PsiQualifiedReference)object2;
            String referenceName = psiQualifiedReference2 != null ? psiQualifiedReference2.getReferenceName() : null;
            MongoJsCompletionUtilKt.suggestCollectionsByQualifier(qualifier, referenceName, originalExpression, (Function2<? super MongoJSCollection, ? super Double, Unit>)((Function2)new Function2<MongoJSCollection, Double, Unit>(result2){
                final /* synthetic */ CompletionResultSet $result;

                public final void invoke(@NotNull MongoJSCollection symbol, double priority) {
                    Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
                    this.$result.addElement(MongoJsCompletionUtilKt.createLookupElement$default(symbol, null, null, priority, 6, null));
                }
                {
                    this.$result = completionResultSet;
                    super(2);
                }
            }));
        }
        MongoJSType mongoJSType = helper.getMongoType(qualifier);
        String string = qualifier.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"qualifier.text");
        this.suggestSymbols(mongoJSType.getMembers(string), isCall, result2);
    }

    private MongoJSReferenceCompletionProvider() {
    }

    static {
        MongoJSReferenceCompletionProvider mongoJSReferenceCompletionProvider;
        INSTANCE = mongoJSReferenceCompletionProvider = new MongoJSReferenceCompletionProvider();
    }
}

