/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.mongo.js;

import com.intellij.database.script.MongoJSLanguage;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiQualifiedReference;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.sql.dialects.mongo.js.JSElementTypes;
import com.intellij.sql.dialects.mongo.js.psi.MongoJSExpression;
import com.intellij.sql.dialects.mongo.js.psi.MongoJSExpressionStatement;
import com.intellij.sql.dialects.mongo.js.psi.MongoJSParenthesizedExpression;
import com.intellij.sql.dialects.mongo.js.psi.MongoJSReference;
import com.intellij.sql.dialects.mongo.js.psi.MongoJSReferenceExpression;
import com.intellij.sql.dialects.mongo.js.psi.MongoJSUseStatement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000<\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0001H\u0002\u001a\u0016\u0010\u0010\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0001\u001a\u000e\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0013\u001a\u000e\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0013\u001a\n\u0010\u0015\u001a\u00020\u0016*\u00020\u0016\"\u0017\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0015\u0010\u0005\u001a\u00020\u0006*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\b\"\u0016\u0010\u0005\u001a\u00020\u0006*\u00020\t8\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\n\u00a8\u0006\u0017"}, d2={"databaseName", "", "Lcom/intellij/sql/dialects/mongo/js/psi/MongoJSUseStatement;", "getDatabaseName", "(Lcom/intellij/sql/dialects/mongo/js/psi/MongoJSUseStatement;)Ljava/lang/String;", "isDbReference", "", "Lcom/intellij/psi/PsiQualifiedReference;", "(Lcom/intellij/psi/PsiQualifiedReference;)Z", "Lcom/intellij/sql/dialects/mongo/js/psi/MongoJSReferenceExpression;", "(Lcom/intellij/sql/dialects/mongo/js/psi/MongoJSReferenceExpression;)Z", "createFile", "Lcom/intellij/psi/PsiFile;", "project", "Lcom/intellij/openapi/project/Project;", "text", "createRefFromText", "isPropertyKey", "element", "Lcom/intellij/psi/PsiElement;", "isRegExpLiteral", "skipParentheses", "Lcom/intellij/sql/dialects/mongo/js/psi/MongoJSExpression;", "intellij.database.dialects.mongo"})
public final class MongoJSPsiUtilKt {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isPropertyKey(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement psiElement = element.getParent();
        if (!Intrinsics.areEqual((Object)(psiElement != null ? PsiTreeUtilKt.getElementType((PsiElement)psiElement) : null), (Object)((Object)JSElementTypes.PROPERTY))) return false;
        PsiElement psiElement2 = element.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"element.parent");
        if (!Intrinsics.areEqual((Object)psiElement2.getFirstChild(), (Object)element)) return false;
        return true;
    }

    public static final boolean isDbReference(@NotNull PsiQualifiedReference $this$isDbReference) {
        Intrinsics.checkNotNullParameter((Object)$this$isDbReference, (String)"$this$isDbReference");
        return $this$isDbReference.getQualifier() == null && Intrinsics.areEqual((Object)$this$isDbReference.getReferenceName(), (Object)"db");
    }

    public static final boolean isDbReference(@NotNull MongoJSReferenceExpression $this$isDbReference) {
        int $i$f$isDbReference = 0;
        Intrinsics.checkNotNullParameter((Object)$this$isDbReference, (String)"$this$isDbReference");
        MongoJSReference mongoJSReference = $this$isDbReference.getReference();
        Intrinsics.checkNotNullExpressionValue((Object)mongoJSReference, (String)"reference");
        return MongoJSPsiUtilKt.isDbReference(mongoJSReference);
    }

    public static final boolean isRegExpLiteral(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement psiElement = element.getFirstChild();
        return Intrinsics.areEqual((Object)(psiElement != null ? PsiTreeUtilKt.getElementType((PsiElement)psiElement) : null), (Object)JSElementTypes.REGEXP_LITERAL);
    }

    @Nullable
    public static final String getDatabaseName(@NotNull MongoJSUseStatement $this$databaseName) {
        Intrinsics.checkNotNullParameter((Object)$this$databaseName, (String)"$this$databaseName");
        MongoJSReferenceExpression mongoJSReferenceExpression = $this$databaseName.getDatabaseReference();
        return mongoJSReferenceExpression != null ? mongoJSReferenceExpression.getName() : null;
    }

    @NotNull
    public static final MongoJSExpression skipParentheses(@NotNull MongoJSExpression $this$skipParentheses) {
        MongoJSExpression mongoJSExpression;
        Intrinsics.checkNotNullParameter((Object)$this$skipParentheses, (String)"$this$skipParentheses");
        PsiElement psiElement = $this$skipParentheses.getParent();
        if (!(psiElement instanceof MongoJSParenthesizedExpression)) {
            psiElement = null;
        }
        if ((mongoJSExpression = (MongoJSParenthesizedExpression)psiElement) == null || (mongoJSExpression = MongoJSPsiUtilKt.skipParentheses(mongoJSExpression)) == null) {
            mongoJSExpression = $this$skipParentheses;
        }
        return mongoJSExpression;
    }

    @NotNull
    public static final MongoJSReferenceExpression createRefFromText(@NotNull Project project, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        PsiElement psiElement = MongoJSPsiUtilKt.createFile(project, text).getFirstChild();
        if (psiElement == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.sql.dialects.mongo.js.psi.MongoJSExpressionStatement");
        }
        PsiElement psiElement2 = ((MongoJSExpressionStatement)psiElement).getChildren()[0];
        if (psiElement2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.sql.dialects.mongo.js.psi.MongoJSReferenceExpression");
        }
        return (MongoJSReferenceExpression)psiElement2;
    }

    private static final PsiFile createFile(Project project, String text) {
        PsiFile psiFile = PsiFileFactory.getInstance((Project)project).createFileFromText("a.js", (Language)MongoJSLanguage.INSTANCE, (CharSequence)text, false, false);
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"PsiFileFactory.getInstan\u2026uage, text, false, false)");
        return psiFile;
    }
}

