/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.hsql;

import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.SqlTypeSystem;
import com.intellij.sql.dialects.hsql.HsqlDialect;
import com.intellij.sql.psi.SqlType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HsqlTypeSystem
extends SqlTypeSystem {
    public static final HsqlTypeSystem INSTANCE = new HsqlTypeSystem();

    private HsqlTypeSystem() {
        super((SqlLanguageDialectEx)HsqlDialect.INSTANCE);
    }

    @NotNull
    public String getNormalizedTypeName(@NotNull String name2) {
        if (name2 == null) {
            HsqlTypeSystem.$$$reportNull$$$0(0);
        }
        if ("DEC".equals(name2 = super.getNormalizedTypeName(name2))) {
            return "DECIMAL";
        }
        if ("INT".equals(name2)) {
            return "INTEGER";
        }
        if ("OBJECT".equals(name2)) {
            return "OTHER";
        }
        if ("FLOAT".equals(name2)) {
            return "DOUBLE";
        }
        if ("REAL".equals(name2)) {
            return "DOUBLE";
        }
        if ("DOUBLE PRECISION".equals(name2)) {
            return "DOUBLE";
        }
        if ("CHAR".equals(name2)) {
            return "CHARACTER";
        }
        if ("CHARACTER VARYING".equals(name2)) {
            return "VARCHAR";
        }
        if ("CHAR VARYING".equals(name2)) {
            return "VARCHAR";
        }
        if ("CHARACTER LARGE OBJECT".equals(name2)) {
            return "CLOB";
        }
        if ("CHAR LARGE OBJECT".equals(name2)) {
            return "CLOB";
        }
        if ("VARCHAR_IGNORECASE".equals(name2)) {
            return "VARCHAR";
        }
        if ("LONGVARCHAR".equals(name2)) {
            return "VARCHAR";
        }
        if ("BINARY VARYING".equals(name2)) {
            return "VARBINARY";
        }
        if ("BINARY LARGE OBJECT".equals(name2)) {
            return "BLOB";
        }
        if ("LONGVARBINARY".equals(name2)) {
            return "VARBINARY";
        }
        if ("DATETIME".equals(name2)) {
            return "TIMESTAMP";
        }
        String string = name2;
        if (string == null) {
            HsqlTypeSystem.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    public String getDefaultTypeName(@NotNull SqlType.Category cat) {
        if (cat == null) {
            HsqlTypeSystem.$$$reportNull$$$0(2);
        }
        switch (cat) {
            case INTEGER: {
                return "integer";
            }
            case REAL: {
                return "numeric";
            }
            case STRING: {
                return "varchar";
            }
            case BOOLEAN: {
                return "boolean";
            }
            case DATE_TIME: {
                return "datetime";
            }
            case DATE: {
                return "date";
            }
            case TIME: {
                return "time";
            }
            case TIMESTAMP: {
                return "timestamp";
            }
            case INTERVAL: {
                return "interval";
            }
            case BYTES: {
                return "blob";
            }
            case ARRAY: {
                return "array";
            }
        }
        return null;
    }

    @NotNull
    public SqlType.Category getTypeCategoryByName(@NotNull String typeName) {
        if (typeName == null) {
            HsqlTypeSystem.$$$reportNull$$$0(3);
        }
        if ("CLOB".equals(typeName)) {
            SqlType.Category category = SqlType.Category.STRING;
            if (category == null) {
                HsqlTypeSystem.$$$reportNull$$$0(4);
            }
            return category;
        }
        if ("BLOB".equals(typeName)) {
            SqlType.Category category = SqlType.Category.BYTES;
            if (category == null) {
                HsqlTypeSystem.$$$reportNull$$$0(5);
            }
            return category;
        }
        if ("BIT VARYING".equals(typeName)) {
            SqlType.Category category = SqlType.Category.INTEGER;
            if (category == null) {
                HsqlTypeSystem.$$$reportNull$$$0(6);
            }
            return category;
        }
        SqlType.Category category = super.getTypeCategoryByName(typeName);
        if (category == null) {
            HsqlTypeSystem.$$$reportNull$$$0(7);
        }
        return category;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/hsql/HsqlTypeSystem";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cat";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/hsql/HsqlTypeSystem";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getNormalizedTypeName";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeCategoryByName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getNormalizedTypeName";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultTypeName";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getTypeCategoryByName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

