/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.h2;

import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.SqlTypeSystem;
import com.intellij.sql.dialects.h2.H2Dialect;
import com.intellij.sql.psi.SqlType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class H2TypeSystem
extends SqlTypeSystem {
    public static final H2TypeSystem INSTANCE = new H2TypeSystem();

    private H2TypeSystem() {
        super((SqlLanguageDialectEx)H2Dialect.INSTANCE);
    }

    @NotNull
    public String getNormalizedTypeName(@NotNull String name2) {
        if (name2 == null) {
            H2TypeSystem.$$$reportNull$$$0(0);
        }
        if ("INT2".equals(name2 = super.getNormalizedTypeName(name2))) {
            return "SMALLINT";
        }
        if ("MEDIUMINT".equals(name2)) {
            return "INTEGER";
        }
        if ("INT4".equals(name2)) {
            return "INTEGER";
        }
        if ("SIGNED".equals(name2)) {
            return "INTEGER";
        }
        if ("BIT".equals(name2)) {
            return "BOOLEAN";
        }
        if ("BOOL".equals(name2)) {
            return "BOOLEAN";
        }
        if ("INT8".equals(name2)) {
            return "BIGINT";
        }
        if ("YEAR".equals(name2)) {
            return "SMALLINT";
        }
        if ("INT".equals(name2)) {
            return "INTEGER";
        }
        if ("IDENTITY".equals(name2)) {
            return "BIGINT";
        }
        if ("DEC".equals(name2)) {
            return "DECIMAL";
        }
        if ("NUMERIC".equals(name2)) {
            return "DECIMAL";
        }
        if ("NUMBER".equals(name2)) {
            return "DECIMAL";
        }
        if ("DOUBLE PRECISION".equals(name2)) {
            return "DOUBLE";
        }
        if ("FLOAT4".equals(name2)) {
            return "REAL";
        }
        if ("FLOAT8".equals(name2)) {
            return "DOUBLE";
        }
        if ("FLOAT".equals(name2)) {
            return "DOUBLE";
        }
        if ("DATETIME".equals(name2)) {
            return "TIMESTAMP";
        }
        if ("SMALLDATETIME".equals(name2)) {
            return "TIMESTAMP";
        }
        if ("BINARY".equals(name2)) {
            return "VARBINARY";
        }
        if ("LONGVARBINARY".equals(name2)) {
            return "VARBINARY";
        }
        if ("RAW".equals(name2)) {
            return "VARBINARY";
        }
        if ("BYTEA".equals(name2)) {
            return "VARBINARY";
        }
        if ("VARCHAR2".equals(name2)) {
            return "VARCHAR";
        }
        if ("LONGVARCHAR".equals(name2)) {
            return "VARCHAR";
        }
        if ("VARCHAR_CASESENSITIVE".equals(name2)) {
            return "VARCHAR";
        }
        if ("NVARCHAR2".equals(name2)) {
            return "VARCHAR";
        }
        if ("NVARCHAR".equals(name2)) {
            return "VARCHAR";
        }
        if ("CHARACTER".equals(name2)) {
            return "CHAR";
        }
        if ("NCHAR".equals(name2)) {
            return "CHAR";
        }
        if ("TINYBLOB".equals(name2)) {
            return "BLOB";
        }
        if ("MEDIUMBLOB".equals(name2)) {
            return "BLOB";
        }
        if ("LONGBLOB".equals(name2)) {
            return "BLOB";
        }
        if ("IMAGE".equals(name2)) {
            return "BLOB";
        }
        if ("OID".equals(name2)) {
            return "BLOB";
        }
        if ("TINYTEXT".equals(name2)) {
            return "CLOB";
        }
        if ("TEXT".equals(name2)) {
            return "CLOB";
        }
        if ("MEDIUMTEXT".equals(name2)) {
            return "CLOB";
        }
        if ("LONGTEXT".equals(name2)) {
            return "CLOB";
        }
        if ("NTEXT".equals(name2)) {
            return "CLOB";
        }
        if ("NCLOB".equals(name2)) {
            return "CLOB";
        }
        String string = name2;
        if (string == null) {
            H2TypeSystem.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    public String getDefaultTypeName(@NotNull SqlType.Category cat) {
        if (cat == null) {
            H2TypeSystem.$$$reportNull$$$0(2);
        }
        switch (cat) {
            case INTEGER: {
                return "integer";
            }
            case REAL: {
                return "decimal";
            }
            case STRING: {
                return "varchar";
            }
            case BOOLEAN: {
                return "boolean";
            }
            case DATE_TIME: {
                return "datetime";
            }
            case DATE: {
                return "date";
            }
            case TIME: {
                return "time";
            }
            case TIMESTAMP: {
                return "timestamp";
            }
            case INTERVAL: {
                return "interval";
            }
            case BYTES: {
                return "blob";
            }
            case ARRAY: {
                return "array";
            }
            case TABLE: {
                return "table";
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/h2/H2TypeSystem";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cat";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/h2/H2TypeSystem";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getNormalizedTypeName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getNormalizedTypeName";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultTypeName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

