/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.db2.zos;

import com.intellij.database.Dbms;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.Version;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.SqlTypeSystem;
import com.intellij.sql.dialects.db2.Db2DialectBase;
import com.intellij.sql.dialects.db2.Db2TypeSystem;
import com.intellij.sql.dialects.db2.Db2Types;
import com.intellij.sql.dialects.functions.SqlFunctionsUtil;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlVariableDefinitionImpl;
import org.jetbrains.annotations.NotNull;

public class Db2ZOSDialect
extends Db2DialectBase {
    public static final Db2ZOSDialect INSTANCE = new Db2ZOSDialect();

    public Db2ZOSDialect() {
        super("DB2_ZOS");
    }

    @NotNull
    public Dbms getDbms() {
        Dbms dbms = Dbms.DB2_ZOS;
        if (dbms == null) {
            Db2ZOSDialect.$$$reportNull$$$0(0);
        }
        return dbms;
    }

    private static boolean isWithReturnCursor(@NotNull SqlIdentifier identifier) {
        SqlVariableDefinitionImpl cursorDefinition;
        if (identifier == null) {
            Db2ZOSDialect.$$$reportNull$$$0(1);
        }
        if ((cursorDefinition = (SqlVariableDefinitionImpl)PsiTreeUtil.getParentOfType((PsiElement)identifier, SqlVariableDefinitionImpl.class)) == null || cursorDefinition.getKind() != SqlDbElementType.CURSOR) {
            return false;
        }
        PsiElement withKeyword = PsiTreeUtil.findSiblingForward((PsiElement)cursorDefinition.getFirstChild(), (IElementType)Db2Types.DB2_WITH, null);
        if (withKeyword == null) {
            return false;
        }
        PsiElement returnKeyword = PsiTreeUtil.findSiblingForward((PsiElement)withKeyword, (IElementType)Db2Types.DB2_WITH, null);
        return returnKeyword != null;
    }

    @NotNull
    public SqlTypeSystem getTypeSystem() {
        Db2TypeSystem db2TypeSystem = Db2TypeSystem.ZOS_INSTANCE;
        if (db2TypeSystem == null) {
            Db2ZOSDialect.$$$reportNull$$$0(2);
        }
        return db2TypeSystem;
    }

    public int getMaxIdentifierLength(@NotNull SqlIdentifier identifier, Version version) {
        ObjectKind kind;
        if (identifier == null) {
            Db2ZOSDialect.$$$reportNull$$$0(3);
        }
        return (kind = SqlImplUtil.getIdentifierKind((SqlIdentifier)identifier)) == ObjectKind.COLUMN || kind == SqlDbElementType.CURSOR && Db2ZOSDialect.isWithReturnCursor(identifier) ? 30 : (kind == ObjectKind.DATABASE || kind == ObjectKind.TABLESPACE ? 8 : 128);
    }

    @Override
    @NotNull
    public SqlLanguageDialectEx.BuiltinFunctions getSupportedFunctions() {
        SqlLanguageDialectEx.BuiltinFunctions builtinFunctions = LazyData.ourFunctionMap;
        if (builtinFunctions == null) {
            Db2ZOSDialect.$$$reportNull$$$0(4);
        }
        return builtinFunctions;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/db2/zos/Db2ZOSDialect";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/db2/zos/Db2ZOSDialect";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeSystem";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedFunctions";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isWithReturnCursor";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getMaxIdentifierLength";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class LazyData {
        static final SqlLanguageDialectEx.BuiltinFunctions ourFunctionMap = SqlFunctionsUtil.loadFunctionDefinition((SqlLanguageDialectEx)INSTANCE);

        LazyData() {
        }
    }
}

