/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.db2;

import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.SqlTypeSystem;
import com.intellij.sql.dialects.db2.Db2DialectBase;
import com.intellij.sql.dialects.db2.Db2LUWDialect;
import com.intellij.sql.dialects.db2.iseries.Db2ISDialect;
import com.intellij.sql.dialects.db2.zos.Db2ZOSDialect;
import com.intellij.sql.psi.SqlType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Db2TypeSystem
extends SqlTypeSystem {
    public static final Db2TypeSystem LUW_INSTANCE = new Db2TypeSystem(Db2LUWDialect.INSTANCE);
    public static final Db2TypeSystem IS_INSTANCE = new Db2TypeSystem(Db2ISDialect.INSTANCE);
    public static final Db2TypeSystem ZOS_INSTANCE = new Db2TypeSystem(Db2ZOSDialect.INSTANCE);

    private Db2TypeSystem(Db2DialectBase dialect) {
        super((SqlLanguageDialectEx)dialect);
    }

    @NotNull
    public String getNormalizedTypeName(@NotNull String name2) {
        if (name2 == null) {
            Db2TypeSystem.$$$reportNull$$$0(0);
        }
        if ((name2 = super.getNormalizedTypeName(name2)).equals("INT")) {
            return "INTEGER";
        }
        if (name2.equals("DEC")) {
            return "DECIMAL";
        }
        if (name2.equals("NUMERIC")) {
            return "DECIMAL";
        }
        if (name2.equals("NUM")) {
            return "DECIMAL";
        }
        if (name2.equals("FLOAT")) {
            return "DOUBLE";
        }
        if (name2.equals("DOUBLE PRECISION")) {
            return "DOUBLE";
        }
        if (name2.equals("CHARACTER")) {
            return "CHAR";
        }
        if (name2.equals("CHAR LARGE OBJECT")) {
            return "CLOB";
        }
        if (name2.equals("CHARACTER LARGE OBJECT")) {
            return "CLOB";
        }
        if (name2.equals("CHAR VARYING")) {
            return "VARCHAR";
        }
        if (name2.equals("CHARACTER VARYING")) {
            return "VARCHAR";
        }
        if (name2.equals("NCHAR")) {
            return "GRAPHIC";
        }
        if (name2.equals("NATIONAL CHAR")) {
            return "GRAPHIC";
        }
        if (name2.equals("NATIONAL CHARACTER")) {
            return "GRAPHIC";
        }
        if (name2.equals("NVARCHAR")) {
            return "VARGRAPHIC";
        }
        if (name2.equals("NATIONAL CHAR VARYING")) {
            return "VARGRAPHIC";
        }
        if (name2.equals("NATIONAL CHARACTER VARYING")) {
            return "VARGRAPHIC";
        }
        if (name2.equals("NCLOB")) {
            return "DBCLOB";
        }
        if (name2.equals("BINARY LARGE OBJECT")) {
            return "BLOB";
        }
        String string = name2;
        if (string == null) {
            Db2TypeSystem.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    public String getDefaultTypeName(@NotNull SqlType.Category cat) {
        if (cat == null) {
            Db2TypeSystem.$$$reportNull$$$0(2);
        }
        switch (cat) {
            case INTEGER: {
                return "int";
            }
            case REAL: {
                return "decimal";
            }
            case STRING: {
                return "varchar";
            }
            case BOOLEAN: {
                return "boolean";
            }
            case DATE_TIME: {
                return "date";
            }
            case DATE: {
                return "date";
            }
            case TIME: {
                return "time";
            }
            case TIMESTAMP: {
                return "timestamp";
            }
            case INTERVAL: {
                return "int";
            }
            case BYTES: {
                return "blob";
            }
        }
        return null;
    }

    @NotNull
    public SqlType.Category getTypeCategoryByName(@NotNull String typeName) {
        if (typeName == null) {
            Db2TypeSystem.$$$reportNull$$$0(3);
        }
        if ("GRAPHIC".equals(typeName)) {
            SqlType.Category category = SqlType.Category.STRING;
            if (category == null) {
                Db2TypeSystem.$$$reportNull$$$0(4);
            }
            return category;
        }
        if ("VARGRAPHIC".equals(typeName)) {
            SqlType.Category category = SqlType.Category.STRING;
            if (category == null) {
                Db2TypeSystem.$$$reportNull$$$0(5);
            }
            return category;
        }
        if ("DBCLOB".equals(typeName)) {
            SqlType.Category category = SqlType.Category.STRING;
            if (category == null) {
                Db2TypeSystem.$$$reportNull$$$0(6);
            }
            return category;
        }
        SqlType.Category category = super.getTypeCategoryByName(typeName);
        if (category == null) {
            Db2TypeSystem.$$$reportNull$$$0(7);
        }
        return category;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/db2/Db2TypeSystem";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cat";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/db2/Db2TypeSystem";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getNormalizedTypeName";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeCategoryByName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getNormalizedTypeName";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultTypeName";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getTypeCategoryByName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

