/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.couchbase;

import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.symbols.DasSymbol;
import com.intellij.psi.PsiElement;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.SqlTypeSystem;
import com.intellij.sql.dialects.couchbase.CouchbaseDialect;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.SqlTypedDefinition;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlReferenceImpl;
import com.intellij.sql.psi.impl.SqlTypeFactory;
import com.intellij.util.containers.JBIterable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CouchbaseTypeSystem
extends SqlTypeSystem {
    public static final CouchbaseTypeSystem INSTANCE = new CouchbaseTypeSystem();

    private CouchbaseTypeSystem() {
        super((SqlLanguageDialectEx)CouchbaseDialect.INSTANCE);
    }

    @NotNull
    public SqlType getSqlType(@Nullable SqlReferenceImpl ref, @Nullable PsiElement resolved, @Nullable DasSymbol symbol) {
        if (symbol == null) {
            SqlType sqlType = super.getSqlType(ref, resolved, null);
            if (sqlType == null) {
                CouchbaseTypeSystem.$$$reportNull$$$0(0);
            }
            return sqlType;
        }
        if (symbol.getKind() == ObjectKind.COLUMN) {
            String prefix;
            DasObject table;
            DasObject object = symbol.getDasObject();
            DasObject dasObject = table = object == null ? null : object.getDasParent();
            if (table == null) {
                SqlType sqlType = super.getSqlType(ref, resolved, symbol);
                if (sqlType == null) {
                    CouchbaseTypeSystem.$$$reportNull$$$0(1);
                }
                return sqlType;
            }
            JBIterable allColumns = table.getDasChildren(ObjectKind.COLUMN).filter(DasColumn.class);
            JBIterable children2 = allColumns.filter(arg_0 -> CouchbaseTypeSystem.lambda$getSqlType$0(prefix = symbol.getName() + ".", arg_0));
            if (!children2.isEmpty()) {
                SqlType sqlType = SqlImplUtil.createTableTypeWithColumns((SqlLanguageDialectEx)this.getDialect(), (JBIterable)children2, (PsiElement)resolved, (DasSymbol)symbol);
                if (sqlType == null) {
                    CouchbaseTypeSystem.$$$reportNull$$$0(2);
                }
                return sqlType;
            }
            if (object instanceof DasColumn && !(object instanceof SqlTypedDefinition)) {
                DasColumn column2 = (DasColumn)object;
                SqlType sqlType = SqlTypeFactory.of((DataType)column2.getDataType(), (SqlLanguageDialectEx)this.getDialect());
                if (sqlType == null) {
                    CouchbaseTypeSystem.$$$reportNull$$$0(3);
                }
                return sqlType;
            }
        } else if (symbol.getKind() == ObjectKind.TABLE) {
            DasTable table = (DasTable)symbol;
            JBIterable columns = table.getDasChildren(ObjectKind.COLUMN).filter(DasColumn.class);
            SqlType sqlType = SqlImplUtil.createTableTypeWithColumns((SqlLanguageDialectEx)this.getDialect(), (JBIterable)columns, (PsiElement)resolved, (DasSymbol)symbol);
            if (sqlType == null) {
                CouchbaseTypeSystem.$$$reportNull$$$0(4);
            }
            return sqlType;
        }
        SqlType sqlType = super.getSqlType(ref, resolved, symbol);
        if (sqlType == null) {
            CouchbaseTypeSystem.$$$reportNull$$$0(5);
        }
        return sqlType;
    }

    @Nullable
    public String getDefaultTypeName(@NotNull SqlType.Category cat) {
        if (cat == null) {
            CouchbaseTypeSystem.$$$reportNull$$$0(6);
        }
        switch (cat) {
            case BOOLEAN: {
                return "boolean";
            }
            case INTEGER: 
            case REAL: {
                return "number";
            }
            case STRING: {
                return "string";
            }
            case ARRAY: {
                return "array";
            }
            case BYTES: {
                return "binary";
            }
            case DATE: {
                return "date";
            }
            case MAP: {
                return "object";
            }
        }
        return null;
    }

    private static /* synthetic */ boolean lambda$getSqlType$0(String prefix, DasColumn col) {
        return col.getName().startsWith(prefix);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/couchbase/CouchbaseTypeSystem";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cat";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSqlType";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/couchbase/CouchbaseTypeSystem";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultTypeName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

