/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.clickhouse;

import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.database.Dbms;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.model.PsiColumn;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.symbols.DasSymbol;
import com.intellij.database.util.Case;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.TreePatternNode;
import com.intellij.lang.Language;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveState;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.dialects.ReservedEntity;
import com.intellij.sql.dialects.SqlDialectImplUtil;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.SqlTypeSystem;
import com.intellij.sql.dialects.base.SqlLexer;
import com.intellij.sql.dialects.base.TokenClasses;
import com.intellij.sql.dialects.clickhouse.CHouseElementTypes;
import com.intellij.sql.dialects.clickhouse.CHouseLexer;
import com.intellij.sql.dialects.clickhouse.CHouseOptionalKeywords;
import com.intellij.sql.dialects.clickhouse.CHouseTokens;
import com.intellij.sql.dialects.clickhouse.CHouseTypeSystem;
import com.intellij.sql.dialects.clickhouse.CHouseTypes;
import com.intellij.sql.dialects.functions.SqlFunctionDefinition;
import com.intellij.sql.dialects.functions.SqlFunctionsUtil;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlBinaryExpression;
import com.intellij.sql.psi.SqlColumnDefinition;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlElementTypes;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlExpressionList;
import com.intellij.sql.psi.SqlKeywordTokenType;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReference;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlScopeProcessor;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.SqlTypeElement;
import com.intellij.sql.psi.SqlTypedDefinition;
import com.intellij.sql.psi.impl.SqlArrayType;
import com.intellij.sql.psi.impl.SqlFileImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlTypeFactory;
import com.intellij.sql.psi.impl.SubtractedSqlTableTypeImpl;
import com.intellij.sql.psi.impl.TableBasedSqlTableTypeImpl;
import com.intellij.sql.symbols.DasSymbolUtil;
import com.intellij.sql.util.SqlTokenRegistry;
import com.intellij.util.NullableFunction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CHouseDialect
extends SqlLanguageDialectEx {
    public static final CHouseDialect INSTANCE = new CHouseDialect();

    public CHouseDialect() {
        super("ClickHouse");
    }

    @NotNull
    public SqlTypeSystem getTypeSystem() {
        CHouseTypeSystem cHouseTypeSystem = CHouseTypeSystem.INSTANCE;
        if (cHouseTypeSystem == null) {
            CHouseDialect.$$$reportNull$$$0(0);
        }
        return cHouseTypeSystem;
    }

    protected void addTypes(Map<String, SqlFunctionDefinition.Type> myTypes) {
        super.addTypes(myTypes);
        SqlFunctionDefinition.addSimpleType(myTypes, (SqlFunctionDefinition.Type)Types.ANY_NA);
        SqlFunctionDefinition.addSimpleType(myTypes, (SqlFunctionDefinition.Type)Types.STRING_OR_TOKEN);
        SqlFunctionDefinition.addSimpleType(myTypes, (SqlFunctionDefinition.Type)Types.STRING_OR_SCHEMA);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"UInt8", (String)"UInt8", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"UInt16", (String)"UInt16", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"UInt32", (String)"UInt32", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"UInt64", (String)"UInt64", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"Int8", (String)"Int8", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"Int16", (String)"Int16", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"Int32", (String)"Int32", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"Int64", (String)"Int64", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"Float32", (String)"Float32", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"Float64", (String)"Float64", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"Date", (String)"Date", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"DateTime", (String)"DateTime", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"DateTime64", (String)"DateTime64", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"String", (String)"String", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"FixedString", (String)"FixedString", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, (SqlFunctionDefinition.Type)Types.ARRAY);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"Tuple", (String)"Tuple", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"Enum", (String)"Enum", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"UUID", (String)"UUID", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"Expression", (String)"Expression", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, (SqlFunctionDefinition.Type)Types.AGGREGATE_FUNCTION);
    }

    @NotNull
    public Dbms getDbms() {
        Dbms dbms = Dbms.CLICKHOUSE;
        if (dbms == null) {
            CHouseDialect.$$$reportNull$$$0(1);
        }
        return dbms;
    }

    public boolean processReservedEntitiesWithType(@Nullable String name2, @NotNull PsiElement place, boolean resolve2, @NotNull SqlScopeProcessor processor) {
        if (place == null) {
            CHouseDialect.$$$reportNull$$$0(2);
        }
        if (processor == null) {
            CHouseDialect.$$$reportNull$$$0(3);
        }
        if (processor.isExpected(ObjectKind.COLUMN)) {
            for (ReservedEntity.Typed entity : LazyData.RE_COLUMNS) {
                if (CHouseDialect.processReservedEntitiesWithTypeSimple((ReservedEntity)entity, (SqlType)entity.type, (String)name2, (PsiElement)place, (boolean)resolve2, (SqlScopeProcessor)processor, (boolean)true, (Boolean)true)) continue;
                return false;
            }
        }
        if (place instanceof SqlReferenceExpression && ((SqlReferenceExpression)place).getQualifierExpression() == null) {
            for (ReservedEntity type : LazyData.ourObjects) {
                if (CHouseDialect.processReservedEntitiesWithTypeSimple((ReservedEntity)type, (SqlType)SqlTypeFactory.REFERENCE, (String)name2, (PsiElement)place, (boolean)resolve2, (SqlScopeProcessor)processor, (boolean)true, (Boolean)resolve2)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isReservedKeyword(IElementType tokenType) {
        return tokenType instanceof SqlKeywordTokenType && LazyData.ourReservedTokens.fun((Object)tokenType.toString()) != null;
    }

    @NotNull
    public SqlLanguageDialectEx.BuiltinFunctions getSupportedFunctions() {
        SqlLanguageDialectEx.BuiltinFunctions builtinFunctions = LazyData.ourFunctionMap;
        if (builtinFunctions == null) {
            CHouseDialect.$$$reportNull$$$0(4);
        }
        return builtinFunctions;
    }

    public boolean isOperatorSupported(@Nullable IElementType tokenType) {
        return tokenType != null && LazyData.ourSupportedOperators.contains(tokenType);
    }

    @NotNull
    public Set<String> getKeywords() {
        Set<String> set = LazyData.ourKeywords;
        if (set == null) {
            CHouseDialect.$$$reportNull$$$0(5);
        }
        return set;
    }

    @NotNull
    public Set<String> getReservedKeywords() {
        Set<String> set = LazyData.ourReservedKeywords;
        if (set == null) {
            CHouseDialect.$$$reportNull$$$0(6);
        }
        return set;
    }

    @NotNull
    public Set<String> getSystemVariables() {
        Set<String> set = LazyData.ourSystemVars;
        if (set == null) {
            CHouseDialect.$$$reportNull$$$0(7);
        }
        return set;
    }

    @NotNull
    public TreePattern getBaseImports(@Nullable DbDataSource dataSource, @Nullable ObjectName[] dsNames) {
        DasNamespace namespace = CHouseDialect.getDefaultNamespace((DbDataSource)dataSource, null);
        if (namespace != null) {
            TreePattern treePattern = SqlDialectImplUtil.createObjectPattern((ObjectName[])dsNames, (DasObject)namespace, (TreePatternNode.Group[])new TreePatternNode.Group[0]);
            if (treePattern == null) {
                CHouseDialect.$$$reportNull$$$0(8);
            }
            return treePattern;
        }
        TreePattern treePattern = this.getSchemaBaseImports(dataSource, dsNames, true);
        if (treePattern == null) {
            CHouseDialect.$$$reportNull$$$0(9);
        }
        return treePattern;
    }

    public static SqlTableType filterComputedColumns(@NotNull SqlTableType type) {
        if (type == null) {
            CHouseDialect.$$$reportNull$$$0(10);
        }
        SqlTableType resultType = type;
        int i2 = 0;
        while (i2 < resultType.getColumnCount()) {
            PsiElement columnSource = resultType.getSourceColumnElement(i2);
            if (columnSource instanceof PsiColumn && SqlImplUtil.isComputedVal((DasColumn)((PsiColumn)columnSource))) {
                resultType = SubtractedSqlTableTypeImpl.subtract((SqlTableType)resultType, (int)i2);
                continue;
            }
            ++i2;
        }
        return resultType;
    }

    public boolean allowGlobalTableResolve(@NotNull PsiElement place) {
        if (place == null) {
            CHouseDialect.$$$reportNull$$$0(11);
        }
        return CHouseDialect.isOpIn(place) && !(place.getParent() instanceof SqlReferenceExpression);
    }

    @NotNull
    public Set<SqlFunctionDefinition.Location> getExpectedFunctionLocations(@Nullable SqlExpression expression) {
        SqlReferenceExpression ref = (SqlReferenceExpression)ObjectUtils.tryCast((Object)expression, SqlReferenceExpression.class);
        if (ref != null) {
            ObjectKind kind = ref.getReferenceElementType().getTargetKind();
            if (kind == CHouseElementTypes.Kinds.TABLE_ENGINE) {
                EnumSet<SqlFunctionDefinition.Location> enumSet = EnumSet.of(SqlFunctionDefinition.Location.TABLE_ENGINE_SPEC);
                if (enumSet == null) {
                    CHouseDialect.$$$reportNull$$$0(12);
                }
                return enumSet;
            }
            if (kind == CHouseElementTypes.Kinds.DATABASE_ENGINE) {
                EnumSet<SqlFunctionDefinition.Location> enumSet = EnumSet.of(SqlFunctionDefinition.Location.DATABASE_ENGINE_SPEC);
                if (enumSet == null) {
                    CHouseDialect.$$$reportNull$$$0(13);
                }
                return enumSet;
            }
            if (kind == CHouseElementTypes.Kinds.CODEC) {
                EnumSet<SqlFunctionDefinition.Location> enumSet = EnumSet.of(SqlFunctionDefinition.Location.CODEC_SPEC);
                if (enumSet == null) {
                    CHouseDialect.$$$reportNull$$$0(14);
                }
                return enumSet;
            }
            if (kind == SqlDbElementType.INDEXTYPE) {
                EnumSet<SqlFunctionDefinition.Location> enumSet = EnumSet.of(SqlFunctionDefinition.Location.INDEX_TYPE_SPEC);
                if (enumSet == null) {
                    CHouseDialect.$$$reportNull$$$0(15);
                }
                return enumSet;
            }
        }
        Set set = super.getExpectedFunctionLocations(expression);
        if (set == null) {
            CHouseDialect.$$$reportNull$$$0(16);
        }
        return set;
    }

    public boolean isValidRawToken(@NotNull IElementType type, @NotNull CharSequence text) {
        if (type == null) {
            CHouseDialect.$$$reportNull$$$0(17);
        }
        if (text == null) {
            CHouseDialect.$$$reportNull$$$0(18);
        }
        return CHouseLexer.isValidRawToken(text);
    }

    public boolean supportsJoinUsing() {
        return true;
    }

    public boolean isSpecialFunctionReference(@NotNull IElementType elementType) {
        if (elementType == null) {
            CHouseDialect.$$$reportNull$$$0(19);
        }
        return LazyData.SPECIAL_FUNCTION_REFERENCES.contains(elementType);
    }

    public boolean shouldHide(@Nullable DasSymbol symbol, @Nullable PsiElement place) {
        DasObject object = symbol != null ? symbol.getDasObject() : null;
        DasObject parent2 = object != null ? object.getDasParent() : null;
        return object instanceof DasRoutine && parent2 != null && parent2.getKind() == ObjectKind.ROOT;
    }

    public TokenSet getStatementSeparators() {
        return LazyData.ourClosingTokens;
    }

    public <T extends Collection<ObjectKind>> T getParentDbTypes(T result2, ObjectKind type) {
        Collection res2 = super.getParentDbTypes(result2, type);
        if (type == ObjectKind.COLUMN) {
            res2.add(ObjectKind.COLUMN);
        }
        return (T)res2;
    }

    public boolean isResolveTargetAccepted(@Nullable DasSymbol symbol, ObjectKind type, @NotNull Set<ObjectKind> expectedTypes, @Nullable PsiElement place, boolean strict, boolean isCompletion) {
        if (expectedTypes == null) {
            CHouseDialect.$$$reportNull$$$0(20);
        }
        if ((type == ObjectKind.VIEW || type == ObjectKind.MAT_VIEW) && expectedTypes.contains(ObjectKind.TABLE)) {
            return true;
        }
        if (type == SqlDbElementType.LOCAL_ALIAS && expectedTypes.contains(ObjectKind.COLUMN)) {
            return true;
        }
        if (type == ObjectKind.ROUTINE && (expectedTypes.contains(CHouseElementTypes.Kinds.TABLE_ENGINE) || expectedTypes.contains(CHouseElementTypes.Kinds.DATABASE_ENGINE) || expectedTypes.contains(CHouseElementTypes.Kinds.CODEC) || expectedTypes.contains(SqlDbElementType.INDEXTYPE))) {
            return true;
        }
        return super.isResolveTargetAccepted(symbol, type, expectedTypes, place, strict, isCompletion);
    }

    public boolean shouldQuotedTypeReferenceBeChecked(@NotNull String ref) {
        if (ref == null) {
            CHouseDialect.$$$reportNull$$$0(21);
        }
        return !this.getKeywords().contains(ref);
    }

    @Nullable
    public EnterHandlerDelegate getEnterHandler() {
        return null;
    }

    public boolean shallResolve(@Nullable SqlReferenceExpression o2, ObjectKind type) {
        return type != SqlDbElementType.FORMAT && type != SqlDbElementType.PARTITION && super.shallResolve(o2, type);
    }

    public boolean processUnqualifiedResolve(@NotNull SqlScopeProcessor processor, @NotNull ResolveState state2, @NotNull PsiReference ref) {
        SqlReferenceExpression prevRef;
        if (processor == null) {
            CHouseDialect.$$$reportNull$$$0(22);
        }
        if (state2 == null) {
            CHouseDialect.$$$reportNull$$$0(23);
        }
        if (ref == null) {
            CHouseDialect.$$$reportNull$$$0(24);
        }
        if (!CHouseDialect.processAliases(processor, state2, ref)) {
            return false;
        }
        PsiElement place = ref.getElement();
        if (SqlImplUtil.isProcessingOneOf((SqlScopeProcessor)processor, (ObjectKind[])new ObjectKind[]{ObjectKind.TABLE}) && ObjectUtils.tryCast((Object)place.getParent(), SqlExpressionList.class) != null && (prevRef = (SqlReferenceExpression)ObjectUtils.tryCast((Object)PsiTreeUtil.getPrevSiblingOfType((PsiElement)place, SqlExpression.class), SqlReferenceExpression.class)) != null && prevRef.getReferenceElementType().getTargetKind() == ObjectKind.SCHEMA && !SqlImplUtil.processQualifier((SqlReferenceExpression)prevRef, (SqlScopeProcessor)processor, (ResolveState)state2, (PsiElement)place)) {
            return false;
        }
        return super.processUnqualifiedResolve(processor, state2, ref);
    }

    public boolean processQualifiedResolve(@NotNull SqlScopeProcessor processor, @NotNull ResolveState state2, @NotNull SqlReference ref, @NotNull SqlExpression qualifier) {
        SqlType sqlType;
        if (processor == null) {
            CHouseDialect.$$$reportNull$$$0(25);
        }
        if (state2 == null) {
            CHouseDialect.$$$reportNull$$$0(26);
        }
        if (ref == null) {
            CHouseDialect.$$$reportNull$$$0(27);
        }
        if (qualifier == null) {
            CHouseDialect.$$$reportNull$$$0(28);
        }
        if (SqlImplUtil.isProcessingOneOf((SqlScopeProcessor)processor, (ObjectKind[])new ObjectKind[]{ObjectKind.COLUMN}) && (sqlType = qualifier.getSqlType()) instanceof SqlArrayType) {
            SqlTableType type = (SqlTableType)ObjectUtils.tryCast((Object)((SqlArrayType)sqlType).getInnerType(), SqlTableType.class);
            return type == null || SqlImplUtil.processDeclarationsInType((SqlTableType)type, (SqlScopeProcessor)processor, (ResolveState)state2, (PsiElement)ref.getElement());
        }
        return super.processQualifiedResolve(processor, state2, ref, qualifier);
    }

    public boolean processTypeExtra(SqlTableType type, SqlScopeProcessor processor, ResolveState state2, PsiElement place) {
        for (DasSymbol pc : CHouseDialect.getParentColumnObjects(place.getContainingFile(), type)) {
            if (processor.execute(pc, state2)) continue;
            return false;
        }
        return super.processTypeExtra(type, processor, state2, place);
    }

    private static boolean isOpIn(@Nullable PsiElement place) {
        SqlBinaryExpression exp;
        SqlBinaryExpression sqlBinaryExpression = exp = place == null ? null : (SqlBinaryExpression)ObjectUtils.tryCast((Object)place.getParent(), SqlBinaryExpression.class);
        if (exp == null || exp.getROperand() != place) {
            return place == null;
        }
        return exp.getOpSign() == SqlCommonKeywords.SQL_IN;
    }

    private static boolean processAliases(@NotNull SqlScopeProcessor processor, @NotNull ResolveState state2, @NotNull PsiReference ref) {
        PsiElement place;
        SqlQueryExpression root2;
        if (processor == null) {
            CHouseDialect.$$$reportNull$$$0(29);
        }
        if (state2 == null) {
            CHouseDialect.$$$reportNull$$$0(30);
        }
        if (ref == null) {
            CHouseDialect.$$$reportNull$$$0(31);
        }
        if ((root2 = (SqlQueryExpression)PsiTreeUtil.getContextOfType((PsiElement)(place = ref.getElement()), (Class[])new Class[]{SqlQueryExpression.class})) == null) {
            return true;
        }
        for (SqlAsExpression alias : CHouseDialect.getAliases(root2)) {
            if (PsiTreeUtil.isContextAncestor((PsiElement)alias, (PsiElement)place, (boolean)false) || processor.execute((DasSymbol)alias, state2)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public static List<DasSymbol> getParentColumnObjects(@NotNull PsiFile file, @Nullable SqlTableType type) {
        if (file == null) {
            CHouseDialect.$$$reportNull$$$0(32);
        }
        if (type == null || type.getTypeElement() instanceof MyAggColumnDefinition) {
            List<DasSymbol> list = Collections.emptyList();
            if (list == null) {
                CHouseDialect.$$$reportNull$$$0(33);
            }
            return list;
        }
        HashMap grouped = null;
        int c = type.getColumnCount();
        for (int i2 = 0; i2 < c; ++i2) {
            String name2 = type.getColumnName(i2);
            int dotIdx = name2.indexOf(46);
            if (dotIdx == -1) continue;
            if (grouped == null) {
                grouped = new HashMap();
            }
            ((List)ContainerUtil.getOrCreate(grouped, (Object)name2.substring(0, dotIdx), () -> new ArrayList())).add((PsiElement)ObjectUtils.chooseNotNull((Object)type.getSourceColumnElement(i2), (Object)type.getColumnElement(i2)));
        }
        if (grouped == null) {
            List<DasSymbol> list = Collections.emptyList();
            if (list == null) {
                CHouseDialect.$$$reportNull$$$0(34);
            }
            return list;
        }
        ArrayList<DasSymbol> res2 = new ArrayList<DasSymbol>(grouped.size());
        ConcurrentMap caches = (ConcurrentMap)CachedValuesManager.getCachedValue((PsiElement)file, () -> CachedValueProvider.Result.create((Object)ContainerUtil.createConcurrentWeakKeyWeakValueMap(), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
        for (Map.Entry entry : grouped.entrySet()) {
            res2.add((DasSymbol)caches.computeIfAbsent(Pair.create((Object)((String)entry.getKey()), (Object)((List)entry.getValue())), param -> new MyAggColumnDefinition((PsiElement)((List)param.second).get(0), (String)param.first, (List)param.second)));
        }
        ArrayList<DasSymbol> arrayList = res2;
        if (arrayList == null) {
            CHouseDialect.$$$reportNull$$$0(35);
        }
        return arrayList;
    }

    public static boolean isNestedType(@NotNull SqlColumnDefinition o1) {
        SqlTypeElement type;
        if (o1 == null) {
            CHouseDialect.$$$reportNull$$$0(36);
        }
        if (PsiUtilCore.getElementType((PsiElement)(type = (SqlTypeElement)PsiTreeUtil.getChildOfType((PsiElement)o1, SqlTypeElement.class))) != SqlCompositeElementTypes.SQL_TABLE_TYPE_ELEMENT) {
            return false;
        }
        PsiElement name2 = type.getFirstChild();
        name2 = name2 == null ? null : name2.getFirstChild();
        name2 = name2 == null ? null : name2.getFirstChild();
        return PsiUtilCore.getElementType((PsiElement)name2) == CHouseTypes.CH_NESTED;
    }

    private static List<SqlAsExpression> getAliases(SqlQueryExpression root2) {
        return (List)CachedValuesManager.getCachedValue((PsiElement)root2, () -> CachedValueProvider.Result.create(CHouseDialect.calcAliases(root2), (Object[])new Object[]{root2}));
    }

    @NotNull
    private static List<SqlAsExpression> calcAliases(SqlQueryExpression root2) {
        List list = ((SyntaxTraverser)SqlImplUtil.sqlTraverser((PsiElement)root2).expand(e2 -> e2 == root2 || !(e2 instanceof SqlQueryExpression))).filter(SqlAsExpression.class).toList();
        if (list == null) {
            CHouseDialect.$$$reportNull$$$0(37);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 10: 
            case 11: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 36: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 10: 
            case 11: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 36: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/clickhouse/CHouseDialect";
                break;
            }
            case 2: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 3: 
            case 22: 
            case 25: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 10: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedTypes";
                break;
            }
            case 21: 
            case 24: 
            case 27: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 23: 
            case 26: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o1";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeSystem";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 2: 
            case 3: 
            case 10: 
            case 11: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/clickhouse/CHouseDialect";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedFunctions";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeywords";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getReservedKeywords";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemVariables";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseImports";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpectedFunctionLocations";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getParentColumnObjects";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "calcAliases";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "processReservedEntitiesWithType";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "filterComputedColumns";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "allowGlobalTableResolve";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isValidRawToken";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isSpecialFunctionReference";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isResolveTargetAccepted";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "shouldQuotedTypeReferenceBeChecked";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "processUnqualifiedResolve";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "processQualifiedResolve";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "processAliases";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getParentColumnObjects";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "isNestedType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 10: 
            case 11: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 36: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyAggColumnDefinition
    extends MyColumnDefinition {
        private final List<PsiElement> myColumns;

        MyAggColumnDefinition(PsiElement parent2, String name2, List<PsiElement> columns) {
            super(parent2, name2);
            this.myColumns = columns;
        }

        @Override
        @NotNull
        public SqlType getSqlType() {
            String preName = this.getName();
            ArrayList<MyColumnDefinition> columns = new ArrayList<MyColumnDefinition>(this.myColumns.size());
            for (PsiElement column2 : this.myColumns) {
                String name2 = column2 instanceof DasObject ? ((DasObject)column2).getName() : "";
                String cName = name2.length() <= preName.length() ? name2 : name2.substring(preName.length() + 1);
                columns.add((MyColumnDefinition)((Object)CachedValuesManager.getCachedValue((PsiElement)column2, () -> CachedValueProvider.Result.create((Object)((Object)new MyColumnDefinition(column2, cName)), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}))));
            }
            return new TableBasedSqlTableTypeImpl(columns, (PsiElement)this);
        }
    }

    private static class MyColumnDefinition
    extends SqlFileImpl.FakeDefinition
    implements SqlTypedDefinition {
        MyColumnDefinition(PsiElement parent2, String name2) {
            super(parent2, name2);
        }

        @NotNull
        public Dbms getDbms() {
            Dbms dbms = Dbms.CLICKHOUSE;
            if (dbms == null) {
                MyColumnDefinition.$$$reportNull$$$0(0);
            }
            return dbms;
        }

        @NotNull
        public Language getLanguage() {
            SqlLanguageDialectEx sqlLanguageDialectEx = SqlImplUtil.getSqlDialectSafe((PsiElement)this.getParent());
            if (sqlLanguageDialectEx == null) {
                MyColumnDefinition.$$$reportNull$$$0(1);
            }
            return sqlLanguageDialectEx;
        }

        @NotNull
        public PsiElement getNavigationElement() {
            PsiElement psiElement = this.getParent();
            if (psiElement == null) {
                MyColumnDefinition.$$$reportNull$$$0(2);
            }
            return psiElement;
        }

        public boolean isNameQuoted() {
            return false;
        }

        @NotNull
        public ObjectKind getKind() {
            ObjectKind objectKind = ObjectKind.COLUMN;
            if (objectKind == null) {
                MyColumnDefinition.$$$reportNull$$$0(3);
            }
            return objectKind;
        }

        @NotNull
        public DataType getDataType() {
            DataType dataType = this.getSqlType().getDataType();
            if (dataType == null) {
                MyColumnDefinition.$$$reportNull$$$0(4);
            }
            return dataType;
        }

        public boolean isNotNull() {
            return true;
        }

        @Nullable
        public String getDefault() {
            return null;
        }

        @NotNull
        public SqlType getSqlType() {
            PsiElement parent2 = this.getParent();
            SqlType sqlType = INSTANCE.getTypeSystem().getSqlType(null, parent2, DasSymbolUtil.getSymbolByPsi((PsiElement)parent2));
            if (sqlType == null) {
                MyColumnDefinition.$$$reportNull$$$0(5);
            }
            return sqlType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/sql/dialects/clickhouse/CHouseDialect$MyColumnDefinition";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDbms";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLanguage";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNavigationElement";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKind";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDataType";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSqlType";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private static class SuffixedBuiltinFunctions
    implements SqlLanguageDialectEx.BuiltinFunctions {
        private final SqlLanguageDialectEx.BuiltinFunctions myDelegate = SqlFunctionsUtil.loadFunctionDefinition((SqlLanguageDialectEx)INSTANCE);

        private SuffixedBuiltinFunctions() {
        }

        @Nullable
        public SqlFunctionDefinition get(@Nullable String name2) {
            SqlFunctionDefinition def = this.getImpl(name2);
            if (def != null || name2 == null) {
                return def;
            }
            return this.getSuffixed(name2);
        }

        @Nullable
        private SqlFunctionDefinition getSuffixed(@NotNull String name2) {
            Suffix suffix2;
            if (name2 == null) {
                SuffixedBuiltinFunctions.$$$reportNull$$$0(0);
            }
            if ((suffix2 = Suffix.find(name2)) == null) {
                return null;
            }
            SqlFunctionDefinition def = this.myDelegate.get(name2 = suffix2.trim(name2));
            if (def != null && !"true".equals(def.getDialectAttribute("aggregate"))) {
                return null;
            }
            if (def == null) {
                def = this.getSuffixed(name2);
            }
            return def == null ? null : suffix2.modify(def);
        }

        public boolean contains(@Nullable String name2) {
            if (this.getImpl(name2) != null) {
                return true;
            }
            while (name2 != null) {
                Suffix suffix2 = Suffix.find(name2);
                if (suffix2 == null) {
                    return false;
                }
                SqlFunctionDefinition def = this.myDelegate.get(name2 = suffix2.trim(name2));
                if (def == null) continue;
                return "true".equals(def.getDialectAttribute("aggregate"));
            }
            return false;
        }

        @Nullable
        private SqlFunctionDefinition getImpl(@Nullable String name2) {
            SqlFunctionDefinition def = this.myDelegate.get(name2);
            if (def != null || name2 == null) {
                return def;
            }
            def = this.myDelegate.get(Case.LOWER.apply(name2));
            return def != null && "true".equals(def.getDialectAttribute("insensitive")) ? def : null;
        }

        @NotNull
        public Iterable<SqlFunctionDefinition> byMatcher(@NotNull PrefixMatcher matcher) {
            if (matcher == null) {
                SuffixedBuiltinFunctions.$$$reportNull$$$0(1);
            }
            Iterable iterable = this.myDelegate.byMatcher(matcher);
            if (iterable == null) {
                SuffixedBuiltinFunctions.$$$reportNull$$$0(2);
            }
            return iterable;
        }

        @NotNull
        public Collection<SqlFunctionDefinition> forTokens() {
            Collection collection = this.myDelegate.forTokens();
            if (collection == null) {
                SuffixedBuiltinFunctions.$$$reportNull$$$0(3);
            }
            return collection;
        }

        @Nullable
        public SqlLanguageDialectEx.BuiltinFunctions typeMethods(@NotNull String typeName, boolean forInstance) {
            if (typeName == null) {
                SuffixedBuiltinFunctions.$$$reportNull$$$0(4);
            }
            return this.myDelegate.typeMethods(typeName, forInstance);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "matcher";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/dialects/clickhouse/CHouseDialect$SuffixedBuiltinFunctions";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "typeName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/dialects/clickhouse/CHouseDialect$SuffixedBuiltinFunctions";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "byMatcher";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "forTokens";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getSuffixed";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "byMatcher";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "typeMethods";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        static enum Suffix {
            If{

                @Override
                protected SqlFunctionDefinition.Prototype modifyProto(SqlFunctionDefinition.Prototype p) {
                    SqlFunctionDefinition.Parameter[] oldParams = p.getParams();
                    boolean broken = oldParams.length != 0 && this.isGreedy(oldParams[oldParams.length - 1]);
                    SqlFunctionDefinition.Parameter[] params = new SqlFunctionDefinition.Parameter[oldParams.length + (broken ? 1 : 2)];
                    System.arraycopy(oldParams, 0, params, 0, oldParams.length);
                    SqlFunctionDefinition.Parameter[] argSeq = broken ? new SqlFunctionDefinition.Parameter[2] : params;
                    argSeq[argSeq.length - 2] = COMMA.copyWithPrototype(p.getPrototypeId());
                    argSeq[argSeq.length - 1] = COND.copyWithPrototype(p.getPrototypeId());
                    if (broken) {
                        params[params.length - 1] = new SqlFunctionDefinition.ParameterBlock(p.getPrototypeId(), SqlFunctionDefinition.ParameterBlockType.OPTIONAL_SEQUENCE, argSeq, false);
                    }
                    return new SqlFunctionDefinition.Prototype(null, p.getReturnType(), p.getPrototypeId(), p.getHeadBlock(), params, p.getAttributes());
                }

                private boolean isGreedy(SqlFunctionDefinition.Parameter param) {
                    if (param.isMany()) {
                        return true;
                    }
                    SqlFunctionDefinition.ParameterBlock block = (SqlFunctionDefinition.ParameterBlock)ObjectUtils.tryCast((Object)param, SqlFunctionDefinition.ParameterBlock.class);
                    if (block == null || block.getBlockType() == SqlFunctionDefinition.ParameterBlockType.CHOICE) {
                        return false;
                    }
                    if (block.getBlockType() == SqlFunctionDefinition.ParameterBlockType.OPTIONAL_SEQUENCE) {
                        return true;
                    }
                    SqlFunctionDefinition.Parameter[] params = block.getParams();
                    return params.length == 0 || this.isGreedy(params[params.length - 1]);
                }
            }
            ,
            Array{

                @Override
                protected SqlFunctionDefinition.Prototype modifyProto(SqlFunctionDefinition.Prototype p) {
                    SqlFunctionDefinition.Parameter[] params = Suffix.makeArrayParams(p.getParams());
                    SqlFunctionDefinition.Type ret = p.getReturnType();
                    if (ret instanceof SqlFunctionDefinition.ParamType) {
                        ret = SqlFunctionDefinition.ANY;
                    }
                    return new SqlFunctionDefinition.Prototype(null, ret, p.getPrototypeId(), p.getHeadBlock(), params, p.getAttributes());
                }
            }
            ,
            State{

                @Override
                protected SqlFunctionDefinition.Prototype modifyProto(SqlFunctionDefinition.Prototype p) {
                    return new SqlFunctionDefinition.Prototype(null, Types.AGGREGATE_FUNCTION, p.getPrototypeId(), p.getHeadBlock(), p.getParams(), p.getAttributes());
                }
            }
            ,
            Merge{

                @Override
                protected SqlFunctionDefinition.Prototype modifyProto(SqlFunctionDefinition.Prototype p) {
                    SqlFunctionDefinition.Type ret = p.getReturnType();
                    if (ret instanceof SqlFunctionDefinition.ParamType) {
                        ret = SqlFunctionDefinition.ANY;
                    }
                    return new SqlFunctionDefinition.Prototype(null, ret, p.getPrototypeId(), p.getHeadBlock(), new SqlFunctionDefinition.Parameter[]{STATE.copyWithPrototype(p.getPrototypeId())}, p.getAttributes());
                }
            }
            ,
            ForEach{

                @Override
                protected SqlFunctionDefinition.Prototype modifyProto(SqlFunctionDefinition.Prototype p) {
                    SqlFunctionDefinition.Parameter[] params = Suffix.makeArrayParams(p.getParams());
                    return new SqlFunctionDefinition.Prototype(null, Types.ARRAY, p.getPrototypeId(), p.getHeadBlock(), params, p.getAttributes());
                }
            };

            private static final SqlFunctionDefinition.Parameter COMMA;
            private static final SqlFunctionDefinition.Parameter COND;
            private static final SqlFunctionDefinition.Parameter STATE;
            private final Map<SqlFunctionDefinition, SqlFunctionDefinition> myCache = ConcurrentFactoryMap.create(this::modifyDef, ContainerUtil::createConcurrentSoftValueMap);

            boolean at(String s) {
                return this.name().length() < s.length() && s.endsWith(this.name());
            }

            String trim(String s) {
                return s.substring(0, s.length() - this.name().length());
            }

            SqlFunctionDefinition modify(SqlFunctionDefinition def) {
                return this.myCache.get(def);
            }

            private SqlFunctionDefinition modifyDef(SqlFunctionDefinition def) {
                SqlFunctionDefinition.Prototype[] protos = def.getPrototypes();
                ArrayList<SqlFunctionDefinition.Prototype> newProtos = new ArrayList<SqlFunctionDefinition.Prototype>(protos.length);
                for (SqlFunctionDefinition.Prototype proto2 : protos) {
                    newProtos.add(this.modifyProto(proto2));
                }
                return new SqlFunctionDefinition(def.getName() + this.name(), def.getAliasedFunction(), def.getDialectAttrs(), newProtos, def.getDbms());
            }

            protected abstract SqlFunctionDefinition.Prototype modifyProto(SqlFunctionDefinition.Prototype var1);

            @NotNull
            private static SqlFunctionDefinition.Parameter[] makeArrayParams(SqlFunctionDefinition.Parameter[] oldParams) {
                SqlFunctionDefinition.Parameter[] params = new SqlFunctionDefinition.Parameter[oldParams.length];
                for (int i2 = 0; i2 < oldParams.length; ++i2) {
                    SqlFunctionDefinition.Parameter param = oldParams[i2];
                    params[i2] = Suffix.makeArrayParams(param);
                }
                if (params == null) {
                    Suffix.$$$reportNull$$$0(0);
                }
                return params;
            }

            private static SqlFunctionDefinition.Parameter makeArrayParams(SqlFunctionDefinition.Parameter p) {
                if (p instanceof SqlFunctionDefinition.SimpleParameter) {
                    return new SqlFunctionDefinition.SimpleParameter(p.getPrototypeId(), ((SqlFunctionDefinition.SimpleParameter)p).getName(), Types.ARRAY, p.isMany());
                }
                if (p instanceof SqlFunctionDefinition.ParameterBlock) {
                    return new SqlFunctionDefinition.ParameterBlock(p.getPrototypeId(), ((SqlFunctionDefinition.ParameterBlock)p).getBlockType(), Suffix.makeArrayParams(((SqlFunctionDefinition.ParameterBlock)p).getParams()), p.isMany());
                }
                return p;
            }

            @Nullable
            static Suffix find(@NotNull String s) {
                if (s == null) {
                    Suffix.$$$reportNull$$$0(1);
                }
                for (Suffix suffix2 : Suffix.values()) {
                    if (!suffix2.at(s)) continue;
                    return suffix2;
                }
                return null;
            }

            static {
                COMMA = new SqlFunctionDefinition.SyntaxParameter(0, ",");
                COND = new SqlFunctionDefinition.SimpleParameter(0, "cond", (SqlFunctionDefinition.Type)INSTANCE.getBuiltInTypes().get("B"), false);
                STATE = new SqlFunctionDefinition.SimpleParameter(0, "state", Types.AGGREGATE_FUNCTION, false);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/sql/dialects/clickhouse/CHouseDialect$SuffixedBuiltinFunctions$Suffix";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "s";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "makeArrayParams";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/sql/dialects/clickhouse/CHouseDialect$SuffixedBuiltinFunctions$Suffix";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "find";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }
    }

    static class Types {
        static final SqlFunctionDefinition.Type ANY_NA = new SqlFunctionDefinition.Type("ANY_NA", DataTypeFactory.of((String)"any"));
        static final SqlFunctionDefinition.Type STRING_OR_TOKEN = new SqlFunctionDefinition.Type("StringOrToken", DataTypeFactory.of((String)"String"));
        static final SqlFunctionDefinition.Type STRING_OR_SCHEMA = new SqlFunctionDefinition.Type("StringOrSchema", DataTypeFactory.of((String)"String"));
        static final SqlFunctionDefinition.Type ARRAY = new SqlFunctionDefinition.Type("Array", DataTypeFactory.of((String)"Array"));
        static final SqlFunctionDefinition.Type AGGREGATE_FUNCTION = new SqlFunctionDefinition.Type("AggregateFunction", DataTypeFactory.of((String)"AggregateFunction"));

        Types() {
        }
    }

    static class LazyData {
        static final TokenClasses ourClasses = new TokenClasses(CHouseTokens.class);
        static final SqlLanguageDialectEx.BuiltinFunctions ourFunctionMap = new SuffixedBuiltinFunctions();
        static final Set<String> ourSystemVars;
        static final NullableFunction<String, IElementType> ourReservedTokens;
        static Set<String> ourKeywords;
        static Set<String> ourReservedKeywords;
        static final TokenSet ourClosingTokens;
        static final Set<IElementType> ourSupportedOperators;
        static final List<ReservedEntity> ourObjects;
        static final List<ReservedEntity.Typed> RE_COLUMNS;
        static final TokenSet SPECIAL_FUNCTION_REFERENCES;

        LazyData() {
        }

        static {
            SqlLexer.initTokens(ourFunctionMap, ourClasses);
            ourSystemVars = Collections.unmodifiableSet(SqlDialectImplUtil.loadSystemVars((SqlLanguageDialect)INSTANCE));
            ourReservedTokens = SqlTokenRegistry.getTokenProvider((Class)LazyData.ourClasses.reserved);
            ourKeywords = SqlTokenRegistry.getTokens((Class)LazyData.ourClasses.all);
            ourReservedKeywords = SqlTokenRegistry.getTokens((Class)LazyData.ourClasses.reserved);
            ourClosingTokens = TokenSet.orSet((TokenSet[])new TokenSet[]{SqlCommonTokens.STATEMENT_SEPARATORS, TokenSet.create((IElementType[])new IElementType[]{CHouseTypes.CH_DELIMITER_TOKEN})});
            ourSupportedOperators = Set.of(SqlElementTypes.SQL_OP_PLUS, SqlElementTypes.SQL_OP_MINUS, SqlElementTypes.SQL_OP_MUL, SqlElementTypes.SQL_OP_DIV, SqlElementTypes.SQL_OP_NEQ, SqlElementTypes.SQL_OP_LE, SqlElementTypes.SQL_OP_LT, SqlElementTypes.SQL_OP_GE, SqlElementTypes.SQL_OP_EQ, SqlElementTypes.SQL_OP_GT, SqlElementTypes.SQL_AND, SqlElementTypes.SQL_NOT, SqlElementTypes.SQL_OR, SqlElementTypes.SQL_IS, SqlElementTypes.SQL_LIKE, SqlElementTypes.SQL_COLLATE, SqlElementTypes.SQL_IN, SqlElementTypes.SQL_OP_LOGICAL_AND, SqlElementTypes.SQL_OP_BITWISE_AND, SqlElementTypes.SQL_OP_INVERT, SqlElementTypes.SQL_OP_BITWISE_OR, SqlElementTypes.SQL_OP_LOGICAL_OR, SqlElementTypes.SQL_OP_BITWISE_XOR, SqlElementTypes.SQL_OP_NULLSAFE_EQ, SqlElementTypes.SQL_OP_LEFT_SHIFT, SqlElementTypes.SQL_OP_RIGHT_SHIFT, SqlElementTypes.SQL_OP_MODULO, SqlElementTypes.SQL_OP_NEQ2, SqlElementTypes.SQL_OP_NOT2, SqlElementTypes.SQL_OP_ASSIGN, CHouseOptionalKeywords.CH_SOUNDS);
            ourObjects = SqlDialectImplUtil.loadObjects((SqlLanguageDialect)INSTANCE, (String)"fallback.txt");
            RE_COLUMNS = Arrays.asList(new ReservedEntity.Typed(Dbms.CLICKHOUSE, "_part", ObjectKind.COLUMN, CHouseTypeSystem.INSTANCE.stringType()), new ReservedEntity.Typed(Dbms.CLICKHOUSE, "_part_index", ObjectKind.COLUMN, CHouseTypeSystem.INSTANCE.integerType()), new ReservedEntity.Typed(Dbms.CLICKHOUSE, "_sample_factor", ObjectKind.COLUMN, CHouseTypeSystem.INSTANCE.realType()), new ReservedEntity.Typed(Dbms.CLICKHOUSE, "_table", ObjectKind.COLUMN, CHouseTypeSystem.INSTANCE.stringType()));
            SPECIAL_FUNCTION_REFERENCES = TokenSet.create((IElementType[])new IElementType[]{CHouseElementTypes.Extra.CH_TABLE_ENGINE_REFERENCE, CHouseElementTypes.Extra.CH_DATABASE_ENGINE_REFERENCE, CHouseElementTypes.Extra.CH_CODEC_REFERENCE, CHouseElementTypes.Extra.CH_INDEX_TYPE_REFERENCE});
        }
    }
}

