/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.cassandra;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.SqlTypeSystem;
import com.intellij.sql.dialects.cassandra.CassDialect;
import com.intellij.sql.psi.SqlType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CassTypeSystem
extends SqlTypeSystem {
    public static final CassTypeSystem INSTANCE = new CassTypeSystem();

    private CassTypeSystem() {
        super((SqlLanguageDialectEx)CassDialect.INSTANCE);
    }

    @Nullable
    public String getDefaultTypeName(@NotNull SqlType.Category cat) {
        if (cat == null) {
            CassTypeSystem.$$$reportNull$$$0(0);
        }
        switch (cat) {
            case INTEGER: {
                return "int";
            }
            case REAL: {
                return "double";
            }
            case STRING: {
                return "text";
            }
            case DATE_TIME: 
            case DATE: {
                return "date";
            }
            case INTERVAL: {
                return "duration";
            }
            case ARRAY: {
                return "list";
            }
            case MAP: {
                return "map";
            }
            case SETOF: {
                return "set";
            }
        }
        return super.getDefaultTypeName(cat);
    }

    @NotNull
    public SqlType.Category getTypeCategoryByName(@NotNull String typeName) {
        String fixed;
        if (typeName == null) {
            CassTypeSystem.$$$reportNull$$$0(1);
        }
        if ((fixed = StringUtil.toUpperCase((String)typeName)).startsWith("SET<")) {
            SqlType.Category category = SqlType.Category.SETOF;
            if (category == null) {
                CassTypeSystem.$$$reportNull$$$0(2);
            }
            return category;
        }
        if (fixed.startsWith("MAP<")) {
            SqlType.Category category = SqlType.Category.MAP;
            if (category == null) {
                CassTypeSystem.$$$reportNull$$$0(3);
            }
            return category;
        }
        if (fixed.startsWith("LIST<")) {
            SqlType.Category category = SqlType.Category.ARRAY;
            if (category == null) {
                CassTypeSystem.$$$reportNull$$$0(4);
            }
            return category;
        }
        if (fixed.startsWith("TUPLE<")) {
            SqlType.Category category = SqlType.Category.RECORD;
            if (category == null) {
                CassTypeSystem.$$$reportNull$$$0(5);
            }
            return category;
        }
        if (fixed.startsWith("FROZEN<")) {
            SqlType.Category category = SqlType.Category.TYPE_MODIFIER;
            if (category == null) {
                CassTypeSystem.$$$reportNull$$$0(6);
            }
            return category;
        }
        if (fixed.contains("TIMEUUID")) {
            SqlType.Category category = SqlType.Category.TIMESTAMP;
            if (category == null) {
                CassTypeSystem.$$$reportNull$$$0(7);
            }
            return category;
        }
        if (fixed.contains("DURATION")) {
            SqlType.Category category = SqlType.Category.INTERVAL;
            if (category == null) {
                CassTypeSystem.$$$reportNull$$$0(8);
            }
            return category;
        }
        if (fixed.contains("BLOB")) {
            SqlType.Category category = SqlType.Category.BYTES;
            if (category == null) {
                CassTypeSystem.$$$reportNull$$$0(9);
            }
            return category;
        }
        SqlType.Category category = super.getTypeCategoryByName(typeName);
        if (category == null) {
            CassTypeSystem.$$$reportNull$$$0(10);
        }
        return category;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cat";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/cassandra/CassTypeSystem";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/cassandra/CassTypeSystem";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeCategoryByName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultTypeName";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getTypeCategoryByName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

