/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.vertica.model;

import com.intellij.database.dialects.vertica.model.VertForeignKey;
import com.intellij.database.dialects.vertica.model.VertSchema;
import com.intellij.database.dialects.vertica.model.VertTable;
import com.intellij.database.model.basic.BasicModForeignKey;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.basic.BasicTableOrView;
import com.intellij.database.model.families.NamingIdentifyingFamily;
import org.jetbrains.annotations.Nullable;

public interface VertMixinForeignKey
extends BasicModForeignKey {
    @Nullable
    default public BasicTableOrView getRefTable() {
        VertTable table = this.getTableById();
        return table == null ? super.getRefTable() : table;
    }

    @Nullable
    default public BasicSchema getRefSchema() {
        VertTable table = this.getTableById();
        return table == null ? super.getRefSchema() : table.getSchema();
    }

    @Nullable
    default public VertTable getTableById() {
        VertForeignKey fk = (VertForeignKey)this;
        long id = fk.getRefTableId();
        if (id == Long.MIN_VALUE) {
            return null;
        }
        VertSchema schema = fk.getSchema();
        if (schema == null) {
            return null;
        }
        VertTable table = (VertTable)schema.getTables().getByObjectId(id);
        if (table != null) {
            return table;
        }
        NamingIdentifyingFamily<? extends VertSchema> f = schema.getParentFamily();
        if (f == null) {
            return null;
        }
        for (VertSchema s : f) {
            if (s == schema || (table = (VertTable)schema.getTables().getByObjectId(id)) == null) continue;
            return table;
        }
        return null;
    }
}

