/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.sybase.plan;

import com.intellij.database.dialects.base.plan.AbstractXmlPlanModelBuilder;
import com.intellij.database.dialects.sybase.plan.AseRawPlanData;
import com.intellij.database.plan.PlanModel;
import com.intellij.database.plan.PlanRetrievalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.text.CharSequenceReader;
import com.intellij.util.text.CharSequenceSubSequence;
import java.io.IOException;
import java.io.Reader;
import java.math.BigDecimal;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpression;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class AsePlanModelBuilder
extends AbstractXmlPlanModelBuilder<AseRawPlanData, Element> {
    private static final Map<String, PlanModel.NodeType> TYPE_MAPPING = new HashMap<String, PlanModel.NodeType>();
    private static final Map<String, PlanModel.NodeType> STATEMENT_MAPPING = new HashMap<String, PlanModel.NodeType>();
    private final XPathExpression INDID_QUERY = this.compileXPath("Details/Indid");
    private final XPathExpression PLAN_ROWS_QUERY = this.compileXPath("est/rowCnt");
    private final XPathExpression ACT_ROWS_QUERY = this.compileXPath("act/rowCnt");
    private final XPathExpression DETAILS_QUERY = this.compileXPath("Details");
    private final XPathExpression OBJ_NAME_QUERY = this.compileXPath("objName");
    private final XPathExpression IND_NAME_QUERY = this.compileXPath("indName");
    private final XPathExpression ACT_EMIT_QUERY = this.compileXPath("/query/opTree/Emit");
    private final Set<String> NONE_OP = Set.of("Details", "VA");
    private final Set<String> HANDLED_KEYS = Set.of("rowCnt", "objName", "indName", "Vtuple", "Collection");
    private final Pattern RELATION_PATTERN = Pattern.compile(".*:(.*)");
    private final Pattern INDEX_PATTERN = Pattern.compile(".*\\((.*)\\)");

    public AsePlanModelBuilder() {
        super(EnumSet.of(PlanModel.Feature.TOTAL_COST, PlanModel.Feature.STARTUP_COST));
    }

    @Override
    @NotNull
    public AseRawPlanData createData() {
        return new AseRawPlanData();
    }

    @Override
    protected void parseData() {
        this.parseXml(((AseRawPlanData)this.myData).xml);
    }

    private void parseXml(@NotNull String xml) {
        if (xml == null) {
            AsePlanModelBuilder.$$$reportNull$$$0(0);
        }
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = dbf.newDocumentBuilder();
            this.openNode(null);
            int from = 0;
            while (from < xml.length()) {
                int end = xml.indexOf("<?xml", from + 1);
                if (end == -1) {
                    end = xml.length();
                }
                Document doc = builder.parse(new InputSource((Reader)new CharSequenceReader((CharSequence)new CharSequenceSubSequence((CharSequence)xml, from, end))));
                this.parseStatement(doc.getDocumentElement());
                from = end;
            }
            this.closeNode(new PlanModel.GenericNode(PlanModel.NodeType.ROOT, null));
        }
        catch (ParserConfigurationException e2) {
            throw new PlanRetrievalException("Failed to configure XML parser", (Throwable)e2);
        }
        catch (SAXException e3) {
            throw new PlanRetrievalException("Failed to parse XML", (Throwable)e3);
        }
        catch (IOException e4) {
            throw new PlanRetrievalException("Failed to parse XML", (Throwable)e4);
        }
    }

    @Override
    @NotNull
    protected String parseRawDescription(final @NotNull Element element) {
        if (element == null) {
            AsePlanModelBuilder.$$$reportNull$$$0(1);
        }
        String string = new Object(){
            final StringBuilder sb = new StringBuilder();
            {
                Element details;
                Element element2 = details = AsePlanModelBuilder.this.myActual ? element : AsePlanModelBuilder.queryElement(AsePlanModelBuilder.this.DETAILS_QUERY, element);
                if (details != null) {
                    this.visit("", details);
                }
            }

            void visit(String prefix, Element el) {
                if (!prefix.isEmpty()) {
                    StringBuilder sub = new StringBuilder();
                    for (int i2 = 0; i2 < el.getChildNodes().getLength(); ++i2) {
                        String s;
                        Text child = (Text)ObjectUtils.tryCast((Object)el.getChildNodes().item(i2), Text.class);
                        if (child == null || child.getNodeValue() == null || StringUtil.isEmpty((String)(s = child.getNodeValue().trim()))) continue;
                        sub.append(s);
                    }
                    if (sub.length() != 0) {
                        this.sb.append(prefix).append(" = ").append((CharSequence)sub).append(";\n");
                    }
                }
                for (int i3 = 0; i3 < el.getChildNodes().getLength(); ++i3) {
                    String name2;
                    Element child = (Element)ObjectUtils.tryCast((Object)el.getChildNodes().item(i3), Element.class);
                    String string = name2 = child == null ? null : child.getTagName();
                    if (name2 == null || AsePlanModelBuilder.this.myActual && AsePlanModelBuilder.this.isSubPlan(child) || AsePlanModelBuilder.this.HANDLED_KEYS.contains(name2)) continue;
                    this.visit(prefix + (prefix.isEmpty() ? "" : ".") + name2, child);
                }
            }
        }.sb.toString();
        if (string == null) {
            AsePlanModelBuilder.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @Nullable
    protected String parseAccessRelation(@NotNull Element element) {
        Matcher matcher;
        if (element == null) {
            AsePlanModelBuilder.$$$reportNull$$$0(3);
        }
        if (this.myActual) {
            Element name2 = this.querySingleElement(this.OBJ_NAME_QUERY, element);
            return name2 == null ? null : name2.getTextContent();
        }
        String relation = element.getAttribute("Label");
        if (relation != null && (matcher = this.RELATION_PATTERN.matcher(relation)).matches()) {
            return matcher.group(1);
        }
        return relation;
    }

    @Override
    @Nullable
    protected BigDecimal parsePlanNumRows(@NotNull Element element) {
        Element rn;
        if (element == null) {
            AsePlanModelBuilder.$$$reportNull$$$0(4);
        }
        return (rn = this.querySingleElement(this.PLAN_ROWS_QUERY, element)) == null ? null : new BigDecimal(rn.getTextContent());
    }

    @Override
    @Nullable
    protected BigDecimal parseActualNumRows(@NotNull Element element) {
        Element rn;
        if (element == null) {
            AsePlanModelBuilder.$$$reportNull$$$0(5);
        }
        return (rn = this.querySingleElement(this.ACT_ROWS_QUERY, element)) == null ? null : new BigDecimal(rn.getTextContent());
    }

    @Override
    @Nullable
    protected String parseAccessIndex(@NotNull Element element) {
        Matcher m;
        if (element == null) {
            AsePlanModelBuilder.$$$reportNull$$$0(6);
        }
        if (this.myActual) {
            Element name2 = this.querySingleElement(this.IND_NAME_QUERY, element);
            return name2 == null ? null : name2.getTextContent();
        }
        Element indid = AsePlanModelBuilder.queryElement(this.INDID_QUERY, element);
        if (indid != null && (m = this.INDEX_PATTERN.matcher(indid.getTextContent())).matches()) {
            return m.group(1);
        }
        return indid == null ? null : indid.getTextContent();
    }

    @Override
    protected void parsePlan(@NotNull Element state2) {
        if (state2 == null) {
            AsePlanModelBuilder.$$$reportNull$$$0(7);
        }
        this.openNode(null);
        this.parseSubPlans(state2);
        String name2 = state2.getTagName();
        PlanModel.NodeType type = TYPE_MAPPING.get(name2);
        if (type == null) {
            type = PlanModel.NodeType.UNKNOWN;
        }
        if (type == PlanModel.NodeType.ACCESS) {
            Element indid = AsePlanModelBuilder.queryElement(this.INDID_QUERY, state2);
            type = indid != null && !indid.getTextContent().equals("0") ? PlanModel.NodeType.INDEX_SCAN : PlanModel.NodeType.SEQ_SCAN;
        }
        PlanModel.GenericNode node = this.createNode(state2, type, name2);
        this.closeNode(node);
    }

    @Override
    protected void parseSubPlans(@NotNull Element element) {
        if (element == null) {
            AsePlanModelBuilder.$$$reportNull$$$0(8);
        }
        for (Element sub : this.getSubPlans(element)) {
            this.parsePlan(sub);
        }
    }

    protected JBIterable<Element> getSubPlans(@NotNull Element element) {
        if (element == null) {
            AsePlanModelBuilder.$$$reportNull$$$0(9);
        }
        return JBIterable.generate((Object)element.getFirstChild(), Node::getNextSibling).filter(Element.class).filter(e2 -> this.isSubPlan((Element)e2));
    }

    private boolean isSubPlan(Element e2) {
        return Character.isUpperCase(e2.getTagName().charAt(0)) && !this.NONE_OP.contains(e2.getTagName());
    }

    @Override
    protected void parseStatement(@NotNull Element element) {
        PlanModel.NodeType type;
        Element startOp;
        Element emit;
        if (element == null) {
            AsePlanModelBuilder.$$$reportNull$$$0(10);
        }
        this.openNode(null);
        this.myActual = "query".equals(element.getTagName());
        if (!this.myActual && !"Emit".equals(element.getTagName())) {
            this.unsupportedFormat();
        }
        Element element2 = emit = this.myActual ? this.querySingleElement(this.ACT_EMIT_QUERY, element) : element;
        if (emit == null) {
            this.unsupportedFormat();
        }
        if ((startOp = (Element)this.getSubPlans(emit).single()) == null) {
            this.unsupportedFormat();
        }
        if ((type = STATEMENT_MAPPING.get(startOp.getTagName())) != null) {
            if ((startOp = (Element)this.getSubPlans(startOp).single()) == null) {
                this.unsupportedFormat();
            }
        } else {
            type = PlanModel.NodeType.SELECT;
        }
        this.parsePlan(startOp);
        this.closeNode(this.createNode(emit, type, null));
    }

    @Override
    @Nullable
    protected Double parseTotalCost(@NotNull Element element) {
        if (element == null) {
            AsePlanModelBuilder.$$$reportNull$$$0(11);
        }
        return null;
    }

    @Override
    @Nullable
    protected Double parseStartupCost(@NotNull Element element) {
        if (element == null) {
            AsePlanModelBuilder.$$$reportNull$$$0(12);
        }
        return null;
    }

    @Override
    protected boolean parseSubqueryCorrelated(@NotNull Element element) {
        if (element == null) {
            AsePlanModelBuilder.$$$reportNull$$$0(13);
        }
        return false;
    }

    @Override
    protected boolean parseSubqueryScalar(@NotNull Element element) {
        if (element == null) {
            AsePlanModelBuilder.$$$reportNull$$$0(14);
        }
        return false;
    }

    static {
        TYPE_MAPPING.put("Scan", PlanModel.NodeType.ACCESS);
        TYPE_MAPPING.put("TableScan", PlanModel.NodeType.ACCESS);
        TYPE_MAPPING.put("IndexScan", PlanModel.NodeType.INDEX_SCAN);
        TYPE_MAPPING.put("Scalar", PlanModel.NodeType.VALUE);
        TYPE_MAPPING.put("HashUnion", PlanModel.NodeType.UNION);
        TYPE_MAPPING.put("MergeJoin", PlanModel.NodeType.MERGE_JOIN);
        TYPE_MAPPING.put("NLJOp", PlanModel.NodeType.NESTED_LOOPS);
        TYPE_MAPPING.put("NestLoopJoin", PlanModel.NodeType.NESTED_LOOPS);
        TYPE_MAPPING.put("NaryNLJoin", PlanModel.NodeType.NESTED_LOOPS);
        TYPE_MAPPING.put("HashJoin", PlanModel.NodeType.HASH_JOIN);
        TYPE_MAPPING.put("GroupSorted", PlanModel.NodeType.GROUP_BY);
        TYPE_MAPPING.put("Sort", PlanModel.NodeType.SORT);
        TYPE_MAPPING.put("HashDistinct", PlanModel.NodeType.HASH_UNIQUE);
        TYPE_MAPPING.put("HashVectAgg", PlanModel.NodeType.AGGREGATE);
        TYPE_MAPPING.put("UnionAll", PlanModel.NodeType.UNION_ALL);
        TYPE_MAPPING.put("MergeUnion", PlanModel.NodeType.UNION);
        TYPE_MAPPING.put("ScalarAgg", PlanModel.NodeType.AGGREGATE);
        TYPE_MAPPING.put("Restrict", PlanModel.NodeType.UNKNOWN);
        TYPE_MAPPING.put("Store", PlanModel.NodeType.TEMPORARY);
        TYPE_MAPPING.put("WorkTable", PlanModel.NodeType.TEMPORARY);
        TYPE_MAPPING.put("Sequencer", PlanModel.NodeType.SEQUENTIALLY);
        TYPE_MAPPING.put("RemoteScan", PlanModel.NodeType.ACCESS);
        TYPE_MAPPING.put("Scroll", PlanModel.NodeType.UNKNOWN);
        TYPE_MAPPING.put("RidJoin", PlanModel.NodeType.JOIN);
        TYPE_MAPPING.put("FilterOp", PlanModel.NodeType.FILTER);
        TYPE_MAPPING.put("SQFilter", PlanModel.NodeType.FILTER);
        TYPE_MAPPING.put("Exchange", PlanModel.NodeType.OPERATION);
        TYPE_MAPPING.put("InsteadOf", PlanModel.NodeType.OPERATION);
        TYPE_MAPPING.put("InsteadOfTrigger", PlanModel.NodeType.OPERATION);
        TYPE_MAPPING.put("CursorScan", PlanModel.NodeType.ACCESS);
        STATEMENT_MAPPING.put("Insert", PlanModel.NodeType.INSERT);
        STATEMENT_MAPPING.put("Update", PlanModel.NodeType.UPDATE);
        STATEMENT_MAPPING.put("Delete", PlanModel.NodeType.DELETE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xml";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/sybase/plan/AsePlanModelBuilder";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/sybase/plan/AsePlanModelBuilder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "parseRawDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parseXml";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "parseRawDescription";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "parseAccessRelation";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "parsePlanNumRows";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "parseActualNumRows";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "parseAccessIndex";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "parsePlan";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "parseSubPlans";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getSubPlans";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "parseStatement";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "parseTotalCost";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "parseStartupCost";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "parseSubqueryCorrelated";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "parseSubqueryScalar";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

