/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.spark.generator;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.base.generator.ScriptingContext;
import com.intellij.database.dialects.base.generator.producers.CreateProducer;
import com.intellij.database.dialects.base.generator.producers.DropProducer;
import com.intellij.database.dialects.hivebase.generator.HiveBaseScriptGeneratorHelper;
import com.intellij.database.dialects.spark.generator.producers.SparkCreateFunction;
import com.intellij.database.dialects.spark.generator.producers.SparkDropFunction;
import com.intellij.database.dialects.spark.model.SparkFunction;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u001c\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lcom/intellij/database/dialects/spark/generator/SparkScriptGeneratorHelper;", "Lcom/intellij/database/dialects/hivebase/generator/HiveBaseScriptGeneratorHelper;", "()V", "supportsCreateIfNotExists", "", "Lcom/intellij/database/model/ObjectKind;", "getSupportsCreateIfNotExists", "()Ljava/util/Set;", "createDropProducer", "Lcom/intellij/database/dialects/base/generator/producers/DropProducer;", "context", "Lcom/intellij/database/dialects/base/generator/ScriptingContext;", "element", "Lcom/intellij/database/model/basic/BasicElement;", "createProducer", "Lcom/intellij/database/dialects/base/generator/producers/CreateProducer;", "intellij.database.dialects.spark"})
public final class SparkScriptGeneratorHelper
extends HiveBaseScriptGeneratorHelper {
    public static final SparkScriptGeneratorHelper INSTANCE;

    @Override
    @NotNull
    protected Set<ObjectKind> getSupportsCreateIfNotExists() {
        return SetsKt.setOf((Object[])new ObjectKind[]{ObjectKind.SCHEMA, ObjectKind.TABLE, ObjectKind.VIEW, ObjectKind.ROUTINE});
    }

    @Override
    @NotNull
    public CreateProducer<?> createProducer(@NotNull ScriptingContext context, @NotNull BasicElement element) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        BasicElement basicElement = element;
        return basicElement instanceof SparkFunction ? (CreateProducer)new SparkCreateFunction(context, (SparkFunction)element) : super.createProducer(context, element);
    }

    @Override
    @NotNull
    public DropProducer<?> createDropProducer(@NotNull ScriptingContext context, @NotNull BasicElement element) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        BasicElement basicElement = element;
        return basicElement instanceof SparkFunction ? (DropProducer)new SparkDropFunction(context, (SparkFunction)element) : super.createDropProducer(context, element);
    }

    private SparkScriptGeneratorHelper() {
        Dbms dbms = Dbms.SPARK;
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"Dbms.SPARK");
        super(dbms);
    }

    static {
        SparkScriptGeneratorHelper sparkScriptGeneratorHelper;
        INSTANCE = sparkScriptGeneratorHelper = new SparkScriptGeneratorHelper();
    }
}

