/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.snowflake;

import com.intellij.database.data.types.ConversionPoint;
import com.intellij.database.data.types.DomainRegistry;
import com.intellij.database.data.types.domain.BinaryDomain;
import com.intellij.database.data.types.domain.BooleanDomain;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.data.types.domain.FloatDomain;
import com.intellij.database.data.types.domain.FractionDomain;
import com.intellij.database.data.types.domain.Number2Domain;
import com.intellij.database.data.types.domain.OperationSupport;
import com.intellij.database.data.types.domain.PhysicalDomainType;
import com.intellij.database.data.types.domain.SimpleDomain;
import com.intellij.database.data.types.domain.TextDomain;

public class SFlakeDomains
extends DomainRegistry {
    private static final int MAX_PRECISION = 38;
    private static final int MAX_FRACTION = 9;
    private static final int MAX_VARCHAR = 0x1000000;
    private static final int MAX_BINARY = 0x800000;

    public SFlakeDomains() {
        this.add((Domain)new Number2Domain("NUMBER", ConversionPoint.BIG_DECIMAL, 38, 38, true));
        this.add((Domain)new FloatDomain("FLOAT", ConversionPoint.DOUBLE_PRECISION, Double.MIN_VALUE, Double.MAX_VALUE));
        this.add((Domain)new FloatDomain("DOUBLE", ConversionPoint.DOUBLE_PRECISION, Double.MIN_VALUE, Double.MAX_VALUE));
        this.add((Domain)new TextDomain("VARCHAR", ConversionPoint.VARCHAR, 0x1000000L, TextDomain.Length.optional((long)0x1000000L, (boolean)true)));
        this.add((Domain)new BinaryDomain("BINARY", ConversionPoint.BINARY, 0x800000L, TextDomain.Length.optional((long)1L, (boolean)false), OperationSupport.SUPPORTS_NOTHING));
        this.add((Domain)new BooleanDomain("BOOLEAN", ConversionPoint.BOOLEAN));
        this.add((Domain)new SimpleDomain("DATE", ConversionPoint.DATE, PhysicalDomainType.DATE, OperationSupport.SUPPORTS_LIKE));
        this.add((Domain)new FractionDomain("TIME", ConversionPoint.TIME, PhysicalDomainType.TIME, 9, 9, true, OperationSupport.SUPPORTS_LIKE));
        this.add((Domain)new FractionDomain("TIMESTAMPNTZ", ConversionPoint.TIMESTAMP, PhysicalDomainType.TIMESTAMP, 9, 9, true, OperationSupport.SUPPORTS_LIKE));
        this.add((Domain)new FractionDomain("TIMESTAMPLTZ", ConversionPoint.TIMESTAMP_WITH_TIMEZONE, PhysicalDomainType.TIMESTAMP, 9, 9, true, OperationSupport.SUPPORTS_LIKE));
        this.add((Domain)new FractionDomain("TIMESTAMPTZ", ConversionPoint.TIMESTAMP_WITH_TIMEZONE, PhysicalDomainType.TIMESTAMP, 9, 9, true, OperationSupport.SUPPORTS_LIKE));
        this.add((Domain)new SimpleDomain("VARIANT", ConversionPoint.JSON, PhysicalDomainType.UNKNOWN));
        this.add((Domain)new SimpleDomain("OBJECT", ConversionPoint.JSON, PhysicalDomainType.UNKNOWN, OperationSupport.SUPPORTS_NOTHING));
        this.add((Domain)new SimpleDomain("ARRAY", ConversionPoint.JSON, PhysicalDomainType.UNKNOWN, OperationSupport.SUPPORTS_NOTHING));
    }
}

