/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.redshift;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.DatabaseAuthProvider;
import com.intellij.database.dataSource.DatabaseConnectionInterceptor;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.DatabaseCredentialsAuthProvider;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.url.template.MutableParametersHolder;
import com.intellij.database.dataSource.url.template.ParametersHolder;
import com.intellij.database.dataSource.url.ui.UrlPropertiesPanel;
import com.intellij.database.dialects.redshift.AwsProfileAuthProvider;
import com.intellij.database.dialects.redshift.AwsProfileAuthProvider$sam$com_intellij_util_Function$0;
import com.intellij.database.dialects.redshift.AwsProfileAuthProvider$sam$java_util_function_Supplier$0;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.ui.TextFieldWithAutoCompletion;
import com.intellij.ui.TextFieldWithAutoCompletionListProvider;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.text.StringKt;
import java.awt.Component;
import java.awt.LayoutManager;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.streams.jdk8.StreamsKt;
import kotlin.text.Regex;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.serialization.PathMacroUtil;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 \u001c2\u00020\u0001:\u0002\u001b\u001cB\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0005H\u0002J\r\u0010\u0011\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0005H\u0016J \u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u00152\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00192\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/database/dialects/redshift/AwsProfileAuthProvider;", "Lcom/intellij/database/dataSource/DatabaseAuthProvider;", "()V", "cache", "", "", "Lcom/intellij/database/dialects/redshift/AwsProfileAuthProvider$AwsCredentials;", "createWidget", "Lcom/intellij/database/dataSource/DatabaseAuthProvider$AuthWidget;", "project", "Lcom/intellij/openapi/project/Project;", "credentials", "Lcom/intellij/database/access/DatabaseCredentials;", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "getCredentials", "path", "getDisplayName", "Lorg/jetbrains/annotations/Nls;", "getId", "intercept", "Ljava/util/concurrent/CompletionStage;", "Lcom/intellij/database/dataSource/DatabaseConnectionInterceptor$ProtoConnection;", "proto", "silent", "", "isApplicable", "AwsCredentials", "Companion", "intellij.database.dialects.redshift"})
public final class AwsProfileAuthProvider
implements DatabaseAuthProvider {
    private final Map<String, AwsCredentials> cache;
    @NotNull
    public static final String ID = "dg.aws.profile";
    @NotNull
    public static final String AWS_PROFILE = "Profile";
    @NotNull
    public static final String AWS_USER = "DbUser";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String getId() {
        return ID;
    }

    @NotNull
    public String getDisplayName() {
        String string = DatabaseBundle.message((String)"auth.provider.aws.profile.name", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"DatabaseBundle.message(\"\u2026ovider.aws.profile.name\")");
        return string;
    }

    @Nullable
    public DatabaseAuthProvider.AuthWidget createWidget(@Nullable Project project, @NotNull DatabaseCredentials credentials, @NotNull LocalDataSource dataSource) {
        Intrinsics.checkNotNullParameter((Object)credentials, (String)"credentials");
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        return (DatabaseAuthProvider.AuthWidget)new DatabaseCredentialsAuthProvider.UserWidget(this, project){
            @NotNull
            private final createWidget.Provider completion;
            @NotNull
            private final TextFieldWithAutoCompletion<String> profileEditor;
            final /* synthetic */ AwsProfileAuthProvider this$0;
            final /* synthetic */ Project $project;

            @NotNull
            public final createWidget.Provider getCompletion() {
                return this.completion;
            }

            @NotNull
            public final TextFieldWithAutoCompletion<String> getProfileEditor() {
                return this.profileEditor;
            }

            @NotNull
            protected JPanel createPanel() {
                JPanel panel2 = new JPanel((LayoutManager)new GridLayoutManager(2, 6));
                this.addUserField(panel2, 0);
                JBLabel profile = new JBLabel(DatabaseBundle.message((String)"auth.provider.aws.profile.profile", (Object[])new Object[0]));
                panel2.add((Component)profile, UrlPropertiesPanel.createLabelConstraints((int)1, (int)0, (double)profile.getPreferredSize().getWidth()));
                panel2.add((Component)this.profileEditor, UrlPropertiesPanel.createSimpleConstraints((int)1, (int)1, (int)3));
                return panel2;
            }

            public void onChanged(@NotNull Runnable r) {
                Intrinsics.checkNotNullParameter((Object)r, (String)"r");
                super.onChanged(r);
                this.profileEditor.getDocument().addDocumentListener(new DocumentListener(r){
                    final /* synthetic */ Runnable $r;

                    public void documentChanged(@NotNull DocumentEvent event) {
                        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                        this.$r.run();
                    }
                    {
                        this.$r = $captured_local_variable$0;
                    }
                });
                r.run();
            }

            public void save(@NotNull LocalDataSource dataSource, boolean copyCredentials) {
                Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
                this.getComponent();
                String string = this.getUserName();
                if (string == null) {
                    string = "";
                }
                dataSource.setUsername(string);
                DataSourceUiUtil.putOrRemove((Map)dataSource.getAdditionalJdbcProperties(), (Object)"Profile", (Object)StringKt.nullize$default((String)this.profileEditor.getText(), (boolean)false, (int)1, null));
            }

            public void reset(@NotNull LocalDataSource dataSource, boolean resetCredentials) {
                Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
                this.getComponent();
                this.completion.setCredentials(this.getCredentialsFile());
                this.setUser(dataSource.getUsername());
                String string = (String)dataSource.getAdditionalJdbcProperties().get("Profile");
                if (string == null) {
                    string = "";
                }
                this.profileEditor.setText(string);
            }

            public boolean isPasswordChanged() {
                return false;
            }

            public void hidePassword() {
            }

            public void reloadCredentials() {
            }

            public void forceSave() {
            }

            public void updateFromUrl(@NotNull ParametersHolder holder) {
                Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            }

            public void updateUrl(@NotNull MutableParametersHolder model) {
                Intrinsics.checkNotNullParameter((Object)model, (String)"model");
                model.setParameter("iam", "iam:");
            }

            private final String getCredentialsFile() {
                return SystemInfo.isWindows ? Intrinsics.stringPlus((String)EnvironmentUtil.getValue((String)"USERPROFILE"), (Object)"\\.aws\\credentials") : PathMacroUtil.getUserHomePath() + "/.aws/credentials";
            }
            {
                this.this$0 = this$0;
                this.$project = $captured_local_variable$1;
                this.completion = new createWidget.Provider(this);
                this.profileEditor = new TextFieldWithAutoCompletion($captured_local_variable$1, (TextFieldWithAutoCompletionListProvider)this.completion, true, null);
            }
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isApplicable(@NotNull LocalDataSource dataSource) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        if (Intrinsics.areEqual((Object)dataSource.getDbms(), (Object)Dbms.REDSHIFT)) return true;
        String string = dataSource.getDriverClass();
        if (string == null) return false;
        String string2 = string;
        boolean bl = false;
        boolean bl2 = false;
        String it = string2;
        boolean bl3 = false;
        boolean bl4 = StringUtil.containsIgnoreCase((String)it, (String)"simba.athena.");
        if (!bl4) return false;
        return true;
    }

    @Nullable
    public CompletionStage<DatabaseConnectionInterceptor.ProtoConnection> intercept(@NotNull DatabaseConnectionInterceptor.ProtoConnection proto2, boolean silent) {
        Intrinsics.checkNotNullParameter((Object)proto2, (String)"proto");
        Map map2 = proto2.getConnectionProperties();
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"proto.connectionProperties");
        DatabaseConnectionPoint databaseConnectionPoint = proto2.getConnectionPoint();
        Intrinsics.checkNotNullExpressionValue((Object)databaseConnectionPoint, (String)"proto.connectionPoint");
        map2.put(AWS_PROFILE, databaseConnectionPoint.getAdditionalJdbcProperties().get(AWS_PROFILE));
        Map map3 = proto2.getConnectionProperties();
        Intrinsics.checkNotNullExpressionValue((Object)map3, (String)"proto.connectionProperties");
        DatabaseConnectionPoint databaseConnectionPoint2 = proto2.getConnectionPoint();
        Intrinsics.checkNotNullExpressionValue((Object)databaseConnectionPoint2, (String)"proto.connectionPoint");
        LocalDataSource localDataSource = databaseConnectionPoint2.getDataSource();
        Intrinsics.checkNotNullExpressionValue((Object)localDataSource, (String)"proto.connectionPoint.dataSource");
        map3.put(AWS_USER, localDataSource.getUsername());
        return CompletableFuture.completedFuture(proto2);
    }

    private final AwsCredentials getCredentials(String path) {
        File file;
        File file2 = file = new File(path).getAbsoluteFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"file");
        String canonical = file2.getCanonicalPath();
        AwsCredentials profile = this.cache.get(canonical);
        long stamp = file.exists() ? file.lastModified() : -1L;
        AwsCredentials awsCredentials = profile;
        if (awsCredentials == null || awsCredentials.getStamp() != stamp) {
            this.cache.remove(canonical);
            profile = this.cache.get(canonical);
        }
        AwsCredentials awsCredentials2 = profile;
        Intrinsics.checkNotNull((Object)awsCredentials2);
        return awsCredentials2;
    }

    public AwsProfileAuthProvider() {
        Function1 function1 = (Function1)new Function1<String, AwsCredentials>(Companion){

            @NotNull
            public final AwsCredentials invoke(@NotNull String p1) {
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                return com.intellij.database.dialects.redshift.AwsProfileAuthProvider$Companion.access$parse((Companion)this.receiver, p1);
            }
        };
        Function function = new AwsProfileAuthProvider$sam$com_intellij_util_Function$0(function1);
        Object object = cache.2.INSTANCE;
        if (object != null) {
            function1 = object;
            object = new AwsProfileAuthProvider$sam$java_util_function_Supplier$0((Function0)function1);
        }
        ConcurrentMap concurrentMap = ConcurrentFactoryMap.create((Function)function, (Supplier)((Supplier)object));
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"ConcurrentFactoryMap.cre\u2026oncurrentSoftValueMap\n  )");
        this.cache = concurrentMap;
    }

    public static final /* synthetic */ AwsCredentials access$getCredentials(AwsProfileAuthProvider $this, String path) {
        return $this.getCredentials(path);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010 \n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B'\u0012\n\b\u0001\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\u0002\u0010\bR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/intellij/database/dialects/redshift/AwsProfileAuthProvider$AwsCredentials;", "", "error", "", "stamp", "", "profiles", "", "(Ljava/lang/String;JLjava/util/List;)V", "getError", "()Ljava/lang/String;", "getProfiles", "()Ljava/util/List;", "getStamp", "()J", "intellij.database.dialects.redshift"})
    private static final class AwsCredentials {
        @Nullable
        private final String error;
        private final long stamp;
        @NotNull
        private final List<String> profiles;

        @Nullable
        public final String getError() {
            return this.error;
        }

        public final long getStamp() {
            return this.stamp;
        }

        @NotNull
        public final List<String> getProfiles() {
            return this.profiles;
        }

        public AwsCredentials(@Nls @Nullable String error, long stamp, @NotNull List<String> profiles) {
            Intrinsics.checkNotNullParameter(profiles, (String)"profiles");
            this.error = error;
            this.stamp = stamp;
            this.profiles = profiles;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/database/dialects/redshift/AwsProfileAuthProvider$Companion;", "", "()V", "AWS_PROFILE", "", "AWS_USER", "ID", "parse", "Lcom/intellij/database/dialects/redshift/AwsProfileAuthProvider$AwsCredentials;", "path", "intellij.database.dialects.redshift"})
    public static final class Companion {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final AwsCredentials parse(String path) {
            File file = new File(path);
            if (!file.exists()) {
                return new AwsCredentials(DatabaseBundle.message((String)"path.does.not.exists", (Object[])new Object[]{path}), -1L, CollectionsKt.emptyList());
            }
            long stamp = file.lastModified();
            try {
                Closeable closeable = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), CharsetToolkit.UTF8_CHARSET));
                boolean bl = false;
                boolean bl2 = false;
                Throwable throwable = null;
                try {
                    BufferedReader reader = (BufferedReader)closeable;
                    boolean bl3 = false;
                    Regex pattern = new Regex("\\[(.*)]\\s*");
                    Stream<String> stream = reader.lines();
                    Intrinsics.checkNotNullExpressionValue(stream, (String)"reader.lines()");
                    List names2 = SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)StreamsKt.asSequence(stream), (Function1)((Function1)new Function1<String, String>(pattern){
                        final /* synthetic */ Regex $pattern;

                        @Nullable
                        public final String invoke(String line) {
                            String string = line;
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"line");
                            Object object = this.$pattern.matchEntire((CharSequence)string);
                            return object != null && (object = object.getGroupValues()) != null ? (String)object.get(1) : null;
                        }
                        {
                            this.$pattern = regex;
                            super(1);
                        }
                    })));
                    AwsCredentials awsCredentials = new AwsCredentials(null, stamp, names2);
                    return awsCredentials;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            catch (Throwable th) {
                return new AwsCredentials(th.getMessage(), stamp, CollectionsKt.emptyList());
            }
        }

        private Companion() {
        }

        public static final /* synthetic */ AwsCredentials access$parse(Companion $this, String path) {
            return $this.parse(path);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

