/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.postgresgreenplumbase.model.properties;

import com.intellij.database.dialects.postgresbase.model.properties.PgBasePropertyConverter;
import com.intellij.database.dialects.postgresgreenplumbase.model.properties.PgAccessMethodType;
import com.intellij.database.dialects.postgresgreenplumbase.model.properties.PgAggregateKind;
import com.intellij.database.dialects.postgresgreenplumbase.model.properties.PgAmOp;
import com.intellij.database.dialects.postgresgreenplumbase.model.properties.PgAmProc;
import com.intellij.database.dialects.postgresgreenplumbase.model.properties.PgFireMode;
import com.intellij.database.dialects.postgresgreenplumbase.model.properties.PgRelation;
import com.intellij.database.model.meta.BasicMetaType;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public interface PgGPlumBasePropertyConverter
extends PgBasePropertyConverter {
    public static final BasicMetaType<PgAccessMethodType> T_PG_ACCESS_METHOD_TYPE = new BasicMetaType(PgAccessMethodType.class, PgGPlumBasePropertyConverter::importPgAccessMethodType, PropertyConverter::export);
    public static final BasicMetaType<PgFireMode> T_PG_FIRE_MODE = new BasicMetaType(PgFireMode.class, PgGPlumBasePropertyConverter::importPgFireMode, PropertyConverter::export);
    public static final BasicMetaType<PgAggregateKind> T_PG_AGGREGATE_KIND = new BasicMetaType(PgAggregateKind.class, PgGPlumBasePropertyConverter::importPgAggregateKind, PropertyConverter::export);
    public static final BasicMetaType<Set<PgRelation>> T_SET_OF_PG_RELATION = new BasicMetaType.CollectionMetaType(Set.class, PgRelation.class, PgGPlumBasePropertyConverter::importSetOfPgRelation, PgGPlumBasePropertyConverter::exportSetOfPgRelation);
    public static final BasicMetaType<List<PgAmOp>> T_LIST_OF_PG_AM_OP = new BasicMetaType.CollectionMetaType(List.class, PgAmOp.class, PgGPlumBasePropertyConverter::importListOfPgAmOp, PgGPlumBasePropertyConverter::exportListOfPgAmOp);
    public static final BasicMetaType<List<PgAmProc>> T_LIST_OF_PG_AM_PROC = new BasicMetaType.CollectionMetaType(List.class, PgAmProc.class, PgGPlumBasePropertyConverter::importListOfPgAmProc, PgGPlumBasePropertyConverter::exportListOfPgAmProc);

    public static PgFireMode importPgFireMode(String text) {
        return (PgFireMode)PropertyConverter.importEnum(PgFireMode.class, (String)text);
    }

    public static PgAggregateKind importPgAggregateKind(String text) {
        return (PgAggregateKind)PropertyConverter.importEnum(PgAggregateKind.class, (String)text);
    }

    public static PgAccessMethodType importPgAccessMethodType(String text) {
        return (PgAccessMethodType)PropertyConverter.importEnum(PgAccessMethodType.class, (String)text);
    }

    public static String exportSetOfPgRelation(@NotNull Set<PgRelation> dependencies) {
        if (dependencies == null) {
            PgGPlumBasePropertyConverter.$$$reportNull$$$0(0);
        }
        StringBuilder sb = new StringBuilder();
        for (PgRelation dependency : dependencies) {
            sb.append(dependency.export()).append("\n");
        }
        return sb.toString();
    }

    public static String exportListOfPgAmOp(@NotNull List<PgAmOp> ops) {
        if (ops == null) {
            PgGPlumBasePropertyConverter.$$$reportNull$$$0(1);
        }
        return StringUtil.join((Iterable)JBIterable.from(ops).map(PgAmOp::serialize).sort(String::compareTo), (String)"\n");
    }

    public static String exportListOfPgAmProc(@NotNull List<PgAmProc> procs) {
        if (procs == null) {
            PgGPlumBasePropertyConverter.$$$reportNull$$$0(2);
        }
        return StringUtil.join((Iterable)JBIterable.from(procs).map(PgAmProc::serialize).sort(String::compareTo), (String)"\n");
    }

    @NotNull
    public static Set<PgRelation> importSetOfPgRelation(String text) {
        String[] lines;
        LinkedHashSet<PgRelation> dependencies = new LinkedHashSet<PgRelation>();
        for (String line : lines = StringUtil.splitByLines((String)text)) {
            dependencies.add(PgRelation.read(line));
        }
        LinkedHashSet<PgRelation> linkedHashSet = dependencies;
        if (linkedHashSet == null) {
            PgGPlumBasePropertyConverter.$$$reportNull$$$0(3);
        }
        return linkedHashSet;
    }

    @NotNull
    public static List<PgAmOp> importListOfPgAmOp(String text) {
        String[] lines;
        ArrayList<PgAmOp> ops = new ArrayList<PgAmOp>();
        for (String line : lines = StringUtil.splitByLines((String)text)) {
            ops.add(new PgAmOp(line));
        }
        ArrayList<PgAmOp> arrayList = ops;
        if (arrayList == null) {
            PgGPlumBasePropertyConverter.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @NotNull
    public static List<PgAmProc> importListOfPgAmProc(String text) {
        String[] lines;
        ArrayList<PgAmProc> procs = new ArrayList<PgAmProc>();
        for (String line : lines = StringUtil.splitByLines((String)text)) {
            procs.add(new PgAmProc(line));
        }
        ArrayList<PgAmProc> arrayList = procs;
        if (arrayList == null) {
            PgGPlumBasePropertyConverter.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencies";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ops";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "procs";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/postgresgreenplumbase/model/properties/PgGPlumBasePropertyConverter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/postgresgreenplumbase/model/properties/PgGPlumBasePropertyConverter";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "importSetOfPgRelation";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "importListOfPgAmOp";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "importListOfPgAmProc";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "exportSetOfPgRelation";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "exportListOfPgAmOp";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "exportListOfPgAmProc";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

