/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.postgresgreenplumbase.model;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.dialects.postgresbase.model.PgBaseModelHelper;
import com.intellij.database.dialects.postgresbase.model.PgBaseSchema;
import com.intellij.database.dialects.postgresbase.model.PgBaseTable;
import com.intellij.database.dialects.postgresbase.model.properties.PgDataTypeSubKind;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseDefType;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseDefTypeAttribute;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseOperatorClass;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseRole;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseSchema;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseSequence;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseTable;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ModelHelper;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0005\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\r2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000fH\u0016J\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0012J\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00120\u00152\u0006\u0010\u0013\u001a\u00020\u0012J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016\u00a8\u0006\u001b"}, d2={"Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseModelHelper;", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseModelHelper;", "()V", "fillPropertiesWithExamples", "", "e", "Lcom/intellij/database/model/basic/BasicModElement;", "variant", "Lcom/intellij/database/model/ModelHelper$ObjectKindVariant;", "vars", "", "", "generationVariants", "Lcom/intellij/util/containers/JBIterable;", "meta", "Lcom/intellij/database/model/meta/BasicMetaObject;", "getAncestors", "", "Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseTable;", "table", "getSuccessors", "", "hasDefaultType", "", "sequence", "Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseSequence;", "Companion", "intellij.database.dialects.postgresgreenplumbase"})
public abstract class PgGPlumBaseModelHelper
extends PgBaseModelHelper {
    private static final ModelHelper.ObjectKindVariant USER;
    private static final ModelHelper.ObjectKindVariant ENUM;
    private static final ModelHelper.ObjectKindVariant DOMAIN;
    private static final ModelHelper.ObjectKindVariant COMPOSITE_TYPE;
    public static final Companion Companion;

    public boolean hasDefaultType(@NotNull PgGPlumBaseSequence sequence) {
        Intrinsics.checkNotNullParameter((Object)sequence, (String)"sequence");
        DataType dataType = sequence.getDataType();
        Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"sequence.dataType");
        DataType dataType2 = dataType;
        return Intrinsics.areEqual((Object)dataType2, (Object)DataType.UNKNOWN) || StringsKt.equals((String)dataType2.typeName, (String)"bigint", (boolean)true);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<PgGPlumBaseTable> getAncestors(@NotNull PgGPlumBaseTable table) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        List<Long> list = table.getAncestorIds();
        Intrinsics.checkNotNullExpressionValue(list, (String)"table.ancestorIds");
        List<Long> ancestorIds = list;
        if (ancestorIds.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        PgGPlumBaseSchema pgGPlumBaseSchema = table.getSchema();
        if (pgGPlumBaseSchema == null) {
            return CollectionsKt.emptyList();
        }
        Intrinsics.checkNotNullExpressionValue((Object)pgGPlumBaseSchema, (String)"table.schema ?: return emptyList()");
        PgGPlumBaseSchema schema = pgGPlumBaseSchema;
        Iterable $this$mapNotNull$iv = ancestorIds;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            PgGPlumBaseTable pgGPlumBaseTable;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Long it = (Long)element$iv$iv;
            boolean bl2 = false;
            PgBaseSchema pgBaseSchema = schema;
            Long l = it;
            Intrinsics.checkNotNullExpressionValue((Object)l, (String)"it");
            PgBaseTable pgBaseTable = this.findTableByObjectId(pgBaseSchema, l);
            if (!(pgBaseTable instanceof PgGPlumBaseTable)) {
                pgBaseTable = null;
            }
            if ((PgGPlumBaseTable)pgBaseTable == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            PgGPlumBaseTable it$iv$iv = pgGPlumBaseTable;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<PgGPlumBaseTable> getSuccessors(@NotNull PgGPlumBaseTable table) {
        void $this$mapNotNullTo$iv;
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Set<Long> set = table.getSuccessorIds();
        Intrinsics.checkNotNullExpressionValue(set, (String)"table.successorIds");
        Set<Long> successorIds = set;
        if (successorIds.isEmpty()) {
            return SetsKt.emptySet();
        }
        PgGPlumBaseSchema pgGPlumBaseSchema = table.getSchema();
        if (pgGPlumBaseSchema == null) {
            return SetsKt.emptySet();
        }
        Intrinsics.checkNotNullExpressionValue((Object)pgGPlumBaseSchema, (String)"table.schema ?: return emptySet()");
        PgGPlumBaseSchema schema = pgGPlumBaseSchema;
        Iterable iterable = successorIds;
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv.iterator();
        while (iterator.hasNext()) {
            PgGPlumBaseTable pgGPlumBaseTable;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator.next();
            boolean bl = false;
            Long id = (Long)element$iv;
            boolean bl2 = false;
            PgBaseSchema pgBaseSchema = schema;
            Long l = id;
            Intrinsics.checkNotNullExpressionValue((Object)l, (String)"id");
            PgBaseTable pgBaseTable = this.findTableByObjectId(pgBaseSchema, l);
            if (!(pgBaseTable instanceof PgGPlumBaseTable)) {
                pgBaseTable = null;
            }
            if ((PgGPlumBaseTable)pgBaseTable == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            PgGPlumBaseTable it$iv = pgGPlumBaseTable;
            boolean bl5 = false;
            destination$iv.add(it$iv);
        }
        return (Set)destination$iv;
    }

    @NotNull
    public JBIterable<ModelHelper.ObjectKindVariant> generationVariants(@NotNull BasicMetaObject<?> meta) {
        JBIterable jBIterable;
        Intrinsics.checkNotNullParameter(meta, (String)"meta");
        ObjectKind objectKind = meta.kind;
        if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.ROLE)) {
            JBIterable jBIterable2 = super.generationVariants(meta).append((Object)USER);
            jBIterable = jBIterable2;
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"super.generationVariants(meta).append(USER)");
        } else if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.OBJECT_TYPE)) {
            JBIterable jBIterable3 = JBIterable.of((Object[])new ModelHelper.ObjectKindVariant[]{ENUM, DOMAIN, COMPOSITE_TYPE});
            jBIterable = jBIterable3;
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable3, (String)"JBIterable.of(ENUM, DOMAIN, COMPOSITE_TYPE)");
        } else {
            JBIterable jBIterable4 = super.generationVariants(meta);
            jBIterable = jBIterable4;
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable4, (String)"super.generationVariants(meta)");
        }
        return jBIterable;
    }

    public void fillPropertiesWithExamples(@NotNull BasicModElement e2, @NotNull ModelHelper.ObjectKindVariant variant, @NotNull Map<String, String> vars) {
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        Intrinsics.checkNotNullParameter(vars, (String)"vars");
        if (Intrinsics.areEqual((Object)variant, (Object)USER) && e2 instanceof PgGPlumBaseRole) {
            ((PgGPlumBaseRole)e2).setCanLogin(true);
        }
        if (e2 instanceof PgGPlumBaseOperatorClass) {
            ((PgGPlumBaseOperatorClass)e2).setInType(DataTypeFactory.of((String)"int"));
            vars.put("type", "int");
        }
        if (e2 instanceof PgGPlumBaseDefType) {
            ModelHelper.ObjectKindVariant objectKindVariant = variant;
            if (Intrinsics.areEqual((Object)objectKindVariant, (Object)ENUM)) {
                ((PgGPlumBaseDefType)e2).setSubKind(PgDataTypeSubKind.ENUM);
                ((PgGPlumBaseDefType)e2).setLabels(CollectionsKt.listOf((Object)"label"));
                vars.put("labels", "'label'");
            } else if (Intrinsics.areEqual((Object)objectKindVariant, (Object)DOMAIN)) {
                ((PgGPlumBaseDefType)e2).setSubKind(PgDataTypeSubKind.DOMAIN);
            } else if (Intrinsics.areEqual((Object)objectKindVariant, (Object)COMPOSITE_TYPE)) {
                ((PgGPlumBaseDefType)e2).setSubKind(PgDataTypeSubKind.COMPOSITE);
                PgGPlumBaseDefTypeAttribute attr = (PgGPlumBaseDefTypeAttribute)((PgGPlumBaseDefType)e2).getAttributes().createNewOne();
                this.setTemplateName(attr, "attr");
                PgGPlumBaseDefTypeAttribute pgGPlumBaseDefTypeAttribute = attr;
                Intrinsics.checkNotNullExpressionValue((Object)pgGPlumBaseDefTypeAttribute, (String)"attr");
                pgGPlumBaseDefTypeAttribute.setDataType(DataTypeFactory.of((String)"int"));
                vars.put("attrs", "attr int");
            }
        }
        super.fillPropertiesWithExamples(e2, variant, vars);
    }

    static {
        Companion = new Companion(null);
        USER = new ModelHelper.ObjectKindVariant(DatabaseBundle.messagePointer((String)"ObjectKindVariant.user", (Object[])new Object[0]));
        ENUM = new ModelHelper.ObjectKindVariant(DatabaseBundle.messagePointer((String)"ObjectKindVariant.enum", (Object[])new Object[0]));
        DOMAIN = new ModelHelper.ObjectKindVariant(DatabaseBundle.messagePointer((String)"ObjectKindVariant.domain", (Object[])new Object[0]));
        COMPOSITE_TYPE = new ModelHelper.ObjectKindVariant(DatabaseBundle.messagePointer((String)"ObjectKindVariant.composite.type", (Object[])new Object[0]));
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseModelHelper$Companion;", "", "()V", "COMPOSITE_TYPE", "Lcom/intellij/database/model/ModelHelper$ObjectKindVariant;", "DOMAIN", "ENUM", "USER", "intellij.database.dialects.postgresgreenplumbase"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

