/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.postgresbase.pgpass;

import com.intellij.credentialStore.Credentials;
import com.intellij.database.Dbms;
import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.dataSource.DatabaseAuthProvider;
import com.intellij.database.dataSource.DatabaseConnectionInterceptor;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.DatabaseCredentialsAuthProvider;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.url.JdbcUrlParser;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.database.dialects.postgresbase.pgpass.PgPassAuthProvider;
import com.intellij.database.dialects.postgresbase.pgpass.PgPassAuthProvider$sam$java_util_function_Supplier$0;
import com.intellij.database.dialects.postgresbase.pgpass.PgPassEntry;
import com.intellij.database.dialects.postgresbase.pgpass.PgPassFile;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ConcurrentFactoryMap;
import java.io.File;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.serialization.PathMacroUtil;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0015\u001a\u00020\u0005H\u0016J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0017\u001a\u00020\u0005H\u0002J\b\u0010\u0018\u001a\u00020\u0005H\u0016J\u001c\u0010\u0019\u001a\u00020\u00052\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u001bH\u0002J \u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u001d2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u001f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010!\u001a\u00020\u001f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R/\u0010\u0003\u001a#\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00070\u00070\u0004\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/database/dialects/postgresbase/pgpass/PgPassAuthProvider;", "Lcom/intellij/database/dataSource/DatabaseAuthProvider;", "()V", "cache", "Ljava/util/concurrent/ConcurrentMap;", "", "kotlin.jvm.PlatformType", "Lcom/intellij/database/dialects/postgresbase/pgpass/PgPassFile;", "Lorg/jetbrains/annotations/NotNull;", "createWidget", "Lcom/intellij/database/dataSource/DatabaseAuthProvider$AuthWidget;", "project", "Lcom/intellij/openapi/project/Project;", "credentials", "Lcom/intellij/database/access/DatabaseCredentials;", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "getCredentials", "Lcom/intellij/credentialStore/Credentials;", "proto", "Lcom/intellij/database/dataSource/DatabaseConnectionInterceptor$ProtoConnection;", "getDisplayName", "getFile", "path", "getId", "getLocation", "vmEnv", "", "intercept", "Ljava/util/concurrent/CompletionStage;", "silent", "", "isApplicable", "isApplicableAsDefault", "Companion", "intellij.database.dialects.postgresbase"})
public final class PgPassAuthProvider
implements DatabaseAuthProvider {
    private final ConcurrentMap<String, PgPassFile> cache;
    @NotNull
    public static final String ID = "pgpass";
    @NlsSafe
    @NotNull
    public static final String theDisplayName = "pgpass";
    public static final Companion Companion = new Companion(null);

    @Nullable
    public CompletionStage<DatabaseConnectionInterceptor.ProtoConnection> intercept(@NotNull DatabaseConnectionInterceptor.ProtoConnection proto2, boolean silent) {
        Intrinsics.checkNotNullParameter((Object)proto2, (String)"proto");
        DatabaseCredentialsAuthProvider.applyCredentials((DatabaseConnectionInterceptor.ProtoConnection)proto2, (Credentials)this.getCredentials(proto2), (boolean)false);
        return CompletableFuture.completedFuture(proto2);
    }

    @NotNull
    public String getId() {
        return "pgpass";
    }

    public boolean isApplicable(@NotNull LocalDataSource dataSource) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        Dbms dbms = dataSource.getDbms();
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"dataSource.dbms");
        return dbms.isPostgres();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isApplicableAsDefault(@NotNull LocalDataSource dataSource) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        if (!this.isApplicable(dataSource)) return false;
        Object object = dataSource.getDatabaseDriver();
        if (object == null || (object = object.getVmEnv()) == null) {
            object = MapsKt.emptyMap();
        }
        Map map2 = dataSource.getVmEnv();
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"dataSource.vmEnv");
        if (!new File(this.getLocation(MapsKt.plus((Map)object, (Map)map2))).exists()) return false;
        return true;
    }

    @NotNull
    public String getDisplayName() {
        return "pgpass";
    }

    @Nullable
    public DatabaseAuthProvider.AuthWidget createWidget(@Nullable Project project, @NotNull DatabaseCredentials credentials, @NotNull LocalDataSource dataSource) {
        Intrinsics.checkNotNullParameter((Object)credentials, (String)"credentials");
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        return (DatabaseAuthProvider.AuthWidget)new DatabaseCredentialsAuthProvider.UserWidget();
    }

    private final PgPassFile getFile(String path) {
        String string = PathManager.getAbsolutePath((String)path);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"PathManager.getAbsolutePath(path)");
        String absolutePath = string;
        PgPassFile res2 = (PgPassFile)this.cache.get(absolutePath);
        if (res2 != null && res2.getStamp() != new File(absolutePath).lastModified()) {
            this.cache.remove(absolutePath);
            return (PgPassFile)this.cache.get(absolutePath);
        }
        return res2;
    }

    private final String getLocation(Map<String, String> vmEnv) {
        String string = vmEnv.get("PGPASSFILE");
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            return it;
        }
        String string3 = EnvironmentUtil.getValue((String)"PGPASSFILE");
        if (string3 != null) {
            String string4 = string3;
            boolean bl = false;
            boolean bl4 = false;
            String it = string4;
            boolean bl5 = false;
            String string5 = it;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"it");
            return string5;
        }
        if (SystemInfo.isWindows) {
            return EnvironmentUtil.getValue((String)"APPDATA") + "\\postgresql\\pgpass.conf";
        }
        return PathMacroUtil.getUserHomePath() + "/.pgpass";
    }

    private final Credentials getCredentials(DatabaseConnectionInterceptor.ProtoConnection proto2) {
        String string;
        Map map2 = proto2.getRunConfiguration().VM_ENV;
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"proto.runConfiguration.VM_ENV");
        String path = this.getLocation(map2);
        PgPassFile pgPassFile = this.getFile(path);
        if (pgPassFile == null) {
            throw (Throwable)new RuntimeException("No pgpass file at `" + path + '`');
        }
        PgPassFile file = pgPassFile;
        JdbcUrlParser jdbcUrlParser = JdbcUrlParserUtil.parsed((RawConnectionConfig)((RawConnectionConfig)proto2.getConnectionPoint()), (String)proto2.getUrl());
        if (jdbcUrlParser == null) {
            throw (Throwable)new RuntimeException("Unable to parse `" + proto2.getUrl() + '`');
        }
        Intrinsics.checkNotNullExpressionValue((Object)jdbcUrlParser, (String)"JdbcUrlParserUtil.parsed\u2026to parse `${proto.url}`\")");
        JdbcUrlParser props = jdbcUrlParser;
        String string2 = props.getParameter("host");
        if (string2 == null) {
            throw (Throwable)new RuntimeException("Host not found in `" + proto2.getUrl() + '`');
        }
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"props.getParameter(State\u2026found in `${proto.url}`\")");
        String host = string2;
        String string3 = props.getParameter("port");
        if (string3 == null) {
            throw (Throwable)new RuntimeException("Port not found in `" + proto2.getUrl() + '`');
        }
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"props.getParameter(State\u2026found in `${proto.url}`\")");
        String port = string3;
        String string4 = props.getParameter("database");
        if (string4 == null) {
            string4 = "postgres";
        }
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"props.getParameter(State\u2026_PARAMETER) ?: \"postgres\"");
        String db = string4;
        String string5 = DatabaseCredentialsAuthProvider.getUser((DatabaseConnectionInterceptor.ProtoConnection)proto2);
        if (string5 == null) {
            string5 = string = StringUtil.nullize((String)props.getParameter("user"));
        }
        if (string5 == null) {
            DatabaseConnectionPoint databaseConnectionPoint = proto2.getConnectionPoint();
            Intrinsics.checkNotNullExpressionValue((Object)databaseConnectionPoint, (String)"proto.connectionPoint");
            LocalDataSource localDataSource = databaseConnectionPoint.getDataSource();
            Intrinsics.checkNotNullExpressionValue((Object)localDataSource, (String)"proto.connectionPoint.dataSource");
            string = localDataSource.getUsername();
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"DatabaseCredentialsAuthP\u2026Point.dataSource.username");
        String user = string;
        PgPassEntry pgPassEntry = file.entry(host, port, db, user);
        if (pgPassEntry == null) {
            throw (Throwable)new RuntimeException("No matching entry for `" + proto2.getUrl() + "` found in `" + path + '`');
        }
        PgPassEntry pgPassEntry2 = pgPassEntry;
        boolean bl = false;
        boolean bl2 = false;
        PgPassEntry it = pgPassEntry2;
        boolean bl3 = false;
        return new Credentials(user, it.getPass());
    }

    public PgPassAuthProvider() {
        Function function = cache.1.INSTANCE;
        Object object = cache.2.INSTANCE;
        if (object != null) {
            Function0 function0 = object;
            object = new PgPassAuthProvider$sam$java_util_function_Supplier$0(function0);
        }
        ConcurrentMap concurrentMap = ConcurrentFactoryMap.create((Function)function, (Supplier)((Supplier)object));
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"ConcurrentFactoryMap.cre\u2026teConcurrentSoftValueMap)");
        this.cache = concurrentMap;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/database/dialects/postgresbase/pgpass/PgPassAuthProvider$Companion;", "", "()V", "ID", "", "theDisplayName", "intellij.database.dialects.postgresbase"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

