/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.postgresbase.model.properties;

import com.intellij.database.dialects.postgresbase.model.properties.PgAclItem;
import com.intellij.database.dialects.postgresbase.model.properties.PgDataTypeSubKind;
import com.intellij.database.dialects.postgresbase.model.properties.PgDateInputStyle;
import com.intellij.database.dialects.postgresbase.model.properties.PgOperatorKind;
import com.intellij.database.dialects.postgresbase.model.properties.PgTimeZone;
import com.intellij.database.dialects.postgresbase.model.properties.PgVolatilityKind;
import com.intellij.database.model.meta.BasicMetaType;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface PgBasePropertyConverter
extends PropertyConverter {
    public static final BasicMetaType<PgDataTypeSubKind> T_PG_DATA_TYPE_SUB_KIND = new BasicMetaType(PgDataTypeSubKind.class, PgBasePropertyConverter::importPgDataTypeSubKind, PropertyConverter::export);
    public static final BasicMetaType<PgOperatorKind> T_PG_OPERATOR_KIND = new BasicMetaType(PgOperatorKind.class, PgBasePropertyConverter::importPgOperatorKind, PropertyConverter::export);
    public static final BasicMetaType<PgDateInputStyle> T_PG_DATE_INPUT_STYLE = new BasicMetaType(PgDateInputStyle.class, PgBasePropertyConverter::importPgDateInputStyle, PropertyConverter::export);
    public static final BasicMetaType<PgVolatilityKind> T_PG_VOLATILITY_KIND = new BasicMetaType(PgVolatilityKind.class, PgBasePropertyConverter::importPgVolatilityKind, PropertyConverter::export);
    public static final BasicMetaType<Map<String, PgTimeZone>> T_MAP_OF_STRING_PG_TIME_ZONE = new BasicMetaType.MapMetaType(String.class, PgTimeZone.class, PgBasePropertyConverter::importMapOfStringPgTimeZone, PgBasePropertyConverter::exportMapOfStringPgTimeZone);
    public static final BasicMetaType<List<PgAclItem>> T_LIST_OF_PG_ACL_ITEM = new BasicMetaType.CollectionMetaType(List.class, PgAclItem.class, PgBasePropertyConverter::importListOfPgAclItem, PgBasePropertyConverter::exportListOfPgAclItem);

    public static PgOperatorKind importPgOperatorKind(String text) {
        return (PgOperatorKind)PropertyConverter.importEnum(PgOperatorKind.class, (String)text);
    }

    public static PgDataTypeSubKind importPgDataTypeSubKind(String text) {
        return (PgDataTypeSubKind)PropertyConverter.importEnum(PgDataTypeSubKind.class, (String)text);
    }

    public static PgDateInputStyle importPgDateInputStyle(String text) {
        return (PgDateInputStyle)PropertyConverter.importEnum(PgDateInputStyle.class, (String)text);
    }

    @Nullable
    public static PgVolatilityKind importPgVolatilityKind(String kind) {
        return (PgVolatilityKind)PropertyConverter.importEnum(PgVolatilityKind.class, (String)kind);
    }

    public static String exportMapOfStringPgTimeZone(Map<String, PgTimeZone> timeZones) {
        StringBuilder sb = new StringBuilder();
        for (PgTimeZone timeZone : timeZones.values()) {
            sb.append(timeZone.export()).append("\n");
        }
        return sb.toString();
    }

    @NotNull
    public static Map<String, PgTimeZone> importMapOfStringPgTimeZone(String text) {
        String[] lines;
        LinkedHashMap<String, PgTimeZone> timeZones = new LinkedHashMap<String, PgTimeZone>();
        for (String line : lines = StringUtil.splitByLines((String)text)) {
            PgTimeZone timeZone = PgTimeZone.read(line);
            timeZones.put(StringUtil.toLowerCase((String)timeZone.getName()), timeZone);
        }
        LinkedHashMap<String, PgTimeZone> linkedHashMap = timeZones;
        if (linkedHashMap == null) {
            PgBasePropertyConverter.$$$reportNull$$$0(0);
        }
        return linkedHashMap;
    }

    public static List<PgAclItem> importListOfPgAclItem(String text) {
        String[] lines;
        if (text == null || text.length() == 0) {
            return Collections.emptyList();
        }
        ArrayList<PgAclItem> res2 = new ArrayList<PgAclItem>();
        for (String line : lines = StringUtil.splitByLines((String)text)) {
            res2.add(new PgAclItem(line));
        }
        return res2;
    }

    public static String exportListOfPgAclItem(List<PgAclItem> acl) {
        StringBuilder sb = new StringBuilder();
        for (PgAclItem item : acl) {
            item.export(sb).append("\n");
        }
        return sb.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/postgresbase/model/properties/PgBasePropertyConverter", "importMapOfStringPgTimeZone"));
    }
}

