/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.postgresbase.introspector;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.PgDialectHelper;
import com.intellij.database.dialects.base.introspector.jdbc.JdbcSourceLoader;
import com.intellij.database.dialects.postgresbase.model.PgBaseRoutine;
import com.intellij.database.dialects.postgresbase.model.properties.PgVolatilityKind;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.basic.BasicModSourceAware;
import com.intellij.database.script.CompositeText;
import com.intellij.database.script.SimpleCompositeText;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.Version;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;

public class PgBaseJdbcSourceLoader
extends JdbcSourceLoader {
    @Override
    protected boolean loadRoutine(@NotNull DatabaseDialectEx dialect, @NotNull BasicModSourceAware object, @NotNull DatabaseConnection connection) throws Exception {
        if (dialect == null) {
            PgBaseJdbcSourceLoader.$$$reportNull$$$0(0);
        }
        if (object == null) {
            PgBaseJdbcSourceLoader.$$$reportNull$$$0(1);
        }
        if (connection == null) {
            PgBaseJdbcSourceLoader.$$$reportNull$$$0(2);
        }
        if (!dialect.supportsProcedureDefinition() || !(object instanceof DasRoutine)) {
            return false;
        }
        Dbms dbms = connection.getDbms();
        if (dbms.isPostgres() && object instanceof PgBaseRoutine) {
            Version curVersion = connection.getVersion();
            boolean hasUseful = curVersion.isOrGreater(new int[]{8, 4});
            boolean isPre81 = !curVersion.isOrGreater(new int[]{8, 1});
            PgBaseRoutine routine2 = (PgBaseRoutine)object;
            int limit = Math.max(10, routine2.getArguments().size()) + 5;
            Boolean res2 = (Boolean)DbImplUtil.executeAndGetResult((DatabaseConnection)connection, (String)("select " + (String)(hasUseful ? "       pg_catalog.pg_get_function_arguments(pg_proc.oid) as arguments_def,\n       pg_catalog.pg_get_function_result(pg_proc.oid) as result_def,\n" : "       " + PgDialectHelper.typeArg((String)"tr", (String)"rettype", (String)"prorettype", (boolean)isPre81) + ", " + PgDialectHelper.select((int)limit, (boolean)isPre81) + "       pronargs,\n       proretset,\n") + "       prosrc,\n       lanname\nfrom pg_proc join pg_namespace nsp on nsp.oid = pronamespace left join pg_language l on l.oid = prolang\n" + (String)(hasUseful ? "" : PgDialectHelper.joinType((String)"tr", (String)"prorettype", (boolean)isPre81) + " " + PgDialectHelper.join((int)limit, (boolean)isPre81) + "\n") + "where proname = " + PgDialectHelper.str((String)object.getName()) + " and nsp.nspname = " + PgDialectHelper.str((String)DasUtil.getSchema((DasObject)object)) + "\n"), rs -> {
                if (!rs.next()) {
                    return false;
                }
                if (hasUseful) {
                    routine2.setArgumentsDefinition(StringUtil.nullize((String)rs.getString("arguments_def")));
                    routine2.setResultsDefinition(StringUtil.nullize((String)rs.getString("result_def")));
                } else {
                    PgDialectHelper.SignatureBuilder sigBuilder = new PgDialectHelper.SignatureBuilder(isPre81, rs);
                    DdlBuilder builder = new DdlBuilder().withDialect(DbImplUtil.getDatabaseDialect((Dbms)Dbms.POSTGRES));
                    routine2.setArgumentsDefinition(StringUtil.nullize((String)sigBuilder.buildArguments(builder).getStatement()));
                    builder.clear();
                    routine2.setResultsDefinition(StringUtil.nullize((String)sigBuilder.buildReturn(builder).getStatement()));
                }
                routine2.setSourceText((CompositeText)new SimpleCompositeText((CharSequence)rs.getString("prosrc"), CompositeText.Kind.ORIGINAL_TEXT));
                routine2.setLanguageName(StringUtil.nullize((String)rs.getString("lanname")));
                if (dbms.isRedshift()) {
                    routine2.setVolatilityKind(PgVolatilityKind.VOLATILE);
                }
                return true;
            });
            return res2 == Boolean.TRUE;
        }
        return super.loadRoutine(dialect, object, connection);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "dialect";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "object";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "connection";
                break;
            }
        }
        objectArray[1] = "com/intellij/database/dialects/postgresbase/introspector/PgBaseJdbcSourceLoader";
        objectArray[2] = "loadRoutine";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

