/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.postgres.model;

import com.intellij.database.dialects.postgres.model.PgAccessMethod;
import com.intellij.database.dialects.postgres.model.PgAggregate;
import com.intellij.database.dialects.postgres.model.PgDefType;
import com.intellij.database.dialects.postgres.model.PgDescriptionService;
import com.intellij.database.dialects.postgres.model.PgEventTrigger;
import com.intellij.database.dialects.postgres.model.PgModelFun;
import com.intellij.database.dialects.postgres.model.PgModelHelper;
import com.intellij.database.dialects.postgres.model.PgRole;
import com.intellij.database.dialects.postgres.model.PgRoutine;
import com.intellij.database.dialects.postgres.model.PgTrigger;
import com.intellij.database.dialects.postgres.model.properties.PgDataTypeSubCategory;
import com.intellij.database.dialects.postgres.model.properties.PgRoutineConcurrencyKind;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseAggregate;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseDefType;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseModelHelper;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseRole;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseRoutine;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumDescriptionService;
import com.intellij.database.dialects.postgresgreenplumbase.model.properties.PgAccessMethodType;
import com.intellij.database.model.DataType;
import com.intellij.database.model.DescriptionService;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.meta.BasicMetaProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014J\u001e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\rH\u0014J\u001e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\rH\u0014J\u0018\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u001a\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u001a\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u001d2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u001e\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\f\u001a\u00020\rH\u0014R\u0014\u0010\u0003\u001a\u00020\u00048TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006!"}, d2={"Lcom/intellij/database/dialects/postgres/model/PgDescriptionService;", "Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumDescriptionService;", "()V", "helper", "Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseModelHelper;", "getHelper", "()Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseModelHelper;", "collectAggregateAttributes", "", "", "aggregate", "Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseAggregate;", "context", "Lcom/intellij/database/model/DescriptionService$Context;", "collectRoleAttributes", "role", "Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseRole;", "collectRoutineAttributes", "routine", "Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseRoutine;", "content", "e", "Lcom/intellij/database/model/basic/BasicElement;", "describePgAccessMethod", "method", "Lcom/intellij/database/dialects/postgres/model/PgAccessMethod;", "describeTrigger", "trig", "Lcom/intellij/database/dialects/postgres/model/PgEventTrigger;", "Lcom/intellij/database/dialects/postgres/model/PgTrigger;", "getTypeCategory", "dt", "Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseDefType;", "intellij.database.dialects.postgres"})
public final class PgDescriptionService
extends PgGPlumDescriptionService {
    @Override
    @NotNull
    protected PgGPlumBaseModelHelper getHelper() {
        return PgModelHelper.INSTANCE;
    }

    @Override
    @NotNull
    public String content(@NotNull BasicElement e2, @NotNull DescriptionService.Context context) {
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        BasicElement basicElement = e2;
        return basicElement instanceof PgAccessMethod ? this.describePgAccessMethod((PgAccessMethod)e2, context) : (basicElement instanceof PgTrigger ? this.describeTrigger((PgTrigger)e2, context) : (basicElement instanceof PgEventTrigger ? this.describeTrigger((PgEventTrigger)e2, context) : super.content(e2, context)));
    }

    @Override
    @NotNull
    protected List<String> collectRoutineAttributes(@NotNull PgGPlumBaseRoutine routine2, @NotNull DescriptionService.Context context) {
        Intrinsics.checkNotNullParameter((Object)routine2, (String)"routine");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        PgRoutine cfr_ignored_0 = (PgRoutine)routine2;
        Collection collection = context.getDescribed();
        Object object = PgRoutine.CONCURRENCY_KIND;
        boolean bl = false;
        collection.add(object);
        collection = context.getDescribed();
        object = PgRoutine.WINDOW;
        bl = false;
        collection.add(object);
        collection = context.getDescribed();
        object = PgRoutine.ROWS;
        bl = false;
        collection.add(object);
        ArrayList<String> attributes2 = new ArrayList<String>();
        object = ((PgRoutine)routine2).getConcurrencyKind();
        bl = false;
        boolean bl2 = false;
        Object it = object;
        boolean bl3 = false;
        if (it != PgRoutineConcurrencyKind.UNSAFE) {
            StringBuilder stringBuilder = new StringBuilder().append("parallel ");
            Object object2 = it;
            Intrinsics.checkNotNullExpressionValue(object2, (String)"it");
            attributes2.add(stringBuilder.append(((PgRoutineConcurrencyKind)((Object)object2)).getModifier()).toString());
        }
        if (((PgRoutine)routine2).isWindow()) {
            attributes2.add("window");
        }
        if (PgModelFun.isRowsDefined((PgRoutine)routine2)) {
            attributes2.add("rows " + PgModelFun.rowsAsString((PgRoutine)routine2));
        }
        return CollectionsKt.plus((Collection)super.collectRoutineAttributes(routine2, context), (Iterable)attributes2);
    }

    @Override
    @NotNull
    protected String getTypeCategory(@NotNull PgGPlumBaseDefType dt, @NotNull DescriptionService.Context context) {
        Intrinsics.checkNotNullParameter((Object)dt, (String)"dt");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        PgDefType cfr_ignored_0 = (PgDefType)dt;
        Collection collection = context.getDescribed();
        BasicMetaProperty<PgDataTypeSubCategory> basicMetaProperty = PgDefType.SUB_CATEGORY;
        boolean bl = false;
        collection.add(basicMetaProperty);
        String category = super.getTypeCategory(dt, context);
        PgDataTypeSubCategory pgDataTypeSubCategory = ((PgDefType)dt).getSubCategory();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)pgDataTypeSubCategory), (String)"dt.subCategory");
        PgDataTypeSubCategory sc2 = pgDataTypeSubCategory;
        if (sc2 != PgDataTypeSubCategory.NONE && Intrinsics.areEqual((Object)sc2.human_readable_name(), (Object)category) ^ true) {
            return category + " (" + sc2.human_readable_name() + ')';
        }
        return category;
    }

    private final String describeTrigger(PgTrigger trig, DescriptionService.Context context) {
        boolean bl;
        Collection collection = context.getDescribed();
        Object object = PgTrigger.COLUMN_INDICES;
        boolean bl2 = false;
        collection.add(object);
        collection = context.getDescribed();
        object = PgTrigger.WHEN_CONDITION;
        bl2 = false;
        collection.add(object);
        String d = super.describeTrigger(trig, context);
        ArrayList atts = new ArrayList();
        List<Long> list = trig.getColumnIndices();
        Intrinsics.checkNotNullExpressionValue(list, (String)"trig.columnIndices");
        List<Long> cIndices = list;
        Collection collection2 = cIndices;
        boolean bl3 = false;
        if (!collection2.isEmpty()) {
            collection2 = atts;
            String string = "[columns: " + CollectionsKt.joinToString$default((Iterable)cIndices, null, null, null, (int)0, null, (Function1)describeTrigger.1.INSTANCE, (int)31, null) + ']';
            bl = false;
            collection2.add(string);
        }
        if (trig.getWhenCondition() != null) {
            collection2 = atts;
            String string = "[when: " + trig.getWhenCondition() + ']';
            bl = false;
            collection2.add(string);
        }
        String suffix2 = CollectionsKt.joinToString$default((Iterable)atts, null, null, null, (int)0, null, (Function1)describeTrigger.suffix.1.INSTANCE, (int)31, null);
        CharSequence charSequence = suffix2;
        bl = false;
        return d + (charSequence.length() == 0 ? "" : ' ' + suffix2);
    }

    private final String describeTrigger(PgEventTrigger trig, DescriptionService.Context context) {
        Collection collection = context.getDescribed();
        BasicMetaProperty<Long> basicMetaProperty = PgEventTrigger.CALL_ROUTINE_ID;
        boolean bl = false;
        collection.add(basicMetaProperty);
        StringBuilder stringBuilder = new StringBuilder().append(this.describeBasicElement((BasicElement)trig)).append(" call ");
        Object object = trig.getCallRoutine();
        if (object == null || (object = object.getName()) == null) {
            object = "???";
        }
        return stringBuilder.append((String)object).toString();
    }

    @Override
    @NotNull
    protected List<String> collectRoleAttributes(@NotNull PgGPlumBaseRole role, @NotNull DescriptionService.Context context) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)role, (String)"role");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        PgRole cfr_ignored_0 = (PgRole)role;
        Collection collection = context.getDescribed();
        Object object = PgRole.REPLICATION;
        boolean bl2 = false;
        collection.add(object);
        collection = context.getDescribed();
        object = PgRole.BYPASS_RLS;
        bl2 = false;
        collection.add(object);
        ArrayList attributes2 = new ArrayList();
        if (((PgRole)role).isReplication()) {
            object = attributes2;
            String string = " replication";
            bl = false;
            object.add((String)string);
        }
        if (((PgRole)role).isBypassRls()) {
            object = attributes2;
            String string = " bypassrls";
            bl = false;
            object.add(string);
        }
        return CollectionsKt.plus((Collection)super.collectRoleAttributes(role, context), (Iterable)attributes2);
    }

    private final String describePgAccessMethod(PgAccessMethod method, DescriptionService.Context context) {
        Collection collection = context.getDescribed();
        BasicMetaProperty basicMetaProperty = PgAccessMethod.HANDLER;
        boolean bl = false;
        collection.add(basicMetaProperty);
        collection = context.getDescribed();
        basicMetaProperty = PgAccessMethod.HANDLER_ID;
        bl = false;
        collection.add(basicMetaProperty);
        collection = context.getDescribed();
        basicMetaProperty = PgAccessMethod.TYPE;
        bl = false;
        collection.add(basicMetaProperty);
        List attributes2 = new ArrayList();
        StringBuilder stringBuilder = new StringBuilder().append("type: ");
        PgAccessMethodType pgAccessMethodType = method.getType();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)pgAccessMethodType), (String)"method.type");
        attributes2.add(stringBuilder.append(pgAccessMethodType.getModifier()).toString());
        if (method.getHandler() != null) {
            attributes2.add("handler: " + method.getHandler());
        }
        return CollectionsKt.joinToString$default((Iterable)attributes2, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
    }

    @Override
    @NotNull
    protected List<String> collectAggregateAttributes(@NotNull PgGPlumBaseAggregate aggregate, @NotNull DescriptionService.Context context) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)aggregate, (String)"aggregate");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        PgAggregate cfr_ignored_0 = (PgAggregate)aggregate;
        Collection collection = context.getDescribed();
        Object object = PgAggregate.FINAL_EXTRA;
        boolean bl2 = false;
        collection.add(object);
        collection = context.getDescribed();
        object = PgAggregate.COMBINE;
        bl2 = false;
        collection.add(object);
        collection = context.getDescribed();
        object = PgAggregate.SERIALIZATION;
        bl2 = false;
        collection.add(object);
        collection = context.getDescribed();
        object = PgAggregate.DESERIALIZATION;
        bl2 = false;
        collection.add(object);
        collection = context.getDescribed();
        object = PgAggregate.STATE_SIZE;
        bl2 = false;
        collection.add(object);
        collection = context.getDescribed();
        object = PgAggregate.INVERSE_TRANSITION;
        bl2 = false;
        collection.add(object);
        collection = context.getDescribed();
        object = PgAggregate.MOVING_TRANSITION;
        bl2 = false;
        collection.add(object);
        collection = context.getDescribed();
        object = PgAggregate.MOVING_STATE_TYPE;
        bl2 = false;
        collection.add(object);
        collection = context.getDescribed();
        object = PgAggregate.MOVING_STATE_SIZE;
        bl2 = false;
        collection.add(object);
        collection = context.getDescribed();
        object = PgAggregate.MOVING_FINAL;
        bl2 = false;
        collection.add(object);
        collection = context.getDescribed();
        object = PgAggregate.MOVING_FINAL_EXTRA;
        bl2 = false;
        collection.add(object);
        collection = context.getDescribed();
        object = PgAggregate.MOVING_INITIAL_VALUE;
        bl2 = false;
        collection.add(object);
        collection = context.getDescribed();
        object = PgAggregate.CONCURRENCY_KIND;
        bl2 = false;
        collection.add(object);
        ArrayList attributes2 = new ArrayList();
        if (((PgAggregate)aggregate).isFinalExtra()) {
            object = attributes2;
            String string = "final extra arguments";
            bl = false;
            object.add((String)string);
        }
        if (((PgAggregate)aggregate).getCombine() != null) {
            object = attributes2;
            String string = "combine function: " + ((PgAggregate)aggregate).getCombine();
            bl = false;
            object.add(string);
        }
        if (((PgAggregate)aggregate).getSerialization() != null) {
            object = attributes2;
            String string = "serialization function: " + ((PgAggregate)aggregate).getSerialization();
            bl = false;
            object.add(string);
        }
        if (((PgAggregate)aggregate).getDeserialization() != null) {
            object = attributes2;
            String string = "deserialization function: " + ((PgAggregate)aggregate).getDeserialization();
            bl = false;
            object.add(string);
        }
        if (((PgAggregate)aggregate).getStateSize() != 0L) {
            object = attributes2;
            String string = "state size: " + ((PgAggregate)aggregate).getStateSize();
            bl = false;
            object.add(string);
        }
        if (((PgAggregate)aggregate).getInverseTransition() != null) {
            object = attributes2;
            String string = "inverse transition: " + ((PgAggregate)aggregate).getInverseTransition();
            bl = false;
            object.add(string);
        }
        if (((PgAggregate)aggregate).getMovingTransition() != null) {
            object = attributes2;
            String string = "moving transition: " + ((PgAggregate)aggregate).getMovingTransition();
            bl = false;
            object.add(string);
        }
        if (Intrinsics.areEqual((Object)((PgAggregate)aggregate).getMovingStateType(), (Object)DataType.UNKNOWN) ^ true) {
            object = attributes2;
            String string = "moving state type: " + ((PgAggregate)aggregate).getMovingStateType();
            bl = false;
            object.add(string);
        }
        if (((PgAggregate)aggregate).getMovingStateSize() != 0L) {
            object = attributes2;
            String string = "moving state size: " + ((PgAggregate)aggregate).getMovingStateSize();
            bl = false;
            object.add(string);
        }
        if (((PgAggregate)aggregate).getMovingFinal() != null) {
            object = attributes2;
            String string = "moving final function: " + ((PgAggregate)aggregate).getMovingFinal();
            bl = false;
            object.add(string);
        }
        if (((PgAggregate)aggregate).isMovingFinalExtra()) {
            object = attributes2;
            String string = "moving final extra arguments";
            bl = false;
            object.add(string);
        }
        if (((PgAggregate)aggregate).getMovingInitialValue() != null) {
            object = attributes2;
            String string = "moving initial value: " + ((PgAggregate)aggregate).getMovingInitialValue();
            bl = false;
            object.add(string);
        }
        if (((PgAggregate)aggregate).getConcurrencyKind() != PgRoutineConcurrencyKind.UNSAFE) {
            object = attributes2;
            StringBuilder stringBuilder = new StringBuilder().append("concurrency kind: ");
            PgRoutineConcurrencyKind pgRoutineConcurrencyKind = ((PgAggregate)aggregate).getConcurrencyKind();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)pgRoutineConcurrencyKind), (String)"aggregate.concurrencyKind");
            String string = stringBuilder.append(pgRoutineConcurrencyKind.getModifier()).toString();
            bl = false;
            object.add(string);
        }
        return CollectionsKt.plus((Collection)super.collectAggregateAttributes(aggregate, context), (Iterable)attributes2);
    }
}

