/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.postgres;

import com.intellij.database.dialects.base.SqlObjectBuilderImpl;
import com.intellij.database.dialects.postgres.model.PgAccessMethod;
import com.intellij.database.dialects.postgres.model.PgAggregate;
import com.intellij.database.dialects.postgres.model.PgLikeStoredTable;
import com.intellij.database.dialects.postgres.model.PgLocalTableColumn;
import com.intellij.database.dialects.postgres.model.PgMatView;
import com.intellij.database.dialects.postgres.model.PgRole;
import com.intellij.database.dialects.postgres.model.PgRoutine;
import com.intellij.database.dialects.postgres.model.PgTrigger;
import com.intellij.database.dialects.postgres.model.properties.PgIdentityKind;
import com.intellij.database.dialects.postgres.model.properties.PgRoutineConcurrencyKind;
import com.intellij.database.dialects.postgresgreenplumbase.PgGPlumBaseObjectBuilder;
import com.intellij.database.dialects.postgresgreenplumbase.model.properties.PgAccessMethodType;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.SqlObjectBuilder;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicMixinElement;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.script.CompositeText;
import com.intellij.database.script.SimpleCompositeText;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.sql.dialects.postgres.PgElementTypes;
import com.intellij.sql.dialects.postgres.PgTypes;
import com.intellij.sql.dialects.postgres.psi.PgCreateAggregateStatementImpl;
import com.intellij.sql.dialects.postgres.psi.PgCreateTriggerStatementImpl;
import com.intellij.sql.psi.SqlClause;
import com.intellij.sql.psi.SqlColumnDefinition;
import com.intellij.sql.psi.SqlCompositeElementType;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlCreateProcedureStatement;
import com.intellij.sql.psi.SqlCreateStatement;
import com.intellij.sql.psi.SqlElementTypes;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlTypeElement;
import com.intellij.sql.psi.stubs.SqlDefinitionStub;
import com.intellij.sql.psi.stubs.SqlStubbedElement;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J \u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J \u0010\u0011\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J \u0010\u0013\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J \u0010\u0015\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00162\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J \u0010\u0017\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00182\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J \u0010\u0019\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u001a2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J \u0010\u001b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u001c2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002R\u0016\u0010\u0003\u001a\u0004\u0018\u00010\u00048TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006!"}, d2={"Lcom/intellij/database/dialects/postgres/PgObjectBuilder;", "Lcom/intellij/database/dialects/postgresgreenplumbase/PgGPlumBaseObjectBuilder;", "()V", "lazyCodeBlock", "Lcom/intellij/psi/tree/IElementType;", "getLazyCodeBlock", "()Lcom/intellij/psi/tree/IElementType;", "build", "", "obj", "Lcom/intellij/database/model/basic/BasicModElement;", "source", "Lcom/intellij/database/model/DasObject;", "context", "Lcom/intellij/database/model/SqlObjectBuilder$Context;", "buildAccessMethod", "Lcom/intellij/database/dialects/postgres/model/PgAccessMethod;", "buildAggregate", "Lcom/intellij/database/dialects/postgres/model/PgAggregate;", "buildColumn", "Lcom/intellij/database/dialects/postgres/model/PgLocalTableColumn;", "buildMatView", "Lcom/intellij/database/dialects/postgres/model/PgMatView;", "buildRole", "Lcom/intellij/database/dialects/postgres/model/PgRole;", "buildRoutine", "Lcom/intellij/database/dialects/postgres/model/PgRoutine;", "buildTrigger", "Lcom/intellij/database/dialects/postgres/model/PgTrigger;", "findConcurrencyKind", "Lcom/intellij/database/dialects/postgres/model/properties/PgRoutineConcurrencyKind;", "element", "Lcom/intellij/psi/PsiElement;", "intellij.database.dialects.postgres"})
public class PgObjectBuilder
extends PgGPlumBaseObjectBuilder {
    @Override
    @Nullable
    protected IElementType getLazyCodeBlock() {
        return PgElementTypes.Misc.PG_LAZY_CODE_BLOCK;
    }

    @Override
    public void build(@NotNull BasicModElement obj2, @NotNull DasObject source, @NotNull SqlObjectBuilder.Context context) {
        Intrinsics.checkNotNullParameter((Object)obj2, (String)"obj");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        BasicModElement basicModElement = obj2;
        if (basicModElement instanceof PgLocalTableColumn) {
            this.buildColumn((PgLocalTableColumn)obj2, source, context);
        } else if (basicModElement instanceof PgRoutine) {
            this.buildRoutine((PgRoutine)obj2, source, context);
        } else if (basicModElement instanceof PgRole) {
            this.buildRole((PgRole)obj2, source, context);
        } else if (basicModElement instanceof PgAggregate) {
            this.buildAggregate((PgAggregate)obj2, source, context);
        } else if (basicModElement instanceof PgAccessMethod) {
            this.buildAccessMethod((PgAccessMethod)obj2, source, context);
        } else if (basicModElement instanceof PgMatView) {
            this.buildMatView((PgMatView)obj2, source, context);
        } else if (basicModElement instanceof PgTrigger) {
            this.buildTrigger((PgTrigger)obj2, source, context);
        } else {
            super.build(obj2, source, context);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void buildColumn(PgLocalTableColumn obj2, DasObject source, SqlObjectBuilder.Context context) {
        PgLocalTableColumn stubbed;
        BasicElement basicElement;
        void $this$stubbed$iv;
        this.buildBasicElement(obj2, source, context);
        DasObject dasObject = source;
        SqlObjectBuilderImpl this_$iv = this;
        boolean $i$f$stubbed2 = false;
        void var8_9 = $this$stubbed$iv;
        if (var8_9 instanceof PgLocalTableColumn) {
            basicElement = (BasicElement)$this$stubbed$iv;
        } else if (var8_9 instanceof SqlStubbedElement) {
            StubElement stubElement = ((SqlStubbedElement)$this$stubbed$iv).getGreenStub();
            if (!(stubElement instanceof SqlDefinitionStub)) {
                stubElement = null;
            }
            SqlDefinitionStub sqlDefinitionStub = (SqlDefinitionStub)stubElement;
            Object object = sqlDefinitionStub != null ? sqlDefinitionStub.getElement() : null;
            if (!(object instanceof PgLocalTableColumn)) {
                object = null;
            }
            basicElement = (BasicElement)((PgLocalTableColumn)object);
        } else {
            basicElement = null;
        }
        if ((stubbed = (PgLocalTableColumn)basicElement) != null) {
            obj2.setIdentityKind(stubbed.getIdentityKind());
            obj2.setNotNull(stubbed.isNotNull());
        } else {
            void this_$iv2;
            boolean wasNotNull = obj2.isNotNull();
            PgIdentityKind identityKind = null;
            SqlObjectBuilderImpl $i$f$stubbed2 = this;
            DasObject dasObject2 = source;
            if (!(dasObject2 instanceof SqlColumnDefinition)) {
                dasObject2 = null;
            }
            PsiElement el$iv = (PsiElement)((SqlColumnDefinition)dasObject2);
            boolean $i$f$forEachChild = false;
            void var10_12 = this_$iv2;
            PsiElement psiElement = el$iv;
            PsiElement first$iv$iv = psiElement != null ? psiElement.getFirstChild() : null;
            boolean $i$f$forEachSibling = false;
            for (PsiElement tmp$iv$iv = first$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                PsiElement maybeClause = tmp$iv$iv;
                boolean bl = false;
                if (!(maybeClause instanceof SqlClause)) continue;
                SqlObjectBuilderImpl this_$iv3 = this;
                boolean $i$f$forEachChild2 = false;
                SqlObjectBuilderImpl sqlObjectBuilderImpl = this_$iv3;
                PsiElement first$iv$iv2 = maybeClause.getFirstChild();
                boolean $i$f$forEachSibling2 = false;
                for (PsiElement tmp$iv$iv2 = first$iv$iv2; tmp$iv$iv2 != null; tmp$iv$iv2 = tmp$iv$iv2.getNextSibling()) {
                    PsiElement byDefaultStart;
                    PsiElement child = tmp$iv$iv2;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)child), (Object)PgTypes.PG_GENERATED)) continue;
                    IElementType iElementType = PgTypes.PG_ALWAYS;
                    Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"PG_ALWAYS");
                    PsiElement always = this.findSibling(child, iElementType);
                    if (always != null) {
                        identityKind = PgIdentityKind.ALWAYS;
                        continue;
                    }
                    IElementType iElementType2 = PgTypes.PG_BY;
                    Intrinsics.checkNotNullExpressionValue((Object)iElementType2, (String)"PG_BY");
                    if (this.findSibling(child, iElementType2) == null) {
                        continue;
                    }
                    IElementType iElementType3 = PgTypes.PG_DEFAULT;
                    Intrinsics.checkNotNullExpressionValue((Object)iElementType3, (String)"PG_DEFAULT");
                    if (this.findSibling(byDefaultStart, iElementType3) == null) {
                        continue;
                    }
                    identityKind = PgIdentityKind.BY_DEFAULT;
                }
            }
            obj2.setIdentityKind(identityKind);
            obj2.setNotNull(identityKind != null || wasNotNull);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void buildTrigger(PgTrigger obj2, DasObject source, SqlObjectBuilder.Context context) {
        PgTrigger stubbed;
        BasicElement basicElement;
        void $this$stubbed$iv;
        if (!context.isIntrospector()) {
            super.buildTrigger(obj2, source, context);
        }
        DasObject dasObject = source;
        SqlObjectBuilderImpl this_$iv = this;
        boolean $i$f$stubbed = false;
        void var8_8 = $this$stubbed$iv;
        if (var8_8 instanceof PgTrigger) {
            basicElement = (BasicElement)$this$stubbed$iv;
        } else if (var8_8 instanceof SqlStubbedElement) {
            StubElement stubElement = ((SqlStubbedElement)$this$stubbed$iv).getGreenStub();
            if (!(stubElement instanceof SqlDefinitionStub)) {
                stubElement = null;
            }
            SqlDefinitionStub sqlDefinitionStub = (SqlDefinitionStub)stubElement;
            Object object = sqlDefinitionStub != null ? sqlDefinitionStub.getElement() : null;
            if (!(object instanceof PgTrigger)) {
                object = null;
            }
            basicElement = (BasicElement)((PgTrigger)object);
        } else {
            basicElement = null;
        }
        if ((stubbed = (PgTrigger)basicElement) != null) {
            obj2.setColumnIndices(stubbed.getColumnIndices());
            obj2.setWhenCondition(stubbed.getWhenCondition());
        } else {
            ArrayList columnIndices = new ArrayList();
            String whenCondition = null;
            if (source instanceof PgCreateTriggerStatementImpl) {
                PgLikeStoredTable table = obj2.getParent();
                CasingProvider casingProvider = BasicMixinElement.getCasingProvider((BasicElement)((BasicElement)table));
                if (casingProvider == null) {
                    casingProvider = DasUtil.NO_CASING_PROVIDER;
                }
                CasingProvider casingProvider2 = casingProvider;
                SqlObjectBuilderImpl this_$iv2 = this;
                boolean $i$f$forEachChild = false;
                SqlObjectBuilderImpl sqlObjectBuilderImpl = this_$iv2;
                PsiElement first$iv$iv = ((PsiElement)source).getFirstChild();
                boolean $i$f$forEachSibling = false;
                for (PsiElement tmp$iv$iv = first$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                    PsiElement psiElement;
                    block28: {
                        PsiElement c = tmp$iv$iv;
                        boolean bl = false;
                        IElementType iElementType = PsiTreeUtilKt.getElementType((PsiElement)c);
                        if (Intrinsics.areEqual((Object)iElementType, (Object)SqlCompositeElementTypes.SQL_TRIGGER_EVENT_CLAUSE)) {
                            PsiElement of;
                            PsiElement update;
                            if (context.isIntrospector()) continue;
                            IElementType iElementType2 = PgTypes.PG_UPDATE;
                            Intrinsics.checkNotNullExpressionValue((Object)iElementType2, (String)"PG_UPDATE");
                            if (this.findChild(c, iElementType2) == null) {
                                continue;
                            }
                            IElementType iElementType3 = PgTypes.PG_OF;
                            Intrinsics.checkNotNullExpressionValue((Object)iElementType3, (String)"PG_OF");
                            if (this.findSibling(update, iElementType3) == null) {
                                continue;
                            }
                            SqlReferenceElementType sqlReferenceElementType = SqlCompositeElementTypes.SQL_COLUMN_SHORT_REFERENCE;
                            Intrinsics.checkNotNullExpressionValue((Object)sqlReferenceElementType, (String)"SqlCompositeElementTypes\u2026QL_COLUMN_SHORT_REFERENCE");
                            PsiElement psiElement2 = this.findSibling(of, (IElementType)sqlReferenceElementType);
                            if (!(psiElement2 instanceof SqlReferenceExpression)) {
                                psiElement2 = null;
                            }
                            SqlReferenceExpression column2 = (SqlReferenceExpression)psiElement2;
                            DasTable dasTable = ((PgCreateTriggerStatementImpl)source).getTable();
                            if (dasTable == null || (dasTable = dasTable.getDasChildren(ObjectKind.COLUMN)) == null) {
                                JBIterable jBIterable = JBIterable.empty();
                                dasTable = jBIterable;
                                Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"JBIterable.empty()");
                            }
                            DasTable columns = dasTable;
                            while (column2 != null) {
                                int n;
                                block27: {
                                    Intrinsics.checkNotNullExpressionValue((Object)DbSqlUtil.byName((String)column2.getName(), (boolean)DbSqlUtil.isQuoted((SqlNameElement)((SqlNameElement)column2)), null, (CasingProvider)casingProvider2), (String)"DbSqlUtil.byName<DasObje\u2026n), null, casingProvider)");
                                    Iterable $this$indexOfFirst$iv = (Iterable)columns;
                                    boolean $i$f$indexOfFirst = false;
                                    int index$iv = 0;
                                    for (Object item$iv : $this$indexOfFirst$iv) {
                                        Condition condition;
                                        boolean bl2 = false;
                                        if (index$iv < 0) {
                                            CollectionsKt.throwIndexOverflow();
                                        }
                                        DasObject it = (DasObject)item$iv;
                                        boolean bl3 = false;
                                        if (condition.value((Object)it)) {
                                            n = index$iv;
                                            break block27;
                                        }
                                        ++index$iv;
                                    }
                                    n = -1;
                                }
                                long col = (long)n + 1L;
                                if (col != 0L) {
                                    Collection collection = columnIndices;
                                    Long l = col;
                                    boolean bl4 = false;
                                    collection.add(l);
                                }
                                PsiElement psiElement3 = column2.getNextSibling();
                                SqlReferenceElementType sqlReferenceElementType2 = SqlCompositeElementTypes.SQL_COLUMN_SHORT_REFERENCE;
                                Intrinsics.checkNotNullExpressionValue((Object)sqlReferenceElementType2, (String)"SqlCompositeElementTypes\u2026QL_COLUMN_SHORT_REFERENCE");
                                PsiElement psiElement4 = this.findSibling(psiElement3, (IElementType)sqlReferenceElementType2);
                                if (!(psiElement4 instanceof SqlReferenceExpression)) {
                                    psiElement4 = null;
                                }
                                column2 = (SqlReferenceExpression)psiElement4;
                            }
                            continue;
                        }
                        if (!Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_WHEN_CLAUSE)) continue;
                        IElementType iElementType4 = PgTypes.PG_WHEN;
                        Intrinsics.checkNotNullExpressionValue((Object)iElementType4, (String)"PG_WHEN");
                        if (this.findChild(c, iElementType4) == null) {
                            continue;
                        }
                        SqlObjectBuilderImpl this_$iv3 = this;
                        boolean $i$f$findSibling = false;
                        for (PsiElement tmp$iv = whenChild; tmp$iv != null; tmp$iv = tmp$iv.getNextSibling()) {
                            PsiElement it = tmp$iv;
                            boolean bl5 = false;
                            if (!(it instanceof SqlExpression)) continue;
                            psiElement = tmp$iv;
                            break block28;
                        }
                        psiElement = null;
                    }
                    if (psiElement == null) {
                        continue;
                    }
                    PsiElement expression = psiElement;
                    whenCondition = expression.getText();
                }
            }
            if (!context.isIntrospector()) {
                obj2.setColumnIndices(columnIndices);
            }
            obj2.setWhenCondition(whenCondition);
        }
    }

    private final void buildMatView(PgMatView obj2, DasObject source, SqlObjectBuilder.Context context) {
        this.buildBasicElement(obj2, source, context);
        this.assignSources(obj2, context, (Function0<? extends CompositeText>)((Function0)new Function0<CompositeText>(this, source){
            final /* synthetic */ PgObjectBuilder this$0;
            final /* synthetic */ DasObject $source;

            @Nullable
            public final CompositeText invoke() {
                return (CompositeText)PgObjectBuilder.access$getViewQuery(this.this$0, this.$source, CompositeText.Kind.ORIGINAL_TEXT);
            }
            {
                this.this$0 = pgObjectBuilder;
                this.$source = dasObject;
                super(0);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    private final void buildAccessMethod(PgAccessMethod obj2, DasObject source, SqlObjectBuilder.Context context) {
        BasicElement basicElement;
        BasicElement basicElement2;
        void $this$stubbed$iv$iv;
        void $this$stubbedOrBuild$iv;
        DasObject dasObject = source;
        SqlObjectBuilderImpl this_$iv = this;
        boolean $i$f$stubbedOrBuild = false;
        void var8_7 = $this$stubbedOrBuild$iv;
        SqlObjectBuilderImpl this_$iv$iv = this_$iv;
        boolean $i$f$stubbed = false;
        void var11_11 = $this$stubbed$iv$iv;
        if (var11_11 instanceof PgAccessMethod) {
            basicElement2 = (BasicElement)$this$stubbed$iv$iv;
        } else if (var11_11 instanceof SqlStubbedElement) {
            StubElement stubElement = ((SqlStubbedElement)$this$stubbed$iv$iv).getGreenStub();
            if (!(stubElement instanceof SqlDefinitionStub)) {
                stubElement = null;
            }
            SqlDefinitionStub sqlDefinitionStub = (SqlDefinitionStub)stubElement;
            Object object = sqlDefinitionStub != null ? sqlDefinitionStub.getElement() : null;
            if (!(object instanceof PgAccessMethod)) {
                object = null;
            }
            basicElement2 = (BasicElement)((PgAccessMethod)object);
        } else {
            basicElement2 = basicElement = null;
        }
        if (basicElement2 == null) {
            void this_$iv2;
            BasicModElement basicModElement = ((BasicElement)obj2).getMetaObject().newDataObject();
            if (basicModElement == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.database.dialects.postgres.model.PgAccessMethod");
            }
            BasicElement basicElement3 = (BasicElement)((PgAccessMethod)basicModElement);
            boolean bl = false;
            boolean bl2 = false;
            PgAccessMethod $this$stubbedOrBuild = (PgAccessMethod)basicElement3;
            boolean bl3 = false;
            SqlObjectBuilderImpl sqlObjectBuilderImpl = this;
            DasObject dasObject2 = source;
            if (!(dasObject2 instanceof SqlCreateStatement)) {
                dasObject2 = null;
            }
            PsiElement el$iv = (PsiElement)((SqlCreateStatement)dasObject2);
            boolean $i$f$forEachChild = false;
            void var17_17 = this_$iv2;
            PsiElement psiElement = el$iv;
            PsiElement first$iv$iv = psiElement != null ? psiElement.getFirstChild() : null;
            boolean $i$f$forEachSibling = false;
            for (PsiElement tmp$iv$iv = first$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                PsiElement child = tmp$iv$iv;
                boolean bl4 = false;
                IElementType iElementType = PsiTreeUtilKt.getElementType((PsiElement)child);
                if (!Intrinsics.areEqual((Object)iElementType, (Object)SqlElementTypes.SQL_CLAUSE)) continue;
                SqlObjectBuilderImpl this_$iv3 = this;
                boolean $i$f$forEachChild2 = false;
                SqlObjectBuilderImpl sqlObjectBuilderImpl2 = this_$iv3;
                PsiElement first$iv$iv2 = child.getFirstChild();
                boolean $i$f$forEachSibling2 = false;
                for (PsiElement tmp$iv$iv2 = first$iv$iv2; tmp$iv$iv2 != null; tmp$iv$iv2 = tmp$iv$iv2.getNextSibling()) {
                    PsiElement it = tmp$iv$iv2;
                    boolean bl5 = false;
                    IElementType iElementType2 = PsiTreeUtilKt.getElementType((PsiElement)it);
                    if (Intrinsics.areEqual((Object)iElementType2, (Object)PgTypes.PG_INDEX)) {
                        $this$stubbedOrBuild.setType(PgAccessMethodType.INDEX);
                        continue;
                    }
                    if (!Intrinsics.areEqual((Object)iElementType2, (Object)PgTypes.PG_HANDLER)) continue;
                    PgGPlumBaseObjectBuilder.Reference reference = this.findFunctionReference(it);
                    $this$stubbedOrBuild.setHandler(reference != null ? reference.getFullName() : null);
                }
            }
            basicElement = basicElement3;
        }
        PgAccessMethod stubbed = (PgAccessMethod)basicElement;
        obj2.setType(stubbed.getType());
        obj2.setHandler(stubbed.getHandler());
    }

    /*
     * WARNING - void declaration
     */
    private final void buildAggregate(PgAggregate obj2, DasObject source, SqlObjectBuilder.Context context) {
        BasicElement basicElement;
        BasicElement basicElement2;
        void $this$stubbed$iv$iv;
        void $this$stubbedOrBuild$iv;
        super.buildAggregate(obj2, source, context);
        DasObject dasObject = source;
        SqlObjectBuilderImpl this_$iv = this;
        boolean $i$f$stubbedOrBuild = false;
        void var8_7 = $this$stubbedOrBuild$iv;
        SqlObjectBuilderImpl this_$iv$iv = this_$iv;
        boolean $i$f$stubbed = false;
        void var11_11 = $this$stubbed$iv$iv;
        if (var11_11 instanceof PgAggregate) {
            basicElement2 = (BasicElement)$this$stubbed$iv$iv;
        } else if (var11_11 instanceof SqlStubbedElement) {
            StubElement stubElement = ((SqlStubbedElement)$this$stubbed$iv$iv).getGreenStub();
            if (!(stubElement instanceof SqlDefinitionStub)) {
                stubElement = null;
            }
            SqlDefinitionStub sqlDefinitionStub = (SqlDefinitionStub)stubElement;
            Object object = sqlDefinitionStub != null ? sqlDefinitionStub.getElement() : null;
            if (!(object instanceof PgAggregate)) {
                object = null;
            }
            basicElement2 = (BasicElement)((PgAggregate)object);
        } else {
            basicElement2 = basicElement = null;
        }
        if (basicElement2 == null) {
            void this_$iv2;
            BasicModElement basicModElement = ((BasicElement)obj2).getMetaObject().newDataObject();
            if (basicModElement == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.database.dialects.postgres.model.PgAggregate");
            }
            BasicElement basicElement3 = (BasicElement)((PgAggregate)basicModElement);
            boolean bl = false;
            boolean bl2 = false;
            PgAggregate $this$stubbedOrBuild = (PgAggregate)basicElement3;
            boolean bl3 = false;
            SqlObjectBuilderImpl sqlObjectBuilderImpl = this;
            DasObject dasObject2 = source;
            if (!(dasObject2 instanceof PgCreateAggregateStatementImpl)) {
                dasObject2 = null;
            }
            PsiElement el$iv = (PsiElement)((PgCreateAggregateStatementImpl)dasObject2);
            boolean $i$f$forEachChild = false;
            void var17_17 = this_$iv2;
            PsiElement psiElement = el$iv;
            PsiElement first$iv$iv = psiElement != null ? psiElement.getFirstChild() : null;
            boolean $i$f$forEachSibling = false;
            for (PsiElement tmp$iv$iv = first$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                PsiElement child = tmp$iv$iv;
                boolean bl4 = false;
                IElementType iElementType = PsiTreeUtilKt.getElementType((PsiElement)child);
                if (!Intrinsics.areEqual((Object)iElementType, (Object)SqlCompositeElementTypes.SQL_GENERIC_SETTINGS_CLAUSE)) continue;
                SqlObjectBuilderImpl this_$iv3 = this;
                boolean $i$f$forEachChild2 = false;
                SqlObjectBuilderImpl sqlObjectBuilderImpl2 = this_$iv3;
                PsiElement first$iv$iv2 = child.getFirstChild();
                boolean $i$f$forEachSibling2 = false;
                for (PsiElement tmp$iv$iv2 = first$iv$iv2; tmp$iv$iv2 != null; tmp$iv$iv2 = tmp$iv$iv2.getNextSibling()) {
                    PsiElement it = tmp$iv$iv2;
                    boolean bl5 = false;
                    IElementType iElementType2 = PsiTreeUtilKt.getElementType((PsiElement)it);
                    if (Intrinsics.areEqual((Object)iElementType2, (Object)PgTypes.PG_FINALFUNC_EXTRA)) {
                        $this$stubbedOrBuild.setFinalExtra(true);
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)iElementType2, (Object)PgTypes.PG_COMBINEFUNC)) {
                        PgGPlumBaseObjectBuilder.Reference reference = this.findFunctionReference(it);
                        $this$stubbedOrBuild.setCombine(reference != null ? reference.getFullName() : null);
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)iElementType2, (Object)PgTypes.PG_SERIALFUNC)) {
                        PgGPlumBaseObjectBuilder.Reference reference = this.findFunctionReference(it);
                        $this$stubbedOrBuild.setSerialization(reference != null ? reference.getFullName() : null);
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)iElementType2, (Object)PgTypes.PG_DESERIALFUNC)) {
                        PgGPlumBaseObjectBuilder.Reference reference = this.findFunctionReference(it);
                        $this$stubbedOrBuild.setDeserialization(reference != null ? reference.getFullName() : null);
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)iElementType2, (Object)PgTypes.PG_MSFUNC)) {
                        PgGPlumBaseObjectBuilder.Reference reference = this.findFunctionReference(it);
                        $this$stubbedOrBuild.setMovingTransition(reference != null ? reference.getFullName() : null);
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)iElementType2, (Object)PgTypes.PG_MINVFUNC)) {
                        PgGPlumBaseObjectBuilder.Reference reference = this.findFunctionReference(it);
                        $this$stubbedOrBuild.setInverseTransition(reference != null ? reference.getFullName() : null);
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)iElementType2, (Object)PgTypes.PG_MSTYPE)) {
                        SqlTypeElement sqlTypeElement;
                        SqlCompositeElementType sqlCompositeElementType = SqlElementTypes.SQL_TYPE_ELEMENT;
                        Intrinsics.checkNotNullExpressionValue((Object)sqlCompositeElementType, (String)"SqlElementTypes.SQL_TYPE_ELEMENT");
                        PsiElement psiElement2 = this.findSibling(it, (IElementType)sqlCompositeElementType);
                        if (!(psiElement2 instanceof SqlTypeElement)) {
                            psiElement2 = null;
                        }
                        if ((sqlTypeElement = (SqlTypeElement)psiElement2) != null && (sqlTypeElement = sqlTypeElement.getDataType()) != null) {
                            SqlTypeElement sqlTypeElement2 = sqlTypeElement;
                            boolean bl6 = false;
                            boolean bl7 = false;
                            SqlTypeElement it2 = sqlTypeElement2;
                            boolean bl8 = false;
                            $this$stubbedOrBuild.setMovingStateType((DataType)it2);
                        }
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)iElementType2, (Object)PgTypes.PG_SSPACE)) {
                        Float f = this.findNumberInSiblings(it);
                        $this$stubbedOrBuild.setStateSize(f != null ? (long)f.floatValue() : 0L);
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)iElementType2, (Object)PgTypes.PG_MSSPACE)) {
                        Float f = this.findNumberInSiblings(it);
                        $this$stubbedOrBuild.setMovingStateSize(f != null ? (long)f.floatValue() : 0L);
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)iElementType2, (Object)PgTypes.PG_MFINALFUNC)) {
                        PgGPlumBaseObjectBuilder.Reference reference = this.findFunctionReference(it);
                        $this$stubbedOrBuild.setMovingFinal(reference != null ? reference.getFullName() : null);
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)iElementType2, (Object)PgTypes.PG_MFINALFUNC_EXTRA)) {
                        $this$stubbedOrBuild.setMovingFinalExtra(true);
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)iElementType2, (Object)PgTypes.PG_MINITCOND)) {
                        String string = this.findString(it);
                        if (string == null) {
                            Float f = this.findNumberInSiblings(it);
                            string = f != null ? String.valueOf((int)f.floatValue()) : null;
                        }
                        $this$stubbedOrBuild.setMovingInitialValue(string);
                        continue;
                    }
                    if (!Intrinsics.areEqual((Object)iElementType2, (Object)PgTypes.PG_PARALLEL)) continue;
                    $this$stubbedOrBuild.setConcurrencyKind(this.findConcurrencyKind(it));
                }
            }
            basicElement = basicElement3;
        }
        PgAggregate stubbed = (PgAggregate)basicElement;
        obj2.setCombine(stubbed.getCombine());
        obj2.setSerialization(stubbed.getSerialization());
        obj2.setDeserialization(stubbed.getDeserialization());
        obj2.setFinalExtra(stubbed.isFinalExtra());
        obj2.setMovingTransition(stubbed.getMovingTransition());
        obj2.setInverseTransition(stubbed.getInverseTransition());
        obj2.setMovingStateType(stubbed.getMovingStateType());
        obj2.setStateSize(stubbed.getStateSize());
        obj2.setMovingStateSize(stubbed.getMovingStateSize());
        obj2.setMovingFinal(stubbed.getMovingFinal());
        obj2.setMovingFinalExtra(stubbed.isMovingFinalExtra());
        obj2.setMovingInitialValue(stubbed.getMovingInitialValue());
        obj2.setConcurrencyKind(stubbed.getConcurrencyKind());
    }

    /*
     * WARNING - void declaration
     */
    private final void buildRole(PgRole obj2, DasObject source, SqlObjectBuilder.Context context) {
        PgRole stubbed;
        BasicElement basicElement;
        void $this$stubbed$iv;
        super.buildRole(obj2, source, context);
        DasObject dasObject = source;
        SqlObjectBuilderImpl this_$iv = this;
        boolean $i$f$stubbed2 = false;
        void var8_10 = $this$stubbed$iv;
        if (var8_10 instanceof PgRole) {
            basicElement = (BasicElement)$this$stubbed$iv;
        } else if (var8_10 instanceof SqlStubbedElement) {
            StubElement stubElement = ((SqlStubbedElement)$this$stubbed$iv).getGreenStub();
            if (!(stubElement instanceof SqlDefinitionStub)) {
                stubElement = null;
            }
            SqlDefinitionStub sqlDefinitionStub = (SqlDefinitionStub)stubElement;
            Object object = sqlDefinitionStub != null ? sqlDefinitionStub.getElement() : null;
            if (!(object instanceof PgRole)) {
                object = null;
            }
            basicElement = (BasicElement)((PgRole)object);
        } else {
            basicElement = null;
        }
        if ((stubbed = (PgRole)basicElement) != null) {
            obj2.setReplication(stubbed.isReplication());
            obj2.setBypassRls(stubbed.isBypassRls());
        } else {
            void this_$iv2;
            boolean isReplication = false;
            boolean isBypassRls = false;
            SqlObjectBuilderImpl $i$f$stubbed2 = this;
            DasObject dasObject2 = source;
            if (!(dasObject2 instanceof SqlCreateStatement)) {
                dasObject2 = null;
            }
            PsiElement el$iv = (PsiElement)((SqlCreateStatement)dasObject2);
            boolean $i$f$forEachChild = false;
            void var10_13 = this_$iv2;
            PsiElement psiElement = el$iv;
            PsiElement first$iv$iv = psiElement != null ? psiElement.getFirstChild() : null;
            boolean $i$f$forEachSibling = false;
            for (PsiElement tmp$iv$iv = first$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                PsiElement it = tmp$iv$iv;
                boolean bl = false;
                if (!(it instanceof SqlClause)) continue;
                PsiElement c = ((SqlClause)it).getFirstChild();
                IElementType iElementType = PsiTreeUtilKt.getElementType((PsiElement)c);
                if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_REPLICATION)) {
                    isReplication = true;
                    continue;
                }
                if (!Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_BYPASSRLS)) continue;
                isBypassRls = true;
            }
            obj2.setReplication(isReplication);
            obj2.setBypassRls(isBypassRls);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void buildRoutine(PgRoutine obj2, DasObject source, SqlObjectBuilder.Context context) {
        PgRoutine stubbed;
        BasicElement basicElement;
        void $this$stubbed$iv;
        super.buildRoutine(obj2, source, context);
        DasObject dasObject = source;
        SqlObjectBuilderImpl this_$iv = this;
        boolean $i$f$stubbed = false;
        void var8_7 = $this$stubbed$iv;
        if (var8_7 instanceof PgRoutine) {
            basicElement = (BasicElement)$this$stubbed$iv;
        } else if (var8_7 instanceof SqlStubbedElement) {
            StubElement stubElement = ((SqlStubbedElement)$this$stubbed$iv).getGreenStub();
            if (!(stubElement instanceof SqlDefinitionStub)) {
                stubElement = null;
            }
            SqlDefinitionStub sqlDefinitionStub = (SqlDefinitionStub)stubElement;
            Object object = sqlDefinitionStub != null ? sqlDefinitionStub.getElement() : null;
            if (!(object instanceof PgRoutine)) {
                object = null;
            }
            basicElement = (BasicElement)((PgRoutine)object);
        } else {
            basicElement = null;
        }
        if ((stubbed = (PgRoutine)basicElement) != null) {
            obj2.setConcurrencyKind(stubbed.getConcurrencyKind());
            obj2.setWindow(stubbed.isWindow());
            obj2.setRows(stubbed.getRows());
        } else {
            void this_$iv2;
            ArrayList<String> assignments = new ArrayList<String>();
            PgRoutineConcurrencyKind concurrencyKind = PgRoutineConcurrencyKind.UNSAFE;
            boolean isWindow = false;
            float rows = 0.0f;
            boolean isSet = false;
            SqlObjectBuilderImpl sqlObjectBuilderImpl = this;
            DasObject dasObject2 = source;
            if (!(dasObject2 instanceof SqlCreateProcedureStatement)) {
                dasObject2 = null;
            }
            PsiElement el$iv = (PsiElement)((SqlCreateProcedureStatement)dasObject2);
            boolean $i$f$forEachChild = false;
            void var13_14 = this_$iv2;
            PsiElement psiElement = el$iv;
            PsiElement first$iv$iv = psiElement != null ? psiElement.getFirstChild() : null;
            boolean $i$f$forEachSibling = false;
            for (PsiElement tmp$iv$iv = first$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                IElementType iElementType;
                PsiElement s;
                PsiElement it = tmp$iv$iv;
                boolean bl = false;
                PsiElement psiElement2 = s = it.getFirstChild();
                Object object = iElementType = psiElement2 != null ? PsiTreeUtilKt.getElementType((PsiElement)psiElement2) : null;
                if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_SET)) {
                    SqlObjectBuilderImpl this_$iv3 = this;
                    boolean $i$f$forEachSibling2 = false;
                    for (PsiElement tmp$iv = s; tmp$iv != null; tmp$iv = tmp$iv.getNextSibling()) {
                        PsiElement it2 = tmp$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)it2), (Object)PgTypes.PG_SET_ASSIGNMENT)) continue;
                        assignments.add(it2.getText());
                    }
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_PARALLEL)) {
                    PsiElement psiElement3 = s;
                    Intrinsics.checkNotNullExpressionValue((Object)psiElement3, (String)"s");
                    concurrencyKind = this.findConcurrencyKind(psiElement3);
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_WINDOW)) {
                    isWindow = true;
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_SECURITY) || Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_ROWS)) {
                    Float f = this.findNumberInSiblings(s);
                    rows = f != null ? f.floatValue() : 0.0f;
                    continue;
                }
                if (!Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_RETURNS)) continue;
                SqlCompositeElementType sqlCompositeElementType = SqlCompositeElementTypes.SQL_TYPE_ELEMENT;
                Intrinsics.checkNotNullExpressionValue((Object)sqlCompositeElementType, (String)"SQL_TYPE_ELEMENT");
                PsiElement psiElement4 = this.findChild(it, (IElementType)sqlCompositeElementType);
                isSet = Intrinsics.areEqual((Object)(psiElement4 != null && (psiElement4 = psiElement4.getFirstChild()) != null ? PsiTreeUtilKt.getElementType((PsiElement)psiElement4) : null), (Object)PgTypes.PG_SETOF);
            }
            obj2.setConcurrencyKind(concurrencyKind);
            obj2.setWindow(isWindow);
            obj2.setRows(rows == 0.0f && isSet ? 1000.0f : rows);
        }
    }

    private final PgRoutineConcurrencyKind findConcurrencyKind(PsiElement element) {
        SqlObjectBuilderImpl this_$iv = this;
        boolean $i$f$forEachSibling = false;
        for (PsiElement tmp$iv = element; tmp$iv != null; tmp$iv = tmp$iv.getNextSibling()) {
            PsiElement it = tmp$iv;
            boolean bl = false;
            ASTNode aSTNode = it.getNode();
            Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"it.node");
            IElementType iElementType = aSTNode.getElementType();
            if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_SAFE)) {
                return PgRoutineConcurrencyKind.SAFE;
            }
            if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_RESTRICTED)) {
                return PgRoutineConcurrencyKind.RESTRICTED;
            }
            if (!Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_UNSAFE)) continue;
            return PgRoutineConcurrencyKind.UNSAFE;
        }
        return PgRoutineConcurrencyKind.UNSAFE;
    }

    public static final /* synthetic */ SimpleCompositeText access$getViewQuery(PgObjectBuilder $this, DasObject source, CompositeText.Kind kind) {
        return $this.getViewQuery(source, kind);
    }
}

