/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle.plan;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dialects.base.plan.AbstractExplainPlanProvider;
import com.intellij.database.dialects.base.plan.AbstractPlanModelBuilder;
import com.intellij.database.dialects.oracle.plan.OraPlanModelBuilder;
import com.intellij.database.script.ScriptModel;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.Version;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.sql.psi.SqlParameter;
import org.jetbrains.annotations.NotNull;

public class OraExplainPlanProvider
extends AbstractExplainPlanProvider {
    public OraExplainPlanProvider() {
        super(Dbms.ORACLE);
    }

    @NotNull
    public <V> ScriptModel<V> adjustModel(@NotNull ScriptModel<V> model) {
        if (model == null) {
            OraExplainPlanProvider.$$$reportNull$$$0(0);
        }
        ScriptModel scriptModel = model.rawTransform(st -> {
            SyntaxTraverser.Api api = st.api;
            return (SyntaxTraverser)st.forceIgnore(v2 -> {
                if (!(v2 instanceof SqlParameter)) {
                    return false;
                }
                CharSequence text = api.textOf(v2);
                return text.equals("?") || StringUtil.startsWith((CharSequence)text, (CharSequence)":");
            });
        });
        if (scriptModel == null) {
            OraExplainPlanProvider.$$$reportNull$$$0(1);
        }
        return scriptModel;
    }

    @Override
    public AbstractPlanModelBuilder<?, ?> createBuilder(@NotNull Version version, boolean run2) {
        if (version == null) {
            OraExplainPlanProvider.$$$reportNull$$$0(2);
        }
        return new OraPlanModelBuilder();
    }

    public DdlBuilder sqlExplainPlan(@NotNull LocalDataSource dataSource, @NotNull DdlBuilder builder, @NotNull String statement, boolean analyze) throws UnsupportedOperationException, IllegalArgumentException {
        if (dataSource == null) {
            OraExplainPlanProvider.$$$reportNull$$$0(3);
        }
        if (builder == null) {
            OraExplainPlanProvider.$$$reportNull$$$0(4);
        }
        if (statement == null) {
            OraExplainPlanProvider.$$$reportNull$$$0(5);
        }
        if (analyze) {
            throw new UnsupportedOperationException("Oracle does not support EXPLAIN ANALYZE");
        }
        String uid = AbstractPlanModelBuilder.randomShorterUUID();
        builder.keywords(new String[]{"explain", "plan"}).space().keyword("set").space().plain("statement_id").symbol("=").symbol("'").plain(uid).symbol("'").space().keyword("for").space().plain(statement).newStatement();
        builder.keyword("select").space().symbol("*").space().keyword("from").space().keyword("table").symbol("(").plain("DBMS_XPLAN.DISPLAY").symbol("(").symbol("'").plain("PLAN_TABLE").symbol("'").symbol(",").symbol("'").plain(uid).symbol("'").symbol(")").symbol(")");
        return builder;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/oracle/plan/OraExplainPlanProvider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/oracle/plan/OraExplainPlanProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "adjustModel";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createBuilder";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "sqlExplainPlan";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

