/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle.model;

import com.intellij.database.dialects.oracle.model.OraPackage;
import com.intellij.database.dialects.oracle.model.OraRoot;
import com.intellij.database.dialects.oracle.model.OraSchema;
import com.intellij.database.model.DasUserDefinedType;
import com.intellij.database.model.DataType;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicMixinElement;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OraModelUtils {
    private OraModelUtils() {
    }

    @Nullable
    public static DasUserDefinedType findTypeInPackage(@NotNull OraPackage pack2, @NotNull String name2) {
        DasUserDefinedType type;
        if (pack2 == null) {
            OraModelUtils.$$$reportNull$$$0(0);
        }
        if (name2 == null) {
            OraModelUtils.$$$reportNull$$$0(1);
        }
        if ((type = (DasUserDefinedType)pack2.getAliasTypes().get(name2)) == null) {
            type = (DasUserDefinedType)pack2.getCollectionTypes().get(name2);
        }
        return type;
    }

    @Nullable
    public static DasUserDefinedType findTypeInSchema(@NotNull OraSchema schema, @NotNull String name2) {
        DasUserDefinedType type;
        if (schema == null) {
            OraModelUtils.$$$reportNull$$$0(2);
        }
        if (name2 == null) {
            OraModelUtils.$$$reportNull$$$0(3);
        }
        if ((type = (DasUserDefinedType)schema.getObjectTypes().get(name2)) == null) {
            type = (DasUserDefinedType)schema.getCollectionTypes().get(name2);
        }
        return type;
    }

    @Nullable
    public static DasUserDefinedType resolveDataType(@NotNull DataType dataType, @NotNull BasicElement context) {
        String parentName;
        if (dataType == null) {
            OraModelUtils.$$$reportNull$$$0(4);
        }
        if (context == null) {
            OraModelUtils.$$$reportNull$$$0(5);
        }
        String name2 = dataType.typeName;
        String packageName = dataType.packageName;
        String schemaName = dataType.schemaName;
        if (StringUtil.isNotEmpty((String)schemaName) && StringUtil.isNotEmpty((String)packageName)) {
            OraSchema schema = (OraSchema)((OraRoot)BasicMixinElement.parent((BasicElement)context, OraRoot.class)).getSchemas().get(schemaName);
            if (schema == null) {
                return null;
            }
            OraPackage pack2 = (OraPackage)schema.getPackages().get(packageName);
            if (pack2 == null) {
                return null;
            }
            return OraModelUtils.findTypeInPackage(pack2, name2);
        }
        String string = parentName = StringUtil.isNotEmpty((String)schemaName) ? schemaName : packageName;
        if (StringUtil.isNotEmpty((String)parentName)) {
            DasUserDefinedType superType;
            OraPackage pack3 = (OraPackage)((OraSchema)BasicMixinElement.parent((BasicElement)context, OraSchema.class)).getPackages().get(parentName);
            DasUserDefinedType dasUserDefinedType = superType = pack3 != null ? OraModelUtils.findTypeInPackage(pack3, name2) : null;
            if (superType == null) {
                OraSchema schema = (OraSchema)((OraRoot)BasicMixinElement.parent((BasicElement)context, OraRoot.class)).getSchemas().get(parentName);
                superType = schema != null ? OraModelUtils.findTypeInSchema(schema, name2) : null;
            }
            return superType;
        }
        OraPackage currentPack = (OraPackage)BasicMixinElement.parent((BasicElement)context, OraPackage.class);
        DasUserDefinedType superType = OraModelUtils.findTypeInPackage(currentPack, name2);
        if (superType == null) {
            superType = OraModelUtils.findTypeInSchema((OraSchema)BasicMixinElement.parent((BasicElement)currentPack, OraSchema.class), name2);
        }
        return superType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pack";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schema";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataType";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/dialects/oracle/model/OraModelUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findTypeInPackage";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "findTypeInSchema";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "resolveDataType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

