/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle.model;

import com.intellij.database.dialects.oracle.model.OraMajorObject;
import com.intellij.database.dialects.oracle.model.OraModel;
import com.intellij.database.dialects.oracle.model.OraRoot;
import com.intellij.database.dialects.oracle.model.OraSequence;
import com.intellij.database.dialects.oracle.model.OraTable;
import com.intellij.database.dialects.oracle.model.OraTableColumn;
import com.intellij.database.model.basic.BasicIdentifiedElement;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;

public interface OraMixinSequence
extends OraMajorObject {
    public static final Pattern HOSTED_NAME_PATTERN = Pattern.compile("^ISEQ\\$\\$_(\\d+)$");

    @Nullable
    default public OraTableColumn getHostTableColumn() {
        OraTable table = this.getHostTable();
        if (table == null) {
            return null;
        }
        for (OraTableColumn column2 : table.getColumns()) {
            if (!column2.isAutoInc()) continue;
            return column2;
        }
        return null;
    }

    @Nullable
    default public OraTable getHostTable() {
        int id = this.getHostTableId();
        if (id == 0) {
            return null;
        }
        OraModel model = (OraModel)this.getModel();
        OraRoot root2 = model.getRoot();
        BasicIdentifiedElement element = root2.findIdentifiedElement(id);
        return element instanceof OraTable ? (OraTable)element : null;
    }

    default public int getHostTableId() {
        String name2 = this.getRealName();
        if (name2 == null) {
            return 0;
        }
        Matcher m = HOSTED_NAME_PATTERN.matcher(name2);
        boolean ok = m.matches();
        if (!ok) {
            return 0;
        }
        String idStr = m.group(1);
        try {
            return Integer.parseInt(idStr);
        }
        catch (NumberFormatException e2) {
            return 0;
        }
    }

    default public boolean isBelongsToDroppedTable() {
        OraSequence sequence = (OraSequence)this;
        return sequence.isBelongsToColumn() && this.getHostTable() == null;
    }
}

