/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle.generator.producers;

import com.intellij.database.dialects.base.generator.BaseProducer;
import com.intellij.database.dialects.base.generator.ScriptingContext;
import com.intellij.database.dialects.oracle.generator.OraNamingService;
import com.intellij.database.dialects.oracle.introspector.OraIntrospectorSourcesHelperKt;
import com.intellij.database.dialects.oracle.model.OraDbLink;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.script.CompositeText;
import com.intellij.database.script.generator.CodeTextBuilder;
import com.intellij.database.script.generator.ScriptingOptionStatic;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"HEX_PATTERN_32p", "Lkotlin/text/Regex;", "produceCode", "", "producer", "Lcom/intellij/database/dialects/base/generator/BaseProducer;", "dbLink", "Lcom/intellij/database/dialects/oracle/model/OraDbLink;", "create", "", "quotePassword", "", "pwd", "intellij.database.dialects.oracle"})
public final class OraDbLinkProducersKt {
    private static final Regex HEX_PATTERN_32p = new Regex("^[0-9A-Fa-f]{32,}");

    /*
     * WARNING - void declaration
     */
    private static final void produceCode(BaseProducer producer, OraDbLink dbLink, boolean create) {
        String string;
        String shared;
        BaseProducer baseProducer = producer;
        boolean bl = false;
        boolean bl2 = false;
        BaseProducer $this$apply = baseProducer;
        boolean bl3 = false;
        String keyword = create ? "create" : "alter";
        boolean isPublic = Intrinsics.areEqual((Object)dbLink.getSchemaName(), (Object)"PUBLIC");
        String string2 = isPublic ? "public" : null;
        String string3 = shared = dbLink.isShared() ? "shared" : null;
        if (isPublic) {
            void $this$scr$iv;
            String string4 = dbLink.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"dbLink.name");
            String string5 = string4;
            BaseProducer this_$iv = $this$apply;
            boolean $i$f$getScr = false;
            string = this_$iv.getContext().getNaming().nameToScript((String)$this$scr$iv, null, false, ((SqlCodeStyleSettings)this_$iv.getOptions().get(ScriptingOptionStatic.CODE_STYLE)).getQuotesPriority());
        } else {
            string = BaseProducer.currentScopeName$default($this$apply, (BasicElement)dbLink, null, 1, null);
        }
        String name2 = string;
        $this$apply.newCoding((Function1<? super ScriptingContext.NewCodingAdapter, Unit>)((Function1)new Function1<ScriptingContext.NewCodingAdapter, Unit>(keyword, shared, string2, name2, create, dbLink){
            final /* synthetic */ String $keyword;
            final /* synthetic */ String $shared;
            final /* synthetic */ String $public;
            final /* synthetic */ String $name;
            final /* synthetic */ boolean $create$inlined;
            final /* synthetic */ OraDbLink $dbLink$inlined;
            {
                this.$keyword = string;
                this.$shared = string2;
                this.$public = string3;
                this.$name = string4;
                this.$create$inlined = bl;
                this.$dbLink$inlined = oraDbLink;
                super(1);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke(@NotNull ScriptingContext.NewCodingAdapter $this$newCoding) {
                Intrinsics.checkNotNullParameter((Object)$this$newCoding, (String)"$receiver");
                $this$newCoding.getBuilder().phrase(new CharSequence[]{this.$keyword, this.$shared, this.$public, "database link", this.$name});
                CodeTextBuilder this_$iv = $this$newCoding.getBuilder();
                boolean $i$f$indenting = false;
                CodeTextBuilder.indent$default((CodeTextBuilder)this_$iv, null, (int)1, null);
                try {
                    boolean bl = false;
                    ScriptingContext.NewCodingAdapter this_$iv2 = $this$newCoding;
                    boolean nl$iv = true;
                    boolean $i$f$withNewLines = false;
                    boolean prev$iv = this_$iv2.getStartWithNewLine();
                    this_$iv2.setStartWithNewLine(nl$iv);
                    boolean bl2 = false;
                    String connectUserPassword = this.$dbLink$inlined.getConnectUserPassword();
                    StringBuilder stringBuilder = new StringBuilder().append("identified by ");
                    String string = connectUserPassword;
                    if (string == null) {
                        string = "?";
                    }
                    String identPhrase = stringBuilder.append(OraDbLinkProducersKt.access$quotePassword(string)).toString();
                    String userName = this.$dbLink$inlined.getConnectUserName();
                    if (this.$dbLink$inlined.isShared() || userName != null) {
                        if (Intrinsics.areEqual((Object)userName, (Object)"CURRENT_USER")) {
                            $this$newCoding.unaryPlus("connect to current_user");
                        } else {
                            ScriptingContext.NewCodingAdapter this_$iv3 = $this$newCoding;
                            boolean $i$f$orError = false;
                            $this$newCoding.plus($this$newCoding.plus($this$newCoding.unaryPlus("connect to"), (Function0<? extends Object>)((Function0)new Function0<Unit>(this_$iv3, userName){
                                final /* synthetic */ ScriptingContext.NewCodingAdapter this$0;
                                final /* synthetic */ String $text;
                                {
                                    this.this$0 = newCodingAdapter;
                                    this.$text = string;
                                    super(0);
                                }

                                public final void invoke() {
                                    if (this.$text != null) {
                                        ScriptingContext.NewCodingAdapter.appendSimple$default(this.this$0, this.$text, null, null, 6, null);
                                    } else {
                                        CompositeText.Kind kind = null;
                                        CharSequence charSequence = "???";
                                        ScriptingContext.NewCodingAdapter newCodingAdapter = this.this$0;
                                        boolean bl = false;
                                        String string = "user name must be specified";
                                        ScriptingContext.NewCodingAdapter.appendSimple$default(newCodingAdapter, charSequence, kind, string, 2, null);
                                    }
                                }
                            })), identPhrase);
                        }
                    }
                    if (this.$dbLink$inlined.isShared()) {
                        String authUserPassword = this.$dbLink$inlined.getAuthUserPassword();
                        StringBuilder stringBuilder2 = new StringBuilder().append("identified by ");
                        String string2 = authUserPassword;
                        if (string2 == null) {
                            string2 = "?";
                        }
                        String identPhrase2 = stringBuilder2.append(OraDbLinkProducersKt.access$quotePassword(string2)).toString();
                        String userName2 = this.$dbLink$inlined.getAuthUserName();
                        ScriptingContext.NewCodingAdapter this_$iv4 = $this$newCoding;
                        boolean $i$f$orError = false;
                        $this$newCoding.plus($this$newCoding.plus($this$newCoding.unaryPlus("authenticated by"), (Function0<? extends Object>)((Function0)new Function0<Unit>(this_$iv4, userName2){
                            final /* synthetic */ ScriptingContext.NewCodingAdapter this$0;
                            final /* synthetic */ String $text;
                            {
                                this.this$0 = newCodingAdapter;
                                this.$text = string;
                                super(0);
                            }

                            public final void invoke() {
                                if (this.$text != null) {
                                    ScriptingContext.NewCodingAdapter.appendSimple$default(this.this$0, this.$text, null, null, 6, null);
                                } else {
                                    CompositeText.Kind kind = null;
                                    CharSequence charSequence = "???";
                                    ScriptingContext.NewCodingAdapter newCodingAdapter = this.this$0;
                                    boolean bl = false;
                                    String string = "user name must be specified when the DB link is shared";
                                    ScriptingContext.NewCodingAdapter.appendSimple$default(newCodingAdapter, charSequence, kind, string, 2, null);
                                }
                            }
                        })), identPhrase2);
                    }
                    if (this.$create$inlined) {
                        String string3 = this.$dbLink$inlined.getRemoteDatabaseString();
                        String remoteDatabaseString = string3 != null ? OraIntrospectorSourcesHelperKt.quoteAsOraLiteral(string3) : null;
                        ScriptingContext.NewCodingAdapter this_$iv5 = $this$newCoding;
                        boolean $i$f$orError = false;
                        $this$newCoding.plus($this$newCoding.unaryPlus("using"), (Function0<? extends Object>)((Function0)new Function0<Unit>(this_$iv5, remoteDatabaseString){
                            final /* synthetic */ ScriptingContext.NewCodingAdapter this$0;
                            final /* synthetic */ String $text;
                            {
                                this.this$0 = newCodingAdapter;
                                this.$text = string;
                                super(0);
                            }

                            public final void invoke() {
                                if (this.$text != null) {
                                    ScriptingContext.NewCodingAdapter.appendSimple$default(this.this$0, this.$text, null, null, 6, null);
                                } else {
                                    CompositeText.Kind kind = null;
                                    CharSequence charSequence = "???";
                                    ScriptingContext.NewCodingAdapter newCodingAdapter = this.this$0;
                                    boolean bl = false;
                                    String string = "a TNS alias of the remote database must be specified";
                                    ScriptingContext.NewCodingAdapter.appendSimple$default(newCodingAdapter, charSequence, kind, string, 2, null);
                                }
                            }
                        }));
                    }
                    this_$iv2.setStartWithNewLine(prev$iv);
                }
                finally {
                    this_$iv.unindent();
                }
            }
        }));
    }

    private static final String quotePassword(String pwd) {
        String string;
        if (Intrinsics.areEqual((Object)pwd, (Object)"?")) {
            string = pwd;
        } else if (StringsKt.startsWith$default((CharSequence)pwd, (char)':', (boolean)false, (int)2, null)) {
            string = pwd;
        } else {
            CharSequence charSequence = pwd;
            Regex regex = HEX_PATTERN_32p;
            boolean bl = false;
            string = regex.matches(charSequence) ? "values '" + pwd + '\'' : (OraNamingService.INSTANCE.isPlain(pwd, true) ? pwd : OraIntrospectorSourcesHelperKt.quoteAsOraLiteral(pwd));
        }
        return string;
    }

    public static final /* synthetic */ void access$produceCode(BaseProducer producer, OraDbLink dbLink, boolean create) {
        OraDbLinkProducersKt.produceCode(producer, dbLink, create);
    }

    public static final /* synthetic */ String access$quotePassword(String pwd) {
        return OraDbLinkProducersKt.quotePassword(pwd);
    }
}

