/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle.generator;

import com.intellij.database.dialects.oracle.model.OraArgument;
import com.intellij.database.dialects.oracle.model.OraCollectionType;
import com.intellij.database.dialects.oracle.model.OraCollectionTypeBase;
import com.intellij.database.dialects.oracle.model.OraPackage;
import com.intellij.database.dialects.oracle.model.OraPackageCollectionType;
import com.intellij.database.dialects.oracle.model.OraRoot;
import com.intellij.database.dialects.oracle.model.OraRoutine;
import com.intellij.database.dialects.oracle.model.OraSchema;
import com.intellij.database.dialects.oracle.model.properties.OraCollectionTypeKind;
import com.intellij.database.model.ArgumentDirection;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DataType;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicMixinElement;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.families.ModNamingIdentifyingFamily;
import com.intellij.database.model.families.ModPositioningNamingFamily;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.Version;
import com.intellij.openapi.util.Condition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 (2\u00020\u0001:\u0005()*+,B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0014\u001a\u00020\u0007H\u0002J\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00070\nJ\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00070\nJ\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00070\nJ\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00070\nJ\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\n2\u0006\u0010\u001b\u001a\u00020\u001cJ\b\u0010\u001d\u001a\u0004\u0018\u00010\u0007J\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\n2\u0006\u0010\u0014\u001a\u00020\u0007H\u0002J\u0010\u0010 \u001a\u00020!2\u0006\u0010\u0014\u001a\u00020\u0007H\u0002J\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00070\nJ\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00070\nJ\u0010\u0010$\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0007H\u0002J\u0010\u0010%\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0007H\u0002J\u0010\u0010&\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0007H\u0002J\u0010\u0010'\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0007H\u0002R\u001c\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000f\u001a\u00020\u0010*\u00020\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0012\u00a8\u0006-"}, d2={"Lcom/intellij/database/dialects/oracle/generator/OraRoutineArgumentsAnalyzer;", "", "routine", "Lcom/intellij/database/dialects/oracle/model/OraRoutine;", "(Lcom/intellij/database/dialects/oracle/model/OraRoutine;)V", "kinds", "", "Lcom/intellij/database/dialects/oracle/model/OraArgument;", "Lcom/intellij/database/dialects/oracle/model/properties/OraCollectionTypeKind;", "outs", "", "getOuts", "()Ljava/util/List;", "outs$delegate", "Lkotlin/Lazy;", "isReturn", "", "Lcom/intellij/database/model/ArgumentDirection;", "(Lcom/intellij/database/model/ArgumentDirection;)Z", "findKindOfType", "argument", "getAssociativeArrayArguments", "getCursorArguments", "getPlTypeArrayArguments", "getPlTypeNestedTableArguments", "getPrimitives", "Lcom/intellij/database/dialects/oracle/generator/OraRoutineArgumentsAnalyzer$PrimitivesPack;", "version", "Lcom/intellij/database/util/Version;", "getReturnArgument", "getSchemasToSearch", "", "getScope", "Lcom/intellij/database/dialects/oracle/generator/OraRoutineArgumentsAnalyzer$Scope;", "getSqlTypeArrayArguments", "getSqlTypeNestedTableArguments", "isArray", "isAssociativeArray", "isNestedTable", "isRefCursor", "Companion", "PackageScope", "PrimitivesPack", "SchemaScope", "Scope", "intellij.database.dialects.oracle"})
public final class OraRoutineArgumentsAnalyzer {
    private final Lazy outs$delegate;
    private final Map<OraArgument, OraCollectionTypeKind> kinds;
    private final OraRoutine routine;
    public static final Companion Companion = new Companion(null);

    private final List<OraArgument> getOuts() {
        Lazy lazy = this.outs$delegate;
        OraRoutineArgumentsAnalyzer oraRoutineArgumentsAnalyzer = this;
        Object var3_3 = null;
        boolean bl = false;
        return (List)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<OraArgument> getCursorArguments() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.getOuts();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            OraArgument it = (OraArgument)element$iv$iv;
            boolean bl = false;
            if (!this.isRefCursor(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<OraArgument> getAssociativeArrayArguments() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.getOuts();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            OraArgument it = (OraArgument)element$iv$iv;
            boolean bl = false;
            if (!(!this.isRefCursor(it) && this.isAssociativeArray(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<OraArgument> getSqlTypeArrayArguments() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.getOuts();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            OraArgument it = (OraArgument)element$iv$iv;
            boolean bl = false;
            if (!(!this.isRefCursor(it) && Companion.isSqlTypeArgument(it) && this.isArray(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<OraArgument> getPlTypeArrayArguments() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.getOuts();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            OraArgument it = (OraArgument)element$iv$iv;
            boolean bl = false;
            if (!(!this.isRefCursor(it) && !Companion.isSqlTypeArgument(it) && this.isArray(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<OraArgument> getSqlTypeNestedTableArguments() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.getOuts();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            OraArgument it = (OraArgument)element$iv$iv;
            boolean bl = false;
            if (!(!this.isRefCursor(it) && Companion.isSqlTypeArgument(it) && this.isNestedTable(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<OraArgument> getPlTypeNestedTableArguments() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.getOuts();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            OraArgument it = (OraArgument)element$iv$iv;
            boolean bl = false;
            if (!(!this.isRefCursor(it) && !Companion.isSqlTypeArgument(it) && this.isNestedTable(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<PrimitivesPack> getPrimitives(@NotNull Version version) {
        void $this$mapTo$iv$iv;
        Object key$iv$iv;
        Map $this$groupByTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Sequence $this$groupBy$iv = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)this.getOuts()), (Function1)((Function1)new Function1<OraArgument, Boolean>(this){
            final /* synthetic */ OraRoutineArgumentsAnalyzer this$0;

            public final boolean invoke(@NotNull OraArgument it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return !OraRoutineArgumentsAnalyzer.access$isRefCursor(this.this$0, it) && !OraRoutineArgumentsAnalyzer.access$isArray(this.this$0, it) && !OraRoutineArgumentsAnalyzer.access$isAssociativeArray(this.this$0, it) && !OraRoutineArgumentsAnalyzer.access$isNestedTable(this.this$0, it);
            }
            {
                this.this$0 = oraRoutineArgumentsAnalyzer;
                super(1);
            }
        }));
        boolean $i$f$groupBy = false;
        Sequence sequence = $this$groupBy$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        Iterator iterator = $this$groupByTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object object;
            Object element$iv$iv = iterator.next();
            OraArgument it = (OraArgument)element$iv$iv;
            boolean bl = false;
            key$iv$iv = Companion.isSqlTypeArgument(it);
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map $this$map$iv = destination$iv$iv;
        boolean $i$f$map = false;
        $this$groupByTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        iterator = $this$mapTo$iv$iv;
        boolean bl = false;
        for (Map.Entry item$iv$iv : iterator.entrySet()) {
            void it;
            key$iv$iv = item$iv$iv;
            Object object = destination$iv$iv;
            boolean bl3 = false;
            PrimitivesPack primitivesPack = new PrimitivesPack((Boolean)it.getKey() != false || Companion.supportPlTypesInSql(version), (List)it.getValue());
            object.add(primitivesPack);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public final OraArgument getReturnArgument() {
        Object v1;
        block1: {
            Iterable iterable = this.getOuts();
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                OraArgument it = (OraArgument)t;
                boolean bl3 = false;
                ArgumentDirection argumentDirection = it.getArgumentDirection();
                Intrinsics.checkNotNullExpressionValue((Object)argumentDirection, (String)"it.argumentDirection");
                if (!this.isReturn(argumentDirection)) continue;
                v1 = t;
                break block1;
            }
            v1 = null;
        }
        return v1;
    }

    private final boolean isReturn(ArgumentDirection $this$isReturn) {
        return $this$isReturn == ArgumentDirection.RETURN;
    }

    private final boolean isRefCursor(OraArgument argument) {
        return StringsKt.equals((String)argument.getDataType().typeName, (String)"ref cursor", (boolean)true);
    }

    private final boolean isAssociativeArray(OraArgument argument) {
        return this.findKindOfType(argument) == OraCollectionTypeKind.ASSOCIATIVE_ARRAY;
    }

    private final boolean isArray(OraArgument argument) {
        return this.findKindOfType(argument) == OraCollectionTypeKind.VARIABLE_SIZE_ARRAY;
    }

    private final boolean isNestedTable(OraArgument argument) {
        return this.findKindOfType(argument) == OraCollectionTypeKind.NESTED_TABLE;
    }

    /*
     * WARNING - void declaration
     */
    private final OraCollectionTypeKind findKindOfType(OraArgument argument) {
        OraCollectionTypeKind oraCollectionTypeKind;
        if (this.kinds.containsKey(argument)) {
            oraCollectionTypeKind = this.kinds.get(argument);
        } else {
            void var2_2;
            OraCollectionTypeBase oraCollectionTypeBase = this.getScope(argument).search(argument);
            OraCollectionTypeKind typeKind = oraCollectionTypeBase != null ? oraCollectionTypeBase.getTypeKind() : null;
            this.kinds.put(argument, typeKind);
            oraCollectionTypeKind = var2_2;
        }
        return oraCollectionTypeKind;
    }

    private final Scope getScope(OraArgument argument) {
        Scope scope;
        List<String> schemas2 = this.getSchemasToSearch(argument);
        DataType dataType = argument.getDataType();
        Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"argument.dataType");
        DataType dataType2 = dataType;
        if (dataType2.packageName == null) {
            String string = dataType2.typeName;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"dataType.typeName");
            scope = new SchemaScope(schemas2, string);
        } else {
            String string = dataType2.typeName;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"dataType.typeName");
            String string2 = dataType2.packageName;
            Intrinsics.checkNotNull((Object)string2);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"dataType.packageName!!");
            scope = new PackageScope(schemas2, string, string2);
        }
        return scope;
    }

    private final List<String> getSchemasToSearch(OraArgument argument) {
        List list;
        DataType dataType = argument.getDataType();
        Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"argument.dataType");
        DataType dataType2 = dataType;
        if (dataType2.schemaName != null) {
            String string = dataType2.schemaName;
            Intrinsics.checkNotNull((Object)string);
            list = CollectionsKt.listOf((Object)string);
        } else {
            Object[] objectArray = new String[2];
            BasicSchema basicSchema = argument.getSchema();
            objectArray[0] = basicSchema != null ? basicSchema.getName() : null;
            objectArray[1] = "PUBLIC";
            list = CollectionsKt.listOfNotNull((Object[])objectArray);
        }
        return list;
    }

    public OraRoutineArgumentsAnalyzer(@NotNull OraRoutine routine2) {
        Intrinsics.checkNotNullParameter((Object)routine2, (String)"routine");
        this.routine = routine2;
        this.outs$delegate = LazyKt.lazy((Function0)((Function0)new Function0<List<? extends OraArgument>>(this){
            final /* synthetic */ OraRoutineArgumentsAnalyzer this$0;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<OraArgument> invoke() {
                void $this$filterTo$iv$iv;
                ModPositioningNamingFamily<? extends OraArgument> modPositioningNamingFamily = OraRoutineArgumentsAnalyzer.access$getRoutine$p(this.this$0).getArguments();
                Intrinsics.checkNotNullExpressionValue(modPositioningNamingFamily, (String)"routine.arguments");
                Iterable $this$filter$iv = (Iterable)modPositioningNamingFamily;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    ArgumentDirection direction;
                    OraArgument it = (OraArgument)element$iv$iv;
                    boolean bl = false;
                    OraArgument oraArgument = it;
                    Intrinsics.checkNotNullExpressionValue((Object)oraArgument, (String)"it");
                    Intrinsics.checkNotNullExpressionValue((Object)oraArgument.getArgumentDirection(), (String)"it.argumentDirection");
                    boolean bl2 = direction.isOut() || OraRoutineArgumentsAnalyzer.access$isReturn$p(this.this$0, direction);
                    if (!bl2) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                return (List)destination$iv$iv;
            }
            {
                this.this$0 = oraRoutineArgumentsAnalyzer;
                super(0);
            }
        }));
        this.kinds = new HashMap();
    }

    public static final /* synthetic */ boolean access$isRefCursor(OraRoutineArgumentsAnalyzer $this, OraArgument argument) {
        return $this.isRefCursor(argument);
    }

    public static final /* synthetic */ boolean access$isArray(OraRoutineArgumentsAnalyzer $this, OraArgument argument) {
        return $this.isArray(argument);
    }

    public static final /* synthetic */ boolean access$isAssociativeArray(OraRoutineArgumentsAnalyzer $this, OraArgument argument) {
        return $this.isAssociativeArray(argument);
    }

    public static final /* synthetic */ boolean access$isNestedTable(OraRoutineArgumentsAnalyzer $this, OraArgument argument) {
        return $this.isNestedTable(argument);
    }

    public static final /* synthetic */ OraRoutine access$getRoutine$p(OraRoutineArgumentsAnalyzer $this) {
        return $this.routine;
    }

    public static final /* synthetic */ boolean access$isReturn$p(OraRoutineArgumentsAnalyzer $this, ArgumentDirection $this$access_u24isReturn_u24p) {
        return $this.isReturn($this$access_u24isReturn_u24p);
    }

    @JvmStatic
    public static final boolean supportPlTypesInSql(@NotNull Version version) {
        return Companion.supportPlTypesInSql(version);
    }

    @JvmStatic
    public static final boolean isSqlTypeArgument(@NotNull OraArgument argument) {
        return Companion.isSqlTypeArgument(argument);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bb\u0018\u00002\u00020\u0001J\u0012\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/intellij/database/dialects/oracle/generator/OraRoutineArgumentsAnalyzer$Scope;", "", "search", "Lcom/intellij/database/dialects/oracle/model/OraCollectionTypeBase;", "argument", "Lcom/intellij/database/dialects/oracle/model/OraArgument;", "intellij.database.dialects.oracle"})
    private static interface Scope {
        @Nullable
        public OraCollectionTypeBase search(@NotNull OraArgument var1);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0012\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0004H\u0014J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/database/dialects/oracle/generator/OraRoutineArgumentsAnalyzer$SchemaScope;", "Lcom/intellij/database/dialects/oracle/generator/OraRoutineArgumentsAnalyzer$Scope;", "schemas", "", "", "typeName", "(Ljava/util/List;Ljava/lang/String;)V", "findInSchema", "Lcom/intellij/database/dialects/oracle/model/OraCollectionTypeBase;", "schema", "Lcom/intellij/database/dialects/oracle/model/OraSchema;", "search", "argument", "Lcom/intellij/database/dialects/oracle/model/OraArgument;", "intellij.database.dialects.oracle"})
    private static class SchemaScope
    implements Scope {
        private final List<String> schemas;
        private final String typeName;

        @Override
        @Nullable
        public OraCollectionTypeBase search(@NotNull OraArgument argument) {
            Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
            return (OraCollectionTypeBase)Companion.inSchema(argument, (Function1)new Function1<OraSchema, OraCollectionTypeBase>(this){
                final /* synthetic */ SchemaScope this$0;

                @Nullable
                public final OraCollectionTypeBase invoke(@NotNull OraSchema schema) {
                    Object v0;
                    boolean bl;
                    Iterable iterable;
                    block3: {
                        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
                        iterable = SchemaScope.access$getSchemas$p(this.this$0);
                        bl = false;
                        Iterable iterable2 = iterable;
                        boolean bl2 = false;
                        for (T t : iterable2) {
                            String it = (String)t;
                            boolean bl3 = false;
                            if (!com.intellij.database.dialects.oracle.generator.OraRoutineArgumentsAnalyzer$Companion.access$nameCondition(OraRoutineArgumentsAnalyzer.Companion, it, schema).value((Object)schema)) continue;
                            v0 = t;
                            break block3;
                        }
                        v0 = null;
                    }
                    String foundOrNot = v0;
                    if (foundOrNot == null) {
                        iterable = SchemaScope.access$getSchemas$p(this.this$0);
                        bl = false;
                        if (!iterable.isEmpty()) {
                            return null;
                        }
                    }
                    return this.this$0.findInSchema(schema, SchemaScope.access$getTypeName$p(this.this$0));
                }
                {
                    this.this$0 = schemaScope;
                    super(1);
                }
            });
        }

        @Nullable
        protected OraCollectionTypeBase findInSchema(@NotNull OraSchema schema, @NotNull String typeName) {
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            Intrinsics.checkNotNullParameter((Object)typeName, (String)"typeName");
            Condition condition = Companion.nameCondition(typeName, schema);
            return (OraCollectionTypeBase)schema.getCollectionTypes().find((Predicate)new Predicate<OraCollectionType>(condition){
                final /* synthetic */ Condition $condition;

                public final boolean test(OraCollectionType it) {
                    return this.$condition.value((Object)it);
                }
                {
                    this.$condition = condition;
                }
            });
        }

        public SchemaScope(@NotNull List<String> schemas2, @NotNull String typeName) {
            Intrinsics.checkNotNullParameter(schemas2, (String)"schemas");
            Intrinsics.checkNotNullParameter((Object)typeName, (String)"typeName");
            this.schemas = schemas2;
            this.typeName = typeName;
        }

        public static final /* synthetic */ List access$getSchemas$p(SchemaScope $this) {
            return $this.schemas;
        }

        public static final /* synthetic */ String access$getTypeName$p(SchemaScope $this) {
            return $this.typeName;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B#\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0007J\u001a\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0004H\u0014R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/database/dialects/oracle/generator/OraRoutineArgumentsAnalyzer$PackageScope;", "Lcom/intellij/database/dialects/oracle/generator/OraRoutineArgumentsAnalyzer$SchemaScope;", "schemas", "", "", "typeName", "packageName", "(Ljava/util/List;Ljava/lang/String;Ljava/lang/String;)V", "findInSchema", "Lcom/intellij/database/dialects/oracle/model/OraCollectionTypeBase;", "schema", "Lcom/intellij/database/dialects/oracle/model/OraSchema;", "intellij.database.dialects.oracle"})
    private static final class PackageScope
    extends SchemaScope {
        private final String packageName;

        @Override
        @Nullable
        protected OraCollectionTypeBase findInSchema(@NotNull OraSchema schema, @NotNull String typeName) {
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            Intrinsics.checkNotNullParameter((Object)typeName, (String)"typeName");
            Condition packageCondition = Companion.nameCondition(this.packageName, schema);
            OraPackage oraPackage = (OraPackage)schema.getPackages().find((Predicate)new Predicate<OraPackage>(packageCondition){
                final /* synthetic */ Condition $packageCondition;

                public final boolean test(OraPackage it) {
                    return this.$packageCondition.value((Object)it);
                }
                {
                    this.$packageCondition = condition;
                }
            });
            if (oraPackage == null) {
                return null;
            }
            OraPackage pack2 = oraPackage;
            Condition typeCondition = Companion.nameCondition(typeName, schema);
            return (OraCollectionTypeBase)pack2.getCollectionTypes().find((Predicate)new Predicate<OraPackageCollectionType>(typeCondition){
                final /* synthetic */ Condition $typeCondition;

                public final boolean test(OraPackageCollectionType it) {
                    return this.$typeCondition.value((Object)it);
                }
                {
                    this.$typeCondition = condition;
                }
            });
        }

        public PackageScope(@NotNull List<String> schemas2, @NotNull String typeName, @NotNull String packageName) {
            Intrinsics.checkNotNullParameter(schemas2, (String)"schemas");
            Intrinsics.checkNotNullParameter((Object)typeName, (String)"typeName");
            Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
            super(schemas2, typeName);
            this.packageName = packageName;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00032\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/intellij/database/dialects/oracle/generator/OraRoutineArgumentsAnalyzer$PrimitivesPack;", "", "enabled", "", "arguments", "", "Lcom/intellij/database/dialects/oracle/model/OraArgument;", "(ZLjava/util/List;)V", "getArguments", "()Ljava/util/List;", "getEnabled", "()Z", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "intellij.database.dialects.oracle"})
    public static final class PrimitivesPack {
        private final boolean enabled;
        @NotNull
        private final List<OraArgument> arguments;

        public final boolean getEnabled() {
            return this.enabled;
        }

        @NotNull
        public final List<OraArgument> getArguments() {
            return this.arguments;
        }

        public PrimitivesPack(boolean enabled, @NotNull List<? extends OraArgument> arguments) {
            Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
            this.enabled = enabled;
            this.arguments = arguments;
        }

        public final boolean component1() {
            return this.enabled;
        }

        @NotNull
        public final List<OraArgument> component2() {
            return this.arguments;
        }

        @NotNull
        public final PrimitivesPack copy(boolean enabled, @NotNull List<? extends OraArgument> arguments) {
            Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
            return new PrimitivesPack(enabled, arguments);
        }

        public static /* synthetic */ PrimitivesPack copy$default(PrimitivesPack primitivesPack, boolean bl, List list, int n, Object object) {
            if ((n & 1) != 0) {
                bl = primitivesPack.enabled;
            }
            if ((n & 2) != 0) {
                list = primitivesPack.arguments;
            }
            return primitivesPack.copy(bl, list);
        }

        @NotNull
        public String toString() {
            return "PrimitivesPack(enabled=" + this.enabled + ", arguments=" + this.arguments + ")";
        }

        public int hashCode() {
            int n = this.enabled ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            List<OraArgument> list = this.arguments;
            return n * 31 + (list != null ? ((Object)list).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof PrimitivesPack)) break block3;
                    PrimitivesPack primitivesPack = (PrimitivesPack)object;
                    if (this.enabled != primitivesPack.enabled || !Intrinsics.areEqual(this.arguments, primitivesPack.arguments)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J3\u0010\u0003\u001a\u0004\u0018\u0001H\u0004\"\u0004\b\u0000\u0010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0014\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u0001H\u00040\bH\u0002\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J*\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\u00040\u000e\"\b\b\u0000\u0010\u0004*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\tH\u0002J\u0010\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0007\u00a8\u0006\u0016"}, d2={"Lcom/intellij/database/dialects/oracle/generator/OraRoutineArgumentsAnalyzer$Companion;", "", "()V", "inSchema", "T", "argument", "Lcom/intellij/database/dialects/oracle/model/OraArgument;", "processor", "Lkotlin/Function1;", "Lcom/intellij/database/dialects/oracle/model/OraSchema;", "(Lcom/intellij/database/dialects/oracle/model/OraArgument;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "isSqlTypeArgument", "", "nameCondition", "Lcom/intellij/openapi/util/Condition;", "Lcom/intellij/database/model/DasObject;", "name", "", "schema", "supportPlTypesInSql", "version", "Lcom/intellij/database/util/Version;", "intellij.database.dialects.oracle"})
    public static final class Companion {
        @JvmStatic
        public final boolean supportPlTypesInSql(@NotNull Version version) {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            return version.isOrGreater(new int[]{12, 1});
        }

        @JvmStatic
        public final boolean isSqlTypeArgument(@NotNull OraArgument argument) {
            Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
            return argument.getDataType().packageName == null;
        }

        private final <T> T inSchema(OraArgument argument, Function1<? super OraSchema, ? extends T> processor) {
            BasicModModel basicModModel = (BasicModModel)argument.getModel();
            Object object = basicModModel != null ? basicModModel.getRoot() : null;
            if (!(object instanceof OraRoot)) {
                object = null;
            }
            OraRoot oraRoot = (OraRoot)object;
            if (oraRoot == null) {
                return null;
            }
            OraRoot root2 = oraRoot;
            ModNamingIdentifyingFamily<? extends OraSchema> modNamingIdentifyingFamily = root2.getSchemas();
            Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily, (String)"root.schemas");
            Iterable $this$forEach$iv = (Iterable)modNamingIdentifyingFamily;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                OraSchema it = (OraSchema)element$iv;
                boolean bl = false;
                OraSchema oraSchema = it;
                Intrinsics.checkNotNullExpressionValue((Object)oraSchema, (String)"it");
                Object foundMaybe = processor.invoke((Object)oraSchema);
                if (foundMaybe == null) continue;
                return (T)foundMaybe;
            }
            return null;
        }

        private final <T extends DasObject> Condition<T> nameCondition(String name2, OraSchema schema) {
            CasingProvider casingProvider = BasicMixinElement.getCasingProvider((BasicElement)((BasicElement)schema));
            if (casingProvider == null) {
                casingProvider = DasUtil.NO_CASING_PROVIDER;
            }
            Condition condition = DasUtil.byName((String)name2, (CasingProvider)casingProvider);
            Intrinsics.checkNotNullExpressionValue((Object)condition, (String)"DasUtil.byName<T>(name, \u2026sUtil.NO_CASING_PROVIDER)");
            return condition;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

