/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle.debugger;

import com.intellij.database.dialects.oracle.model.OraTrigger;
import com.intellij.database.model.basic.BasicSourceAware;
import com.intellij.database.script.CompositeText;
import java.util.Map;
import java.util.WeakHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u0007H\u0002J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u000e\u001a\u00020\b2\b\u0010\n\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000f\u001a\u00020\bJ\u0010\u0010\u0010\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\bH\u0002J\u0018\u0010\u0011\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\bH\u0002J\u0018\u0010\u0012\u001a\u00020\b2\b\u0010\n\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0013\u001a\u00020\bJ\u0010\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\bH\u0002J\u0018\u0010\u0015\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\bH\u0002J\u0010\u0010\u0016\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u0007H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/database/dialects/oracle/debugger/OraProgramLineMapper;", "", "()V", "lock", "Ljava/lang/Object;", "skips", "Ljava/util/WeakHashMap;", "Lcom/intellij/database/model/basic/BasicSourceAware;", "", "calculateSkip", "programObject", "calculateSkipForTrigger", "trigger", "Lcom/intellij/database/dialects/oracle/model/OraTrigger;", "mapFileToOra", "fileLine", "mapFileToOraForRegularProgram", "mapFileToOraForTrigger", "mapOraToFile", "oraLine", "mapOraToFileForRegularProgram", "mapOraToFileForTrigger", "obtainSkip", "intellij.database.dialects.oracle"})
public final class OraProgramLineMapper {
    private final WeakHashMap<BasicSourceAware, Integer> skips = new WeakHashMap(4);
    private final Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int obtainSkip(BasicSourceAware programObject) {
        Object object = this.lock;
        boolean bl = false;
        int n = 0;
        synchronized (object) {
            boolean bl2 = false;
            Integer skip = this.skips.get(programObject);
            if (skip == null) {
                skip = this.calculateSkip(programObject);
                ((Map)this.skips).put(programObject, skip);
            }
            n = skip;
        }
        return n;
    }

    private final int calculateSkip(BasicSourceAware programObject) {
        BasicSourceAware basicSourceAware = programObject;
        return basicSourceAware instanceof OraTrigger ? this.calculateSkipForTrigger((OraTrigger)programObject) : 0;
    }

    private final int calculateSkipForTrigger(OraTrigger trigger) {
        Object v1;
        Object object2;
        CompositeText source;
        block4: {
            CompositeText compositeText = trigger.getSourceText();
            if (compositeText == null) {
                return 0;
            }
            Intrinsics.checkNotNullExpressionValue((Object)compositeText, (String)"trigger.sourceText ?: return 0");
            source = compositeText;
            Iterable iterable = source.getFragments();
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object object2 : iterable2) {
                CompositeText.Fragment it = (CompositeText.Fragment)object2;
                boolean bl3 = false;
                if (!it.getKind().getContent()) continue;
                v1 = object2;
                break block4;
            }
            v1 = null;
        }
        CompositeText.Fragment fragment = v1;
        if (fragment == null) {
            return 0;
        }
        CompositeText.Fragment content = fragment;
        int offset = content.getBegin();
        CharSequence $this$count$iv = source.getText().subSequence(0, offset);
        boolean $i$f$count = false;
        int count$iv = 0;
        object2 = $this$count$iv;
        for (int j = 0; j < object2.length(); ++j) {
            char element$iv;
            char c = element$iv = object2.charAt(j);
            boolean bl = false;
            if (!(c == '\n')) continue;
            ++count$iv;
        }
        int lineBreaks = count$iv;
        return Integer.max(lineBreaks - 1, 0);
    }

    public final int mapOraToFile(@Nullable BasicSourceAware programObject, int oraLine) {
        if (oraLine <= 0) {
            return -1;
        }
        BasicSourceAware basicSourceAware = programObject;
        return basicSourceAware instanceof OraTrigger ? this.mapOraToFileForTrigger((OraTrigger)programObject, oraLine) : this.mapOraToFileForRegularProgram(oraLine);
    }

    private final int mapOraToFileForTrigger(OraTrigger trigger, int oraLine) {
        if (oraLine == 1) {
            return 0;
        }
        int skipped = this.obtainSkip((BasicSourceAware)trigger);
        int shiftedLine = oraLine + skipped;
        return shiftedLine - 1;
    }

    private final int mapOraToFileForRegularProgram(int oraLine) {
        return oraLine - 1;
    }

    public final int mapFileToOra(@Nullable BasicSourceAware programObject, int fileLine) {
        if (fileLine < 0) {
            return 0;
        }
        BasicSourceAware basicSourceAware = programObject;
        return basicSourceAware instanceof OraTrigger ? this.mapFileToOraForTrigger((OraTrigger)programObject, fileLine) : this.mapFileToOraForRegularProgram(fileLine);
    }

    private final int mapFileToOraForTrigger(OraTrigger trigger, int fileLine) {
        if (fileLine == 0) {
            return 1;
        }
        int skipped = this.obtainSkip((BasicSourceAware)trigger);
        int shiftedLine = Integer.max(fileLine - skipped, 1);
        return shiftedLine + 1;
    }

    private final int mapFileToOraForRegularProgram(int fileLine) {
        return fileLine + 1;
    }
}

