/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle.debugger;

import com.intellij.database.dialects.oracle.debugger.SteppingMode;
import com.intellij.database.model.ModelFun;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import java.io.Serializable;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="OraDebuggerSettings", storages={@Storage(value="debugger.xml")})
@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002:\u0001\u0016B\u0005\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0011\u001a\u00020\u0000H\u0014J\b\u0010\u0012\u001a\u00020\u0003H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0003H\u0016R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0017"}, d2={"Lcom/intellij/database/dialects/oracle/debugger/OraDebuggerSettings;", "", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lcom/intellij/database/dialects/oracle/debugger/OraDebuggerSettings$CompatibleState;", "()V", "steppingMode", "Lcom/intellij/database/dialects/oracle/debugger/SteppingMode;", "getSteppingMode", "()Lcom/intellij/database/dialects/oracle/debugger/SteppingMode;", "setSteppingMode", "(Lcom/intellij/database/dialects/oracle/debugger/SteppingMode;)V", "steppingPauseAtBegin", "", "getSteppingPauseAtBegin", "()Z", "setSteppingPauseAtBegin", "(Z)V", "clone", "getState", "loadState", "", "state", "CompatibleState", "intellij.database.dialects.oracle"})
public final class OraDebuggerSettings
implements Cloneable,
PersistentStateComponent<CompatibleState> {
    @NotNull
    private SteppingMode steppingMode = SteppingMode.STEPPING_GRACEFUL;
    private boolean steppingPauseAtBegin;

    @NotNull
    public final SteppingMode getSteppingMode() {
        return this.steppingMode;
    }

    public final void setSteppingMode(@NotNull SteppingMode steppingMode) {
        Intrinsics.checkNotNullParameter((Object)((Object)steppingMode), (String)"<set-?>");
        this.steppingMode = steppingMode;
    }

    public final boolean getSteppingPauseAtBegin() {
        return this.steppingPauseAtBegin;
    }

    public final void setSteppingPauseAtBegin(boolean bl) {
        this.steppingPauseAtBegin = bl;
    }

    @NotNull
    public CompatibleState getState() {
        return new CompatibleState(this.steppingMode == SteppingMode.STEPPING_NATIVE, this.steppingPauseAtBegin);
    }

    public void loadState(@NotNull CompatibleState state2) {
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        this.steppingMode = (SteppingMode)((Object)ModelFun.choose((boolean)state2.steppingNative, (Object)((Object)SteppingMode.STEPPING_NATIVE), (Object)((Object)SteppingMode.STEPPING_GRACEFUL)));
        this.steppingPauseAtBegin = state2.steppingPauseAtBegin;
    }

    @NotNull
    public OraDebuggerSettings clone() {
        OraDebuggerSettings newOne = new OraDebuggerSettings();
        newOne.steppingMode = this.steppingMode;
        newOne.steppingPauseAtBegin = this.steppingPauseAtBegin;
        return newOne;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\u0006\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\u00032\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001R\u0012\u0010\u0002\u001a\u00020\u00038\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0004\u001a\u00020\u00038\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/database/dialects/oracle/debugger/OraDebuggerSettings$CompatibleState;", "Ljava/io/Serializable;", "steppingNative", "", "steppingPauseAtBegin", "(ZZ)V", "component1", "component2", "copy", "equals", "other", "", "hashCode", "", "toString", "", "intellij.database.dialects.oracle"})
    public static final class CompatibleState
    implements Serializable {
        @JvmField
        public boolean steppingNative;
        @JvmField
        public boolean steppingPauseAtBegin;

        public CompatibleState(boolean steppingNative, boolean steppingPauseAtBegin) {
            this.steppingNative = steppingNative;
            this.steppingPauseAtBegin = steppingPauseAtBegin;
        }

        public /* synthetic */ CompatibleState(boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                bl = false;
            }
            if ((n & 2) != 0) {
                bl2 = false;
            }
            this(bl, bl2);
        }

        public CompatibleState() {
            this(false, false, 3, null);
        }

        public final boolean component1() {
            return this.steppingNative;
        }

        public final boolean component2() {
            return this.steppingPauseAtBegin;
        }

        @NotNull
        public final CompatibleState copy(boolean steppingNative, boolean steppingPauseAtBegin) {
            return new CompatibleState(steppingNative, steppingPauseAtBegin);
        }

        public static /* synthetic */ CompatibleState copy$default(CompatibleState compatibleState, boolean bl, boolean bl2, int n, Object object) {
            if ((n & 1) != 0) {
                bl = compatibleState.steppingNative;
            }
            if ((n & 2) != 0) {
                bl2 = compatibleState.steppingPauseAtBegin;
            }
            return compatibleState.copy(bl, bl2);
        }

        @NotNull
        public String toString() {
            return "CompatibleState(steppingNative=" + this.steppingNative + ", steppingPauseAtBegin=" + this.steppingPauseAtBegin + ")";
        }

        public int hashCode() {
            int n = this.steppingNative ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            int n2 = n * 31;
            int n3 = this.steppingPauseAtBegin ? 1 : 0;
            if (n3 != 0) {
                n3 = 1;
            }
            return n2 + n3;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof CompatibleState)) break block3;
                    CompatibleState compatibleState = (CompatibleState)object;
                    if (this.steppingNative != compatibleState.steppingNative || this.steppingPauseAtBegin != compatibleState.steppingPauseAtBegin) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

