/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle.debugger;

import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.connection.DGDepartment;
import com.intellij.database.dataSource.connection.DatabaseDepartment;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.debugger.SqlDebugController;
import com.intellij.database.debugger.SqlDebugProcess;
import com.intellij.database.debugger.SqlProgramPosition;
import com.intellij.database.debugger.SqlProgramSource;
import com.intellij.database.debugger.SqlProgramSourceKt;
import com.intellij.database.dialects.oracle.debugger.CodeFlowFragmentInfo;
import com.intellij.database.dialects.oracle.debugger.ColumnFragmentInfo;
import com.intellij.database.dialects.oracle.debugger.DebugCommand;
import com.intellij.database.dialects.oracle.debugger.DebuggerUnableException;
import com.intellij.database.dialects.oracle.debugger.DeregisterBreakpointCommand;
import com.intellij.database.dialects.oracle.debugger.EvaluateExpressionCommand;
import com.intellij.database.dialects.oracle.debugger.ExecuteFragmentCommand;
import com.intellij.database.dialects.oracle.debugger.FragmentInfo;
import com.intellij.database.dialects.oracle.debugger.GracefulResumeCommand;
import com.intellij.database.dialects.oracle.debugger.GracefulRunToPositionInProgramCommand;
import com.intellij.database.dialects.oracle.debugger.GracefulRunToPositionInScriptCommand;
import com.intellij.database.dialects.oracle.debugger.GracefulStepOutCommand;
import com.intellij.database.dialects.oracle.debugger.GracefulStepOverCommand;
import com.intellij.database.dialects.oracle.debugger.OraConnectionHelperKt;
import com.intellij.database.dialects.oracle.debugger.OraDebugController;
import com.intellij.database.dialects.oracle.debugger.OraDebugController$OraDebugProcess$WhenMappings;
import com.intellij.database.dialects.oracle.debugger.OraDebugController$WhenMappings;
import com.intellij.database.dialects.oracle.debugger.OraDebugController$sam$java_lang_Runnable$0;
import com.intellij.database.dialects.oracle.debugger.OraDebuggerFacade;
import com.intellij.database.dialects.oracle.debugger.OraDebuggingAbortedException;
import com.intellij.database.dialects.oracle.debugger.OraDebuggingSession;
import com.intellij.database.dialects.oracle.debugger.OraExecutingSession;
import com.intellij.database.dialects.oracle.debugger.OraFragmentAnalyzer;
import com.intellij.database.dialects.oracle.debugger.OraLineBreakpointProperties;
import com.intellij.database.dialects.oracle.debugger.OraLineBreakpointType;
import com.intellij.database.dialects.oracle.debugger.OraPosition;
import com.intellij.database.dialects.oracle.debugger.OraProgramLineMapper;
import com.intellij.database.dialects.oracle.debugger.OraProgramPosition;
import com.intellij.database.dialects.oracle.debugger.OraProgramPositionFile;
import com.intellij.database.dialects.oracle.debugger.OraProgramSources;
import com.intellij.database.dialects.oracle.debugger.OraRealLineBreakpoint;
import com.intellij.database.dialects.oracle.debugger.OraScriptPosition;
import com.intellij.database.dialects.oracle.debugger.OraStack;
import com.intellij.database.dialects.oracle.debugger.OraUnknownPosition;
import com.intellij.database.dialects.oracle.debugger.OraVariableFinder;
import com.intellij.database.dialects.oracle.debugger.OracleDebugHelper;
import com.intellij.database.dialects.oracle.debugger.PauseCommand;
import com.intellij.database.dialects.oracle.debugger.PauseReason;
import com.intellij.database.dialects.oracle.debugger.ProblematicResult;
import com.intellij.database.dialects.oracle.debugger.ProcessState;
import com.intellij.database.dialects.oracle.debugger.RegisterBreakpointCommand;
import com.intellij.database.dialects.oracle.debugger.Result;
import com.intellij.database.dialects.oracle.debugger.ResumeCommand;
import com.intellij.database.dialects.oracle.debugger.RunToPositionCommand;
import com.intellij.database.dialects.oracle.debugger.ScalarExpressionFragmentInfo;
import com.intellij.database.dialects.oracle.debugger.StepIntoCommand;
import com.intellij.database.dialects.oracle.debugger.StepOutCommand;
import com.intellij.database.dialects.oracle.debugger.StepOverCommand;
import com.intellij.database.dialects.oracle.debugger.SteppingMode;
import com.intellij.database.dialects.oracle.debugger.StopCommand;
import com.intellij.database.dialects.oracle.debugger.SuccessfulResult;
import com.intellij.database.dialects.oracle.debugger.UnknownFragmentInfo;
import com.intellij.database.model.ModelFun;
import com.intellij.database.model.basic.BasicSourceAware;
import com.intellij.database.util.GuardedRef;
import com.intellij.database.util.SearchPath;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.FUCounterUsageLogger;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpointHandler;
import com.intellij.xdebugger.breakpoints.XBreakpointListener;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XSuspendContext;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.XValuePlace;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0088\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0017\u0018\u0000 v2\u00020\u0001:\tvwxyz{|}~BE\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\u0002\u0010\u0010J\b\u0010D\u001a\u00020EH\u0016J\b\u0010F\u001a\u00020EH\u0016J\b\u0010G\u001a\u00020EH\u0016J\u001a\u0010H\u001a\u00020E2\u0010\u0010I\u001a\f\u0012\u0004\u0012\u00020-0,j\u0002`JH\u0002J\b\u0010K\u001a\u00020EH\u0002J\u0010\u0010L\u001a\u00020E2\u0006\u0010:\u001a\u00020;H\u0002J\u0016\u0010M\u001a\u00020E2\f\u00107\u001a\b\u0012\u0004\u0012\u00020'0NH\u0002J\b\u0010O\u001a\u00020EH\u0016J\u0016\u0010P\u001a\u00020E2\f\u0010Q\u001a\b\u0012\u0004\u0012\u00020E0RH\u0002J\u0010\u0010S\u001a\u00020T2\u0006\u0010B\u001a\u00020UH\u0016J\u0010\u0010V\u001a\u00020E2\u0006\u0010W\u001a\u00020\u0014H\u0016J\u000e\u0010X\u001a\u00020E2\u0006\u0010Y\u001a\u00020ZJ\b\u0010[\u001a\u00020EH\u0002J\b\u0010\\\u001a\u00020EH\u0002J\u0010\u0010]\u001a\u00020E2\u0006\u0010:\u001a\u00020;H\u0002J\u001e\u0010^\u001a\u00020E2\f\u00107\u001a\b\u0012\u0004\u0012\u00020'0N2\u0006\u0010:\u001a\u00020;H\u0002J\b\u0010_\u001a\u00020\u0014H\u0002J\u0016\u0010`\u001a\u00020a2\f\u0010b\u001a\b\u0012\u0004\u0012\u00020'0NH\u0002J\b\u0010c\u001a\u00020EH\u0002J\b\u0010d\u001a\u00020EH\u0002J\"\u0010e\u001a\u00020E2\u0006\u0010f\u001a\u00020$2\u0006\u0010g\u001a\u00020h2\b\b\u0002\u0010i\u001a\u00020\tH\u0002J\u0018\u0010j\u001a\u00020E2\u0006\u0010k\u001a\u00020$2\u0006\u0010l\u001a\u00020$H\u0002J\u001a\u0010m\u001a\u00020E2\u0010\u0010I\u001a\f\u0012\u0004\u0012\u00020-0,j\u0002`JH\u0002J\u0010\u0010n\u001a\u00020E2\u0006\u0010:\u001a\u00020;H\u0002J\b\u0010o\u001a\u00020EH\u0002J\b\u0010p\u001a\u00020EH\u0002J\b\u0010q\u001a\u00020EH\u0002J\u0018\u0010r\u001a\u00020E2\u0006\u0010s\u001a\u00020;2\u0006\u0010t\u001a\u00020;H\u0002J\u0010\u0010u\u001a\u00020E2\u0006\u0010l\u001a\u00020$H\u0002R\u000e\u0010\u0011\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082.\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0019\u001a\u00060\u001aR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010 \u001a\u00070!\u00a2\u0006\u0002\b\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010#\u001a\u0004\u0018\u00010$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010&\u001a\u0004\u0018\u00010'X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010(\u001a\u00060)R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010*\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020-0,\u0012\u0004\u0012\u00020.0+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u000200X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00102\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00103\u001a\u000204X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00105\u001a\u000206X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00107\u001a\u0004\u0018\u000108X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00109\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010:\u001a\u00020;8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b<\u0010=R\u000e\u0010>\u001a\u00020?X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010@\u001a\u00020AX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010B\u001a\u00020CX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u007f"}, d2={"Lcom/intellij/database/dialects/oracle/debugger/OraDebugController;", "Lcom/intellij/database/debugger/SqlDebugController;", "project", "Lcom/intellij/openapi/project/Project;", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "consoleRequestOwner", "Lcom/intellij/database/datagrid/DataRequest$OwnerEx;", "scriptIsMeaningful", "", "scriptVirtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "scriptRangeMarker", "Lcom/intellij/openapi/editor/RangeMarker;", "searchPath", "Lcom/intellij/database/util/SearchPath;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/database/dataSource/LocalDataSource;Lcom/intellij/database/datagrid/DataRequest$OwnerEx;ZLcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/editor/RangeMarker;Lcom/intellij/database/util/SearchPath;)V", "beginning", "debuggingConnectionRef", "Lcom/intellij/database/util/GuardedRef;", "Lcom/intellij/database/dataSource/DatabaseConnection;", "debuggingSession", "Lcom/intellij/database/dialects/oracle/debugger/OraDebuggingSession;", "debuggingThread", "Ljava/lang/Thread;", "evaluator", "Lcom/intellij/database/dialects/oracle/debugger/OraDebugController$Evaluator;", "executingSession", "Lcom/intellij/database/dialects/oracle/debugger/OraExecutingSession;", "fragmentAnalyzer", "Lcom/intellij/database/dialects/oracle/debugger/OraFragmentAnalyzer;", "fusFinishSent", "fusLogger", "Lcom/intellij/internal/statistic/service/fus/collectors/FUCounterUsageLogger;", "Lorg/jetbrains/annotations/NotNull;", "initializationProblem", "", "initialized", "lastPosition", "Lcom/intellij/database/dialects/oracle/debugger/OraPosition;", "lineBreakpointHandler", "Lcom/intellij/database/dialects/oracle/debugger/OraDebugController$OraLineBreakpointHandler;", "lineBreakpoints", "", "Lcom/intellij/xdebugger/breakpoints/XLineBreakpoint;", "Lcom/intellij/database/dialects/oracle/debugger/OraLineBreakpointProperties;", "Lcom/intellij/database/dialects/oracle/debugger/OraRealLineBreakpoint;", "lineMapper", "Lcom/intellij/database/dialects/oracle/debugger/OraProgramLineMapper;", "pauseAtBegin", "requestOwner", "scriptFirstLineNr", "", "sources", "Lcom/intellij/database/dialects/oracle/debugger/OraProgramSources;", "stack", "Lcom/intellij/database/dialects/oracle/debugger/OraStack;", "startingUp", "state", "Lcom/intellij/database/dialects/oracle/debugger/ProcessState;", "getState", "()Lcom/intellij/database/dialects/oracle/debugger/ProcessState;", "steppingMode", "Lcom/intellij/database/dialects/oracle/debugger/SteppingMode;", "variableFinder", "Lcom/intellij/database/dialects/oracle/debugger/OraVariableFinder;", "xSession", "Lcom/intellij/xdebugger/impl/XDebugSessionImpl;", "close", "", "debugBegin", "debugEnd", "deregisterLineBreakpoint", "xbp", "Lcom/intellij/database/dialects/oracle/debugger/OraXLineBreakpoint;", "doOnStart", "doStateTransition", "doUpdateUI", "", "getReady", "inUI", "what", "Lkotlin/Function0;", "initLocal", "Lcom/intellij/xdebugger/XDebugProcess;", "Lcom/intellij/xdebugger/XDebugSession;", "initRemote", "executingConnection", "issueCommand", "command", "Lcom/intellij/database/dialects/oracle/debugger/DebugCommand;", "kickOffFinishing", "kickOffMainLoop", "mainLoopIteration", "notifyUpdateUI", "obtainDebuggingConnection", "obtainSuspendContext", "Lcom/intellij/xdebugger/frame/XSuspendContext;", "stackPositions", "performFinishing", "performMainLoop", "print", "text", "contentType", "Lcom/intellij/execution/ui/ConsoleViewContentType;", "eoln", "printTrace", "sourceName", "message", "registerLineBreakpoint", "reportFinished", "reset", "retrieveAdditionalData", "retrieveVariables", "stateTransition", "oldState", "newState", "trace", "Companion", "EmptySuspendedContext", "ErrorValue", "Evaluator", "OkValue", "OraDebugProcess", "OraLineBreakpointHandler", "ScalarValue", "SuspendedContext", "intellij.database.dialects.oracle"})
public final class OraDebugController
extends SqlDebugController {
    private final FUCounterUsageLogger fusLogger;
    private boolean fusFinishSent;
    private final Project project;
    private final LocalDataSource dataSource;
    private final DataRequest.OwnerEx requestOwner;
    private final OraProgramLineMapper lineMapper;
    private final SteppingMode steppingMode;
    private final boolean scriptIsMeaningful;
    private final VirtualFile scriptVirtualFile;
    private final RangeMarker scriptRangeMarker;
    private XDebugSessionImpl xSession;
    private OraExecutingSession executingSession;
    private OraDebuggingSession debuggingSession;
    private Thread debuggingThread;
    private boolean initialized;
    private String initializationProblem;
    private GuardedRef<DatabaseConnection> debuggingConnectionRef;
    private int scriptFirstLineNr;
    private final OraLineBreakpointHandler lineBreakpointHandler;
    private final Map<XLineBreakpoint<OraLineBreakpointProperties>, OraRealLineBreakpoint> lineBreakpoints;
    private final OraProgramSources sources;
    private final OraVariableFinder variableFinder;
    private final OraFragmentAnalyzer fragmentAnalyzer;
    private OraStack stack;
    private OraPosition lastPosition;
    private boolean startingUp;
    private boolean beginning;
    private boolean pauseAtBegin;
    private final Evaluator evaluator;
    @NotNull
    public static final String fusGroupId = "database.oracle.debug";
    @NotNull
    public static final String fusStartedEventId = "started";
    @NotNull
    public static final String fusFinishedEventId = "finished";
    @NotNull
    public static final String fusSteppingModeKey = "stepping-mode";
    public static final int fusSteppingModeGraceful = 1;
    public static final int fusSteppingModeNative = 2;
    @NotNull
    public static final String fusSteppingPauseAtBeginKey = "stepping-pauseAtBegin";
    @NotNull
    public static final String fusResultStateKey = "result-state";
    private static final OraLineBreakpointType xbpType;
    public static final Companion Companion;

    private final ProcessState getState() {
        ProcessState processState;
        if (this.debuggingSession != null) {
            OraDebuggingSession oraDebuggingSession = this.debuggingSession;
            if (oraDebuggingSession == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"debuggingSession");
            }
            processState = oraDebuggingSession.getState();
        } else {
            processState = ProcessState.STATE_ASLEEP;
        }
        return processState;
    }

    private final void reset() {
        this.stack = null;
        this.startingUp = false;
        this.fusFinishSent = false;
        this.pauseAtBegin = OraDebuggerFacade.Companion.getSettings$intellij_database_dialects_oracle().getSteppingPauseAtBegin();
        this.lastPosition = null;
    }

    public void getReady() {
        int n;
        switch (OraDebugController$WhenMappings.$EnumSwitchMapping$0[this.steppingMode.ordinal()]) {
            case 1: {
                n = 1;
                break;
            }
            case 2: {
                n = 2;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        int fusSteppingModeValue = n;
        FeatureUsageData fusData = new FeatureUsageData().addData(fusSteppingModeKey, fusSteppingModeValue).addData(fusSteppingPauseAtBeginKey, OraDebuggerFacade.Companion.getSettings$intellij_database_dialects_oracle().getSteppingPauseAtBegin());
        this.fusLogger.logEvent(fusGroupId, fusStartedEventId, fusData);
        boolean bl = this.xSession != null;
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        this.reset();
    }

    @NotNull
    public XDebugProcess initLocal(@NotNull XDebugSession xSession) {
        Intrinsics.checkNotNullParameter((Object)xSession, (String)"xSession");
        boolean bl = xSession instanceof XDebugSessionImpl;
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        this.xSession = (XDebugSessionImpl)xSession;
        XDebuggerManager xDebuggerManager = XDebuggerManager.getInstance((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)xDebuggerManager, (String)"XDebuggerManager.getInstance(project)");
        xDebuggerManager.getBreakpointManager().addBreakpointListener((XBreakpointType)xbpType, (XBreakpointListener)this.lineBreakpointHandler);
        xSession.setPauseActionSupported(this.steppingMode == SteppingMode.STEPPING_GRACEFUL);
        RangeMarker rangeMarker = this.scriptRangeMarker;
        this.scriptFirstLineNr = rangeMarker != null && (rangeMarker = rangeMarker.getDocument()) != null ? rangeMarker.getLineNumber(this.scriptRangeMarker.getStartOffset()) : 0;
        return (XDebugProcess)new OraDebugProcess(xSession);
    }

    public void initRemote(@NotNull DatabaseConnection executingConnection) {
        Intrinsics.checkNotNullParameter((Object)executingConnection, (String)"executingConnection");
        if (this.initialized) {
            return;
        }
        try {
            OraExecutingSession oraExecutingSession = this.executingSession = new OraExecutingSession(executingConnection, this.requestOwner);
            if (oraExecutingSession == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"executingSession");
            }
            oraExecutingSession.setTraceConsumer((Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(this){
                final /* synthetic */ OraDebugController this$0;

                public final void invoke(@NotNull String message2) {
                    Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
                    OraDebugController.access$printTrace(this.this$0, "Executing", message2);
                }
                {
                    this.this$0 = oraDebugController;
                    super(1);
                }
            }));
            OraExecutingSession oraExecutingSession2 = this.executingSession;
            if (oraExecutingSession2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"executingSession");
            }
            oraExecutingSession2.initRemote();
            OraExecutingSession oraExecutingSession3 = this.executingSession;
            if (oraExecutingSession3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"executingSession");
            }
            oraExecutingSession3.makeSessionDebuggable();
            DatabaseConnection debuggingConnection = this.obtainDebuggingConnection();
            OraExecutingSession oraExecutingSession4 = this.executingSession;
            if (oraExecutingSession4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"executingSession");
            }
            OraDebuggingSession oraDebuggingSession = this.debuggingSession = new OraDebuggingSession(debuggingConnection, oraExecutingSession4, this.scriptIsMeaningful);
            if (oraDebuggingSession == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"debuggingSession");
            }
            oraDebuggingSession.setDbmsOutputConsumer((Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(this){
                final /* synthetic */ OraDebugController this$0;

                public final void invoke(@NotNull String s) {
                    Intrinsics.checkNotNullParameter((Object)s, (String)"s");
                    ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.NORMAL_OUTPUT;
                    Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType, (String)"ConsoleViewContentType.NORMAL_OUTPUT");
                    OraDebugController.print$default(this.this$0, s, consoleViewContentType, false, 4, null);
                }
                {
                    this.this$0 = oraDebugController;
                    super(1);
                }
            }));
            OraDebuggingSession oraDebuggingSession2 = this.debuggingSession;
            if (oraDebuggingSession2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"debuggingSession");
            }
            oraDebuggingSession2.setTraceConsumer((Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(this){
                final /* synthetic */ OraDebugController this$0;

                public final void invoke(@NotNull String message2) {
                    Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
                    OraDebugController.access$printTrace(this.this$0, "Debugging", message2);
                }
                {
                    this.this$0 = oraDebugController;
                    super(1);
                }
            }));
            OraDebuggingSession oraDebuggingSession3 = this.debuggingSession;
            if (oraDebuggingSession3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"debuggingSession");
            }
            oraDebuggingSession3.initRemote();
            OraDebuggingSession oraDebuggingSession4 = this.debuggingSession;
            if (oraDebuggingSession4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"debuggingSession");
            }
            oraDebuggingSession4.setOnMainLoopIteration$intellij_database_dialects_oracle((Function1<? super ProcessState, Unit>)((Function1)new Function1<ProcessState, Unit>(this){

                public final void invoke(@NotNull ProcessState p1) {
                    Intrinsics.checkNotNullParameter((Object)((Object)p1), (String)"p1");
                    OraDebugController.access$mainLoopIteration((OraDebugController)((Object)this.receiver), p1);
                }
            }));
            OraDebuggingSession oraDebuggingSession5 = this.debuggingSession;
            if (oraDebuggingSession5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"debuggingSession");
            }
            oraDebuggingSession5.setOnStateTransition$intellij_database_dialects_oracle((Function2<? super ProcessState, ? super ProcessState, Unit>)((Function2)new Function2<ProcessState, ProcessState, Unit>(this){

                public final void invoke(@NotNull ProcessState p1, @NotNull ProcessState p2) {
                    Intrinsics.checkNotNullParameter((Object)((Object)p1), (String)"p1");
                    Intrinsics.checkNotNullParameter((Object)((Object)p2), (String)"p2");
                    OraDebugController.access$stateTransition((OraDebugController)((Object)this.receiver), p1, p2);
                }
            }));
            OraDebuggingSession oraDebuggingSession6 = this.debuggingSession;
            if (oraDebuggingSession6 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"debuggingSession");
            }
            oraDebuggingSession6.setOnEventInfo$intellij_database_dialects_oracle((Function2<? super List<? extends OraPosition>, ? super ProcessState, Unit>)((Function2)new Function2<List<? extends OraPosition>, ProcessState, Unit>(this){

                public final void invoke(@NotNull List<? extends OraPosition> p1, @NotNull ProcessState p2) {
                    Intrinsics.checkNotNullParameter(p1, (String)"p1");
                    Intrinsics.checkNotNullParameter((Object)((Object)p2), (String)"p2");
                    OraDebugController.access$notifyUpdateUI((OraDebugController)((Object)this.receiver), p1, p2);
                }
            }));
            OraDebuggingSession oraDebuggingSession7 = this.debuggingSession;
            if (oraDebuggingSession7 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"debuggingSession");
            }
            oraDebuggingSession7.setOnGoodTimeToRetrieveAdditionalData$intellij_database_dialects_oracle((Function0<Unit>)((Function0)new Function0<Unit>(this){

                public final void invoke() {
                    OraDebugController.access$retrieveAdditionalData((OraDebugController)((Object)this.receiver));
                }
            }));
        }
        catch (DebuggerUnableException due) {
            this.initializationProblem = due.getMessage();
            this.initialized = false;
        }
        catch (Throwable e2) {
            this.initializationProblem = e2.getMessage();
            this.initialized = false;
            if (this.xSession != null) {
                XDebugSessionImpl xDebugSessionImpl = this.xSession;
                if (xDebugSessionImpl == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"xSession");
                }
                xDebugSessionImpl.stop();
            }
            throw e2;
        }
        OraDebuggingSession oraDebuggingSession = this.debuggingSession;
        if (oraDebuggingSession == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"debuggingSession");
        }
        this.initialized = oraDebuggingSession.getAttached();
        this.initializationProblem = null;
    }

    private final DatabaseConnection obtainDebuggingConnection() {
        GuardedRef<DatabaseConnection> connectionRef = OraConnectionHelperKt.obtainGuardedConnection(this.project, this.dataSource, (DatabaseDepartment)DGDepartment.DEBUGGER);
        this.debuggingConnectionRef = connectionRef;
        Object object = connectionRef.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"connectionRef.get()");
        return (DatabaseConnection)object;
    }

    public void debugBegin() {
        if (!this.initialized) {
            Throwable throwable;
            String string = this.initializationProblem;
            if (string != null) {
                String string2 = string;
                boolean bl = false;
                boolean bl2 = false;
                String p1 = string2;
                boolean bl3 = false;
                throwable = (Throwable)((Object)new OraDebuggingAbortedException(p1));
            } else {
                throwable = new IllegalStateException("OracleDebugController is not initialized");
            }
            throw throwable;
        }
        if (this.xSession == null) {
            throw (Throwable)new IllegalStateException("An XDebugSession instance was not assigned");
        }
        this.startingUp = true;
        if (this.getState() == ProcessState.STATE_ASLEEP) {
            ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.SYSTEM_OUTPUT;
            Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType, (String)"ConsoleViewContentType.SYSTEM_OUTPUT");
            OraDebugController.print$default(this, "Starting Debugger\u2026", consoleViewContentType, false, 4, null);
            this.inUI((Function0<Unit>)((Function0)new Function0<Unit>(this){
                final /* synthetic */ OraDebugController this$0;

                public final void invoke() {
                    OraDebugController.access$getXSession$p(this.this$0).getConsoleView();
                }
                {
                    this.this$0 = oraDebugController;
                    super(0);
                }
            }));
        } else {
            ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.SYSTEM_OUTPUT;
            Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType, (String)"ConsoleViewContentType.SYSTEM_OUTPUT");
            OraDebugController.print$default(this, "Restarting Debugger\u2026", consoleViewContentType, false, 4, null);
            OraDebuggingSession oraDebuggingSession = this.debuggingSession;
            if (oraDebuggingSession == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"debuggingSession");
            }
            oraDebuggingSession.resetState();
            XDebugSessionImpl xDebugSessionImpl = this.xSession;
            if (xDebugSessionImpl == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"xSession");
            }
            xDebugSessionImpl.reset();
            this.inUI((Function0<Unit>)((Function0)new Function0<Unit>(this){
                final /* synthetic */ OraDebugController this$0;

                public final void invoke() {
                    OraDebugController.access$getXSession$p(this.this$0).rebuildViews();
                }
                {
                    this.this$0 = oraDebugController;
                    super(0);
                }
            }));
        }
        this.kickOffMainLoop();
        OraExecutingSession oraExecutingSession = this.executingSession;
        if (oraExecutingSession == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"executingSession");
        }
        oraExecutingSession.turnDebugON(false);
        OraExecutingSession oraExecutingSession2 = this.executingSession;
        if (oraExecutingSession2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"executingSession");
        }
        oraExecutingSession2.executionBegin$intellij_database_dialects_oracle();
    }

    public void debugEnd() {
        OraExecutingSession oraExecutingSession = this.executingSession;
        if (oraExecutingSession == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"executingSession");
        }
        boolean executionWasActive = oraExecutingSession.getExecuting();
        OraExecutingSession oraExecutingSession2 = this.executingSession;
        if (oraExecutingSession2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"executingSession");
        }
        oraExecutingSession2.executionEnded$intellij_database_dialects_oracle();
        if (executionWasActive) {
            this.trace("Waiting the debugging thread to complete");
            OraDebuggingSession oraDebuggingSession = this.debuggingSession;
            if (oraDebuggingSession == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"debuggingSession");
            }
            oraDebuggingSession.completeTheProcess();
            Thread thread = this.debuggingThread;
            if (thread == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"debuggingThread");
            }
            thread.join();
        }
        this.trace("Stopping the debugger");
        if (this.initialized) {
            OraExecutingSession oraExecutingSession3 = this.executingSession;
            if (oraExecutingSession3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"executingSession");
            }
            if (oraExecutingSession3.getUnderDebug()) {
                this.kickOffFinishing();
                OraExecutingSession oraExecutingSession4 = this.executingSession;
                if (oraExecutingSession4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"executingSession");
                }
                oraExecutingSession4.turnDebugOFF();
            }
        }
        if (this.debuggingThread != null) {
            Thread thread = this.debuggingThread;
            if (thread == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"debuggingThread");
            }
            thread.join();
        }
        ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.SYSTEM_OUTPUT;
        Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType, (String)"ConsoleViewContentType.SYSTEM_OUTPUT");
        OraDebugController.print$default(this, "Debugger is stopped.", consoleViewContentType, false, 4, null);
    }

    public void close() {
        GuardedRef<DatabaseConnection> connectionRef;
        this.trace("Closing the debugger");
        if (this.xSession != null) {
            XDebugSessionImpl xDebugSessionImpl = this.xSession;
            if (xDebugSessionImpl == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"xSession");
            }
            xDebugSessionImpl.stop();
        }
        XDebuggerManager xDebuggerManager = XDebuggerManager.getInstance((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)xDebuggerManager, (String)"XDebuggerManager.getInstance(project)");
        xDebuggerManager.getBreakpointManager().removeBreakpointListener((XBreakpointType)xbpType, (XBreakpointListener)this.lineBreakpointHandler);
        if (this.debuggingThread != null) {
            Thread thread = this.debuggingThread;
            if (thread == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"debuggingThread");
            }
            if (thread.isAlive()) {
                this.issueCommand(StopCommand.INSTANCE);
                Thread thread2 = this.debuggingThread;
                if (thread2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"debuggingThread");
                }
                thread2.join(5000L);
                Thread thread3 = this.debuggingThread;
                if (thread3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"debuggingThread");
                }
                if (thread3.isAlive()) {
                    throw (Throwable)new RuntimeException("Failed to stop the debugging process (current state: " + (Object)((Object)this.getState()) + ')');
                }
            }
        }
        this.initialized = false;
        if (this.debuggingSession != null) {
            OraDebuggingSession oraDebuggingSession = this.debuggingSession;
            if (oraDebuggingSession == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"debuggingSession");
            }
            oraDebuggingSession.close();
        }
        if (this.executingSession != null) {
            OraExecutingSession oraExecutingSession = this.executingSession;
            if (oraExecutingSession == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"executingSession");
            }
            oraExecutingSession.close();
        }
        if ((connectionRef = this.debuggingConnectionRef) != null) {
            connectionRef.close();
            this.debuggingConnectionRef = null;
        }
        this.trace("Debugger is closed.");
    }

    private final void kickOffMainLoop() {
        OraDebuggingSession oraDebuggingSession = this.debuggingSession;
        if (oraDebuggingSession == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"debuggingSession");
        }
        boolean bl = !oraDebuggingSession.getProcessIsActive();
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            StringBuilder stringBuilder = new StringBuilder().append("Attempting start debugging when already is active (state: ");
            OraDebuggingSession oraDebuggingSession2 = this.debuggingSession;
            if (oraDebuggingSession2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"debuggingSession");
            }
            String string = stringBuilder.append((Object)oraDebuggingSession2.getState()).append(')').toString();
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        Function0 function0 = (Function0)new Function0<Unit>(this){

            public final void invoke() {
                OraDebugController.access$performMainLoop((OraDebugController)((Object)this.receiver));
            }
        };
        Thread thread = this.debuggingThread = new Thread((Runnable)new OraDebugController$sam$java_lang_Runnable$0(function0), "Oracle Debugging");
        if (thread == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"debuggingThread");
        }
        thread.start();
        Thread.sleep(10L);
    }

    private final void performMainLoop() {
        this.beginning = true;
        OraDebuggingSession oraDebuggingSession = this.debuggingSession;
        if (oraDebuggingSession == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"debuggingSession");
        }
        oraDebuggingSession.performMainLoop();
    }

    private final void kickOffFinishing() {
        OraDebuggingSession oraDebuggingSession = this.debuggingSession;
        if (oraDebuggingSession == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"debuggingSession");
        }
        if (oraDebuggingSession.getProcessIsActive()) {
            OraDebuggingSession oraDebuggingSession2 = this.debuggingSession;
            if (oraDebuggingSession2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"debuggingSession");
            }
            oraDebuggingSession2.abortTheProcess();
        }
        Function0 function0 = (Function0)new Function0<Unit>(this){

            public final void invoke() {
                OraDebugController.access$performFinishing((OraDebugController)((Object)this.receiver));
            }
        };
        Thread thread = this.debuggingThread = new Thread((Runnable)new OraDebugController$sam$java_lang_Runnable$0(function0), "Oracle Debugging (finishing)");
        if (thread == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"debuggingThread");
        }
        thread.start();
        Thread.sleep(10L);
    }

    private final void performFinishing() {
        OraDebuggingSession oraDebuggingSession = this.debuggingSession;
        if (oraDebuggingSession == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"debuggingSession");
        }
        oraDebuggingSession.performFinishLoop();
    }

    public final void issueCommand(@NotNull DebugCommand command2) {
        Intrinsics.checkNotNullParameter((Object)command2, (String)"command");
        OraDebuggingSession oraDebuggingSession = this.debuggingSession;
        if (oraDebuggingSession == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"debuggingSession");
        }
        oraDebuggingSession.issueCommand(command2);
    }

    private final void mainLoopIteration(ProcessState state2) {
        boolean working;
        boolean bl = working = state2.compareTo((Enum)ProcessState.STATE_STARTING_UP) >= 0 && state2.compareTo((Enum)ProcessState.STATE_COMPLETING) < 0;
        if (this.startingUp && working) {
            this.doOnStart();
        }
        OraDebuggingSession oraDebuggingSession = this.debuggingSession;
        if (oraDebuggingSession == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"debuggingSession");
        }
        int stackDepth = oraDebuggingSession.getStackDepth();
        if (!this.scriptIsMeaningful && stackDepth < 2) {
            this.issueCommand(StepIntoCommand.INSTANCE);
        }
        OraDebuggingSession oraDebuggingSession2 = this.debuggingSession;
        if (oraDebuggingSession2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"debuggingSession");
        }
        if (oraDebuggingSession2.getReason() == PauseReason.REASON_BREAKPOINT) {
            this.beginning = false;
        }
        if (this.beginning) {
            OraDebuggingSession oraDebuggingSession3 = this.debuggingSession;
            if (oraDebuggingSession3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"debuggingSession");
            }
            if (oraDebuggingSession3.goingToRelax() && stackDepth > 0) {
                if (this.pauseAtBegin) {
                    this.pauseAtBegin = false;
                } else {
                    switch (OraDebugController$WhenMappings.$EnumSwitchMapping$1[this.steppingMode.ordinal()]) {
                        case 1: {
                            this.issueCommand(GracefulResumeCommand.INSTANCE);
                            break;
                        }
                        case 2: {
                            this.issueCommand(ResumeCommand.INSTANCE);
                            break;
                        }
                    }
                }
                this.beginning = false;
            }
        }
    }

    private final void doOnStart() {
        ApplicationManager.getApplication().runReadAction(new Runnable(this){
            final /* synthetic */ OraDebugController this$0;

            public final void run() {
                OraDebugController.access$getXSession$p(this.this$0).initBreakpoints();
            }
            {
                this.this$0 = oraDebugController;
            }
        });
        StringBuilder stringBuilder = new StringBuilder().append("Debugger started in ").append(this.steppingMode.getDisplayName().get()).append(" mode. Probe version: ");
        OraDebuggingSession oraDebuggingSession = this.debuggingSession;
        if (oraDebuggingSession == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"debuggingSession");
        }
        String string = stringBuilder.append(oraDebuggingSession.getProbeVersion()).toString();
        ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.SYSTEM_OUTPUT;
        Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType, (String)"ConsoleViewContentType.SYSTEM_OUTPUT");
        OraDebugController.print$default(this, string, consoleViewContentType, false, 4, null);
        this.startingUp = false;
    }

    /*
     * WARNING - void declaration
     */
    private final void registerLineBreakpoint(XLineBreakpoint<OraLineBreakpointProperties> xbp) {
        void bp;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = this.lineBreakpoints.get(xbp);
        if ((OraRealLineBreakpoint)bp.element == null) {
            VirtualFile virtualFile = this.scriptVirtualFile;
            Result<OraRealLineBreakpoint> r = Intrinsics.areEqual((Object)xbp.getFileUrl(), (Object)(virtualFile != null ? virtualFile.getUrl() : null)) ? OracleDebugHelper.prepareScriptLineBreakpoint(xbp, this.scriptFirstLineNr) : OracleDebugHelper.prepareProgramLineBreakpoint(xbp, this.project, this.lineMapper);
            Result<OraRealLineBreakpoint> result2 = r;
            if (!(result2 instanceof SuccessfulResult)) {
                this.trace("Failed to prepare line breakpoint: " + r.getProblem());
                return;
            }
            bp.element = (OraRealLineBreakpoint)((SuccessfulResult)r).getValue();
            this.lineBreakpoints.put(xbp, (OraRealLineBreakpoint)bp.element);
        }
        try {
            RegisterBreakpointCommand command2 = new RegisterBreakpointCommand((OraRealLineBreakpoint)bp.element, (Function0<Unit>)((Function0)new Function0<Unit>(this, (Ref.ObjectRef)bp){
                final /* synthetic */ OraDebugController this$0;
                final /* synthetic */ Ref.ObjectRef $bp;

                public final void invoke() {
                    if (((OraRealLineBreakpoint)this.$bp.element).getActive()) {
                        OraDebugController.access$getXSession$p(this.this$0).setBreakpointVerified(((OraRealLineBreakpoint)this.$bp.element).getXBreakpoint());
                    } else if (!((OraRealLineBreakpoint)this.$bp.element).getAppropriate()) {
                        OraDebugController.access$getXSession$p(this.this$0).setBreakpointInvalid(((OraRealLineBreakpoint)this.$bp.element).getXBreakpoint(), ((OraRealLineBreakpoint)this.$bp.element).getProblem());
                    }
                }
                {
                    this.this$0 = oraDebugController;
                    this.$bp = objectRef;
                    super(0);
                }
            }));
            this.issueCommand(command2);
        }
        catch (Exception e2) {
            String problemMessage = "Problem preparing breakpoint " + (OraRealLineBreakpoint)bp.element + ": " + e2.getClass().getSimpleName() + ": " + e2.getMessage();
            this.trace(problemMessage);
            XDebugSessionImpl xDebugSessionImpl = this.xSession;
            if (xDebugSessionImpl == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"xSession");
            }
            xDebugSessionImpl.setBreakpointInvalid(((OraRealLineBreakpoint)bp.element).getXBreakpoint(), problemMessage);
        }
    }

    private final void deregisterLineBreakpoint(XLineBreakpoint<OraLineBreakpointProperties> xbp) {
        OraRealLineBreakpoint oraRealLineBreakpoint = this.lineBreakpoints.get(xbp);
        if (oraRealLineBreakpoint == null) {
            return;
        }
        OraRealLineBreakpoint bp = oraRealLineBreakpoint;
        DeregisterBreakpointCommand command2 = new DeregisterBreakpointCommand(bp, (Function0<Unit>)((Function0)deregisterLineBreakpoint.command.1.INSTANCE));
        this.issueCommand(command2);
    }

    private final void retrieveAdditionalData() {
        this.retrieveVariables();
    }

    private final void retrieveVariables() {
        OraDebuggingSession oraDebuggingSession = this.debuggingSession;
        if (oraDebuggingSession == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"debuggingSession");
        }
        if (oraDebuggingSession.getStackDepth() == 0) {
            return;
        }
        OraStack oraStack = this.stack;
        if (oraStack == null || (oraStack = oraStack.getTopFrame()) == null) {
            return;
        }
        OraStack topFrame = oraStack;
    }

    private final void inUI(Function0<Unit> what) {
        Application application = ApplicationManager.getApplication();
        Object object = what;
        if (object != null) {
            Function0<Unit> function0 = object;
            object = new OraDebugController$sam$java_lang_Runnable$0(function0);
        }
        application.invokeLater((Runnable)object);
    }

    private final void trace(String message2) {
        this.printTrace("Controller", message2);
    }

    private final void printTrace(String sourceName, String message2) {
        if (Registry.is((String)"database.debug.trace")) {
            String string = sourceName + ": ";
            ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.LOG_DEBUG_OUTPUT;
            Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType, (String)"ConsoleViewContentType.LOG_DEBUG_OUTPUT");
            this.print(string, consoleViewContentType, false);
            ConsoleViewContentType consoleViewContentType2 = ConsoleViewContentType.LOG_VERBOSE_OUTPUT;
            Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType2, (String)"ConsoleViewContentType.LOG_VERBOSE_OUTPUT");
            this.print(message2, consoleViewContentType2, true);
        }
    }

    private final void print(String text, ConsoleViewContentType contentType, boolean eoln) {
        this.inUI((Function0<Unit>)((Function0)new Function0<Unit>(this, text, contentType, eoln){
            final /* synthetic */ OraDebugController this$0;
            final /* synthetic */ String $text;
            final /* synthetic */ ConsoleViewContentType $contentType;
            final /* synthetic */ boolean $eoln;

            public final void invoke() {
                ConsoleView consoleView2;
                ConsoleView consoleView3 = consoleView2 = OraDebugController.access$getXSession$li(this.this$0) != null ? OraDebugController.access$getXSession$p(this.this$0).getConsoleView() : null;
                if (consoleView2 != null) {
                    consoleView2.print(this.$text, this.$contentType);
                    if (this.$eoln) {
                        consoleView2.print("\n", this.$contentType);
                    }
                } else {
                    String string = this.$text + (this.$eoln ? "\n" : "");
                    boolean bl = false;
                    System.out.print((Object)string);
                }
            }
            {
                this.this$0 = oraDebugController;
                this.$text = string;
                this.$contentType = consoleViewContentType;
                this.$eoln = bl;
                super(0);
            }
        }));
    }

    static /* synthetic */ void print$default(OraDebugController oraDebugController, String string, ConsoleViewContentType consoleViewContentType, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        oraDebugController.print(string, consoleViewContentType, bl);
    }

    private final void stateTransition(ProcessState oldState, ProcessState newState) {
        this.inUI((Function0<Unit>)((Function0)new Function0<Unit>(this, newState){
            final /* synthetic */ OraDebugController this$0;
            final /* synthetic */ ProcessState $newState;

            public final void invoke() {
                OraDebugController.access$doStateTransition(this.this$0, this.$newState);
            }
            {
                this.this$0 = oraDebugController;
                this.$newState = processState;
                super(0);
            }
        }));
    }

    private final void doStateTransition(ProcessState state2) {
        switch (OraDebugController$WhenMappings.$EnumSwitchMapping$2[state2.ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                XDebugSessionImpl xDebugSessionImpl = this.xSession;
                if (xDebugSessionImpl == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"xSession");
                }
                xDebugSessionImpl.sessionResumed();
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                XDebugSessionImpl xDebugSessionImpl = this.xSession;
                if (xDebugSessionImpl == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"xSession");
                }
                xDebugSessionImpl.sessionResumed();
                break;
            }
            case 6: 
            case 7: {
                XDebugSessionImpl xDebugSessionImpl = this.xSession;
                if (xDebugSessionImpl == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"xSession");
                }
                xDebugSessionImpl.sessionResumed();
                break;
            }
            case 8: 
            case 9: {
                XDebugSessionImpl xDebugSessionImpl = this.xSession;
                if (xDebugSessionImpl == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"xSession");
                }
                xDebugSessionImpl.sessionResumed();
                this.reportFinished(state2);
                break;
            }
            case 10: 
            case 11: {
                this.reportFinished(state2);
                break;
            }
        }
        XDebugSessionImpl xDebugSessionImpl = this.xSession;
        if (xDebugSessionImpl == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"xSession");
        }
        xDebugSessionImpl.setPauseActionSupported(this.steppingMode == SteppingMode.STEPPING_GRACEFUL && state2 == ProcessState.STATE_RUNNING);
    }

    private final void reportFinished(ProcessState state2) {
        if (!this.fusFinishSent) {
            FeatureUsageData featureUsageData = new FeatureUsageData();
            String string = StringUtil.toLowerCase((String)state2.name());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringUtil.toLowerCase(state.name)");
            FeatureUsageData fusData = featureUsageData.addData(fusResultStateKey, string);
            this.fusLogger.logEvent(fusGroupId, fusFinishedEventId, fusData);
            this.fusFinishSent = true;
        }
    }

    private final void notifyUpdateUI(List<? extends OraPosition> stack, ProcessState state2) {
        OraPosition currentPosition;
        if (state2.isInteractive() && Intrinsics.areEqual((Object)(currentPosition = (OraPosition)CollectionsKt.firstOrNull(stack)), (Object)this.lastPosition) ^ true) {
            this.lastPosition = currentPosition;
            this.inUI((Function0<Unit>)((Function0)new Function0<Unit>(this, stack){
                final /* synthetic */ OraDebugController this$0;
                final /* synthetic */ List $stack;

                public final void invoke() {
                    OraDebugController.access$doUpdateUI(this.this$0, this.$stack);
                }
                {
                    this.this$0 = oraDebugController;
                    this.$stack = list;
                    super(0);
                }
            }));
        }
    }

    private final void doUpdateUI(List<? extends OraPosition> stack) {
        XSuspendContext suspendContext = this.obtainSuspendContext(stack);
        XDebugSessionImpl xDebugSessionImpl = this.xSession;
        if (xDebugSessionImpl == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"xSession");
        }
        xDebugSessionImpl.positionReached(suspendContext);
        if (Intrinsics.areEqual((Object)suspendContext, (Object)((Object)EmptySuspendedContext.INSTANCE)) ^ true) {
            XDebugSessionImpl xDebugSessionImpl2 = this.xSession;
            if (xDebugSessionImpl2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"xSession");
            }
            xDebugSessionImpl2.showExecutionPoint();
        }
    }

    private final XSuspendContext obtainSuspendContext(List<? extends OraPosition> stackPositions) {
        OraDebuggingSession oraDebuggingSession = this.debuggingSession;
        if (oraDebuggingSession == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"debuggingSession");
        }
        OraStack stack = new OraStack(this.variableFinder, oraDebuggingSession, this.evaluator);
        int k = stackPositions.size();
        for (OraPosition oraPosition : stackPositions) {
            OraPosition oraPosition2 = oraPosition;
            if (oraPosition2 instanceof OraScriptPosition) {
                VirtualFile svf = this.scriptVirtualFile;
                if (svf != null) {
                    XSourcePosition x = SqlProgramSourceKt.createVirtualFilePosition((VirtualFile)svf, (int)(this.scriptFirstLineNr + oraPosition.getLineNr() - 1));
                    stack.makeScriptFrame(k, (OraScriptPosition)oraPosition, x);
                } else {
                    stack.makeRoutineWrapperFrame(k, oraPosition);
                }
            } else if (oraPosition2 instanceof OraProgramPosition) {
                SqlProgramPosition programPosition;
                SqlProgramSource source;
                SqlProgramSource sqlProgramSource = source = this.sources.getProgramSource(((OraProgramPosition)oraPosition).getProgram());
                int fileLine = this.lineMapper.mapOraToFile((BasicSourceAware)(sqlProgramSource != null ? sqlProgramSource.getModelElement() : null), oraPosition.getLineNr());
                SqlProgramPosition sqlProgramPosition = programPosition = source != null ? new SqlProgramPosition(source, fileLine) : null;
                if (programPosition != null) {
                    stack.makeProgramFrame(k, (OraProgramPosition)oraPosition, programPosition);
                } else {
                    stack.makeUnknownFrame(k, oraPosition);
                }
            } else if (oraPosition2 instanceof OraUnknownPosition) {
                stack.makeUnknownFrame(k, oraPosition);
            }
            --k;
        }
        this.stack = stack;
        return new SuspendedContext(stack);
    }

    public OraDebugController(@NotNull Project project, @NotNull LocalDataSource dataSource, @NotNull DataRequest.OwnerEx consoleRequestOwner, boolean scriptIsMeaningful, @Nullable VirtualFile scriptVirtualFile, @Nullable RangeMarker scriptRangeMarker, @Nullable SearchPath searchPath) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        Intrinsics.checkNotNullParameter((Object)consoleRequestOwner, (String)"consoleRequestOwner");
        FUCounterUsageLogger fUCounterUsageLogger = FUCounterUsageLogger.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)fUCounterUsageLogger, (String)"FUCounterUsageLogger.getInstance()");
        this.fusLogger = fUCounterUsageLogger;
        this.lineBreakpointHandler = new OraLineBreakpointHandler();
        this.lineBreakpoints = new ConcurrentHashMap();
        this.evaluator = new Evaluator();
        this.project = project;
        this.dataSource = dataSource;
        this.requestOwner = consoleRequestOwner;
        this.lineMapper = new OraProgramLineMapper();
        this.scriptIsMeaningful = scriptIsMeaningful;
        this.scriptVirtualFile = scriptVirtualFile;
        this.scriptRangeMarker = scriptRangeMarker;
        this.sources = new OraProgramSources(project, dataSource);
        this.variableFinder = new OraVariableFinder(project, this.sources);
        this.fragmentAnalyzer = new OraFragmentAnalyzer(project, dataSource, searchPath);
        this.steppingMode = scriptIsMeaningful ? OraDebuggerFacade.Companion.getSettings$intellij_database_dialects_oracle().getSteppingMode() : SteppingMode.STEPPING_GRACEFUL;
    }

    static {
        Companion = new Companion(null);
        OraLineBreakpointType oraLineBreakpointType = (OraLineBreakpointType)((Object)XBreakpointType.EXTENSION_POINT_NAME.findExtension(OraLineBreakpointType.class));
        if (oraLineBreakpointType == null) {
            String string = "Cannot get the breakpoint type (class: " + OraLineBreakpointType.class.getSimpleName() + ')';
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        Intrinsics.checkNotNullExpressionValue((Object)((Object)oraLineBreakpointType), (String)"XBreakpointType.EXTENSIO\u2026class.java.simpleName})\")");
        xbpType = oraLineBreakpointType;
    }

    public static final /* synthetic */ OraDebuggingSession access$getDebuggingSession$p(OraDebugController $this) {
        OraDebuggingSession oraDebuggingSession = $this.debuggingSession;
        if (oraDebuggingSession == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"debuggingSession");
        }
        return oraDebuggingSession;
    }

    public static final /* synthetic */ void access$setDebuggingSession$p(OraDebugController $this, OraDebuggingSession oraDebuggingSession) {
        $this.debuggingSession = oraDebuggingSession;
    }

    public static final /* synthetic */ void access$setScriptFirstLineNr$p(OraDebugController $this, int n) {
        $this.scriptFirstLineNr = n;
    }

    public static final /* synthetic */ void access$setDebuggingSession$li(OraDebugController $this, OraDebuggingSession oraDebuggingSession) {
        $this.debuggingSession = oraDebuggingSession;
    }

    public static final /* synthetic */ XDebugSessionImpl access$getXSession$p(OraDebugController $this) {
        XDebugSessionImpl xDebugSessionImpl = $this.xSession;
        if (xDebugSessionImpl == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"xSession");
        }
        return xDebugSessionImpl;
    }

    public static final /* synthetic */ void access$setXSession$p(OraDebugController $this, XDebugSessionImpl xDebugSessionImpl) {
        $this.xSession = xDebugSessionImpl;
    }

    public static final /* synthetic */ void access$printTrace(OraDebugController $this, String sourceName, String message2) {
        $this.printTrace(sourceName, message2);
    }

    public static final /* synthetic */ void access$mainLoopIteration(OraDebugController $this, ProcessState state2) {
        $this.mainLoopIteration(state2);
    }

    public static final /* synthetic */ void access$stateTransition(OraDebugController $this, ProcessState oldState, ProcessState newState) {
        $this.stateTransition(oldState, newState);
    }

    public static final /* synthetic */ void access$notifyUpdateUI(OraDebugController $this, List stack, ProcessState state2) {
        $this.notifyUpdateUI(stack, state2);
    }

    public static final /* synthetic */ void access$retrieveAdditionalData(OraDebugController $this) {
        $this.retrieveAdditionalData();
    }

    public static final /* synthetic */ Thread access$getDebuggingThread$p(OraDebugController $this) {
        Thread thread = $this.debuggingThread;
        if (thread == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"debuggingThread");
        }
        return thread;
    }

    public static final /* synthetic */ void access$setDebuggingThread$p(OraDebugController $this, Thread thread) {
        $this.debuggingThread = thread;
    }

    public static final /* synthetic */ OraExecutingSession access$getExecutingSession$p(OraDebugController $this) {
        OraExecutingSession oraExecutingSession = $this.executingSession;
        if (oraExecutingSession == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"executingSession");
        }
        return oraExecutingSession;
    }

    public static final /* synthetic */ void access$setExecutingSession$p(OraDebugController $this, OraExecutingSession oraExecutingSession) {
        $this.executingSession = oraExecutingSession;
    }

    public static final /* synthetic */ void access$performMainLoop(OraDebugController $this) {
        $this.performMainLoop();
    }

    public static final /* synthetic */ void access$performFinishing(OraDebugController $this) {
        $this.performFinishing();
    }

    public static final /* synthetic */ XDebugSessionImpl access$getXSession$li(OraDebugController $this) {
        return $this.xSession;
    }

    public static final /* synthetic */ void access$setXSession$li(OraDebugController $this, XDebugSessionImpl xDebugSessionImpl) {
        $this.xSession = xDebugSessionImpl;
    }

    public static final /* synthetic */ void access$doStateTransition(OraDebugController $this, ProcessState state2) {
        $this.doStateTransition(state2);
    }

    public static final /* synthetic */ void access$doUpdateUI(OraDebugController $this, List stack) {
        $this.doUpdateUI(stack);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0006H\u0016J\u0017\u0010\b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\tH\u0016\u00a2\u0006\u0002\u0010\u000bJ\n\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0011H\u0016J\u0012\u0010\u0014\u001a\u00020\u000f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J\u001a\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J\u0012\u0010\u001a\u001a\u00020\u000f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J\b\u0010\u001b\u001a\u00020\u000fH\u0016J\u0012\u0010\u001c\u001a\u00020\u000f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J\u0012\u0010\u001d\u001a\u00020\u000f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J\u0012\u0010\u001e\u001a\u00020\u000f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J\b\u0010\u001f\u001a\u00020\u000fH\u0016\u00a8\u0006 "}, d2={"Lcom/intellij/database/dialects/oracle/debugger/OraDebugController$OraDebugProcess;", "Lcom/intellij/database/debugger/SqlDebugProcess;", "xSession", "Lcom/intellij/xdebugger/XDebugSession;", "(Lcom/intellij/database/dialects/oracle/debugger/OraDebugController;Lcom/intellij/xdebugger/XDebugSession;)V", "checkCanInitBreakpoints", "", "checkCanPerformCommands", "getBreakpointHandlers", "", "Lcom/intellij/xdebugger/breakpoints/XBreakpointHandler;", "()[Lcom/intellij/xdebugger/breakpoints/XBreakpointHandler;", "getEvaluator", "Lcom/intellij/xdebugger/evaluation/XDebuggerEvaluator;", "registerAdditionalActions", "", "leftToolbar", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "topToolbar", "settings", "resume", "context", "Lcom/intellij/xdebugger/frame/XSuspendContext;", "runToPosition", "position", "Lcom/intellij/xdebugger/XSourcePosition;", "startForceStepInto", "startPausing", "startStepInto", "startStepOut", "startStepOver", "stop", "intellij.database.dialects.oracle"})
    public final class OraDebugProcess
    extends SqlDebugProcess {
        public void registerAdditionalActions(@NotNull DefaultActionGroup leftToolbar, @NotNull DefaultActionGroup topToolbar, @NotNull DefaultActionGroup settings) {
            Intrinsics.checkNotNullParameter((Object)leftToolbar, (String)"leftToolbar");
            Intrinsics.checkNotNullParameter((Object)topToolbar, (String)"topToolbar");
            Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        }

        public void startStepInto(@Nullable XSuspendContext context) {
            if (OraDebugController.this.getState() == ProcessState.STATE_RELAXING) {
                OraDebugController.this.issueCommand(StepIntoCommand.INSTANCE);
            }
        }

        public void startForceStepInto(@Nullable XSuspendContext context) {
            if (OraDebugController.this.getState() == ProcessState.STATE_RELAXING) {
                OraDebugController.this.issueCommand(StepIntoCommand.INSTANCE);
            }
        }

        public void startStepOver(@Nullable XSuspendContext context) {
            if (OraDebugController.this.getState() == ProcessState.STATE_RELAXING) {
                switch (OraDebugController$OraDebugProcess$WhenMappings.$EnumSwitchMapping$0[OraDebugController.this.steppingMode.ordinal()]) {
                    case 1: {
                        OraPosition firstStackPosition = (OraPosition)CollectionsKt.firstOrNull(OraDebugController.access$getDebuggingSession$p(OraDebugController.this).getStack());
                        if (firstStackPosition != null) {
                            OraDebugController.this.issueCommand(new GracefulStepOverCommand(OraDebugController.access$getDebuggingSession$p(OraDebugController.this).getStackDepth(), firstStackPosition.getLineNr()));
                            break;
                        }
                        OraDebugController.this.issueCommand(StepIntoCommand.INSTANCE);
                        break;
                    }
                    case 2: {
                        OraDebugController.this.issueCommand(StepOverCommand.INSTANCE);
                        break;
                    }
                }
            }
        }

        public void startStepOut(@Nullable XSuspendContext context) {
            if (OraDebugController.this.getState() == ProcessState.STATE_RELAXING) {
                switch (OraDebugController$OraDebugProcess$WhenMappings.$EnumSwitchMapping$1[OraDebugController.this.steppingMode.ordinal()]) {
                    case 1: {
                        OraDebugController.this.issueCommand(new GracefulStepOutCommand(OraDebugController.access$getDebuggingSession$p(OraDebugController.this).getStackDepth()));
                        break;
                    }
                    case 2: {
                        OraDebugController.this.issueCommand(new StepOutCommand(OraDebugController.access$getDebuggingSession$p(OraDebugController.this).getStackDepth()));
                        break;
                    }
                }
            }
        }

        public void runToPosition(@NotNull XSourcePosition position, @Nullable XSuspendContext context) {
            block9: {
                Result<OraProgramPositionFile> result2;
                Result<OraProgramPositionFile> pr;
                int xLine;
                VirtualFile virtualFile;
                block10: {
                    block8: {
                        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
                        VirtualFile virtualFile2 = position.getFile();
                        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"position.file");
                        virtualFile = virtualFile2;
                        xLine = position.getLine();
                        if (!Intrinsics.areEqual((Object)virtualFile, (Object)OraDebugController.this.scriptVirtualFile)) break block8;
                        int lineNr = xLine - OraDebugController.this.scriptFirstLineNr + 1;
                        switch (OraDebugController$OraDebugProcess$WhenMappings.$EnumSwitchMapping$2[OraDebugController.this.steppingMode.ordinal()]) {
                            case 1: {
                                OraDebugController.this.issueCommand(new GracefulRunToPositionInScriptCommand(lineNr));
                                break;
                            }
                            case 2: {
                                OraScriptPosition p = new OraScriptPosition(lineNr);
                                OraDebugController.this.issueCommand(new RunToPositionCommand(p));
                                break;
                            }
                        }
                        break block9;
                    }
                    pr = OracleDebugHelper.findOraPositionByVirtualFileLine(virtualFile, xLine, OraDebugController.this.project, OraDebugController.this.lineMapper);
                    result2 = pr;
                    if (!(result2 instanceof SuccessfulResult)) break block10;
                    switch (OraDebugController$OraDebugProcess$WhenMappings.$EnumSwitchMapping$3[OraDebugController.this.steppingMode.ordinal()]) {
                        case 1: {
                            OraDebugController.this.issueCommand(new GracefulRunToPositionInProgramCommand(((OraProgramPositionFile)((SuccessfulResult)pr).getValue()).getPosition()));
                            break;
                        }
                        case 2: {
                            OraDebugController.this.issueCommand(new RunToPositionCommand(((OraProgramPositionFile)((SuccessfulResult)pr).getValue()).getPosition()));
                            break;
                        }
                    }
                    break block9;
                }
                if (!(result2 instanceof ProblematicResult)) break block9;
                OraDebugController.this.trace("Cannot run to position " + virtualFile.getPresentableUrl() + ':' + (xLine + 1) + ": " + ((ProblematicResult)pr).getProblem());
            }
        }

        public void startPausing() {
            if (OraDebugController.this.getState() == ProcessState.STATE_RESUMING || OraDebugController.this.getState() == ProcessState.STATE_RUNNING || OraDebugController.this.getState() == ProcessState.STATE_STARTING_UP) {
                OraDebugController.this.issueCommand(PauseCommand.INSTANCE);
            }
        }

        public void resume(@Nullable XSuspendContext context) {
            if (OraDebugController.this.getState() == ProcessState.STATE_RELAXING) {
                OraDebugController.this.issueCommand((DebugCommand)ModelFun.choose((OraDebugController.this.steppingMode == SteppingMode.STEPPING_GRACEFUL ? 1 : 0) != 0, (Object)GracefulResumeCommand.INSTANCE, (Object)ResumeCommand.INSTANCE));
            }
        }

        public void stop() {
            if (OraDebugController.this.getState().compareTo((Enum)ProcessState.STATE_ASLEEP) > 0 && OraDebugController.this.getState().compareTo((Enum)ProcessState.STATE_COMPLETING) < 0) {
                OraDebugController.this.issueCommand(StopCommand.INSTANCE);
            }
        }

        public boolean checkCanPerformCommands() {
            return OraDebugController.this.getState().isInteractive() || OraDebugController.this.steppingMode == SteppingMode.STEPPING_GRACEFUL;
        }

        @NotNull
        public XBreakpointHandler<?>[] getBreakpointHandlers() {
            return new XBreakpointHandler[]{OraDebugController.this.lineBreakpointHandler};
        }

        public boolean checkCanInitBreakpoints() {
            return OraDebugController.this.debuggingSession != null && OraDebugController.this.getState().compareTo((Enum)ProcessState.STATE_STARTING_UP) >= 0 && OraDebugController.this.getState().compareTo((Enum)ProcessState.STATE_COMPLETING) < 0;
        }

        @Nullable
        public XDebuggerEvaluator getEvaluator() {
            return OraDebugController.this.evaluator;
        }

        public OraDebugProcess(XDebugSession xSession) {
            Intrinsics.checkNotNullParameter((Object)xSession, (String)"xSession");
            super(xSession);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lcom/intellij/database/dialects/oracle/debugger/OraDebugController$Evaluator;", "Lcom/intellij/xdebugger/evaluation/XDebuggerEvaluator;", "(Lcom/intellij/database/dialects/oracle/debugger/OraDebugController;)V", "evaluate", "", "fragment", "", "callback", "Lcom/intellij/xdebugger/evaluation/XDebuggerEvaluator$XEvaluationCallback;", "expressionPosition", "Lcom/intellij/xdebugger/XSourcePosition;", "isCodeFragmentEvaluationSupported", "", "intellij.database.dialects.oracle"})
    private final class Evaluator
    extends XDebuggerEvaluator {
        public void evaluate(@NotNull String fragment, @NotNull XDebuggerEvaluator.XEvaluationCallback callback, @Nullable XSourcePosition expressionPosition) {
            block1: {
                FragmentInfo fragmentInfo;
                block3: {
                    FragmentInfo info;
                    block2: {
                        block0: {
                            Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
                            Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
                            fragmentInfo = info = OraDebugController.this.fragmentAnalyzer.analyze(fragment);
                            if (!(fragmentInfo instanceof ScalarExpressionFragmentInfo)) break block0;
                            OraDebugController.this.trace("Asked to evaluate: " + fragment + " at position " + expressionPosition + ", type " + info);
                            EvaluateExpressionCommand command2 = new EvaluateExpressionCommand(fragment, info, (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(callback){
                                final /* synthetic */ XDebuggerEvaluator.XEvaluationCallback $callback;

                                public final void invoke(@NotNull String it) {
                                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                    this.$callback.evaluated((XValue)new ScalarValue(it));
                                }
                                {
                                    this.$callback = xEvaluationCallback;
                                    super(1);
                                }
                            }));
                            OraDebugController.access$getDebuggingSession$p(OraDebugController.this).issueCommand(command2);
                            break block1;
                        }
                        if (!(fragmentInfo instanceof ColumnFragmentInfo)) break block2;
                        callback.evaluated((XValue)new ErrorValue("ColumnFragment: not implemented yet"));
                        break block1;
                    }
                    if (!(fragmentInfo instanceof CodeFlowFragmentInfo)) break block3;
                    ExecuteFragmentCommand command3 = new ExecuteFragmentCommand(fragment, info, (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(callback){
                        final /* synthetic */ XDebuggerEvaluator.XEvaluationCallback $callback;

                        public final void invoke(@NotNull String it) {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            this.$callback.evaluated((XValue)new OkValue(it));
                        }
                        {
                            this.$callback = xEvaluationCallback;
                            super(1);
                        }
                    }));
                    OraDebugController.access$getDebuggingSession$p(OraDebugController.this).issueCommand(command3);
                    break block1;
                }
                if (!(fragmentInfo instanceof UnknownFragmentInfo)) break block1;
                String problem = "Unknown how to parse this expression.";
                callback.evaluated((XValue)new ErrorValue(problem));
            }
        }

        public boolean isCodeFragmentEvaluationSupported() {
            return false;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lcom/intellij/database/dialects/oracle/debugger/OraDebugController$ScalarValue;", "Lcom/intellij/xdebugger/frame/XValue;", "value", "", "(Ljava/lang/String;)V", "getValue", "()Ljava/lang/String;", "computePresentation", "", "node", "Lcom/intellij/xdebugger/frame/XValueNode;", "place", "Lcom/intellij/xdebugger/frame/XValuePlace;", "intellij.database.dialects.oracle"})
    private static final class ScalarValue
    extends XValue {
        @NotNull
        private final String value;

        public void computePresentation(@NotNull XValueNode node, @NotNull XValuePlace place) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)place, (String)"place");
            node.setPresentation(null, null, this.value, false);
        }

        @NotNull
        public final String getValue() {
            return this.value;
        }

        public ScalarValue(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.value = value;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lcom/intellij/database/dialects/oracle/debugger/OraDebugController$ErrorValue;", "Lcom/intellij/xdebugger/frame/XValue;", "problem", "", "(Ljava/lang/String;)V", "getProblem", "()Ljava/lang/String;", "computePresentation", "", "node", "Lcom/intellij/xdebugger/frame/XValueNode;", "place", "Lcom/intellij/xdebugger/frame/XValuePlace;", "intellij.database.dialects.oracle"})
    private static final class ErrorValue
    extends XValue {
        @NotNull
        private final String problem;

        public void computePresentation(@NotNull XValueNode node, @NotNull XValuePlace place) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)place, (String)"place");
            node.setPresentation(null, null, this.problem, false);
        }

        @NotNull
        public final String getProblem() {
            return this.problem;
        }

        public ErrorValue(@NotNull String problem) {
            Intrinsics.checkNotNullParameter((Object)problem, (String)"problem");
            this.problem = problem;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lcom/intellij/database/dialects/oracle/debugger/OraDebugController$OkValue;", "Lcom/intellij/xdebugger/frame/XValue;", "message", "", "(Ljava/lang/String;)V", "getMessage", "()Ljava/lang/String;", "computePresentation", "", "node", "Lcom/intellij/xdebugger/frame/XValueNode;", "place", "Lcom/intellij/xdebugger/frame/XValuePlace;", "intellij.database.dialects.oracle"})
    private static final class OkValue
    extends XValue {
        @NotNull
        private final String message;

        public void computePresentation(@NotNull XValueNode node, @NotNull XValuePlace place) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)place, (String)"place");
            node.setPresentation(null, null, this.message, false);
        }

        @NotNull
        public final String getMessage() {
            return this.message;
        }

        public OkValue(@NotNull String message2) {
            Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
            this.message = message2;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\b\u0082\u0004\u0018\u00002\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u00040\u00012\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u00040\u0005B\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u0007\u001a\u00020\b2\u0010\u0010\t\u001a\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u0004H\u0016J\u001a\u0010\n\u001a\u00020\b2\u0010\u0010\t\u001a\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u0004H\u0016J\"\u0010\u000b\u001a\u00020\b2\u0010\u0010\t\u001a\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u00042\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/database/dialects/oracle/debugger/OraDebugController$OraLineBreakpointHandler;", "Lcom/intellij/xdebugger/breakpoints/XBreakpointHandler;", "Lcom/intellij/xdebugger/breakpoints/XLineBreakpoint;", "Lcom/intellij/database/dialects/oracle/debugger/OraLineBreakpointProperties;", "Lcom/intellij/database/dialects/oracle/debugger/OraXLineBreakpoint;", "Lcom/intellij/xdebugger/breakpoints/XBreakpointListener;", "(Lcom/intellij/database/dialects/oracle/debugger/OraDebugController;)V", "breakpointChanged", "", "breakpoint", "registerBreakpoint", "unregisterBreakpoint", "temporary", "", "intellij.database.dialects.oracle"})
    private final class OraLineBreakpointHandler
    extends XBreakpointHandler<XLineBreakpoint<OraLineBreakpointProperties>>
    implements XBreakpointListener<XLineBreakpoint<OraLineBreakpointProperties>> {
        public void registerBreakpoint(@NotNull XLineBreakpoint<OraLineBreakpointProperties> breakpoint) {
            Intrinsics.checkNotNullParameter(breakpoint, (String)"breakpoint");
            if (breakpoint.isEnabled()) {
                OraDebugController.this.registerLineBreakpoint((XLineBreakpoint<OraLineBreakpointProperties>)breakpoint);
            }
        }

        public void unregisterBreakpoint(@NotNull XLineBreakpoint<OraLineBreakpointProperties> breakpoint, boolean temporary) {
            Intrinsics.checkNotNullParameter(breakpoint, (String)"breakpoint");
            OraRealLineBreakpoint bp = (OraRealLineBreakpoint)OraDebugController.this.lineBreakpoints.get(breakpoint);
            if (bp != null && bp.getId() > 0) {
                OraDebugController.this.deregisterLineBreakpoint((XLineBreakpoint<OraLineBreakpointProperties>)breakpoint);
            }
        }

        public void breakpointChanged(@NotNull XLineBreakpoint<OraLineBreakpointProperties> breakpoint) {
            Intrinsics.checkNotNullParameter(breakpoint, (String)"breakpoint");
            OraRealLineBreakpoint bp = (OraRealLineBreakpoint)OraDebugController.this.lineBreakpoints.get(breakpoint);
            if (bp != null && bp.getId() > 0) {
                OraDebugController.this.deregisterLineBreakpoint((XLineBreakpoint<OraLineBreakpointProperties>)breakpoint);
            }
            if (breakpoint.isEnabled()) {
                OraDebugController.this.registerLineBreakpoint((XLineBreakpoint<OraLineBreakpointProperties>)breakpoint);
            }
        }

        public OraLineBreakpointHandler() {
            super(OraLineBreakpointType.class);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0003H\u0016J\u0013\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007H\u0016\u00a2\u0006\u0002\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/database/dialects/oracle/debugger/OraDebugController$SuspendedContext;", "Lcom/intellij/xdebugger/frame/XSuspendContext;", "stack", "Lcom/intellij/database/dialects/oracle/debugger/OraStack;", "(Lcom/intellij/database/dialects/oracle/debugger/OraStack;)V", "getActiveExecutionStack", "getExecutionStacks", "", "()[Lcom/intellij/database/dialects/oracle/debugger/OraStack;", "intellij.database.dialects.oracle"})
    private static final class SuspendedContext
    extends XSuspendContext {
        private final OraStack stack;

        @NotNull
        public OraStack getActiveExecutionStack() {
            return this.stack;
        }

        @NotNull
        public OraStack[] getExecutionStacks() {
            return new OraStack[]{this.stack};
        }

        public SuspendedContext(@NotNull OraStack stack) {
            Intrinsics.checkNotNullParameter((Object)((Object)stack), (String)"stack");
            this.stack = stack;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/database/dialects/oracle/debugger/OraDebugController$EmptySuspendedContext;", "Lcom/intellij/xdebugger/frame/XSuspendContext;", "()V", "intellij.database.dialects.oracle"})
    private static final class EmptySuspendedContext
    extends XSuspendContext {
        public static final EmptySuspendedContext INSTANCE;

        private EmptySuspendedContext() {
        }

        static {
            EmptySuspendedContext emptySuspendedContext;
            INSTANCE = emptySuspendedContext = new EmptySuspendedContext();
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\r\u001a\u00070\u000e\u00a2\u0006\u0002\b\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/database/dialects/oracle/debugger/OraDebugController$Companion;", "", "()V", "fusFinishedEventId", "", "fusGroupId", "fusResultStateKey", "fusStartedEventId", "fusSteppingModeGraceful", "", "fusSteppingModeKey", "fusSteppingModeNative", "fusSteppingPauseAtBeginKey", "xbpType", "Lcom/intellij/database/dialects/oracle/debugger/OraLineBreakpointType;", "Lorg/jetbrains/annotations/Nullable;", "intellij.database.dialects.oracle"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

