/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle;

import com.intellij.database.Dbms;
import com.intellij.database.console.JdbcEngine;
import com.intellij.database.dbimport.ImportInfo;
import com.intellij.database.dbimport.ImportManager;
import com.intellij.database.dbimport.TypeMerger;
import com.intellij.database.dialects.DialectUtils;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.view.editors.DatabaseEditorContext;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OraImportManager
extends ImportManager {
    public OraImportManager() {
        super(Dbms.ORACLE, "CLOB", 1, true, true, false, true, new TypeMerger[]{new TypeMerger.IntegerMerger("INTEGER"), new TypeMerger.DoubleMerger("NUMBER")});
    }

    @NotNull
    public List<String> getFastModeOnQueries(@NotNull ImportInfo info) {
        if (info == null) {
            OraImportManager.$$$reportNull$$$0(0);
        }
        List<String> queries = this.getQueries(info.getContext(), info.cache().getBasicTable(), true, "UNUSABLE");
        queries.add(this.getLockQuery(info));
        List<String> list = queries;
        if (list == null) {
            OraImportManager.$$$reportNull$$$0(1);
        }
        return list;
    }

    @NotNull
    public List<String> getFastModeOffQueries(@NotNull ImportInfo info) {
        if (info == null) {
            OraImportManager.$$$reportNull$$$0(2);
        }
        return this.getQueries(info.getContext(), info.cache().getBasicTable(), false, "REBUILD");
    }

    @NotNull
    private List<String> getQueries(@NotNull DatabaseEditorContext context, @NotNull DasTable table, boolean isBeforeImport, @NotNull String whatToDoWithIndices) {
        if (context == null) {
            OraImportManager.$$$reportNull$$$0(3);
        }
        if (table == null) {
            OraImportManager.$$$reportNull$$$0(4);
        }
        if (whatToDoWithIndices == null) {
            OraImportManager.$$$reportNull$$$0(5);
        }
        ArrayList<String> result2 = new ArrayList<String>();
        result2.add(this.triggers(this.alter(this.createBuilder(context), "TABLE", (DasObject)table).space(), !isBeforeImport).getStatement());
        result2.add(this.skipUnusable(context, isBeforeImport));
        this.alterIndices(context, table, result2, whatToDoWithIndices);
        ArrayList<String> arrayList = result2;
        if (arrayList == null) {
            OraImportManager.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    @NotNull
    protected DdlBuilder triggers(@NotNull DdlBuilder builder, boolean enable) {
        if (builder == null) {
            OraImportManager.$$$reportNull$$$0(7);
        }
        DdlBuilder ddlBuilder = builder.keyword(enable ? "ENABLE" : "DISABLE").space().keyword("ALL").space().keyword("TRIGGERS");
        if (ddlBuilder == null) {
            OraImportManager.$$$reportNull$$$0(8);
        }
        return ddlBuilder;
    }

    @NotNull
    public String getInsertStatement(@NotNull ImportInfo info, int linesCount) {
        if (info == null) {
            OraImportManager.$$$reportNull$$$0(9);
        }
        if (linesCount > 1) {
            throw new IllegalArgumentException("Lines count bigger than 1 not supported by oracle");
        }
        List params = OraImportManager.getPlaceholders((Dbms)Dbms.ORACLE, (Collection)info.getConsumersForInsert(), (int)linesCount);
        DdlBuilder builder = this.createBuilder(info.getContext()).keyword("INSERT").space().literal("/*+append*/").space().keyword("INTO").space().qualifiedRef((DasObject)info.cache().getBasicTable()).space().literal("(");
        DialectUtils.appendStringList((DdlBuilder)builder, (Iterable)JdbcEngine.getColumnNamesForInsert((Collection)info.getConsumersForInsert(), (Dbms)Dbms.ORACLE));
        builder.literal(")").space().keyword("VALUES").literal("(");
        DialectUtils.appendCommaSeparated((DdlBuilder)builder, (Iterable)((Iterable)ContainerUtil.getFirstItem((List)params)));
        builder.literal(")");
        String string = builder.getStatement();
        if (string == null) {
            OraImportManager.$$$reportNull$$$0(10);
        }
        return string;
    }

    @Nullable
    public String getLockQuery(@NotNull ImportInfo info) {
        if (info == null) {
            OraImportManager.$$$reportNull$$$0(11);
        }
        return this.createBuilder(info.getContext()).space().keyword("LOCK").space().keyword("TABLE").space().qualifiedRef((DasObject)info.cache().getBasicTable()).space().keyword("IN").space().keyword("EXCLUSIVE").space().keyword("MODE").getStatement();
    }

    private String skipUnusable(@NotNull DatabaseEditorContext context, boolean value) {
        if (context == null) {
            OraImportManager.$$$reportNull$$$0(12);
        }
        return this.createBuilder(context).keyword("ALTER").space().keyword("SESSION").space().keyword("SET").space().literal("skip_unusable_indexes=").space().literal(StringUtil.toLowerCase((String)String.valueOf(value))).getStatement();
    }

    private void alterIndices(@NotNull DatabaseEditorContext context, @NotNull DasTable table, @NotNull List<String> result2, @NotNull String whatToDo) {
        if (context == null) {
            OraImportManager.$$$reportNull$$$0(13);
        }
        if (table == null) {
            OraImportManager.$$$reportNull$$$0(14);
        }
        if (result2 == null) {
            OraImportManager.$$$reportNull$$$0(15);
        }
        if (whatToDo == null) {
            OraImportManager.$$$reportNull$$$0(16);
        }
        for (DasIndex index2 : table.getDasChildren(ObjectKind.INDEX).filter(DasIndex.class)) {
            result2.add(this.alterIndex(context, index2, whatToDo));
        }
    }

    private String alterIndex(@NotNull DatabaseEditorContext context, @NotNull DasIndex index2, @NotNull String whatToDo) {
        if (context == null) {
            OraImportManager.$$$reportNull$$$0(17);
        }
        if (index2 == null) {
            OraImportManager.$$$reportNull$$$0(18);
        }
        if (whatToDo == null) {
            OraImportManager.$$$reportNull$$$0(19);
        }
        return this.alter(this.createBuilder(context), "INDEX", (DasObject)index2).space().keyword(whatToDo).getStatement();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 6: 
            case 8: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 6: 
            case 8: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 1: 
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/oracle/OraImportManager";
                break;
            }
            case 3: 
            case 12: 
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "whatToDoWithIndices";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "whatToDo";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/oracle/OraImportManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFastModeOnQueries";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getQueries";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "triggers";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getInsertStatement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getFastModeOnQueries";
                break;
            }
            case 1: 
            case 6: 
            case 8: 
            case 10: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getFastModeOffQueries";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getQueries";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "triggers";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getInsertStatement";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getLockQuery";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "skipUnusable";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "alterIndices";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "alterIndex";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 6: 
            case 8: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

