/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle;

import com.intellij.database.console.ExecutionEnvironmentHelper;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.connection.statements.Configuration;
import com.intellij.database.dataSource.connection.statements.SmartStatements;
import com.intellij.database.dialects.base.BaseExecutionEnvironmentHelper;
import com.intellij.sql.psi.SqlElement;
import org.jetbrains.annotations.NotNull;

public class OraExecutionEnvironmentHelper
extends BaseExecutionEnvironmentHelper {
    @Override
    @NotNull
    protected String generateSelectStatement(@NotNull String text, @NotNull SqlElement sqlElement) {
        if (text == null) {
            OraExecutionEnvironmentHelper.$$$reportNull$$$0(0);
        }
        if (sqlElement == null) {
            OraExecutionEnvironmentHelper.$$$reportNull$$$0(1);
        }
        String string = String.format("SELECT %s FROM dual", text);
        if (string == null) {
            OraExecutionEnvironmentHelper.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @NotNull
    public ExecutionEnvironmentHelper.TimeZoneManager getTimeZoneManager() {
        ExecutionEnvironmentHelper.TimeZoneManager timeZoneManager = OraTimeZoneManager.INSTANCE;
        if (timeZoneManager == null) {
            OraExecutionEnvironmentHelper.$$$reportNull$$$0(3);
        }
        return timeZoneManager;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqlElement";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/oracle/OraExecutionEnvironmentHelper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/oracle/OraExecutionEnvironmentHelper";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "generateSelectStatement";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTimeZoneManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "generateSelectStatement";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class OraTimeZoneManager
    implements ExecutionEnvironmentHelper.TimeZoneManager {
        private static final ExecutionEnvironmentHelper.TimeZoneManager INSTANCE = new OraTimeZoneManager();

        private OraTimeZoneManager() {
        }

        public boolean canChange() {
            return true;
        }

        public void changeTimeZone(@NotNull DatabaseConnection connection, @NotNull String timeZone) {
            if (connection == null) {
                OraTimeZoneManager.$$$reportNull$$$0(0);
            }
            if (timeZone == null) {
                OraTimeZoneManager.$$$reportNull$$$0(1);
            }
            SmartStatements.poweredBy((DatabaseConnection)connection).simple(Configuration.sourced((SmartStatements.Source)SmartStatements.Source.SYSTEM)).barren().quiet().execute((Object)String.format("alter session set time_zone = '%s'", timeZone));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "connection";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "timeZone";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/dialects/oracle/OraExecutionEnvironmentHelper$OraTimeZoneManager";
            objectArray[2] = "changeTimeZone";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

