/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.DialectUtils;
import com.intellij.database.dialects.base.AbstractDatabaseDialect;
import com.intellij.database.dialects.base.TypeHelper;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbTable;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.SearchPath;
import com.intellij.database.util.Version;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import java.sql.SQLException;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OraDialect
extends AbstractDatabaseDialect
implements DatabaseDialect {
    protected OraDialect() {
        super(new TypeHelper.OraTypeHelper());
    }

    @NotNull
    public Dbms getDbms() {
        Dbms dbms = Dbms.ORACLE;
        if (dbms == null) {
            OraDialect.$$$reportNull$$$0(0);
        }
        return dbms;
    }

    @NotNull
    public String getDisplayName() {
        return "Oracle";
    }

    @Override
    public int getJavaTypeForNativeType(@NotNull String nativeColumnTypeName) {
        if (nativeColumnTypeName == null) {
            OraDialect.$$$reportNull$$$0(1);
        }
        if (StringUtil.toLowerCase((String)nativeColumnTypeName).equals("nvarchar2")) {
            return -9;
        }
        if (StringUtil.toLowerCase((String)nativeColumnTypeName).equals("nchar")) {
            return -15;
        }
        if (StringUtil.toLowerCase((String)nativeColumnTypeName).equals("nclob")) {
            return 2011;
        }
        if (StringUtil.toLowerCase((String)nativeColumnTypeName).startsWith("timestamp")) {
            return 93;
        }
        return super.getJavaTypeForNativeType(nativeColumnTypeName);
    }

    @Override
    public boolean supportsSynonymDefinition() {
        return true;
    }

    @Override
    protected void sqlParameter(@NotNull DdlBuilder builder, DasArgument parameter, boolean longMode) {
        if (builder == null) {
            OraDialect.$$$reportNull$$$0(2);
        }
        DialectUtils.sqlParameter((DdlBuilder)builder, (DasArgument)parameter, (boolean)longMode, (int)1, (boolean)true);
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlSynonymDefinition(@NotNull DasObject element) {
        if (element == null) {
            OraDialect.$$$reportNull$$$0(3);
        }
        Pair pair = Pair.create((Object)("select dbms_metadata.get_ddl('SYNONYM', '" + element.getName() + "', '" + DasUtil.getSchema((DasObject)element) + "') from dual"), (Object)DbImplUtil.ConcatenationProps.NO_CONCAT);
        if (pair == null) {
            OraDialect.$$$reportNull$$$0(4);
        }
        return pair;
    }

    @Override
    @NotNull
    public String tryToLoadSynonymDefinition(DasTable table, DatabaseConnection connection) throws Exception {
        Pair<String, DbImplUtil.ConcatenationProps> pair = this.sqlSynonymDefinition((DasObject)table);
        Dbms dbms = connection.getDbms();
        String string = DbImplUtil.concatStringResults((DatabaseConnection)connection, (Dbms)dbms, (String)((String)pair.first), (int)1, (DbImplUtil.ConcatenationProps)((DbImplUtil.ConcatenationProps)pair.second));
        if (string == null) {
            OraDialect.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    public boolean supportsTableDefinition() {
        return true;
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlTableDefinition(@NotNull DasObject element) {
        if (element == null) {
            OraDialect.$$$reportNull$$$0(6);
        }
        Pair pair = Pair.create((Object)("select dbms_metadata.get_ddl('TABLE', '" + element.getName() + "', '" + DasUtil.getSchema((DasObject)element) + "') from dual"), (Object)DbImplUtil.ConcatenationProps.NO_CONCAT);
        if (pair == null) {
            OraDialect.$$$reportNull$$$0(7);
        }
        return pair;
    }

    @Override
    @NotNull
    public String tryToLoadTableDefinition(@NotNull DasTable table, @NotNull DatabaseConnection connection) throws Exception {
        if (table == null) {
            OraDialect.$$$reportNull$$$0(8);
        }
        if (connection == null) {
            OraDialect.$$$reportNull$$$0(9);
        }
        Dbms dbms = connection.getDbms();
        Pair<String, DbImplUtil.ConcatenationProps> pair = this.sqlTableDefinition((DasObject)table);
        String string = DbImplUtil.concatStringResults((DatabaseConnection)connection, (Dbms)dbms, (String)((String)pair.first), (int)1, (DbImplUtil.ConcatenationProps)((DbImplUtil.ConcatenationProps)pair.second));
        if (string == null) {
            OraDialect.$$$reportNull$$$0(10);
        }
        return string;
    }

    @Override
    public boolean supportsTableInfo() {
        return true;
    }

    @Override
    @NotNull
    public Map<String, Object> tryToLoadTableInfo(@NotNull DbTable element, @NotNull DatabaseConnection connection) throws Exception {
        if (element == null) {
            OraDialect.$$$reportNull$$$0(11);
        }
        if (connection == null) {
            OraDialect.$$$reportNull$$$0(12);
        }
        Dbms dbms = connection.getDbms();
        Map map2 = DbImplUtil.resultRowAsMap((DatabaseConnection)connection, (String)String.format("SELECT NUM_ROWS as \"rows\",  TABLESPACE_NAME as \"tablespace\",  LAST_ANALYZED as \"analyzed on\" FROM SYS.all_tables WHERE owner LIKE '%s' ESCAPE '#' AND table_name LIKE '%s' ESCAPE '#'", DbImplUtil.escapeSql((Object)DasUtil.getSchema((DasObject)element), (boolean)true, (Dbms)dbms), DbImplUtil.escapeSql((Object)element.getName(), (boolean)true, (Dbms)dbms)), (String[])new String[0]);
        if (map2 == null) {
            OraDialect.$$$reportNull$$$0(13);
        }
        return map2;
    }

    @Override
    public SearchPath tryToLoadSearchPath(@NotNull DasDataSource system, @NotNull DatabaseConnection connection) throws SQLException {
        Dbms dbms;
        String s;
        if (system == null) {
            OraDialect.$$$reportNull$$$0(14);
        }
        if (connection == null) {
            OraDialect.$$$reportNull$$$0(15);
        }
        return StringUtil.isEmpty((String)(s = DbImplUtil.concatStringResults((DatabaseConnection)connection, (Dbms)(dbms = connection.getDbms()), (String)"select sys_context('userenv', 'current_schema') x from dual", (int)1, (DbImplUtil.ConcatenationProps)DbImplUtil.ConcatenationProps.NO_CONCAT))) ? null : SearchPath.of((ObjectPath)ObjectPath.create((String)s, (ObjectKind)ObjectKind.SCHEMA));
    }

    @Override
    public String sqlSetSearchPath(@NotNull SearchPath path) {
        if (path == null) {
            OraDialect.$$$reportNull$$$0(16);
        }
        ObjectPath current = path.getCurrent();
        if (current.kind != ObjectKind.SCHEMA) {
            return null;
        }
        String schema = this.getNamingService().nameToScript(current.getDisplayName(), current.kind, false, this.getCodeStyle().getQuotesPriority());
        return String.format("alter session set current_schema = %s", schema);
    }

    @Override
    @NotNull
    public String getTypeName(@NotNull DataType dataType) {
        if (dataType == null) {
            OraDialect.$$$reportNull$$$0(17);
        }
        if (dataType.jdbcType == 0) {
            String string = dataType.getSpecification();
            if (string == null) {
                OraDialect.$$$reportNull$$$0(18);
            }
            return string;
        }
        String typeName = dataType.typeName;
        int jdbcType = dataType.jdbcType;
        int precision = dataType.getPrecision();
        int scale = dataType.getScale();
        if ("NUMBER".equals(typeName)) {
            String string = "number" + (String)(precision == 0 && scale == -127 ? "" : "(" + precision + (String)(scale == 0 ? "" : ", " + scale) + ")");
            if (string == null) {
                OraDialect.$$$reportNull$$$0(19);
            }
            return string;
        }
        if ("LONG".equals(typeName) && jdbcType == -1 && precision == 0 && scale == 0) {
            return "long";
        }
        if ("DATE".equals(typeName) && jdbcType == 93 && precision == 7 && scale == 0) {
            return "date";
        }
        if ("ROWID".equals(typeName) && jdbcType == 1111 && precision == 10 && scale == 0) {
            return "rowid";
        }
        if ("UROWID".equals(typeName) && jdbcType == 1111 && precision == 4000 && scale == 0) {
            return "urowid";
        }
        String string = super.getTypeName(dataType);
        if (string == null) {
            OraDialect.$$$reportNull$$$0(20);
        }
        return string;
    }

    @NotNull
    public DdlBuilder sqlDropSequence(@NotNull DdlBuilder builder, @NotNull DasObject sequence, boolean cascade) {
        if (builder == null) {
            OraDialect.$$$reportNull$$$0(21);
        }
        if (sequence == null) {
            OraDialect.$$$reportNull$$$0(22);
        }
        DdlBuilder ddlBuilder = DialectUtils.getDropSequenceSQL((DdlBuilder)builder, (DasObject)sequence, null);
        if (ddlBuilder == null) {
            OraDialect.$$$reportNull$$$0(23);
        }
        return ddlBuilder;
    }

    public boolean supportsEmptyTables() {
        return false;
    }

    @Override
    public boolean supportsInsertInto() {
        return true;
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlPackageBodyDefinition(@NotNull DasObject element) {
        if (element == null) {
            OraDialect.$$$reportNull$$$0(24);
        }
        Pair pair = Pair.create((Object)OraDialect.getPackageDefinitionQuery(element, "PACKAGE BODY"), (Object)DbImplUtil.ConcatenationProps.TIGHT);
        if (pair == null) {
            OraDialect.$$$reportNull$$$0(25);
        }
        return pair;
    }

    @Override
    public boolean supportsPackageDefinition() {
        return true;
    }

    private static String getPackageDefinitionQuery(DasObject element, String type) {
        return "select TEXT FROM SYS.ALL_SOURCE WHERE OWNER = '" + DasUtil.getSchema((DasObject)element) + "' AND NAME = '" + element.getName() + "' AND TYPE = '" + type + "' ORDER BY LINE";
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlPackageDefinition(@NotNull DasObject element) {
        if (element == null) {
            OraDialect.$$$reportNull$$$0(26);
        }
        Pair pair = Pair.create((Object)OraDialect.getPackageDefinitionQuery(element, "PACKAGE"), (Object)DbImplUtil.ConcatenationProps.TIGHT);
        if (pair == null) {
            OraDialect.$$$reportNull$$$0(27);
        }
        return pair;
    }

    @Override
    public boolean supportsSequenceDefinition() {
        return true;
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlSequenceDefinition(@NotNull DasObject element) {
        if (element == null) {
            OraDialect.$$$reportNull$$$0(28);
        }
        Pair pair = Pair.create((Object)("select dbms_metadata.get_ddl('SEQUENCE', '" + element.getName() + "', '" + DasUtil.getSchema((DasObject)element) + "') from dual"), (Object)DbImplUtil.ConcatenationProps.NO_CONCAT);
        if (pair == null) {
            OraDialect.$$$reportNull$$$0(29);
        }
        return pair;
    }

    public boolean supportsViewDefinition() {
        return true;
    }

    public Pair<String, DbImplUtil.ConcatenationProps> sqlViewDefinition(@NotNull DasObject element) {
        if (element == null) {
            OraDialect.$$$reportNull$$$0(30);
        }
        return Pair.create((Object)("select TEXT FROM SYS.ALL_VIEWS WHERE OWNER = '" + DasUtil.getSchema((DasObject)element) + "' AND VIEW_NAME = '" + element.getName() + "'"), (Object)DbImplUtil.ConcatenationProps.NO_CONCAT);
    }

    public boolean supportsProcedureDefinition() {
        return true;
    }

    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlProcedureDefinition(@NotNull DasRoutine element) {
        if (element == null) {
            OraDialect.$$$reportNull$$$0(31);
        }
        StringBuilder result2 = new StringBuilder();
        result2.append("select TEXT ");
        result2.append("FROM SYS.ALL_SOURCE ");
        result2.append("WHERE OWNER = ");
        result2.append("'");
        result2.append(DasUtil.getSchema((DasObject)element));
        result2.append("'");
        result2.append(" AND NAME = ");
        result2.append("'");
        result2.append(element.getName());
        result2.append("'");
        String type = StringUtil.toUpperCase((String)element.getRoutineKind().name());
        result2.append(" AND TYPE = ");
        result2.append("'");
        result2.append(StringUtil.toUpperCase((String)type));
        result2.append("'");
        result2.append(" ORDER BY LINE");
        Pair pair = Pair.create((Object)result2.toString(), (Object)DbImplUtil.ConcatenationProps.TIGHT);
        if (pair == null) {
            OraDialect.$$$reportNull$$$0(32);
        }
        return pair;
    }

    @NotNull
    public DdlBuilder qualifiedIdentifier(DdlBuilder builder, @NotNull String identifier, @Nullable DasObject object, @NotNull DasObject qualifier) {
        if (identifier == null) {
            OraDialect.$$$reportNull$$$0(33);
        }
        if (qualifier == null) {
            OraDialect.$$$reportNull$$$0(34);
        }
        DasObject schema = DasUtil.getSchemaObject((DasObject)qualifier);
        String pkgName = qualifier instanceof DasRoutine ? ((DasRoutine)qualifier).getPackageName() : null;
        DasObject pkg = pkgName == null ? null : qualifier.getDasParent();
        DdlBuilder ddlBuilder = builder.qualifiedRef(object, identifier, schema, DasUtil.getName((DasObject)schema), null, null, pkg, pkgName);
        if (ddlBuilder == null) {
            OraDialect.$$$reportNull$$$0(35);
        }
        return ddlBuilder;
    }

    public boolean supportsCommonTableExpression() {
        return true;
    }

    @Override
    public boolean hasRowId(@Nullable Version version) {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 31: 
            case 33: 
            case 34: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 31: 
            case 33: 
            case 34: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/oracle/OraDialect";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nativeColumnTypeName";
                break;
            }
            case 2: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 3: 
            case 6: 
            case 11: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 9: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "system";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataType";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 31: 
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/oracle/OraDialect";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlSynonymDefinition";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToLoadSynonymDefinition";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlTableDefinition";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToLoadTableDefinition";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToLoadTableInfo";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeName";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropSequence";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlPackageBodyDefinition";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlPackageDefinition";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlSequenceDefinition";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlProcedureDefinition";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "qualifiedIdentifier";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getJavaTypeForNativeType";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "sqlParameter";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "sqlSynonymDefinition";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "sqlTableDefinition";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadTableDefinition";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadTableInfo";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadSearchPath";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "sqlSetSearchPath";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getTypeName";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropSequence";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "sqlPackageBodyDefinition";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "sqlPackageDefinition";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "sqlSequenceDefinition";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "sqlViewDefinition";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "sqlProcedureDefinition";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "qualifiedIdentifier";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 31: 
            case 33: 
            case 34: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

