/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle;

import com.intellij.database.Dbms;
import com.intellij.database.console.ConsoleErrorProviderFactory;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.connection.statements.StatementParameters;
import com.intellij.database.datagrid.DataAuditor;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.dialects.oracle.ObjectInfo;
import com.intellij.database.dialects.oracle.OraStatementAnalysis;
import com.intellij.database.dialects.oracle.OraUtils;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.ObjectPath;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.util.containers.JBIterable;
import java.sql.SQLException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.IntStream;
import org.jetbrains.annotations.NotNull;

public final class OraConsoleErrorProvider
extends DataAuditor.Adapter
implements JdbcConsole.RawErrorsObtainer {
    private static final Logger LOG = Logger.getInstance(OraConsoleErrorProvider.class);
    private static final Pattern COMPILATION_ERROR_POSITION_PATTERN = Pattern.compile("^(\\d{1,6}):(\\d{1,6}):");
    private static final String CONDITION_PARAMETER = "#CONDITION";
    private static final String RETRIEVE_ERRORS_QUERY_U = "select line||':'||position||':'||text as message \nfrom sys.user_errors \nwhere type #CONDITION \n  and name = ? \norder by sequence \n";
    private static final int[] USER_QUERY_PLACEHOLDERS = StatementParameters.Companion.findParameters("select line||':'||position||':'||text as message \nfrom sys.user_errors \nwhere type #CONDITION \n  and name = ? \norder by sequence \n");
    private static final String RETRIEVE_ERRORS_QUERY_Q = "select line||':'||position||':'||text as message\nfrom sys.all_errors\nwhere type #CONDITION \n  and owner = ? \n  and name = ? \norder by sequence \n";
    private static final int[] ALL_QUERY_PLACEHOLDERS = StatementParameters.Companion.findParameters("select line||':'||position||':'||text as message\nfrom sys.all_errors\nwhere type #CONDITION \n  and owner = ? \n  and name = ? \norder by sequence \n");
    @NotNull
    private final Project myProject;
    @NotNull
    private final LocalDataSource myDataSource;
    @NotNull
    private final DataAuditor mySink;

    public OraConsoleErrorProvider(@NotNull Project project, @NotNull LocalDataSource dataSource, @NotNull DataAuditor sink) {
        if (project == null) {
            OraConsoleErrorProvider.$$$reportNull$$$0(0);
        }
        if (dataSource == null) {
            OraConsoleErrorProvider.$$$reportNull$$$0(1);
        }
        if (sink == null) {
            OraConsoleErrorProvider.$$$reportNull$$$0(2);
        }
        this.myProject = project;
        this.myDataSource = dataSource;
        this.mySink = sink;
    }

    public void afterStatement(@NotNull DataRequest.Context context) {
        String query;
        if (context == null) {
            OraConsoleErrorProvider.$$$reportNull$$$0(3);
        }
        if (StringUtil.isNotEmpty((String)(query = context.getQuery()))) {
            this.obtainErrors(context, query);
        }
    }

    public void obtainErrors(@NotNull DataRequest.Context context, @NotNull String queryText) {
        ObjectPath link;
        DatabaseConnection connection;
        if (context == null) {
            OraConsoleErrorProvider.$$$reportNull$$$0(4);
        }
        if (queryText == null) {
            OraConsoleErrorProvider.$$$reportNull$$$0(5);
        }
        if ((connection = OraUtils.getConnection(context)) == null) {
            return;
        }
        Dbms dbms = this.myDataSource.getDbms();
        if (!dbms.isOracle()) {
            return;
        }
        SqlLanguageDialect dialect = DbSqlUtil.findSqlDialect((LocalDataSource)this.myDataSource);
        if (dialect == null) {
            return;
        }
        ObjectInfo info = OraStatementAnalysis.parseAffectedObjectInfo(queryText, dialect, this.myProject);
        if (info == null) {
            return;
        }
        String objectName = info.getObjectName();
        String schemaName = info.getSchemaName();
        if (schemaName == null && (link = (ObjectPath)JBIterable.from((Iterable)context.getSearchPath().elements).find(e2 -> e2.kind == ObjectKind.SCHEMA)) != null) {
            schemaName = link.name;
        }
        String condition = OraStatementAnalysis.getOracleTypeLikeConditionFor(info.getKind());
        try {
            List<String> errors = schemaName == null ? OraUtils.queryForStrings(connection, RETRIEVE_ERRORS_QUERY_U.replace(CONDITION_PARAMETER, condition), OraConsoleErrorProvider.calculatePlaceholdersOffsets(condition, USER_QUERY_PLACEHOLDERS), objectName) : OraUtils.queryForStrings(connection, RETRIEVE_ERRORS_QUERY_Q.replace(CONDITION_PARAMETER, condition), OraConsoleErrorProvider.calculatePlaceholdersOffsets(condition, ALL_QUERY_PLACEHOLDERS), schemaName, objectName);
            if (!errors.isEmpty()) {
                this.showErrors(context, errors);
                this.navigateToTheErrorPosition(errors.get(0));
            }
        }
        catch (SQLException ex) {
            String name2 = this.myDataSource.getName();
            String message2 = "Failed to obtain compilation errors using data source \"" + name2 + "\": Error " + ex.getErrorCode() + ": " + ex.getMessage();
            LOG.warn(message2, (Throwable)ex);
        }
        catch (Exception e3) {
            String name3 = this.myDataSource.getName();
            String message3 = "Failed to obtain compilation errors using data source \"" + name3 + "\": " + e3.getClass().getSimpleName() + ": " + e3.getMessage();
            LOG.warn(message3, (Throwable)e3);
        }
    }

    private void showErrors(@NotNull DataRequest.Context context, @NotNull List<String> errors) {
        if (context == null) {
            OraConsoleErrorProvider.$$$reportNull$$$0(6);
        }
        if (errors == null) {
            OraConsoleErrorProvider.$$$reportNull$$$0(7);
        }
        for (String error : errors) {
            this.mySink.error(context, error, null);
        }
    }

    private void navigateToTheErrorPosition(@NotNull String errorMessage) {
        if (errorMessage == null) {
            OraConsoleErrorProvider.$$$reportNull$$$0(8);
        }
        try {
            Matcher m = COMPILATION_ERROR_POSITION_PATTERN.matcher(errorMessage);
            if (m.find()) {
                int line = Integer.parseInt(m.group(1));
                int n = Integer.parseInt(m.group(2));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void dispose() {
    }

    private static int[] calculatePlaceholdersOffsets(@NotNull String condition, int[] offsets) {
        if (condition == null) {
            OraConsoleErrorProvider.$$$reportNull$$$0(9);
        }
        int delta = condition.length() - CONDITION_PARAMETER.length();
        return IntStream.of(offsets).map(i2 -> i2 + delta).toArray();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queryText";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errors";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorMessage";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/dialects/oracle/OraConsoleErrorProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "afterStatement";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "obtainErrors";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "showErrors";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "navigateToTheErrorPosition";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "calculatePlaceholdersOffsets";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class Factory
    implements ConsoleErrorProviderFactory {
        @NotNull
        public DataAuditor createErrorProvider(@NotNull Project project, @NotNull LocalDataSource dataSource, @NotNull DataAuditor sink) {
            if (project == null) {
                Factory.$$$reportNull$$$0(0);
            }
            if (dataSource == null) {
                Factory.$$$reportNull$$$0(1);
            }
            if (sink == null) {
                Factory.$$$reportNull$$$0(2);
            }
            return new OraConsoleErrorProvider(project, dataSource, sink);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "dataSource";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "sink";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/dialects/oracle/OraConsoleErrorProvider$Factory";
            objectArray[2] = "createErrorProvider";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

