/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mysqlbase.model.properties;

import com.intellij.database.dialects.mysqlbase.model.properties.MysqlEventStatus;
import com.intellij.database.dialects.mysqlbase.model.properties.MysqlObjectGrant;
import com.intellij.database.dialects.mysqlbase.model.properties.MysqlRoleGrant;
import com.intellij.database.model.meta.BasicMetaType;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public interface MysqlBasePropertyConverter
extends PropertyConverter {
    public static final BasicMetaType<MysqlEventStatus> T_MYSQL_EVENT_STATUS = new BasicMetaType(MysqlEventStatus.class, MysqlBasePropertyConverter::importMysqlEventStatus, PropertyConverter::export);
    public static final BasicMetaType<List<MysqlObjectGrant>> T_LIST_OF_MYSQL_OBJECT_GRANT = new BasicMetaType.CollectionMetaType(List.class, MysqlObjectGrant.class, MysqlBasePropertyConverter::importListOfMysqlObjectGrant, MysqlBasePropertyConverter::exportListOfMysqlObjectGrant);
    public static final BasicMetaType<List<MysqlRoleGrant>> T_LIST_OF_MYSQL_ROLE_GRANT = new BasicMetaType.CollectionMetaType(List.class, MysqlRoleGrant.class, MysqlBasePropertyConverter::importListOfMysqlRoleGrant, MysqlBasePropertyConverter::exportListOfMysqlRoleGrant);

    public static MysqlEventStatus importMysqlEventStatus(String text) {
        return (MysqlEventStatus)PropertyConverter.importEnum(MysqlEventStatus.class, (String)text);
    }

    public static String exportListOfMysqlObjectGrant(List<MysqlObjectGrant> columns) {
        StringBuilder sb = new StringBuilder();
        for (MysqlObjectGrant column2 : columns) {
            sb.append(column2.export()).append("\n");
        }
        return sb.toString();
    }

    @NotNull
    public static List<MysqlObjectGrant> importListOfMysqlObjectGrant(String text) {
        String[] lines;
        if (text == null || text.length() == 0) {
            List<MysqlObjectGrant> list = Collections.emptyList();
            if (list == null) {
                MysqlBasePropertyConverter.$$$reportNull$$$0(0);
            }
            return list;
        }
        ArrayList<MysqlObjectGrant> res2 = new ArrayList<MysqlObjectGrant>();
        for (String line : lines = StringUtil.splitByLines((String)text)) {
            res2.add(new MysqlObjectGrant(line));
        }
        ArrayList<MysqlObjectGrant> arrayList = res2;
        if (arrayList == null) {
            MysqlBasePropertyConverter.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    public static String exportListOfMysqlRoleGrant(List<MysqlRoleGrant> columns) {
        StringBuilder sb = new StringBuilder();
        for (MysqlRoleGrant column2 : columns) {
            sb.append(column2.export()).append("\n");
        }
        return sb.toString();
    }

    @NotNull
    public static List<MysqlRoleGrant> importListOfMysqlRoleGrant(String text) {
        String[] lines;
        if (text == null || text.length() == 0) {
            List<MysqlRoleGrant> list = Collections.emptyList();
            if (list == null) {
                MysqlBasePropertyConverter.$$$reportNull$$$0(2);
            }
            return list;
        }
        ArrayList<MysqlRoleGrant> res2 = new ArrayList<MysqlRoleGrant>();
        for (String line : lines = StringUtil.splitByLines((String)text)) {
            res2.add(new MysqlRoleGrant(line));
        }
        ArrayList<MysqlRoleGrant> arrayList = res2;
        if (arrayList == null) {
            MysqlBasePropertyConverter.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/database/dialects/mysqlbase/model/properties/MysqlBasePropertyConverter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "importListOfMysqlObjectGrant";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "importListOfMysqlRoleGrant";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

