/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mysqlbase;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.connection.statements.ExecutionMode;
import com.intellij.database.dataSource.connection.statements.SmartStatements;
import com.intellij.database.dataSource.connection.statements.StandardExecutionMode;
import com.intellij.database.dataSource.connection.statements.StandardResultsProcessors;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.DialectUtils;
import com.intellij.database.dialects.base.AbstractDatabaseDialect;
import com.intellij.database.dialects.base.TypeHelper;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbTable;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.SearchPath;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ThrowableConvertor;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MysqlBaseDialect
extends AbstractDatabaseDialect
implements DatabaseDialect {
    public MysqlBaseDialect() {
        super(new TypeHelper.MySQLTypeHelper());
    }

    @Override
    public DdlBuilder sqlCreateView(@NotNull DdlBuilder builder, @NotNull DasTable view, @NotNull String definition) {
        if (builder == null) {
            MysqlBaseDialect.$$$reportNull$$$0(0);
        }
        if (view == null) {
            MysqlBaseDialect.$$$reportNull$$$0(1);
        }
        if (definition == null) {
            MysqlBaseDialect.$$$reportNull$$$0(2);
        }
        builder.keywords(new String[]{"CREATE", "OR", "REPLACE", "VIEW"}).space();
        builder.qualifiedRef((DasObject)view).space();
        builder.keyword("AS").space();
        builder.plain(definition);
        return builder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropView(@NotNull DdlBuilder builder, @NotNull DasTable view, boolean cascade) {
        if (builder == null) {
            MysqlBaseDialect.$$$reportNull$$$0(3);
        }
        if (view == null) {
            MysqlBaseDialect.$$$reportNull$$$0(4);
        }
        DdlBuilder ddlBuilder = DialectUtils.getDropViewSQL((DdlBuilder)builder, (DasTable)view, (Boolean)cascade);
        if (ddlBuilder == null) {
            MysqlBaseDialect.$$$reportNull$$$0(5);
        }
        return ddlBuilder;
    }

    public Pair<String, DbImplUtil.ConcatenationProps> sqlViewDefinition(@NotNull DasObject element) {
        if (element == null) {
            MysqlBaseDialect.$$$reportNull$$$0(6);
        }
        return Pair.create((Object)("SELECT view_definition FROM information_schema.views WHERE table_name = '" + element.getName() + "' AND table_schema = '" + MysqlBaseDialect.getDBName(element) + "'"), (Object)DbImplUtil.ConcatenationProps.NO_CONCAT);
    }

    public boolean supportsProcedureDefinition() {
        return true;
    }

    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlProcedureDefinition(@NotNull DasRoutine element) {
        if (element == null) {
            MysqlBaseDialect.$$$reportNull$$$0(7);
        }
        Pair pair = Pair.create((Object)("SELECT routine_definition FROM information_schema.routines WHERE routine_name = '" + element.getName() + "' AND routine_schema = '" + MysqlBaseDialect.getDBName((DasObject)element) + "'"), (Object)DbImplUtil.ConcatenationProps.NO_CONCAT);
        if (pair == null) {
            MysqlBaseDialect.$$$reportNull$$$0(8);
        }
        return pair;
    }

    @Override
    @NotNull
    public String tryToLoadProcedureDefinition(@NotNull DasRoutine procedure, @NotNull DatabaseConnection connection) throws Exception {
        if (procedure == null) {
            MysqlBaseDialect.$$$reportNull$$$0(9);
        }
        if (connection == null) {
            MysqlBaseDialect.$$$reportNull$$$0(10);
        }
        String type = procedure.getRoutineKind().name();
        String query = new DdlBuilder().withDialect((DatabaseDialectEx)this).qualifyReferences(true).keywords(new String[]{"SHOW", "CREATE", type}).space().qualifiedRef((DasObject)procedure).getStatement();
        String string = (String)SmartStatements.poweredBy((DatabaseConnection)connection).simple().noisy().execute((Object)query, (ExecutionMode)StandardExecutionMode.QUERY, StandardResultsProcessors.throwableResultsTransformer(rs -> {
            if (!rs.next()) {
                return "-- failed to load definition";
            }
            DdlBuilder builder = new DdlBuilder().withDialect((DatabaseDialectEx)this).qualifyReferences(true).splitStatements(true);
            this.sqlDropProcedure(builder, procedure).newStatement().plain(rs.getString(3));
            return DialectUtils.sqlConcat((List)builder.getStatements());
        }, (Object)""));
        if (string == null) {
            MysqlBaseDialect.$$$reportNull$$$0(11);
        }
        return string;
    }

    public boolean supportsViewDefinition() {
        return true;
    }

    @Override
    public boolean supportsSystemViewDefinition() {
        return false;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropProcedure(@NotNull DdlBuilder builder, @NotNull DasRoutine procedure) {
        if (builder == null) {
            MysqlBaseDialect.$$$reportNull$$$0(12);
        }
        if (procedure == null) {
            MysqlBaseDialect.$$$reportNull$$$0(13);
        }
        DdlBuilder ddlBuilder = DialectUtils.sqlDropProcedure((DdlBuilder)builder, (DasRoutine)procedure, (boolean)true);
        if (ddlBuilder == null) {
            MysqlBaseDialect.$$$reportNull$$$0(14);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public String getTypeName(@NotNull DataType dataType) {
        if (dataType == null) {
            MysqlBaseDialect.$$$reportNull$$$0(15);
        }
        if (dataType.jdbcType == 0) {
            String string = dataType.getSpecification();
            if (string == null) {
                MysqlBaseDialect.$$$reportNull$$$0(16);
            }
            return string;
        }
        String typeName = dataType.typeName;
        int jdbcType = dataType.jdbcType;
        int precision = dataType.getPrecision();
        int scale = dataType.getScale();
        if ("DOUBLE".equals(typeName) && jdbcType == 8 && precision == 22 && scale == 0) {
            return "double";
        }
        if ("MEDIUMINT".equals(typeName) && jdbcType == 4 && precision == 7 && scale == 0) {
            return "mediumint";
        }
        if ("MEDIUMINT UNSIGNED".equals(typeName) && jdbcType == 4 && precision == 7 && scale == 0) {
            return "mediumint unsigned";
        }
        if ("MEDIUMBLOB".equals(typeName) && jdbcType == -4 && precision == 0xFFFFFF && scale == 0) {
            return "mediumblob";
        }
        if ("TINYBLOB".equals(typeName) && jdbcType == -2 && precision == 255 && scale == 0) {
            return "tinyblob";
        }
        if ("DATETIME".equals(typeName) && jdbcType == 93 && precision == 19 && scale == 0) {
            return "datetime";
        }
        String name2 = super.getTypeName(dataType);
        String unsigned = "unsigned";
        Object object = StringUtil.endsWithIgnoreCase((String)typeName, (String)unsigned) && !StringUtil.endsWithIgnoreCase((String)name2, (String)unsigned) ? name2 + " " + unsigned : name2;
        if (object == null) {
            MysqlBaseDialect.$$$reportNull$$$0(17);
        }
        return object;
    }

    @NotNull
    public DdlBuilder sqlDropSequence(@NotNull DdlBuilder builder, @NotNull DasObject sequence, boolean cascade) {
        if (builder == null) {
            MysqlBaseDialect.$$$reportNull$$$0(18);
        }
        if (sequence == null) {
            MysqlBaseDialect.$$$reportNull$$$0(19);
        }
        throw new UnsupportedOperationException(DatabaseBundle.message((String)"ddl.error.drop.sequence", (Object[])new Object[]{this.getDisplayName()}));
    }

    @Override
    public boolean supportsTableDefinition() {
        return true;
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlTableDefinition(@NotNull DasObject element) {
        if (element == null) {
            MysqlBaseDialect.$$$reportNull$$$0(20);
        }
        DdlBuilder builder = new DdlBuilder().withDialect((DatabaseDialectEx)this).qualifyReferences(true);
        Pair pair = Pair.create((Object)("SHOW CREATE TABLE " + builder.qualifiedRef(element).getStatement()), (Object)DbImplUtil.ConcatenationProps.NO_CONCAT);
        if (pair == null) {
            MysqlBaseDialect.$$$reportNull$$$0(21);
        }
        return pair;
    }

    @Override
    public boolean supportsTableInfo() {
        return true;
    }

    @Override
    @NotNull
    public Map<String, Object> tryToLoadTableInfo(@NotNull DbTable element, @NotNull DatabaseConnection connection) throws Exception {
        if (element == null) {
            MysqlBaseDialect.$$$reportNull$$$0(22);
        }
        if (connection == null) {
            MysqlBaseDialect.$$$reportNull$$$0(23);
        }
        Map map2 = DbImplUtil.resultRowAsMap((DatabaseConnection)connection, (String)String.format("show table status from `%s` like '%s'", MysqlBaseDialect.getDBName((DasObject)element), DbImplUtil.escapeStr((String)element.getName())), (String[])new String[]{"TABLE_ROWS", "rows", "ENGINE", "engine", "TABLE_COLLATION", "collation", "CREATE_TIME", "created"});
        if (map2 == null) {
            MysqlBaseDialect.$$$reportNull$$$0(24);
        }
        return map2;
    }

    @Override
    @NotNull
    public String tryToLoadTableDefinition(@NotNull DasTable table, @NotNull DatabaseConnection connection) throws Exception {
        if (table == null) {
            MysqlBaseDialect.$$$reportNull$$$0(25);
        }
        if (connection == null) {
            MysqlBaseDialect.$$$reportNull$$$0(26);
        }
        Dbms dbms = connection.getDbms();
        Pair<String, DbImplUtil.ConcatenationProps> pair = this.sqlTableDefinition((DasObject)table);
        String string = DbImplUtil.concatStringResults((DatabaseConnection)connection, (Dbms)dbms, (String)((String)pair.first), (int)2, (DbImplUtil.ConcatenationProps)((DbImplUtil.ConcatenationProps)pair.second));
        if (string == null) {
            MysqlBaseDialect.$$$reportNull$$$0(27);
        }
        return string;
    }

    @Override
    public SearchPath tryToLoadSearchPath(@NotNull DasDataSource system, @NotNull DatabaseConnection connection) throws SQLException {
        Dbms dbms;
        String s;
        if (system == null) {
            MysqlBaseDialect.$$$reportNull$$$0(28);
        }
        if (connection == null) {
            MysqlBaseDialect.$$$reportNull$$$0(29);
        }
        return StringUtil.isEmpty((String)(s = DbImplUtil.concatStringResults((DatabaseConnection)connection, (Dbms)(dbms = connection.getDbms()), (String)"select database()", (int)1, (DbImplUtil.ConcatenationProps)DbImplUtil.ConcatenationProps.NO_CONCAT))) ? null : SearchPath.of((ObjectPath)ObjectPath.create((String)s, (ObjectKind)ObjectKind.SCHEMA));
    }

    @Override
    public String sqlSetSearchPath(@NotNull SearchPath path) {
        if (path == null) {
            MysqlBaseDialect.$$$reportNull$$$0(30);
        }
        ObjectPath current = path.getCurrent();
        if (current.kind != ObjectKind.SCHEMA) {
            return null;
        }
        String schema = this.getNamingService().nameToScript(current.getDisplayName(), current.kind, false, this.getCodeStyle().getQuotesPriority());
        return String.format("use %s", schema);
    }

    public boolean supportsEmptyTables() {
        return false;
    }

    @Override
    public boolean supportsInsertInto() {
        return true;
    }

    @NotNull
    private static String getDBName(@NotNull DasObject qualifier) {
        if (qualifier == null) {
            MysqlBaseDialect.$$$reportNull$$$0(31);
        }
        String string = DasUtil.getName((DasObject)MysqlBaseDialect.getDB(qualifier));
        if (string == null) {
            MysqlBaseDialect.$$$reportNull$$$0(32);
        }
        return string;
    }

    @Nullable
    private static DasObject getDB(@NotNull DasObject qualifier) {
        DasObject schema;
        if (qualifier == null) {
            MysqlBaseDialect.$$$reportNull$$$0(33);
        }
        return (schema = DasUtil.getSchemaObject((DasObject)qualifier)) != null && !StringUtil.isEmpty((String)schema.getName()) ? schema : DasUtil.getCatalogObject((DasObject)qualifier);
    }

    @NotNull
    public DdlBuilder qualifiedIdentifier(DdlBuilder builder, @NotNull String identifier, @Nullable DasObject object, @NotNull DasObject qualifier) {
        if (identifier == null) {
            MysqlBaseDialect.$$$reportNull$$$0(34);
        }
        if (qualifier == null) {
            MysqlBaseDialect.$$$reportNull$$$0(35);
        }
        DasObject db = MysqlBaseDialect.getDB(qualifier);
        DdlBuilder ddlBuilder = builder.qualifiedRef(object, identifier, db, DasUtil.getName((DasObject)db), null, null, null, null);
        if (ddlBuilder == null) {
            MysqlBaseDialect.$$$reportNull$$$0(36);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public String getBinaryLiteralString(byte @NotNull [] binaryData) {
        if (binaryData == null) {
            MysqlBaseDialect.$$$reportNull$$$0(37);
        }
        String string = "0x" + DialectUtils.toHexString((byte[])binaryData);
        if (string == null) {
            MysqlBaseDialect.$$$reportNull$$$0(38);
        }
        return string;
    }

    public boolean supportsCommonTableExpression() {
        return true;
    }

    @Override
    public boolean supportsLoadDatabaseList() {
        return true;
    }

    @Override
    @NotNull
    public List<String> tryToLoadDatabaseList(@NotNull DatabaseConnection connection) throws SQLException {
        if (connection == null) {
            MysqlBaseDialect.$$$reportNull$$$0(39);
        }
        List list = (List)DbImplUtil.executeAndGetResult((DatabaseConnection)connection, (String)"SHOW DATABASES", (ThrowableConvertor)DbImplUtil.RS_AS_STRING_LIST);
        if (list == null) {
            MysqlBaseDialect.$$$reportNull$$$0(40);
        }
        return list;
    }

    @Override
    public boolean similarTo(@NotNull DatabaseDialect dialect) {
        if (dialect == null) {
            MysqlBaseDialect.$$$reportNull$$$0(41);
        }
        return dialect instanceof MysqlBaseDialect;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 8: 
            case 11: 
            case 14: 
            case 16: 
            case 17: 
            case 21: 
            case 24: 
            case 27: 
            case 32: 
            case 36: 
            case 38: 
            case 40: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 8: 
            case 11: 
            case 14: 
            case 16: 
            case 17: 
            case 21: 
            case 24: 
            case 27: 
            case 32: 
            case 36: 
            case 38: 
            case 40: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definition";
                break;
            }
            case 5: 
            case 8: 
            case 11: 
            case 14: 
            case 16: 
            case 17: 
            case 21: 
            case 24: 
            case 27: 
            case 32: 
            case 36: 
            case 38: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/mysqlbase/MysqlBaseDialect";
                break;
            }
            case 6: 
            case 7: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "procedure";
                break;
            }
            case 10: 
            case 23: 
            case 26: 
            case 29: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataType";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "system";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 31: 
            case 33: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryData";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/mysqlbase/MysqlBaseDialect";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropView";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlProcedureDefinition";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToLoadProcedureDefinition";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropProcedure";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeName";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlTableDefinition";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToLoadTableInfo";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToLoadTableDefinition";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getDBName";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "qualifiedIdentifier";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getBinaryLiteralString";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToLoadDatabaseList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "sqlCreateView";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropView";
                break;
            }
            case 5: 
            case 8: 
            case 11: 
            case 14: 
            case 16: 
            case 17: 
            case 21: 
            case 24: 
            case 27: 
            case 32: 
            case 36: 
            case 38: 
            case 40: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "sqlViewDefinition";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "sqlProcedureDefinition";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadProcedureDefinition";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropProcedure";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getTypeName";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropSequence";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "sqlTableDefinition";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadTableInfo";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadTableDefinition";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadSearchPath";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "sqlSetSearchPath";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getDBName";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getDB";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "qualifiedIdentifier";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getBinaryLiteralString";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadDatabaseList";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "similarTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 8: 
            case 11: 
            case 14: 
            case 16: 
            case 17: 
            case 21: 
            case 24: 
            case 27: 
            case 32: 
            case 36: 
            case 38: 
            case 40: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

