/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mssql.plan;

import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.connection.statements.ResultsProducer;
import com.intellij.database.dataSource.connection.statements.ReusableSmartStatement;
import com.intellij.database.dialects.base.plan.RawPlanData;
import com.intellij.database.plan.PlanRetrievalException;
import com.intellij.database.remote.jdbc.RemoteResultSet;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ThrowableConsumer;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import kotlin.Unit;
import org.jetbrains.annotations.NotNull;

public class MsRawPlanData
extends RawPlanData {
    public List<String> xmls = new ArrayList<String>();

    @Override
    public void load(@NotNull DatabaseConnection connection, final @NotNull String statement, final boolean run2) {
        if (connection == null) {
            MsRawPlanData.$$$reportNull$$$0(0);
        }
        if (statement == null) {
            MsRawPlanData.$$$reportNull$$$0(1);
        }
        this.xmls.clear();
        MsRawPlanData.useStatementWithPreserved(connection, (RawPlanData.ResourceUser<? super ReusableSmartStatement<String>>)new RawPlanData.ResourceUser<ReusableSmartStatement<String>>(){

            @Override
            public void use(ReusableSmartStatement<String> s) throws PlanRetrievalException, SQLException {
                String option = run2 ? "STATISTICS XML" : "SHOWPLAN_XML";
                try {
                    s.barren().execute((Object)("SET " + option + " ON"));
                    if (!run2) {
                        s.barren().execute((Object)"SET NOEXEC ON");
                    }
                    s.noisy().execute((Object)statement, producer -> {
                        producer.processRemaining((ResultsProducer.Processor)MsRawPlanData.processing((ThrowableConsumer<? super RemoteResultSet, ? extends Exception>)rs -> {
                            String res2;
                            if (rs.getMetaData().getColumnCount() != 1) {
                                return;
                            }
                            String name2 = rs.getMetaData().getColumnName(1);
                            if (name2 == null || !name2.endsWith("XML Showplan")) {
                                return;
                            }
                            if (!rs.next()) {
                                MsRawPlanData.failWithEmptyResultSetError();
                            }
                            if ((res2 = rs.getString(1)) == null) {
                                throw new PlanRetrievalException("Database returned null plan");
                            }
                            if (rs.next()) {
                                throw new PlanRetrievalException("Database returned too many data");
                            }
                            MsRawPlanData.this.xmls.add(res2);
                        }));
                        return Unit.INSTANCE;
                    });
                }
                finally {
                    if (!run2) {
                        s.barren().quiet().execute((Object)"SET NOEXEC OFF");
                    }
                    s.barren().quiet().execute((Object)("SET " + option + " OFF"));
                }
            }
        }, MsRawPlanData.setAutoCommit(false));
    }

    @Override
    public void load(@NotNull String dump) {
        if (dump == null) {
            MsRawPlanData.$$$reportNull$$$0(2);
        }
        this.xmls = StringUtil.split((String)dump, (String)MsRawPlanData.getSep());
    }

    @Override
    public String dump() {
        return StringUtil.join(this.xmls, (String)("\n" + MsRawPlanData.getSep() + "\n"));
    }

    @NotNull
    private static String getSep() {
        String string = StringUtil.repeatSymbol((char)'-', (int)20);
        if (string == null) {
            MsRawPlanData.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dump";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/mssql/plan/MsRawPlanData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/mssql/plan/MsRawPlanData";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSep";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "load";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

