/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mssql.plan;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.connection.statements.BarrenStatement;
import com.intellij.database.dataSource.connection.statements.SmartStatements;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.dialects.base.plan.AbstractExplainPlanProvider;
import com.intellij.database.dialects.base.plan.AbstractPlanModelBuilder;
import com.intellij.database.dialects.mssql.plan.MsPlanModelBuilder;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.Version;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MsExplainPlanProvider
extends AbstractExplainPlanProvider {
    public MsExplainPlanProvider(@NotNull Dbms dbms) {
        if (dbms == null) {
            MsExplainPlanProvider.$$$reportNull$$$0(0);
        }
        super(dbms);
    }

    @Override
    public AbstractPlanModelBuilder<?, ?> createBuilder(@NotNull Version version, boolean run2) {
        if (version == null) {
            MsExplainPlanProvider.$$$reportNull$$$0(1);
        }
        return new MsPlanModelBuilder();
    }

    public DdlBuilder sqlExplainPlan(@NotNull LocalDataSource dataSource, @NotNull DdlBuilder builder, @NotNull String statement, boolean analyze) throws UnsupportedOperationException, IllegalArgumentException {
        if (dataSource == null) {
            MsExplainPlanProvider.$$$reportNull$$$0(2);
        }
        if (builder == null) {
            MsExplainPlanProvider.$$$reportNull$$$0(3);
        }
        if (statement == null) {
            MsExplainPlanProvider.$$$reportNull$$$0(4);
        }
        builder.keywords(new String[]{"set", "showplan_text", "on"}).newStatement();
        builder.keywords(new String[]{"go"}).newLine();
        if (!analyze) {
            builder.keywords(new String[]{"set", "noexec", "on"}).newStatement();
        }
        builder.plain(statement).newStatement();
        if (!analyze) {
            builder.keywords(new String[]{"set", "noexec", "off"}).newStatement();
        }
        builder.keywords(new String[]{"go"}).newLine();
        builder.keywords(new String[]{"set", "showplan_text", "off"}).newStatement();
        builder.keywords(new String[]{"go"}).newLine();
        return builder;
    }

    @Nullable
    public DataRequest.RawRequest sqlPostExplainPlan(@NotNull DataRequest.OwnerEx owner, final boolean analyze) throws UnsupportedOperationException, IllegalArgumentException {
        if (owner == null) {
            MsExplainPlanProvider.$$$reportNull$$$0(5);
        }
        return new DataRequest.RawRequest(owner){

            public void processRaw(DataRequest.Context context, DatabaseConnection connection) throws Exception {
                BarrenStatement.QuietBarrenStatement stmt2 = SmartStatements.poweredBy((DatabaseConnection)connection).simple().barren().quiet();
                if (!analyze) {
                    stmt2.execute((Object)"set noexec off");
                }
                stmt2.execute((Object)"set showplan_text off");
            }
        };
    }

    public boolean isSupported(@NotNull Version version, boolean run2) {
        if (version == null) {
            MsExplainPlanProvider.$$$reportNull$$$0(6);
        }
        return true;
    }

    public boolean isRawSupported(@NotNull Version version, boolean run2) {
        if (version == null) {
            MsExplainPlanProvider.$$$reportNull$$$0(7);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 1: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/dialects/mssql/plan/MsExplainPlanProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createBuilder";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "sqlExplainPlan";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "sqlPostExplainPlan";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isSupported";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isRawSupported";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

