/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mssql.model;

import com.intellij.database.dialects.base.GeneratedModelUtil;
import com.intellij.database.dialects.mssql.introspector.MsRoutineTypes;
import com.intellij.database.dialects.mssql.model.MsAliasType;
import com.intellij.database.dialects.mssql.model.MsIndex;
import com.intellij.database.dialects.mssql.model.MsRoutine;
import com.intellij.database.dialects.mssql.model.MsSchema;
import com.intellij.database.dialects.mssql.model.MsSequence;
import com.intellij.database.dialects.mssql.model.properties.MsRoutineType;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DataType;
import com.intellij.database.model.basic.BasicArrangedElement;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MsGeneratedModelUtil
extends GeneratedModelUtil {
    @NotNull
    public static Iterable<? extends BasicElement> getPredecessors(@NotNull MsSequence element) {
        if (element == null) {
            MsGeneratedModelUtil.$$$reportNull$$$0(0);
        }
        List list = ContainerUtil.createMaybeSingletonList((Object)MsGeneratedModelUtil.resolveType(element));
        if (list == null) {
            MsGeneratedModelUtil.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Nullable
    private static MsAliasType resolveType(@NotNull MsSequence sequence) {
        MsSchema targetSchema;
        if (sequence == null) {
            MsGeneratedModelUtil.$$$reportNull$$$0(2);
        }
        DataType dataType = sequence.getDataType();
        String schemaName = dataType.schemaName;
        String typeName = dataType.typeName;
        MsSchema mySchema = sequence.getSchema();
        if (mySchema == null) {
            return null;
        }
        MsSchema msSchema = targetSchema = schemaName == null ? mySchema : mySchema.getSibling(schemaName);
        if (!(targetSchema instanceof MsSchema)) {
            return null;
        }
        return (MsAliasType)targetSchema.getAliasTypes().get(typeName);
    }

    public static void setSubstituted(@NotNull MsSchema nsp) {
        if (nsp == null) {
            MsGeneratedModelUtil.$$$reportNull$$$0(3);
        }
        MsGeneratedModelUtil.setSubstituted(nsp);
        nsp.setIntrospectionTimestamp(null);
        nsp.setDescriptionsCheckSum(0L);
        nsp.setAliasTypesCheckSum(0L);
        nsp.setTableTypesCheckSum(0L);
    }

    @NotNull
    public static String calculateDisplayOrder(@NotNull MsIndex index2) {
        if (index2 == null) {
            MsGeneratedModelUtil.$$$reportNull$$$0(4);
        }
        String string = MsGeneratedModelUtil.calculateDisplayOrder((BasicArrangedElement)index2);
        if (string == null) {
            MsGeneratedModelUtil.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public static String getDisplayName(@NotNull MsIndex element) {
        if (element == null) {
            MsGeneratedModelUtil.$$$reportNull$$$0(6);
        }
        if (element.isFulltext()) {
            return "fulltext";
        }
        String string = GeneratedModelUtil.getDisplayName((BasicElement)element);
        if (string == null) {
            MsGeneratedModelUtil.$$$reportNull$$$0(7);
        }
        return string;
    }

    public static DasRoutine.Kind getRoutineKind(MsRoutine r) {
        MsRoutineType tp = r.getRoutineType();
        return MsRoutineTypes.MS_FUNCTION_TYPES.containsValue((Object)tp) ? DasRoutine.Kind.FUNCTION : (MsRoutineTypes.MS_PROCEDURE_TYPES.containsValue((Object)tp) ? DasRoutine.Kind.PROCEDURE : DasRoutine.Kind.NONE);
    }

    public static void setRoutineKind(MsRoutine r, DasRoutine.Kind kind) {
        r.setRoutineType(kind == DasRoutine.Kind.FUNCTION ? MsRoutineType.SCALAR_FUN : (kind == DasRoutine.Kind.PROCEDURE ? MsRoutineType.PROC : MsRoutineType.CLR_PROC));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/mssql/model/MsGeneratedModelUtil";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nsp";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/mssql/model/MsGeneratedModelUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPredecessors";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateDisplayOrder";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPredecessors";
                break;
            }
            case 1: 
            case 5: 
            case 7: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "resolveType";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setSubstituted";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "calculateDisplayOrder";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getDisplayName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

